/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.ssh;

import app.termora.DynamicIcon;
import app.termora.Host;
import app.termora.Icons;
import app.termora.TerminalTab;
import app.termora.WindowScope;
import app.termora.actions.DataProvider;
import app.termora.plugin.internal.ssh.SSHTerminalTab;
import app.termora.plugin.internal.ssh.SshClients;
import app.termora.protocol.GenericProtocolProvider;
import app.termora.protocol.ProtocolTestRequest;
import app.termora.protocol.ProtocolTester;
import java.awt.Window;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016\u00a8\u0006\u001c"}, d2={"Lapp/termora/plugin/internal/ssh/SSHProtocolProvider;", "Lapp/termora/protocol/GenericProtocolProvider;", "Lapp/termora/protocol/ProtocolTester;", "<init>", "()V", "getProtocol", "", "createTerminalTab", "Lapp/termora/TerminalTab;", "dataProvider", "Lapp/termora/actions/DataProvider;", "windowScope", "Lapp/termora/WindowScope;", "host", "Lapp/termora/Host;", "getIcon", "Lapp/termora/DynamicIcon;", "width", "", "height", "canTestConnection", "", "requester", "Lapp/termora/protocol/ProtocolTestRequest;", "testConnection", "", "ordered", "Companion", "termora"})
public final class SSHProtocolProvider
implements GenericProtocolProvider,
ProtocolTester {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<SSHProtocolProvider> instance$delegate = LazyKt.lazy(SSHProtocolProvider::instance_delegate$lambda$0);
    @NotNull
    public static final String PROTOCOL = "SSH";

    private SSHProtocolProvider() {
    }

    @Override
    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Override
    @NotNull
    public TerminalTab createTerminalTab(@NotNull DataProvider dataProvider, @NotNull WindowScope windowScope, @NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)windowScope, (String)"windowScope");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new SSHTerminalTab(windowScope, host, null, 4, null);
    }

    @Override
    @NotNull
    public DynamicIcon getIcon(int width, int height) {
        return Icons.INSTANCE.getSsh();
    }

    @Override
    public boolean canTestConnection(@NotNull ProtocolTestRequest requester) {
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testConnection(@NotNull ProtocolTestRequest requester) {
        ClientSession clientSession;
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        SshClient client = null;
        ClientSession session2 = null;
        Window owner = requester.getOwner();
        Host host = requester.getHost();
        try {
            client = owner != null ? SshClients.INSTANCE.openClient(host, owner) : SshClients.INSTANCE.openClient(host);
            clientSession = session2 = SshClients.INSTANCE.openSession(host, client);
        }
        catch (Throwable throwable) {
            SshClient sshClient = client;
            if (sshClient != null) {
                sshClient.close();
            }
            throw throwable;
        }
        if (clientSession != null) {
            clientSession.close();
        }
        SshClient sshClient = client;
        if (sshClient != null) {
            sshClient.close();
        }
    }

    @Override
    public int ordered() {
        return Integer.MIN_VALUE;
    }

    private static final SSHProtocolProvider instance_delegate$lambda$0() {
        return new SSHProtocolProvider();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/termora/plugin/internal/ssh/SSHProtocolProvider$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/plugin/internal/ssh/SSHProtocolProvider;", "getInstance", "()Lapp/termora/plugin/internal/ssh/SSHProtocolProvider;", "instance$delegate", "Lkotlin/Lazy;", "PROTOCOL", "", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SSHProtocolProvider getInstance() {
            Lazy lazy = instance$delegate;
            return (SSHProtocolProvider)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

