/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.telnet;

import app.termora.Host;
import app.termora.ProxyType;
import app.termora.PtyConnectorFactory;
import app.termora.PtyHostTerminalTab;
import app.termora.TerminalTab;
import app.termora.WindowScope;
import app.termora.plugin.internal.telnet.TelnetStreamPtyConnector;
import app.termora.terminal.KeyEncoder;
import app.termora.terminal.KeyEncoderImpl;
import app.termora.terminal.PtyConnector;
import app.termora.terminal.TerminalKeyEvent;
import app.termora.terminal.TerminalSize;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.SimpleOptionHandler;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lapp/termora/plugin/internal/telnet/TelnetTerminalTab;", "Lapp/termora/PtyHostTerminalTab;", "windowScope", "Lapp/termora/WindowScope;", "host", "Lapp/termora/Host;", "<init>", "(Lapp/termora/WindowScope;Lapp/termora/Host;)V", "openPtyConnector", "Lapp/termora/terminal/PtyConnector;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createReconnectTerminalTab", "Lapp/termora/TerminalTab;", "termora"})
public final class TelnetTerminalTab
extends PtyHostTerminalTab {
    public TelnetTerminalTab(@NotNull WindowScope windowScope, @NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)windowScope, (String)"windowScope");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super(windowScope, host, null, 4, null);
    }

    @Override
    @Nullable
    public Object openPtyConnector(@NotNull Continuation<? super PtyConnector> $completion) {
        Object object;
        boolean characterMode;
        TerminalSize winSize = this.getTerminalPanel().winSize();
        TelnetClient telnet = new TelnetClient();
        telnet.setCharset(Charset.forName(this.getHost().getOptions().getEncoding()));
        telnet.setConnectTimeout(60000);
        if (this.getHost().getProxy().getType() == ProxyType.HTTP) {
            telnet.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getHost().getProxy().getHost(), this.getHost().getProxy().getPort())));
        } else if (this.getHost().getProxy().getType() == ProxyType.SOCKS5) {
            telnet.setProxy(new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.getHost().getProxy().getHost(), this.getHost().getProxy().getPort())));
        }
        boolean bl = characterMode = (object = this.getHost().getOptions().getExtras().get("character-at-a-time")) != null && (object = StringsKt.toBooleanStrictOrNull((String)object)) != null ? (Boolean)object : false;
        String string = this.getHost().getOptions().envs().get("TERM");
        if (string == null) {
            string = "xterm-256color";
        }
        String termtype = string;
        TerminalTypeOptionHandler ttopt = new TerminalTypeOptionHandler(termtype, false, false, true, false);
        EchoOptionHandler echoopt = new EchoOptionHandler(false, true, false, true);
        SuppressGAOptionHandler gaopt = new SuppressGAOptionHandler(true, true, true, true);
        WindowSizeOptionHandler wsopt = new WindowSizeOptionHandler(winSize.getCols(), winSize.getRows(), true, false, true, false);
        SimpleOptionHandler bopt = new SimpleOptionHandler(0, true, false, true, false);
        SimpleOptionHandler fcopt = new SimpleOptionHandler(33, true, true, false, false);
        telnet.addOptionHandler((TelnetOptionHandler)bopt);
        telnet.addOptionHandler((TelnetOptionHandler)fcopt);
        telnet.addOptionHandler((TelnetOptionHandler)ttopt);
        telnet.addOptionHandler((TelnetOptionHandler)echoopt);
        telnet.addOptionHandler((TelnetOptionHandler)gaopt);
        telnet.addOptionHandler((TelnetOptionHandler)wsopt);
        telnet.connect(this.getHost().getHost(), this.getHost().getPort());
        telnet.setKeepAlive(true);
        telnet.setTcpNoDelay(characterMode);
        KeyEncoder encoder = this.getTerminal().getKeyEncoder();
        if (encoder instanceof KeyEncoderImpl) {
            String backspace = this.getHost().getOptions().getExtras().get("backspace");
            if (Intrinsics.areEqual((Object)backspace, (Object)"Backspace")) {
                byte[] byArray = new byte[]{8};
                ((KeyEncoderImpl)encoder).putCode$termora(new TerminalKeyEvent(8, 0, 2, null), new String(byArray, Charsets.UTF_8));
            } else if (Intrinsics.areEqual((Object)backspace, (Object)"VT220")) {
                ((KeyEncoderImpl)encoder).putCode$termora(new TerminalKeyEvent(8, 0, 2, null), "\u001b[3~");
            }
        }
        PtyConnectorFactory ptyConnectorFactory = this.getPtyConnectorFactory();
        Charset charset = telnet.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
        return ptyConnectorFactory.decorate(new TelnetStreamPtyConnector(telnet, charset, characterMode));
    }

    @Override
    @NotNull
    protected TerminalTab createReconnectTerminalTab() {
        return new TelnetTerminalTab(this.getWindowScope(), this.getHost());
    }
}

