/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel;

import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.TerminalPanelFactory;
import app.termora.TerminalTab;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.actions.DataProvider;
import app.termora.actions.DataProviders;
import app.termora.database.DatabaseManager;
import app.termora.plugin.ExtensionManager;
import app.termora.plugin.internal.ssh.SSHTerminalTab;
import app.termora.terminal.DataKey;
import app.termora.terminal.panel.FloatingToolbarActionExtension;
import app.termora.terminal.panel.FloatingToolbarPanel;
import app.termora.terminal.panel.TerminalPanel;
import app.termora.terminal.panel.vw.VisualWindow;
import app.termora.terminal.panel.vw.VisualWindowManager;
import com.formdev.flatlaf.extras.components.FlatToolBar;
import com.formdev.flatlaf.ui.FlatRoundBorder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000fJ\b\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0002J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\b\u0010 \u001a\u00020\u0016H\u0002J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lapp/termora/terminal/panel/FloatingToolbarPanel;", "Lcom/formdev/flatlaf/extras/components/FlatToolBar;", "Lapp/termora/Disposable;", "<init>", "()V", "floatingToolbarEnable", "", "getFloatingToolbarEnable", "()Z", "closed", "event", "Lapp/termora/actions/AnActionEvent;", "getEvent", "()Lapp/termora/actions/AnActionEvent;", "updateUI", "", "triggerShow", "triggerHide", "initActions", "initEvents", "resumeVisualWindows", "createButton", "Ljavax/swing/JButton;", "action", "Lapp/termora/actions/AnAction;", "visualWindowManager", "Lapp/termora/terminal/panel/vw/VisualWindowManager;", "tab", "Lapp/termora/TerminalTab;", "extension", "Lapp/termora/terminal/panel/FloatingToolbarActionExtension;", "initPinActionButton", "initCloseActionButton", "initReconnectActionButton", "Companion", "termora"})
public final class FloatingToolbarPanel
extends FlatToolBar
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean closed;
    @NotNull
    private static final DataKey<FloatingToolbarPanel> FloatingToolbar = new DataKey(Reflection.getOrCreateKotlinClass(FloatingToolbarPanel.class));
    @NotNull
    private static final Lazy<Companion.pinAction.2.1> pinAction$delegate = LazyKt.lazy(FloatingToolbarPanel::pinAction_delegate$lambda$0);

    public FloatingToolbarPanel() {
        this.setBorder((Border)new FlatRoundBorder());
        this.setFocusable(false);
        this.setFloatable(false);
        this.setVisible(false);
        if (this.getFloatingToolbarEnable() && FloatingToolbarPanel.Companion.getPinAction().isSelected()) {
            this.setVisible(true);
        }
        this.initEvents();
    }

    private final boolean getFloatingToolbarEnable() {
        return DatabaseManager.Companion.getInstance().getTerminal().getFloatingToolbar();
    }

    private final AnActionEvent getEvent() {
        return new AnActionEvent((Object)this, "", new EventObject(this));
    }

    public void updateUI() {
        super.updateUI();
        this.setBorder((Border)new FlatRoundBorder());
    }

    public final void triggerShow() {
        if (!this.getFloatingToolbarEnable() || this.closed) {
            return;
        }
        if (!this.isVisible()) {
            this.setVisible(true);
            this.firePropertyChange("visible", false, true);
        }
    }

    public final void triggerHide() {
        if (this.getFloatingToolbarEnable() && !this.closed && FloatingToolbarPanel.Companion.getPinAction().isSelected()) {
            return;
        }
        if (this.isVisible()) {
            this.setVisible(false);
            this.firePropertyChange("visible", true, false);
        }
    }

    private final void initActions() {
        TerminalPanel terminalPanel;
        this.add(this.initPinActionButton());
        TerminalTab tab = this.getEvent().getData(DataProviders.INSTANCE.getTerminalTab());
        DataProvider dataProvider = tab;
        TerminalPanel terminalPanel2 = terminalPanel = dataProvider != null ? dataProvider.getData(DataProviders.INSTANCE.getTerminalPanel()) : null;
        if (terminalPanel != null) {
            List<FloatingToolbarActionExtension> extensions = ExtensionManager.Companion.getInstance().getExtensions(FloatingToolbarActionExtension.class);
            for (FloatingToolbarActionExtension extension : extensions) {
                try {
                    this.add(this.createButton(extension.createActionButton(terminalPanel, tab), terminalPanel, tab, extension));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
            this.initReconnectActionButton(tab);
        }
        this.add(this.initCloseActionButton());
    }

    private final void initEvents() {
        this.addPropertyChangeListener("ancestor", new PropertyChangeListener(this){
            final /* synthetic */ FloatingToolbarPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void propertyChange(PropertyChangeEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                this.this$0.removePropertyChangeListener("ancestor", this);
                FloatingToolbarPanel.access$initActions(this.this$0);
            }
        });
        this.addPropertyChangeListener("ancestor", new PropertyChangeListener(this){
            final /* synthetic */ FloatingToolbarPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void propertyChange(PropertyChangeEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                this.this$0.removePropertyChangeListener("ancestor", this);
                SwingUtilities.invokeLater(() -> initEvents.2.propertyChange$lambda$0(this.this$0));
            }

            private static final void propertyChange$lambda$0(FloatingToolbarPanel this$0) {
                FloatingToolbarPanel.access$resumeVisualWindows(this$0);
            }
        });
    }

    private final void resumeVisualWindows() {
        TerminalTab terminalTab = this.getEvent().getData(DataProviders.INSTANCE.getTerminalTab());
        if (terminalTab == null) {
            return;
        }
        TerminalTab tab = terminalTab;
        if (!(tab instanceof SSHTerminalTab)) {
            return;
        }
        TerminalPanel terminalPanel = ((SSHTerminalTab)tab).getData(DataProviders.INSTANCE.getTerminalPanel());
        if (terminalPanel == null) {
            return;
        }
        TerminalPanel terminalPanel2 = terminalPanel;
        terminalPanel2.resumeVisualWindows(((SSHTerminalTab)tab).getHost().getId(), new DataProvider(tab){
            final /* synthetic */ TerminalTab $tab;
            {
                this.$tab = $tab;
            }

            public <T> T getData(DataKey<T> dataKey) {
                Intrinsics.checkNotNullParameter(dataKey, (String)"dataKey");
                if (Intrinsics.areEqual(dataKey, DataProviders.INSTANCE.getTerminalTab())) {
                    TerminalTab terminalTab = this.$tab;
                    Intrinsics.checkNotNull((Object)terminalTab, (String)"null cannot be cast to non-null type T of app.termora.terminal.panel.FloatingToolbarPanel.resumeVisualWindows.<no name provided>.getData");
                    return (T)terminalTab;
                }
                return DataProvider.super.getData(dataKey);
            }
        });
    }

    private final JButton createButton(AnAction action2, VisualWindowManager visualWindowManager, TerminalTab tab, FloatingToolbarActionExtension extension) {
        Icon icon = action2.getSmallIcon();
        JButton btn2 = new JButton((Action)((Object)new AnAction(extension, tab, visualWindowManager, action2, icon){
            final /* synthetic */ FloatingToolbarActionExtension $extension;
            final /* synthetic */ TerminalTab $tab;
            final /* synthetic */ VisualWindowManager $visualWindowManager;
            final /* synthetic */ AnAction $action;
            {
                this.$extension = $extension;
                this.$tab = $tab;
                this.$visualWindowManager = $visualWindowManager;
                this.$action = $action;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1);
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                try {
                    Class<? extends VisualWindow> clazz = this.$extension.getVisualWindowClass(this.$tab);
                    for (VisualWindow window : this.$visualWindowManager.getVisualWindows()) {
                        if (!clazz.isInstance(window)) continue;
                        this.$visualWindowManager.moveToFront(window);
                        return;
                    }
                    this.$action.actionPerformed((ActionEvent)evt);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.$action.actionPerformed((ActionEvent)evt);
                }
            }
        }));
        btn2.setText("");
        btn2.setToolTipText(action2.getShortDescription());
        return btn2;
    }

    private final JButton initPinActionButton() {
        JButton btn2 = new JButton((Icon)((Object)Icons.INSTANCE.getPin()));
        btn2.setSelected(FloatingToolbarPanel.Companion.getPinAction().isSelected());
        ActionListener actionListener = arg_0 -> FloatingToolbarPanel.initPinActionButton$lambda$0(btn2, arg_0);
        FloatingToolbarPanel.Companion.getPinAction().addActionListener(actionListener);
        btn2.addActionListener((ActionListener)((Object)FloatingToolbarPanel.Companion.getPinAction()));
        Disposer.register(this, new Disposable(btn2, actionListener){
            final /* synthetic */ JButton $btn;
            final /* synthetic */ ActionListener $actionListener;
            {
                this.$btn = $btn;
                this.$actionListener = $actionListener;
            }

            public void dispose() {
                this.$btn.removeActionListener((ActionListener)((Object)app.termora.terminal.panel.FloatingToolbarPanel$Companion.access$getPinAction(FloatingToolbarPanel.Companion)));
                app.termora.terminal.panel.FloatingToolbarPanel$Companion.access$getPinAction(FloatingToolbarPanel.Companion).removeActionListener(this.$actionListener);
            }
        });
        return btn2;
    }

    private final JButton initCloseActionButton() {
        JButton btn2 = new JButton((Icon)((Object)Icons.INSTANCE.getCloseSmall()));
        btn2.setToolTipText(I18n.INSTANCE.getString("termora.floating-toolbar.close-in-current-tab"));
        btn2.setPressedIcon((Icon)((Object)Icons.INSTANCE.getCloseSmallHovered()));
        btn2.setRolloverIcon((Icon)((Object)Icons.INSTANCE.getCloseSmallHovered()));
        btn2.addActionListener(arg_0 -> FloatingToolbarPanel.initCloseActionButton$lambda$0(this, arg_0));
        return btn2;
    }

    private final void initReconnectActionButton(TerminalTab tab) {
        if (!tab.canReconnect()) {
            return;
        }
        JButton btn2 = new JButton((Icon)((Object)Icons.INSTANCE.getRefresh()));
        btn2.setToolTipText(I18n.INSTANCE.getString("termora.tabbed.contextmenu.reconnect"));
        btn2.addActionListener((ActionListener)((Object)new AnAction(tab){
            final /* synthetic */ TerminalTab $tab;
            {
                this.$tab = $tab;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                this.$tab.reconnect();
            }
        }));
        this.add(btn2);
    }

    private static final void initPinActionButton$lambda$0(JButton $btn, ActionEvent it) {
        $btn.setSelected(FloatingToolbarPanel.Companion.getPinAction().isSelected());
    }

    private static final void initCloseActionButton$lambda$0(FloatingToolbarPanel this$0, ActionEvent it) {
        this$0.closed = true;
        this$0.triggerHide();
    }

    private static final Companion.pinAction.2.1 pinAction_delegate$lambda$0() {
        return new AnAction(){
            private final String key;
            {
                this.key = "FloatingToolbar.pined";
                this.setStateAction();
                this.setSelected(Boolean.parseBoolean(this.getProperties().getString(this.key, "")));
            }

            private final DatabaseManager.Properties getProperties() {
                return DatabaseManager.Companion.getInstance().getProperties();
            }

            protected void actionPerformed(AnActionEvent evt) {
                Object it;
                Object element$iv;
                int n;
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                this.setSelected(!this.isSelected());
                this.getProperties().putString(this.key, String.valueOf(this.isSelected()));
                ActionListener[] actionListenerArray = this.getActionListeners();
                Intrinsics.checkNotNullExpressionValue((Object)actionListenerArray, (String)"getActionListeners(...)");
                Object[] $this$forEach$iv = actionListenerArray;
                boolean $i$f$forEach = false;
                int n2 = $this$forEach$iv.length;
                for (n = 0; n < n2; ++n) {
                    element$iv = $this$forEach$iv[n];
                    it = (ActionListener)element$iv;
                    boolean bl = false;
                    it.actionPerformed(evt);
                }
                if (this.isSelected()) {
                    $this$forEach$iv = TerminalPanelFactory.Companion.getInstance().getTerminalPanels();
                    $i$f$forEach = false;
                    n2 = $this$forEach$iv.length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv = $this$forEach$iv[n];
                        boolean bl = false;
                        FloatingToolbarPanel floatingToolbarPanel = ((TerminalPanel)it).getData(FloatingToolbarPanel.Companion.getFloatingToolbar());
                        if (floatingToolbarPanel == null) continue;
                        floatingToolbarPanel.triggerShow();
                    }
                } else {
                    FloatingToolbarPanel c = evt.getData(FloatingToolbarPanel.Companion.getFloatingToolbar());
                    TerminalPanel[] $this$forEach$iv2 = TerminalPanelFactory.Companion.getInstance().getTerminalPanels();
                    boolean $i$f$forEach2 = false;
                    int n3 = $this$forEach$iv2.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        TerminalPanel element$iv2;
                        TerminalPanel it2 = element$iv2 = $this$forEach$iv2[n2];
                        boolean bl = false;
                        FloatingToolbarPanel e = it2.getData(FloatingToolbarPanel.Companion.getFloatingToolbar());
                        if (Intrinsics.areEqual((Object)c, (Object)e)) continue;
                        FloatingToolbarPanel floatingToolbarPanel = e;
                        if (floatingToolbarPanel == null) continue;
                        floatingToolbarPanel.triggerHide();
                    }
                }
            }
        };
    }

    public static final /* synthetic */ void access$initActions(FloatingToolbarPanel $this) {
        $this.initActions();
    }

    public static final /* synthetic */ void access$resumeVisualWindows(FloatingToolbarPanel $this) {
        $this.resumeVisualWindows();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000'\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\b\u0006*\u0001\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lapp/termora/terminal/panel/FloatingToolbarPanel$Companion;", "", "<init>", "()V", "FloatingToolbar", "Lapp/termora/terminal/DataKey;", "Lapp/termora/terminal/panel/FloatingToolbarPanel;", "getFloatingToolbar", "()Lapp/termora/terminal/DataKey;", "isPined", "", "()Z", "pinAction", "app/termora/terminal/panel/FloatingToolbarPanel$Companion$pinAction$2$1", "getPinAction", "()Lapp/termora/terminal/panel/FloatingToolbarPanel$Companion$pinAction$2$1;", "pinAction$delegate", "Lkotlin/Lazy;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<FloatingToolbarPanel> getFloatingToolbar() {
            return FloatingToolbar;
        }

        public final boolean isPined() {
            return this.getPinAction().isSelected();
        }

        private final pinAction.2.1 getPinAction() {
            Lazy lazy = pinAction$delegate;
            return (Object)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

