/*
 * Decompiled with CFR 0.152.
 */
package app.termora.transfer.internal.local;

import app.termora.database.DatabaseManager;
import app.termora.protocol.PathHandler;
import app.termora.protocol.PathHandlerRequest;
import app.termora.protocol.TransferProtocolProvider;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lapp/termora/transfer/internal/local/LocalTransferProtocolProvider;", "Lapp/termora/protocol/TransferProtocolProvider;", "<init>", "()V", "isTransient", "", "getProtocol", "", "createPathHandler", "Lapp/termora/protocol/PathHandler;", "requester", "Lapp/termora/protocol/PathHandlerRequest;", "Companion", "termora"})
public final class LocalTransferProtocolProvider
implements TransferProtocolProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<LocalTransferProtocolProvider> instance$delegate = LazyKt.lazy(LocalTransferProtocolProvider::instance_delegate$lambda$0);
    @NotNull
    public static final String PROTOCOL = "file";

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Override
    @NotNull
    public PathHandler createPathHandler(@NotNull PathHandlerRequest requester) {
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        String defaultDirectory = LocalTransferProtocolProvider.Companion.getSftp().getDefaultDirectory();
        if (StringUtils.isBlank((CharSequence)defaultDirectory)) {
            String string = SystemUtils.USER_HOME;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"USER_HOME");
            defaultDirectory = string;
        }
        FileSystem fileSystem = FileSystems.getDefault();
        Intrinsics.checkNotNull((Object)fileSystem);
        Path path = fileSystem.getPath(defaultDirectory, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return new PathHandler(fileSystem, path);
    }

    private static final LocalTransferProtocolProvider instance_delegate$lambda$0() {
        return new LocalTransferProtocolProvider();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lapp/termora/transfer/internal/local/LocalTransferProtocolProvider$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/transfer/internal/local/LocalTransferProtocolProvider;", "getInstance", "()Lapp/termora/transfer/internal/local/LocalTransferProtocolProvider;", "instance$delegate", "Lkotlin/Lazy;", "sftp", "Lapp/termora/database/DatabaseManager$SFTP;", "getSftp", "()Lapp/termora/database/DatabaseManager$SFTP;", "PROTOCOL", "", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalTransferProtocolProvider getInstance() {
            Lazy lazy = instance$delegate;
            return (LocalTransferProtocolProvider)lazy.getValue();
        }

        private final DatabaseManager.SFTP getSftp() {
            return DatabaseManager.Companion.getInstance().getSftp();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

