/*
 * Decompiled with CFR 0.152.
 */
package zmodem.xfer.util;

import zmodem.xfer.util.Arrays;
import zmodem.xfer.util.Buffer;
import zmodem.xfer.util.HexBuffer;

public class ByteBuffer
implements Buffer {
    private java.nio.ByteBuffer _wrapped;

    public ByteBuffer(java.nio.ByteBuffer b) {
        this._wrapped = b;
    }

    public static ByteBuffer allocate(int capacity) {
        return new ByteBuffer(java.nio.ByteBuffer.allocate(capacity));
    }

    public static ByteBuffer allocateDirect(int capacity) {
        return new ByteBuffer(java.nio.ByteBuffer.allocateDirect(capacity));
    }

    public Buffer slice() {
        return new ByteBuffer(this._wrapped.slice());
    }

    public Buffer duplicate() {
        return new ByteBuffer(this._wrapped.duplicate());
    }

    public Buffer asReadOnlyBuffer() {
        return new ByteBuffer(this._wrapped.asReadOnlyBuffer());
    }

    @Override
    public byte get() {
        return this._wrapped.get();
    }

    @Override
    public Buffer get(byte[] dst, int offset, int len) {
        while (offset < len) {
            dst[offset] = this.get();
            ++offset;
        }
        return this;
    }

    @Override
    public Buffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    @Override
    public Buffer put(byte b) {
        this._wrapped.put(b);
        return this;
    }

    @Override
    public Buffer put(byte[] dst, int offset, int len) {
        while (offset < len) {
            this.put(dst[offset]);
            ++offset;
        }
        return this;
    }

    @Override
    public Buffer put(byte[] dst) {
        return this.put(dst, 0, dst.length);
    }

    @Override
    public byte get(int index) {
        return this._wrapped.get(index);
    }

    @Override
    public Buffer get(int index, byte[] dst, int offset, int len) {
        while (offset < len) {
            dst[offset] = this.get(index++);
            ++offset;
        }
        return this;
    }

    @Override
    public Buffer get(int index, byte[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    @Override
    public Buffer put(int index, byte b) {
        this._wrapped.put(index, b);
        return this;
    }

    @Override
    public Buffer put(int index, byte[] dst, int offset, int len) {
        while (offset < len) {
            this.put(index++, dst[offset]);
            ++offset;
        }
        return this;
    }

    @Override
    public Buffer put(int index, byte[] dst) {
        return this.put(index, dst, 0, dst.length);
    }

    public Buffer compact() {
        this._wrapped.compact();
        return this;
    }

    public boolean isDirect() {
        return this._wrapped.isDirect();
    }

    public char getChar() {
        return (char)this.get();
    }

    public Buffer putChar(char value) {
        return this.put((byte)value);
    }

    public char getChar(int index) {
        return (char)this.get(index);
    }

    public Buffer putChar(int index, char value) {
        return this.put(index, (byte)value);
    }

    @Override
    public HexBuffer asHexBuffer() {
        return new HexBuffer(this._wrapped);
    }

    public short getShort() {
        return Arrays.toShort(new byte[]{this.get(), this.get()}, Arrays.Endianness.Little);
    }

    public Buffer putShort(short value) {
        return this.put(Arrays.fromShort(value, Arrays.Endianness.Little));
    }

    public short getShort(int index) {
        return Arrays.toShort(new byte[]{this.get(index), this.get(index + 1)}, Arrays.Endianness.Little);
    }

    public Buffer putShort(int index, short value) {
        return this.put(index, Arrays.fromShort(value, Arrays.Endianness.Little));
    }

    public int getInt() {
        return Arrays.toInt(new byte[]{this.get(), this.get(), this.get(), this.get()}, Arrays.Endianness.Little);
    }

    public Buffer putInt(int value) {
        return this.put(Arrays.fromInt(value, Arrays.Endianness.Little));
    }

    public int getInt(int index) {
        return Arrays.toInt(new byte[]{this.get(index), this.get(index + 1), this.get(index + 2), this.get(index + 3)}, Arrays.Endianness.Little);
    }

    public Buffer putInt(int index, int value) {
        return this.put(index, Arrays.fromInt(value, Arrays.Endianness.Little));
    }

    public long getLong() {
        return Arrays.toLong(new byte[]{this.get(), this.get(), this.get(), this.get(), this.get(), this.get(), this.get(), this.get()}, Arrays.Endianness.Little);
    }

    public Buffer putLong(long value) {
        return this.put(Arrays.fromLong(value, Arrays.Endianness.Little));
    }

    public long getLong(int index) {
        return Arrays.toLong(new byte[]{this.get(index), this.get(index + 1), this.get(index + 2), this.get(index + 3), this.get(index + 4), this.get(index + 5), this.get(index + 6), this.get(index + 7)}, Arrays.Endianness.Little);
    }

    public Buffer putLong(int index, long value) {
        return this.put(index, Arrays.fromLong(value, Arrays.Endianness.Little));
    }

    public boolean isReadOnly() {
        return this._wrapped.isReadOnly();
    }

    @Override
    public void flip() {
        this._wrapped.flip();
    }

    @Override
    public int remaining() {
        return this._wrapped.remaining();
    }

    @Override
    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return this;
    }
}

