/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.datetime;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.jdk8.InstantConversionsJDK8Kt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.format.DateTimeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.ColumnType;
import org.jetbrains.exposed.v1.core.IDateColumnType;
import org.jetbrains.exposed.v1.core.datetime.LocalDateTimeColumnTypeKt;
import org.jetbrains.exposed.v1.core.statements.api.RowApi;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.H2Dialect;
import org.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import org.jetbrains.exposed.v1.core.vendors.OracleDialect;
import org.jetbrains.exposed.v1.core.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.v1.core.vendors.SQLiteDialect;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\b\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0015H\u0002J\u0017\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0011H\u0002J\u001a\u0010\u001e\u001a\u00020\u00152\b\u0010\b\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u001a\u0010$\u001a\u00020\u00112\b\u0010\b\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006%"}, d2={"Lorg/jetbrains/exposed/v1/core/datetime/LocalDateTimeColumnType;", "T", "Lorg/jetbrains/exposed/v1/core/ColumnType;", "Lorg/jetbrains/exposed/v1/core/IDateColumnType;", "<init>", "()V", "toLocalDateTime", "Lkotlinx/datetime/LocalDateTime;", "value", "(Ljava/lang/Object;)Lkotlinx/datetime/LocalDateTime;", "fromLocalDateTime", "(Lkotlinx/datetime/LocalDateTime;)Ljava/lang/Object;", "hasTimePart", "", "getHasTimePart", "()Z", "sqlType", "", "nonNullValueToString", "(Ljava/lang/Object;)Ljava/lang/String;", "localDateTimeValueFromDB", "", "valueFromDB", "(Ljava/lang/Object;)Ljava/lang/Object;", "longToLocalDateTime", "millis", "", "seconds", "nanos", "parseLocalDateTime", "notNullValueToDB", "readObject", "rs", "Lorg/jetbrains/exposed/v1/core/statements/api/RowApi;", "index", "", "nonNullValueAsDefaultString", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nLocalDateTimeColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDateTimeColumnType.kt\norg/jetbrains/exposed/v1/core/datetime/LocalDateTimeColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public abstract class LocalDateTimeColumnType<T>
extends ColumnType<T>
implements IDateColumnType {
    private final boolean hasTimePart;

    public LocalDateTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    @NotNull
    public abstract LocalDateTime toLocalDateTime(T var1);

    public abstract T fromLocalDateTime(@NotNull LocalDateTime var1);

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().dateTimeType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull T value) {
        String string;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        LocalDateTime dateTime = TimeZoneKt.toLocalDateTime((kotlin.time.Instant)TimeZoneKt.toInstant$default((LocalDateTime)this.toLocalDateTime(value), (TimeZone)TimeZone.Companion.currentSystemDefault(), null, (int)2, null), (TimeZone)TimeZone.Companion.currentSystemDefault());
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof SQLiteDialect) {
            string = '\'' + LocalDateTimeColumnTypeKt.access$getSQLITE_ORACLE_DATETIME_FORMAT().format((Object)dateTime) + '\'';
        } else if (dialect instanceof OracleDialect) {
            String formatted = LocalDateTimeColumnTypeKt.access$getSQLITE_ORACLE_DATETIME_FORMAT().format((Object)dateTime);
            string = "TO_TIMESTAMP('" + formatted + "', 'YYYY-MM-DD HH24:MI:SS.FF3')";
        } else if (dialect instanceof MysqlDialect) {
            DateTimeFormat formatter = ((MysqlDialect)dialect).isFractionDateTimeSupported() ? LocalDateTimeColumnTypeKt.access$getMYSQL_FRACTION_DATETIME_FORMAT() : LocalDateTimeColumnTypeKt.access$getMYSQL_DATETIME_FORMAT();
            string = '\'' + formatter.format((Object)dateTime) + '\'';
        } else {
            string = '\'' + LocalDateTimeColumnTypeKt.access$getDEFAULT_DATETIME_FORMAT().format((Object)dateTime) + '\'';
        }
        return string;
    }

    private final LocalDateTime localDateTimeValueFromDB(Object value) {
        LocalDateTime localDateTime;
        Object object = value;
        if (object instanceof LocalDateTime) {
            localDateTime = (LocalDateTime)value;
        } else if (object instanceof Date) {
            localDateTime = this.longToLocalDateTime(((Date)value).getTime());
        } else if (object instanceof Timestamp) {
            localDateTime = this.longToLocalDateTime(((Timestamp)value).getTime() / (long)1000, ((Timestamp)value).getNanos());
        } else if (object instanceof Integer) {
            localDateTime = this.longToLocalDateTime(((Number)value).intValue());
        } else if (object instanceof Long) {
            localDateTime = this.longToLocalDateTime(((Number)value).longValue());
        } else if (object instanceof String) {
            localDateTime = this.parseLocalDateTime((String)value);
        } else if (object instanceof OffsetDateTime) {
            Instant instant = ((OffsetDateTime)value).toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
            localDateTime = TimeZoneKt.toLocalDateTime((kotlin.time.Instant)InstantConversionsJDK8Kt.toKotlinInstant((Instant)instant), (TimeZone)TimeZone.Companion.currentSystemDefault());
        } else {
            localDateTime = this.localDateTimeValueFromDB(value.toString());
        }
        return localDateTime;
    }

    @Override
    @Nullable
    public T valueFromDB(@NotNull Object value) {
        T t;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        LocalDateTime localDateTime = this.localDateTimeValueFromDB(value);
        if (localDateTime != null) {
            LocalDateTime it = localDateTime;
            boolean bl = false;
            t = this.fromLocalDateTime(it);
        } else {
            t = null;
        }
        return t;
    }

    private final LocalDateTime longToLocalDateTime(long millis) {
        return TimeZoneKt.toLocalDateTime((kotlin.time.Instant)kotlin.time.Instant.Companion.fromEpochMilliseconds(millis), (TimeZone)TimeZone.Companion.currentSystemDefault());
    }

    private final LocalDateTime longToLocalDateTime(long seconds, long nanos) {
        return TimeZoneKt.toLocalDateTime((kotlin.time.Instant)kotlin.time.Instant.Companion.fromEpochSeconds(seconds, nanos), (TimeZone)TimeZone.Companion.currentSystemDefault());
    }

    private final LocalDateTime parseLocalDateTime(String value) {
        LocalDateTime localDateTime;
        try {
            int fractionLength = StringsKt.substringAfterLast((String)value, (char)'.', (String)"").length();
            localDateTime = (LocalDateTime)LocalDateTimeColumnTypeKt.createLocalDateTimeFormatter(fractionLength).parse((CharSequence)value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            localDateTime = LocalDateTime.Companion.parse$default((LocalDateTime.Companion)LocalDateTime.Companion, (CharSequence)value, null, (int)2, null);
        }
        return localDateTime;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        LocalDateTime localDateTime = this.toLocalDateTime(value);
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? LocalDateTimeColumnTypeKt.access$getSQLITE_ORACLE_DATETIME_FORMAT().format((Object)localDateTime) : LocalDateTimeColumnTypeKt.toSqlTimestamp$default(localDateTime, null, 1, null);
    }

    @Override
    @Nullable
    public Object readObject(@NotNull RowApi rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect ? rs.getObject(index, Timestamp.class) : super.readObject(rs, index);
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(@NotNull T value) {
        String string;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        LocalDateTime localDateTime = this.toLocalDateTime(value);
        if (dialect instanceof PostgreSQLDialect) {
            String formatted = LocalDateTimeColumnTypeKt.access$getSQLITE_ORACLE_DATETIME_FORMAT().format((Object)localDateTime);
            char[] cArray = new char[]{'0'};
            String string2 = StringsKt.trimEnd((String)formatted, (char[])cArray);
            cArray = new char[]{'.'};
            string = '\'' + StringsKt.trimEnd((String)string2, (char[])cArray) + "'::timestamp without time zone";
        } else {
            H2Dialect h2Dialect = dialect instanceof H2Dialect ? (H2Dialect)dialect : null;
            if ((h2Dialect != null ? h2Dialect.getH2Mode() : null) == H2Dialect.H2CompatibilityMode.Oracle) {
                String formatted = LocalDateTimeColumnTypeKt.access$getSQLITE_ORACLE_DATETIME_FORMAT().format((Object)localDateTime);
                char[] cArray = new char[]{'0'};
                String string3 = StringsKt.trimEnd((String)formatted, (char[])cArray);
                cArray = new char[]{'.'};
                string = '\'' + StringsKt.trimEnd((String)string3, (char[])cArray) + '\'';
            } else {
                string = super.nonNullValueAsDefaultString(value);
            }
        }
        return string;
    }
}

