/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.Column;
import org.jetbrains.exposed.v1.core.ColumnTypeKt;
import org.jetbrains.exposed.v1.core.EntityIDColumnType;
import org.jetbrains.exposed.v1.core.InternalApi;
import org.jetbrains.exposed.v1.core.ResultRow;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.statements.BatchDataInconsistentException;
import org.jetbrains.exposed.v1.core.statements.DefaultValueMarker;
import org.jetbrains.exposed.v1.core.statements.InsertStatement;
import org.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0017\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u0010H\u0002J*\u0010\u0018\u001a\u00020\u0019\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u00102\u0006\u0010\u001c\u001a\u0002H\u001aH\u0096\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u0019J\u0006\u0010\u001f\u001a\u00020\u0019J\b\u0010 \u001a\u00020\u0019H\u0017J\u0012\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100#H\u0002R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fRP\u0010\r\u001a6\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f0\u000ej\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f`\u00128\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010$\u001a\"\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110%0\u0002\u0018\u00010\u00028VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lorg/jetbrains/exposed/v1/core/statements/BatchInsertStatement;", "Lorg/jetbrains/exposed/v1/core/statements/InsertStatement;", "", "Lorg/jetbrains/exposed/v1/core/ResultRow;", "table", "Lorg/jetbrains/exposed/v1/core/Table;", "ignore", "", "shouldReturnGeneratedValues", "<init>", "(Lorg/jetbrains/exposed/v1/core/Table;ZZ)V", "getShouldReturnGeneratedValues", "()Z", "data", "Ljava/util/ArrayList;", "", "Lorg/jetbrains/exposed/v1/core/Column;", "", "Lkotlin/collections/ArrayList;", "getData$annotations", "()V", "getData", "()Ljava/util/ArrayList;", "isDefaultable", "set", "", "S", "column", "value", "(Lorg/jetbrains/exposed/v1/core/Column;Ljava/lang/Object;)V", "addBatch", "removeLastBatch", "validateLastBatch", "allColumnsInDataSet", "", "", "arguments", "Lkotlin/Pair;", "getArguments", "()Ljava/util/List;", "setArguments", "(Ljava/util/List;)V", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nBatchInsertStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BatchInsertStatement.kt\norg/jetbrains/exposed/v1/core/statements/BatchInsertStatement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1460#2,5:123\n827#2:128\n855#2,2:129\n1374#2:131\n1460#2,5:132\n774#2:137\n865#2,2:138\n1563#2:140\n1634#2,3:141\n1563#2:144\n1634#2,2:145\n1563#2:147\n1634#2,3:148\n1636#2:151\n1#3:152\n*S KotlinDebug\n*F\n+ 1 BatchInsertStatement.kt\norg/jetbrains/exposed/v1/core/statements/BatchInsertStatement\n*L\n64#1:123,5\n75#1:128\n75#1:129,2\n82#1:131\n82#1:132,5\n82#1:137\n82#1:138,2\n104#1:140\n104#1:141,3\n105#1:144\n105#1:145,2\n106#1:147\n106#1:148,3\n105#1:151\n*E\n"})
public class BatchInsertStatement
extends InsertStatement<List<? extends ResultRow>> {
    private final boolean shouldReturnGeneratedValues;
    @NotNull
    private final ArrayList<Map<Column<?>, Object>> data;
    @NotNull
    private final Set<Column<?>> allColumnsInDataSet;
    @Nullable
    private List<? extends List<? extends Pair<? extends Column<?>, ? extends Object>>> arguments;

    public BatchInsertStatement(@NotNull Table table, boolean ignore, boolean shouldReturnGeneratedValues) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        super(table, ignore);
        this.shouldReturnGeneratedValues = shouldReturnGeneratedValues;
        this.data = new ArrayList();
        this.allColumnsInDataSet = new LinkedHashSet();
    }

    public /* synthetic */ BatchInsertStatement(Table table, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(table, bl, bl2);
    }

    public final boolean getShouldReturnGeneratedValues() {
        return this.shouldReturnGeneratedValues;
    }

    @NotNull
    public final ArrayList<Map<Column<?>, Object>> getData() {
        return this.data;
    }

    @InternalApi
    public static /* synthetic */ void getData$annotations() {
    }

    private final boolean isDefaultable(Column<?> $this$isDefaultable) {
        return $this$isDefaultable.getColumnType().getNullable() || $this$isDefaultable.getDefaultValueFun() != null || $this$isDefaultable.isDatabaseGenerated$exposed_core();
    }

    @Override
    public <S> void set(@NotNull Column<S> column, S value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (this.data.size() > 1) {
            Map<Column<?>, Object> map = this.data.get(this.data.size() - 2);
            Intrinsics.checkNotNullExpressionValue(map, (String)"get(...)");
            if (!map.containsKey(column) && !this.isDefaultable(column)) {
                String fullIdentity = CoreTransactionManager.INSTANCE.currentTransaction().fullIdentity(column);
                throw new BatchDataInconsistentException("Can't set " + value + " for " + fullIdentity + " because previous insertion can't be defaulted for that column.");
            }
        }
        super.set(column, value);
    }

    public final void addBatch() {
        if (!((Collection)this.data).isEmpty()) {
            this.validateLastBatch();
            this.data.set(this.data.size() - 1, new LinkedHashMap(this.getValues()));
            this.allColumnsInDataSet.addAll((Collection)this.getValues().keySet());
            this.getValues().clear();
            this.setHasBatchedValues(true);
        }
        this.data.add(this.getValues());
        this.setArguments(null);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeLastBatch() {
        void $this$flatMapTo$iv;
        this.data.remove(this.data.size() - 1);
        this.allColumnsInDataSet.clear();
        Iterable iterable = this.data;
        Collection destination$iv = this.allColumnsInDataSet;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Map it = (Map)element$iv;
            boolean bl = false;
            Iterable list$iv = it.keySet();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        this.getValues().clear();
        this.getValues().putAll((Map)CollectionsKt.last((List)this.data));
        this.setArguments(null);
        this.setHasBatchedValues(this.data.size() > 0);
    }

    /*
     * WARNING - void declaration
     */
    @InternalApi
    public void validateLastBatch() {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        Transaction tr = CoreTransactionManager.INSTANCE.currentTransaction();
        Iterable $this$filterNot$iv = SetsKt.minus(this.allColumnsInDataSet, (Iterable)this.getValues().keySet());
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Column it = (Column)element$iv$iv;
            boolean bl = false;
            if (this.isDefaultable(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cantBeDefaulted = (List)destination$iv$iv;
        if (!((Collection)cantBeDefaulted).isEmpty()) {
            String columnList = CollectionsKt.joinToString$default((Iterable)cantBeDefaulted, null, null, null, (int)0, null, arg_0 -> BatchInsertStatement.validateLastBatch$lambda$2(tr, arg_0), (int)31, null);
            throw new BatchDataInconsistentException("Can't add a new batch because columns: " + columnList + " don't have client default values. DB defaults are not supported in batch inserts");
        }
        Iterable $this$flatMap$iv = this.getTargets();
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Table it = (Table)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getColumns();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = CollectionsKt.minus((Iterable)((List)destination$iv$iv2), (Iterable)this.getValues().keySet());
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Column it = (Column)element$iv$iv;
            boolean bl = false;
            if (!(!this.isDefaultable(it) && !ColumnTypeKt.isAutoInc(it.getColumnType()) && it.getDbDefaultValue$exposed_core() == null && !(it.getColumnType() instanceof EntityIDColumnType))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List requiredInTargets = (List)destination$iv$iv2;
        if (CollectionsKt.any((Iterable)requiredInTargets)) {
            String columnList = CollectionsKt.joinToString$default((Iterable)requiredInTargets, null, null, null, (int)0, null, arg_0 -> BatchInsertStatement.validateLastBatch$lambda$5(tr, arg_0), (int)31, null);
            throw new BatchDataInconsistentException("Can't add a new batch because columns: " + columnList + " don't have default values. DB defaults are not supported in batch inserts");
        }
    }

    private final Set<Column<?>> allColumnsInDataSet() {
        Object object = (Map)CollectionsKt.lastOrNull((List)this.data);
        if (object == null || (object = object.keySet()) == null) {
            throw new BatchDataInconsistentException("No data provided for inserting into " + this.getTable().getTableName());
        }
        return SetsKt.plus(this.allColumnsInDataSet, (Iterable)((Iterable)object));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<List<Pair<Column<?>, Object>>> getArguments() {
        Iterable<List<Object>> iterable = this.arguments;
        if (iterable == null) {
            Map it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            BatchInsertStatement $this$_get_arguments__u24lambda_u2411 = this;
            boolean bl = false;
            Set columnsToInsert = CollectionsKt.toSet((Iterable)SetsKt.plus($this$_get_arguments__u24lambda_u2411.allColumnsInDataSet(), (Iterable)$this$_get_arguments__u24lambda_u2411.clientDefaultColumns()));
            Iterable iterable2 = $this$_get_arguments__u24lambda_u2411.data;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Map map = (Map)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                Map<Column<?>, Object> map2 = $this$_get_arguments__u24lambda_u2411.valuesAndClientDefaults(it);
                Intrinsics.checkNotNull(map2, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<org.jetbrains.exposed.v1.core.Column<*>, kotlin.Any?>");
                collection.add(TypeIntrinsics.asMutableMap(map2));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                it = (Map)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                Iterable $this$map$iv2 = columnsToInsert;
                boolean $i$f$map2 = false;
                Iterable iterable3 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    Object object;
                    void values;
                    void column;
                    Column column2 = (Column)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl4 = false;
                    void v2 = column;
                    if (values.containsKey(column)) {
                        object = values.get(column);
                    } else if (column.getDbDefaultValue$exposed_core() != null || column.isDatabaseGenerated$exposed_core()) {
                        object = DefaultValueMarker.INSTANCE;
                    } else {
                        if (!column.getColumnType().getNullable()) {
                            void var24_26 = v2;
                            boolean bl5 = false;
                            void v4 = var24_26;
                            String string = "The value for the column " + column.getName() + " was not provided. The value for non-nullable column without defaults must be specified.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        object = null;
                    }
                    collection2.add(TuplesKt.to((Object)v2, object));
                }
                collection.add((List)destination$iv$iv2);
            }
            Iterable $this$_get_arguments__u24lambda_u2411_u24lambda_u2410 = iterable2 = (List)destination$iv$iv;
            boolean bl6 = false;
            this.arguments = $this$_get_arguments__u24lambda_u2411_u24lambda_u2410;
            iterable = iterable2;
        }
        return iterable;
    }

    @Override
    public void setArguments(@Nullable List<? extends List<? extends Pair<? extends Column<?>, ? extends Object>>> list) {
        this.arguments = list;
    }

    private static final CharSequence validateLastBatch$lambda$2(Transaction $tr, Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $tr.fullIdentity(it);
    }

    private static final CharSequence validateLastBatch$lambda$5(Transaction $tr, Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $tr.fullIdentity(it);
    }
}

