/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.statements.api;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.ReferenceOption;
import org.jetbrains.exposed.v1.core.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.H2Dialect;
import org.jetbrains.exposed.v1.core.vendors.H2Kt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH&J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0003H$J\b\u0010\r\u001a\u00020\tH&J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003J \u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/exposed/v1/core/statements/api/ExposedDatabaseMetadata;", "", "database", "", "<init>", "(Ljava/lang/String;)V", "getDatabase", "()Ljava/lang/String;", "resetCurrentScheme", "", "resolveReferenceOption", "Lorg/jetbrains/exposed/v1/core/ReferenceOption;", "refOption", "cleanCache", "identifierManager", "Lorg/jetbrains/exposed/v1/core/statements/api/IdentifierManagerApi;", "getIdentifierManager", "()Lorg/jetbrains/exposed/v1/core/statements/api/IdentifierManagerApi;", "areEquivalentColumnTypes", "", "columnMetadataSqlType", "columnMetadataType", "", "columnType", "areEquivalentColumnTypesH2", "columnMetadataJdbcType", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nExposedDatabaseMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExposedDatabaseMetadata.kt\norg/jetbrains/exposed/v1/core/statements/api/ExposedDatabaseMetadata\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1740#2,3:124\n1740#2,3:127\n1740#2,3:130\n*S KotlinDebug\n*F\n+ 1 ExposedDatabaseMetadata.kt\norg/jetbrains/exposed/v1/core/statements/api/ExposedDatabaseMetadata\n*L\n60#1:124,3\n64#1:127,3\n81#1:130,3\n*E\n"})
public abstract class ExposedDatabaseMetadata {
    @NotNull
    private final String database;

    public ExposedDatabaseMetadata(@NotNull String database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
    }

    @NotNull
    public final String getDatabase() {
        return this.database;
    }

    public abstract void resetCurrentScheme();

    @Nullable
    protected abstract ReferenceOption resolveReferenceOption(@NotNull String var1);

    public abstract void cleanCache();

    @NotNull
    public abstract IdentifierManagerApi getIdentifierManager();

    public final boolean areEquivalentColumnTypes(@NotNull String columnMetadataSqlType, int columnMetadataType, @NotNull String columnType) {
        Intrinsics.checkNotNullParameter((Object)columnMetadataSqlType, (String)"columnMetadataSqlType");
        Intrinsics.checkNotNullParameter((Object)columnType, (String)"columnType");
        return StringsKt.equals((String)columnMetadataSqlType, (String)columnType, (boolean)true) ? true : (DatabaseDialectKt.getCurrentDialect() instanceof H2Dialect ? this.areEquivalentColumnTypesH2(columnMetadataSqlType, columnMetadataType, columnType) : false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean areEquivalentColumnTypesH2(String columnMetadataSqlType, int columnMetadataJdbcType, String columnType) {
        Object it;
        Object element$iv;
        CharSequence charSequence;
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        String string = columnMetadataSqlType.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String columnMetadataSqlType2 = string;
        String string2 = columnType.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String columnType2 = string2;
        if (columnMetadataJdbcType == 2003) {
            String baseType = StringsKt.substringBefore$default((String)columnMetadataSqlType2, (String)" ARRAY", null, (int)2, null);
            if (!this.areEquivalentColumnTypes(baseType, 1111, StringsKt.substringBefore$default((String)columnType2, (String)" ARRAY", null, (int)2, null))) return false;
            if (!this.areEquivalentColumnTypes(StringsKt.replaceBefore$default((String)columnMetadataSqlType2, (String)"ARRAY", (String)"", null, (int)4, null), 1111, StringsKt.replaceBefore$default((String)columnType2, (String)"ARRAY", (String)"", null, (int)4, null))) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)columnType2, (Object)"TEXT") && Intrinsics.areEqual((Object)columnMetadataSqlType2, (Object)"VARCHAR")) {
            return true;
        }
        Object[] baseType = new String[]{columnMetadataSqlType2, columnType2};
        Object $this$all$iv = (Object[])CollectionsKt.listOf((Object[])baseType);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
            charSequence = (CharSequence)it;
        } while (new Regex("VARCHAR(?:\\((?:MAX|\\d+)\\))?").matches(charSequence));
        boolean bl = false;
        if (bl) {
            return true;
        }
        $this$all$iv = new String[]{columnMetadataSqlType2, columnType2};
        $this$all$iv = CollectionsKt.listOf((Object[])$this$all$iv);
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl2 = false;
            charSequence = (CharSequence)it;
        } while (new Regex("VARBINARY(?:\\((?:MAX|\\d+)\\))?").matches(charSequence));
        boolean bl3 = false;
        if (bl3) {
            return true;
        }
        H2Dialect.H2CompatibilityMode h2CompatibilityMode = H2Kt.getH2Mode(dialect);
        switch (h2CompatibilityMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) {
            case 1: {
                if (Intrinsics.areEqual((Object)columnType2, (Object)"SERIAL")) {
                    if (Intrinsics.areEqual((Object)columnMetadataSqlType2, (Object)"INT")) return true;
                }
                if (!Intrinsics.areEqual((Object)columnType2, (Object)"BIGSERIAL")) return false;
                if (!Intrinsics.areEqual((Object)columnMetadataSqlType2, (Object)"BIGINT")) return false;
                return true;
            }
            case 2: {
                CharSequence charSequence2;
                if (Intrinsics.areEqual((Object)columnType2, (Object)"DATE") && Intrinsics.areEqual((Object)columnMetadataSqlType2, (Object)"TIMESTAMP(0)")) {
                    return true;
                }
                Object[] objectArray = new String[]{columnMetadataSqlType2, columnType2};
                Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$all2 = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    return true;
                }
                it = iterable.iterator();
                do {
                    if (!it.hasNext()) return true;
                    Object element$iv2 = it.next();
                    String it2 = (String)element$iv2;
                    boolean bl4 = false;
                    charSequence2 = it2;
                } while (new Regex("VARCHAR2(?:\\((?:MAX|\\d+)(?:\\s+CHAR)?\\))?").matches(charSequence2));
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
                Regex regex = new Regex("NUMBER(?:\\((\\d+)(?:,\\s?(\\d+))?\\))?");
                Regex numericRegex = new Regex("NUMERIC(?:\\((\\d+)(?:,\\s?(\\d+))?\\))?");
                MatchResult numberMatch = Regex.find$default((Regex)regex, (CharSequence)columnType2, (int)0, (int)2, null);
                MatchResult numericMatch = Regex.find$default((Regex)numericRegex, (CharSequence)columnMetadataSqlType2, (int)0, (int)2, null);
                if (numberMatch == null) return false;
                if (numericMatch == null) return false;
                boolean bl6 = Intrinsics.areEqual(numberMatch.getGroupValues().get(1), numericMatch.getGroupValues().get(1));
                return bl6;
            }
            case 3: {
                CharSequence charSequence3;
                boolean bl6;
                if (StringsKt.equals((String)columnType2, (String)"uniqueidentifier", (boolean)true) && Intrinsics.areEqual((Object)columnMetadataSqlType2, (Object)"UUID")) {
                    return true;
                }
                if (StringsKt.contains$default((CharSequence)columnType2, (CharSequence)" IDENTITY", (boolean)false, (int)2, null)) {
                    bl6 = this.areEquivalentColumnTypes(columnMetadataSqlType2, columnMetadataJdbcType, StringsKt.substringBefore$default((String)columnType2, (String)" IDENTITY", null, (int)2, null));
                    return bl6;
                }
                CharSequence charSequence4 = columnType2;
                if (new Regex("DATETIME2(?:\\(\\d+\\))?").matches(charSequence4) && new Regex("TIMESTAMP(?:\\(\\d+\\))?").matches(charSequence3 = (CharSequence)columnMetadataSqlType2)) {
                    return true;
                }
                CharSequence charSequence5 = columnType2;
                if (!new Regex("NVARCHAR(?:\\((\\d+|MAX)\\))?").matches(charSequence5)) return false;
                CharSequence charSequence6 = columnMetadataSqlType2;
                if (!new Regex("VARCHAR(?:\\((\\d+|MAX)\\))?").matches(charSequence6)) return false;
                return true;
            }
            case -1: 
            case 4: 
            case 5: {
                boolean bl6;
                if (StringsKt.contains$default((CharSequence)columnType2, (CharSequence)" AUTO_INCREMENT", (boolean)false, (int)2, null)) {
                    bl6 = this.areEquivalentColumnTypes(columnMetadataSqlType2, columnMetadataJdbcType, StringsKt.substringBefore$default((String)columnType2, (String)" AUTO_INCREMENT", null, (int)2, null));
                    return bl6;
                }
                CharSequence charSequence7 = columnType2;
                if (!new Regex("DATETIME(?:\\(\\d+\\))?").matches(charSequence7)) return false;
                CharSequence charSequence8 = columnMetadataSqlType2;
                if (!new Regex("TIMESTAMP(?:\\(\\d+\\))?").matches(charSequence8)) return false;
                return true;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[H2Dialect.H2CompatibilityMode.values().length];
            try {
                nArray[H2Dialect.H2CompatibilityMode.PostgreSQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2Dialect.H2CompatibilityMode.Oracle.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2Dialect.H2CompatibilityMode.SQLServer.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2Dialect.H2CompatibilityMode.MySQL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2Dialect.H2CompatibilityMode.MariaDB.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

