/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.vendors;

import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.Column;
import org.jetbrains.exposed.v1.core.ColumnDiff;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.Index;
import org.jetbrains.exposed.v1.core.LiteralOp;
import org.jetbrains.exposed.v1.core.ReferenceOption;
import org.jetbrains.exposed.v1.core.Schema;
import org.jetbrains.exposed.v1.core.SchemaKt;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.vendors.DataTypeProvider;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.FunctionProvider;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u0000 k2\u00020\u0001:\u0001kJ\u0014\u0010E\u001a\u00020\u000f2\n\u0010F\u001a\u0006\u0012\u0002\b\u00030GH\u0016J\u0010\u0010H\u001a\u00020\u00032\u0006\u0010I\u001a\u00020JH&J(\u0010K\u001a\u00020\u00032\u0006\u0010L\u001a\u00020\u00032\u0006\u0010M\u001a\u00020\u00032\u0006\u0010N\u001a\u00020\u000f2\u0006\u0010O\u001a\u00020\u000fH&J\"\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00030Q2\n\u0010R\u001a\u0006\u0012\u0002\b\u00030S2\u0006\u0010T\u001a\u00020UH&J;\u0010V\u001a\u00020\u00032\u0006\u0010W\u001a\u00020X2\b\u0010Y\u001a\u0004\u0018\u00010\u00032\u001a\u0010Z\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030S0[\"\u0006\u0012\u0002\b\u00030SH&\u00a2\u0006\u0002\u0010\\J\u0010\u0010]\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010^\u001a\u00020\u0003H\u0016J\u0010\u0010_\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010`\u001a\u00020\u00032\u0006\u0010a\u001a\u00020bH\u0016J\u0010\u0010c\u001a\u00020\u00032\u0006\u0010a\u001a\u00020bH\u0016J\u0018\u0010d\u001a\u00020\u00032\u0006\u0010a\u001a\u00020b2\u0006\u0010e\u001a\u00020\u000fH\u0016J \u0010f\u001a\u00020\u000f2\u0006\u0010g\u001a\u00020\u00032\u0006\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020\u0003H\u0017R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u0012\u0010\u001c\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011R\u0014\u0010\u001e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011R\u0014\u0010 \u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0011R\u0014\u0010\"\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0011R\u0014\u0010$\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0011R\u0014\u0010&\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0011R\u0014\u0010(\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0011R\u0014\u0010*\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0011R\u0014\u0010,\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0011R\u0014\u0010.\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0011R\u0014\u00100\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0011R\u0014\u00102\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0011R\"\u00104\u001a\u0010\u0012\u0004\u0012\u000206\u0012\u0006\u0012\u0004\u0018\u000106058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0014\u00109\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0011R\u0014\u0010;\u001a\u00020<8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0014\u0010?\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u0011R\u001a\u0010A\u001a\u00020\u000f8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\bB\u0010C\u001a\u0004\bD\u0010\u0011\u00a8\u0006l"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/DatabaseDialect;", "", "name", "", "getName", "()Ljava/lang/String;", "dataTypeProvider", "Lorg/jetbrains/exposed/v1/core/vendors/DataTypeProvider;", "getDataTypeProvider", "()Lorg/jetbrains/exposed/v1/core/vendors/DataTypeProvider;", "functionProvider", "Lorg/jetbrains/exposed/v1/core/vendors/FunctionProvider;", "getFunctionProvider", "()Lorg/jetbrains/exposed/v1/core/vendors/FunctionProvider;", "supportsIfNotExists", "", "getSupportsIfNotExists", "()Z", "supportsCreateSequence", "getSupportsCreateSequence", "needsSequenceToAutoInc", "getNeedsSequenceToAutoInc", "defaultReferenceOption", "Lorg/jetbrains/exposed/v1/core/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/v1/core/ReferenceOption;", "needsQuotesWhenSymbolsInNames", "getNeedsQuotesWhenSymbolsInNames", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsSequenceAsGeneratedKeys", "getSupportsSequenceAsGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsTernaryAffectedRowValues", "getSupportsTernaryAffectedRowValues", "supportsCreateSchema", "getSupportsCreateSchema", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "supportsDualTableConcept", "getSupportsDualTableConcept", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsWindowFrameGroupsMode", "getSupportsWindowFrameGroupsMode", "supportsOnUpdate", "getSupportsOnUpdate", "supportsSetDefaultReferenceOption", "getSupportsSetDefaultReferenceOption", "supportsRestrictReferenceOption", "getSupportsRestrictReferenceOption", "likePatternSpecialChars", "", "", "getLikePatternSpecialChars", "()Ljava/util/Map;", "requiresAutoCommitOnCreateDrop", "getRequiresAutoCommitOnCreateDrop", "sequenceMaxValue", "", "getSequenceMaxValue", "()J", "supportsColumnTypeChange", "getSupportsColumnTypeChange", "supportsSelectForUpdate", "getSupportsSelectForUpdate$annotations", "()V", "getSupportsSelectForUpdate", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/v1/core/Expression;", "createIndex", "index", "Lorg/jetbrains/exposed/v1/core/Index;", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "modifyColumn", "", "column", "Lorg/jetbrains/exposed/v1/core/Column;", "columnDiff", "Lorg/jetbrains/exposed/v1/core/ColumnDiff;", "addPrimaryKey", "table", "Lorg/jetbrains/exposed/v1/core/Table;", "pkName", "pkColumns", "", "(Lorg/jetbrains/exposed/v1/core/Table;Ljava/lang/String;[Lorg/jetbrains/exposed/v1/core/Column;)Ljava/lang/String;", "createDatabase", "listDatabases", "dropDatabase", "setSchema", "schema", "Lorg/jetbrains/exposed/v1/core/Schema;", "createSchema", "dropSchema", "cascade", "areEquivalentColumnTypes", "columnMetadataSqlType", "columnMetadataJdbcType", "", "columnType", "Companion", "exposed-core"})
public interface DatabaseDialect {
    @NotNull
    public static final Companion Companion = org.jetbrains.exposed.v1.core.vendors.DatabaseDialect$Companion.$$INSTANCE;

    @NotNull
    public String getName();

    @NotNull
    public DataTypeProvider getDataTypeProvider();

    @NotNull
    public FunctionProvider getFunctionProvider();

    public boolean getSupportsIfNotExists();

    public boolean getSupportsCreateSequence();

    public boolean getNeedsSequenceToAutoInc();

    @NotNull
    public ReferenceOption getDefaultReferenceOption();

    public boolean getNeedsQuotesWhenSymbolsInNames();

    public boolean getSupportsMultipleGeneratedKeys();

    public boolean getSupportsSequenceAsGeneratedKeys();

    public boolean getSupportsOnlyIdentifiersInGeneratedKeys();

    public boolean getSupportsTernaryAffectedRowValues();

    public boolean getSupportsCreateSchema();

    public boolean getSupportsSubqueryUnions();

    public boolean getSupportsDualTableConcept();

    public boolean getSupportsOrderByNullsFirstLast();

    public boolean getSupportsWindowFrameGroupsMode();

    public boolean getSupportsOnUpdate();

    public boolean getSupportsSetDefaultReferenceOption();

    public boolean getSupportsRestrictReferenceOption();

    @NotNull
    public Map<Character, Character> getLikePatternSpecialChars();

    public boolean getRequiresAutoCommitOnCreateDrop();

    public long getSequenceMaxValue();

    public boolean getSupportsColumnTypeChange();

    public boolean getSupportsSelectForUpdate();

    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> var1);

    @NotNull
    public String createIndex(@NotNull Index var1);

    @NotNull
    public String dropIndex(@NotNull String var1, @NotNull String var2, boolean var3, boolean var4);

    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> var1, @NotNull ColumnDiff var2);

    @NotNull
    public String addPrimaryKey(@NotNull Table var1, @Nullable String var2, Column<?> ... var3);

    @NotNull
    public String createDatabase(@NotNull String var1);

    @NotNull
    public String listDatabases();

    @NotNull
    public String dropDatabase(@NotNull String var1);

    @NotNull
    public String setSchema(@NotNull Schema var1);

    @NotNull
    public String createSchema(@NotNull Schema var1);

    @NotNull
    public String dropSchema(@NotNull Schema var1, boolean var2);

    @Deprecated(message="This method was moved to ExposedDatabaseMetadata and should not be used anymore from here.", replaceWith=@ReplaceWith(expression="currentDialectMetadata.areEquivalentColumnTypes(columnMetadataSqlType, columnMetadataJdbcType, columnType)", imports={}))
    public boolean areEquivalentColumnTypes(@NotNull String var1, int var2, @NotNull String var3);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u0001\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/DatabaseDialect$Companion;", "", "<init>", "()V", "defaultLikePatternSpecialChars", "", "", "", "exposed-core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Map defaultLikePatternSpecialChars;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('%'), null), TuplesKt.to((Object)Character.valueOf('_'), null)};
            defaultLikePatternSpecialChars = MapsKt.mapOf((Pair[])pairArray);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean getSupportsIfNotExists(@NotNull DatabaseDialect $this) {
            return true;
        }

        public static boolean getSupportsCreateSequence(@NotNull DatabaseDialect $this) {
            return true;
        }

        public static boolean getNeedsSequenceToAutoInc(@NotNull DatabaseDialect $this) {
            return false;
        }

        @NotNull
        public static ReferenceOption getDefaultReferenceOption(@NotNull DatabaseDialect $this) {
            return ReferenceOption.RESTRICT;
        }

        public static boolean getNeedsQuotesWhenSymbolsInNames(@NotNull DatabaseDialect $this) {
            return true;
        }

        public static boolean getSupportsSequenceAsGeneratedKeys(@NotNull DatabaseDialect $this) {
            return $this.getSupportsCreateSequence();
        }

        public static boolean getSupportsOnlyIdentifiersInGeneratedKeys(@NotNull DatabaseDialect $this) {
            return false;
        }

        public static boolean getSupportsTernaryAffectedRowValues(@NotNull DatabaseDialect $this) {
            return false;
        }

        public static boolean getSupportsCreateSchema(@NotNull DatabaseDialect $this) {
            return true;
        }

        public static boolean getSupportsSubqueryUnions(@NotNull DatabaseDialect $this) {
            return false;
        }

        public static boolean getSupportsDualTableConcept(@NotNull DatabaseDialect $this) {
            return false;
        }

        public static boolean getSupportsOrderByNullsFirstLast(@NotNull DatabaseDialect $this) {
            return false;
        }

        public static boolean getSupportsWindowFrameGroupsMode(@NotNull DatabaseDialect $this) {
            return false;
        }

        public static boolean getSupportsOnUpdate(@NotNull DatabaseDialect $this) {
            return true;
        }

        public static boolean getSupportsSetDefaultReferenceOption(@NotNull DatabaseDialect $this) {
            return true;
        }

        public static boolean getSupportsRestrictReferenceOption(@NotNull DatabaseDialect $this) {
            return true;
        }

        @NotNull
        public static Map<Character, Character> getLikePatternSpecialChars(@NotNull DatabaseDialect $this) {
            return org.jetbrains.exposed.v1.core.vendors.DatabaseDialect$Companion.defaultLikePatternSpecialChars;
        }

        public static boolean getRequiresAutoCommitOnCreateDrop(@NotNull DatabaseDialect $this) {
            return false;
        }

        public static long getSequenceMaxValue(@NotNull DatabaseDialect $this) {
            return Long.MAX_VALUE;
        }

        public static boolean getSupportsColumnTypeChange(@NotNull DatabaseDialect $this) {
            return false;
        }

        public static boolean getSupportsSelectForUpdate(@NotNull DatabaseDialect $this) {
            return false;
        }

        @Deprecated(message="The parameter was moved to JdbcExposedDatabaseMetadata/R2dbcExposedDatabaseMetadata classes", replaceWith=@ReplaceWith(expression="TransactionManager.current().db.supportsSelectForUpdate", imports={}))
        public static /* synthetic */ void getSupportsSelectForUpdate$annotations() {
        }

        public static boolean isAllowedAsColumnDefault(@NotNull DatabaseDialect $this, @NotNull Expression<?> e) {
            Intrinsics.checkNotNullParameter(e, (String)"e");
            return e instanceof LiteralOp;
        }

        @NotNull
        public static String createDatabase(@NotNull DatabaseDialect $this, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return "CREATE DATABASE IF NOT EXISTS " + DatabaseDialectKt.inProperCase(name);
        }

        @NotNull
        public static String listDatabases(@NotNull DatabaseDialect $this) {
            return "SHOW DATABASES";
        }

        @NotNull
        public static String dropDatabase(@NotNull DatabaseDialect $this, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return "DROP DATABASE IF EXISTS " + DatabaseDialectKt.inProperCase(name);
        }

        @NotNull
        public static String setSchema(@NotNull DatabaseDialect $this, @NotNull Schema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return "SET SCHEMA " + schema.getIdentifier();
        }

        @NotNull
        public static String createSchema(@NotNull DatabaseDialect $this, @NotNull Schema schema) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            StringBuilder $this$createSchema_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$createSchema_u24lambda_u240.append("CREATE SCHEMA IF NOT EXISTS ");
            $this$createSchema_u24lambda_u240.append(schema.getIdentifier());
            SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u240, " AUTHORIZATION ", schema.getAuthorization());
            return stringBuilder.toString();
        }

        @NotNull
        public static String dropSchema(@NotNull DatabaseDialect $this, @NotNull Schema schema, boolean cascade) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            StringBuilder $this$dropSchema_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            String[] stringArray = new String[]{"DROP SCHEMA IF EXISTS ", schema.getIdentifier()};
            StringsKt.append((StringBuilder)$this$dropSchema_u24lambda_u241, (String[])stringArray);
            if (cascade) {
                $this$dropSchema_u24lambda_u241.append(" CASCADE");
            }
            return stringBuilder.toString();
        }

        @Deprecated(message="This method was moved to ExposedDatabaseMetadata and should not be used anymore from here.", replaceWith=@ReplaceWith(expression="currentDialectMetadata.areEquivalentColumnTypes(columnMetadataSqlType, columnMetadataJdbcType, columnType)", imports={}))
        public static boolean areEquivalentColumnTypes(@NotNull DatabaseDialect $this, @NotNull String columnMetadataSqlType, int columnMetadataJdbcType, @NotNull String columnType) {
            Intrinsics.checkNotNullParameter((Object)columnMetadataSqlType, (String)"columnMetadataSqlType");
            Intrinsics.checkNotNullParameter((Object)columnType, (String)"columnType");
            return StringsKt.equals((String)columnMetadataSqlType, (String)columnType, (boolean)true);
        }
    }
}

