/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.vendors;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import org.jetbrains.exposed.v1.core.Index;
import org.jetbrains.exposed.v1.core.LiteralOp;
import org.jetbrains.exposed.v1.core.SQLLogKt;
import org.jetbrains.exposed.v1.core.Version;
import org.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import org.jetbrains.exposed.v1.core.vendors.DataTypeProvider;
import org.jetbrains.exposed.v1.core.vendors.FunctionProvider;
import org.jetbrains.exposed.v1.core.vendors.MariaDBDataTypeProvider;
import org.jetbrains.exposed.v1.core.vendors.MariaDBFunctionProvider;
import org.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import org.jetbrains.exposed.v1.core.vendors.VendorDialect;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\"\u001a\u00020\u0011H\u0016J\b\u0010#\u001a\u00020\u0011H\u0016J\u0014\u0010$\u001a\u00020\u00112\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0016J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001b\u0010\u0016\u001a\u00020\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R!\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0084\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0019\u0012\u0004\b\u001e\u0010\u0003\u001a\u0004\b\u001f\u0010 \u00a8\u0006+"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/MariaDBDialect;", "Lorg/jetbrains/exposed/v1/core/vendors/MysqlDialect;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "dataTypeProvider", "Lorg/jetbrains/exposed/v1/core/vendors/DataTypeProvider;", "getDataTypeProvider", "()Lorg/jetbrains/exposed/v1/core/vendors/DataTypeProvider;", "functionProvider", "Lorg/jetbrains/exposed/v1/core/vendors/FunctionProvider;", "getFunctionProvider", "()Lorg/jetbrains/exposed/v1/core/vendors/FunctionProvider;", "supportsOnlyIdentifiersInGeneratedKeys", "", "getSupportsOnlyIdentifiersInGeneratedKeys", "()Z", "supportsSetDefaultReferenceOption", "getSupportsSetDefaultReferenceOption", "supportsCreateSequence", "getSupportsCreateSequence", "supportsCreateSequence$delegate", "Lkotlin/Lazy;", "supportsSequenceAsGeneratedKeys", "getSupportsSequenceAsGeneratedKeys", "sequenceMaxValue", "", "getSequenceMaxValue$annotations", "getSequenceMaxValue", "()J", "sequenceMaxValue$delegate", "isFractionDateTimeSupported", "isTimeZoneOffsetSupported", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/v1/core/Expression;", "createIndex", "index", "Lorg/jetbrains/exposed/v1/core/Index;", "Companion", "exposed-core"})
public class MariaDBDialect
extends MysqlDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name = Companion.getDialectName();
    @NotNull
    private final DataTypeProvider dataTypeProvider = MariaDBDataTypeProvider.INSTANCE;
    @NotNull
    private final FunctionProvider functionProvider = MariaDBFunctionProvider.INSTANCE;
    private final boolean supportsOnlyIdentifiersInGeneratedKeys;
    private final boolean supportsSetDefaultReferenceOption;
    @NotNull
    private final Lazy supportsCreateSequence$delegate = LazyKt.lazy(MariaDBDialect::supportsCreateSequence_delegate$lambda$0);
    private final boolean supportsSequenceAsGeneratedKeys;
    @NotNull
    private final Lazy sequenceMaxValue$delegate = LazyKt.lazy(() -> MariaDBDialect.sequenceMaxValue_delegate$lambda$1(this));
    private static final int SEQUENCE_MIN_MAJOR_VERSION = 10;
    private static final int SEQUENCE_MIN_MINOR_VERSION = 3;

    public MariaDBDialect() {
        this.supportsOnlyIdentifiersInGeneratedKeys = true;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DataTypeProvider getDataTypeProvider() {
        return this.dataTypeProvider;
    }

    @Override
    @NotNull
    public FunctionProvider getFunctionProvider() {
        return this.functionProvider;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return this.supportsOnlyIdentifiersInGeneratedKeys;
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return this.supportsSetDefaultReferenceOption;
    }

    @Override
    public boolean getSupportsCreateSequence() {
        Lazy lazy = this.supportsCreateSequence$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        return this.supportsSequenceAsGeneratedKeys;
    }

    @Override
    public long getSequenceMaxValue() {
        Lazy lazy = this.sequenceMaxValue$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public static /* synthetic */ void getSequenceMaxValue$annotations() {
    }

    @Override
    public boolean isFractionDateTimeSupported() {
        return Version.covers$default(CoreTransactionManager.INSTANCE.currentTransaction().getDb().getVersion(), 5, 3, 0, 4, null);
    }

    @Override
    public boolean isTimeZoneOffsetSupported() {
        return false;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        if (e instanceof LiteralOp) {
            return true;
        }
        if (this.getFullVersion$exposed_core().compareTo("10.2.1") >= 0) {
            return true;
        }
        return !this.getNotAcceptableDefaults().contains(((Object)StringsKt.trim((CharSequence)e.toString())).toString());
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        if (index.getFunctions() != null) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default((Iterable)index.getFunctions(), null, null, null, (int)0, null, MariaDBDialect::createIndex$lambda$2, (int)31, null) + " can't be created in MariaDB");
            return "";
        }
        return super.createIndex(index);
    }

    private static final boolean supportsCreateSequence_delegate$lambda$0() {
        return Version.covers$default(CoreTransactionManager.INSTANCE.currentTransaction().getDb().getVersion(), 10, 3, 0, 4, null);
    }

    private static final long sequenceMaxValue_delegate$lambda$1(MariaDBDialect this$0) {
        return Version.covers$default(CoreTransactionManager.INSTANCE.currentTransaction().getDb().getVersion(), 11, 5, 0, 4, null) ? super.getSequenceMaxValue() : 0x7FFFFFFFFFFFFFFEL;
    }

    private static final CharSequence createIndex$lambda$2(ExpressionWithColumnType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/MariaDBDialect$Companion;", "Lorg/jetbrains/exposed/v1/core/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "SEQUENCE_MIN_MAJOR_VERSION", "", "SEQUENCE_MIN_MINOR_VERSION", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("MariaDB");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

