/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.Column;
import org.jetbrains.exposed.v1.core.ColumnDiff;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.ReferenceOption;
import org.jetbrains.exposed.v1.core.Schema;
import org.jetbrains.exposed.v1.core.SchemaKt;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.OracleDataTypeProvider;
import org.jetbrains.exposed.v1.core.vendors.OracleFunctionProvider;
import org.jetbrains.exposed.v1.core.vendors.VendorDialect;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 :2\u00020\u0001:\u0001:B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010!\u001a\u00020\u00052\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0016J(\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0016J\"\u0010*\u001a\b\u0012\u0004\u0012\u00020%0+2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020%2\u0006\u00101\u001a\u00020%H\u0016J\b\u00102\u001a\u00020%H\u0016J\u0010\u00103\u001a\u00020%2\u0006\u00101\u001a\u00020%H\u0016J\u0010\u00104\u001a\u00020%2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020%2\u0006\u00105\u001a\u000206H\u0016J\u0018\u00108\u001a\u00020%2\u0006\u00105\u001a\u0002062\u0006\u00109\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0014\u0010\u0014\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0014\u0010\u0016\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0014\u0010\u0018\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0014\u0010\u001a\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u001c\u0010\u001c\u001a\u00020\u00058\u0016X\u0097D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u0003\u001a\u0004\b\u001e\u0010\u0007R\u0014\u0010\u001f\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0007\u00a8\u0006;"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/OracleDialect;", "Lorg/jetbrains/exposed/v1/core/vendors/VendorDialect;", "<init>", "()V", "supportsIfNotExists", "", "getSupportsIfNotExists", "()Z", "needsSequenceToAutoInc", "getNeedsSequenceToAutoInc", "defaultReferenceOption", "Lorg/jetbrains/exposed/v1/core/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/v1/core/ReferenceOption;", "needsQuotesWhenSymbolsInNames", "getNeedsQuotesWhenSymbolsInNames", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsDualTableConcept", "getSupportsDualTableConcept", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsOnUpdate", "getSupportsOnUpdate", "supportsSetDefaultReferenceOption", "getSupportsSetDefaultReferenceOption", "supportsSelectForUpdate", "getSupportsSelectForUpdate$annotations", "getSupportsSelectForUpdate", "supportsRestrictReferenceOption", "getSupportsRestrictReferenceOption", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/v1/core/Expression;", "dropIndex", "", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "modifyColumn", "", "column", "Lorg/jetbrains/exposed/v1/core/Column;", "columnDiff", "Lorg/jetbrains/exposed/v1/core/ColumnDiff;", "createDatabase", "name", "listDatabases", "dropDatabase", "setSchema", "schema", "Lorg/jetbrains/exposed/v1/core/Schema;", "createSchema", "dropSchema", "cascade", "Companion", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nOracleDialect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OracleDialect.kt\norg/jetbrains/exposed/v1/core/vendors/OracleDialect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,502:1\n1563#2:503\n1634#2,3:504\n1563#2:507\n1634#2,3:508\n*S KotlinDebug\n*F\n+ 1 OracleDialect.kt\norg/jetbrains/exposed/v1/core/vendors/OracleDialect\n*L\n456#1:503\n456#1:504,3\n461#1:507\n461#1:508,3\n*E\n"})
public class OracleDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIfNotExists;
    private final boolean needsSequenceToAutoInc;
    @NotNull
    private final ReferenceOption defaultReferenceOption = ReferenceOption.NO_ACTION;
    private final boolean needsQuotesWhenSymbolsInNames;
    private final boolean supportsMultipleGeneratedKeys;
    private final boolean supportsOnlyIdentifiersInGeneratedKeys;
    private final boolean supportsDualTableConcept;
    private final boolean supportsOrderByNullsFirstLast;
    private final boolean supportsOnUpdate;
    private final boolean supportsSetDefaultReferenceOption;
    private final boolean supportsSelectForUpdate;
    private final boolean supportsRestrictReferenceOption;

    public OracleDialect() {
        super(Companion.getDialectName(), OracleDataTypeProvider.INSTANCE, OracleFunctionProvider.INSTANCE);
        this.needsSequenceToAutoInc = true;
        this.supportsOnlyIdentifiersInGeneratedKeys = true;
        this.supportsDualTableConcept = true;
        this.supportsOrderByNullsFirstLast = true;
        this.supportsSelectForUpdate = true;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return this.supportsIfNotExists;
    }

    @Override
    public boolean getNeedsSequenceToAutoInc() {
        return this.needsSequenceToAutoInc;
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return this.defaultReferenceOption;
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return this.needsQuotesWhenSymbolsInNames;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return this.supportsOnlyIdentifiersInGeneratedKeys;
    }

    @Override
    public boolean getSupportsDualTableConcept() {
        return this.supportsDualTableConcept;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean getSupportsOnUpdate() {
        return this.supportsOnUpdate;
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return this.supportsSetDefaultReferenceOption;
    }

    @Override
    public boolean getSupportsSelectForUpdate() {
        return this.supportsSelectForUpdate;
    }

    @Deprecated(message="The parameter was moved to JdbcExposedDatabaseMetadata/R2dbcExposedDatabaseMetadata classes", replaceWith=@ReplaceWith(expression="TransactionManager.current().db.supportsSelectForUpdate", imports={}))
    public static /* synthetic */ void getSupportsSelectForUpdate$annotations() {
    }

    @Override
    public boolean getSupportsRestrictReferenceOption() {
        return this.supportsRestrictReferenceOption;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return true;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        return "DROP INDEX " + this.getIdentifierManager().cutIfNecessaryAndQuote(indexName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        List list;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
        Iterable $this$map$iv = super.modifyColumn(column, columnDiff);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, (String)"MODIFY COLUMN", (String)"MODIFY", (boolean)false, (int)4, null));
        }
        List result = (List)destination$iv$iv;
        if (!columnDiff.getNullability()) {
            void $this$mapTo$iv$iv2;
            String nullableState = column.getColumnType().getNullable() ? "NULL " : "NOT NULL";
            Iterable $this$map$iv2 = result;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String bl = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(StringsKt.replace$default((String)it, (String)nullableState, (String)"", (boolean)false, (int)4, null));
            }
            list = (List)destination$iv$iv2;
        } else {
            list = result;
        }
        return list;
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "CREATE DATABASE " + DatabaseDialectKt.inProperCase(name);
    }

    @Override
    @NotNull
    public String listDatabases() {
        throw new IllegalStateException("This operation is not supported by Oracle dialect".toString());
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "DROP DATABASE";
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return "ALTER SESSION SET CURRENT_SCHEMA = " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        StringBuilder $this$createSchema_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (schema.getQuota() == null ^ schema.getOn() == null) {
            throw new IllegalArgumentException("You must either provide both <quota> and <on> options or non of them");
        }
        String[] stringArray = new String[]{"CREATE USER ", schema.getIdentifier()};
        StringsKt.append((StringBuilder)$this$createSchema_u24lambda_u242, (String[])stringArray);
        stringArray = new String[]{" IDENTIFIED BY ", schema.getPassword()};
        StringsKt.append((StringBuilder)$this$createSchema_u24lambda_u242, (String[])stringArray);
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u242, " DEFAULT TABLESPACE ", schema.getDefaultTablespace());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u242, " TEMPORARY TABLESPACE ", schema.getTemporaryTablespace());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u242, " QUOTA ", schema.getQuota());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u242, " ON ", schema.getOn());
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        StringBuilder $this$dropSchema_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"DROP USER ", schema.getIdentifier()};
        StringsKt.append((StringBuilder)$this$dropSchema_u24lambda_u243, (String[])stringArray);
        if (cascade) {
            $this$dropSchema_u24lambda_u243.append(" CASCADE");
        }
        return stringBuilder.toString();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/OracleDialect$Companion;", "Lorg/jetbrains/exposed/v1/core/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("Oracle");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

