/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.internal;

import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.semver4j.SemverException;
import org.semver4j.internal.Tokenizers;

public class VersionParser {
    private static final Pattern PATTERN = Pattern.compile(Tokenizers.STRICT);
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);

    private VersionParser() {
    }

    public static Version parse(String version) {
        Matcher matcher = PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new SemverException(String.format(Locale.ROOT, "Version [%s] is not valid semver.", version));
        }
        int major = VersionParser.parseInt(matcher.group(1));
        int minor = VersionParser.parseInt(matcher.group(2));
        int patch = VersionParser.parseInt(matcher.group(3));
        List<String> preRelease = VersionParser.convertToList(matcher.group(4));
        List<String> build = VersionParser.convertToList(matcher.group(5));
        return new Version(major, minor, patch, preRelease, build);
    }

    private static int parseInt(@Nullable String maybeInt) {
        if (maybeInt == null) {
            throw new SemverException("Value is null and cannot be parsed as an integer.");
        }
        BigInteger secureNumber = new BigInteger(maybeInt);
        if (MAX_INT.compareTo(secureNumber) < 0) {
            throw new SemverException(String.format(Locale.ROOT, "Value [%s] is too big.", maybeInt));
        }
        return secureNumber.intValue();
    }

    private static List<String> convertToList(@Nullable String toList) {
        return toList == null ? List.of() : List.of(toList.split("\\."));
    }

    public record Version(int major, int minor, int patch, List<String> preRelease, List<String> build) {
        Version(int major, int minor, int patch) {
            this(major, minor, patch, List.of(), List.of());
        }
    }
}

