/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.processor;

import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.semver4j.internal.Tokenizers;
import org.semver4j.internal.Utils;
import org.semver4j.processor.Processor;
import org.semver4j.range.Range;

public class XRangeProcessor
implements Processor {
    private static final Pattern PATTERN = Pattern.compile(Tokenizers.XRANGE);

    @Override
    public @Nullable String process(String range, boolean includePreRelease) {
        String preReleaseSuffix = includePreRelease ? "-0" : "";
        String[] rangeVersions = range.split("\\s+");
        ArrayList<String> processedRanges = new ArrayList<String>();
        for (String rangeVersion : rangeVersions) {
            String processedRange = this.processRangeVersion(rangeVersion, preReleaseSuffix);
            if (processedRange == null) continue;
            processedRanges.add(processedRange);
        }
        if (processedRanges.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)" ", processedRanges);
    }

    private @Nullable String processRangeVersion(String rangeVersion, String preReleaseSuffix) {
        Matcher matcher = PATTERN.matcher(rangeVersion);
        if (!matcher.matches()) {
            return null;
        }
        String fullRange = matcher.group(0);
        String compareSign = matcher.group(1);
        int major = Utils.parseIntWithXSupport(matcher.group(2));
        int minor = Utils.parseIntWithXSupport(matcher.group(3));
        int patch = Utils.parseIntWithXSupport(matcher.group(4));
        if (compareSign.equals(Range.RangeOperator.EQ.asString()) && Utils.isX(patch)) {
            compareSign = "";
        }
        if (!compareSign.isEmpty() && Utils.isX(patch)) {
            return this.processWithComparisonOperator(compareSign, major, minor, preReleaseSuffix);
        }
        if (Utils.isX(minor)) {
            return this.processMajorOnly(major, preReleaseSuffix);
        }
        if (Utils.isX(patch)) {
            return this.processMajorMinor(major, minor, preReleaseSuffix);
        }
        return fullRange;
    }

    private String processWithComparisonOperator(String compareSign, int major, int minor, String preReleaseSuffix) {
        if (compareSign.equals(Range.RangeOperator.GT.asString())) {
            compareSign = Range.RangeOperator.GTE.asString();
            if (Utils.isX(minor)) {
                ++major;
                minor = 0;
            } else {
                ++minor;
            }
        } else if (compareSign.equals(Range.RangeOperator.LTE.asString())) {
            compareSign = Range.RangeOperator.LT.asString();
            if (Utils.isX(minor)) {
                ++major;
                minor = 0;
            } else {
                ++minor;
            }
        } else if (Utils.isX(minor)) {
            minor = 0;
        }
        return this.formatVersion(compareSign, major, minor, preReleaseSuffix);
    }

    private String processMajorOnly(int major, String preReleaseSuffix) {
        String from = this.formatVersion(Range.RangeOperator.GTE.asString(), major, 0, preReleaseSuffix);
        String to = this.formatVersion(Range.RangeOperator.LT.asString(), major + 1, 0, preReleaseSuffix);
        return from + " " + to;
    }

    private String processMajorMinor(int major, int minor, String preReleaseSuffix) {
        String from = this.formatVersion(Range.RangeOperator.GTE.asString(), major, minor, preReleaseSuffix);
        String to = this.formatVersion(Range.RangeOperator.LT.asString(), major, minor + 1, preReleaseSuffix);
        return from + " " + to;
    }

    private String formatVersion(String operator, int major, int minor, String preReleaseSuffix) {
        return String.format(Locale.ROOT, "%s%d.%d.%d%s", operator, major, minor, 0, preReleaseSuffix);
    }
}

