/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.RandomUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\n\u0010\n\u001a\u00020\u0005*\u00020\u0007J\n\u0010\u000b\u001a\u00020\u0007*\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lapp/termora/AES;", "", "<init>", "()V", "ALGORITHM", "", "randomBytes", "", "size", "", "encodeBase64String", "decodeBase64", "GCM", "ECB", "CBC", "termora"})
public final class AES {
    @NotNull
    public static final AES INSTANCE = new AES();
    @NotNull
    private static final String ALGORITHM = "AES";

    private AES() {
    }

    @NotNull
    public final byte[] randomBytes(int size) {
        byte[] byArray = RandomUtils.secureStrong().randomBytes(size);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"randomBytes(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] randomBytes$default(AES aES, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 32;
        }
        return aES.randomBytes(n);
    }

    @NotNull
    public final String encodeBase64String(@NotNull byte[] $this$encodeBase64String) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeBase64String, (String)"<this>");
        String string = Base64.encodeBase64String((byte[])$this$encodeBase64String);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeBase64String(...)");
        return string;
    }

    @NotNull
    public final byte[] decodeBase64(@NotNull String $this$decodeBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase64, (String)"<this>");
        byte[] byArray = Base64.decodeBase64((String)$this$decodeBase64);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decodeBase64(...)");
        return byArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u001a\u0010\f\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u001a\u0010\f\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u001a\u0010\r\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lapp/termora/AES$CBC;", "", "<init>", "()V", "TRANSFORMATION", "", "encrypt", "", "key", "iv", "data", "decrypt", "aesCBCEncrypt", "aesCBCDecrypt", "termora"})
    public static final class CBC {
        @NotNull
        public static final CBC INSTANCE = new CBC();
        @NotNull
        private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";

        private CBC() {
        }

        @NotNull
        public final byte[] encrypt(@NotNull byte[] key, @NotNull byte[] iv, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(1, (Key)new SecretKeySpec(key, AES.ALGORITHM), new IvParameterSpec(iv));
            byte[] byArray = cipher.doFinal(data);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
            return byArray;
        }

        @NotNull
        public final byte[] decrypt(@NotNull byte[] key, @NotNull byte[] iv, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, (Key)new SecretKeySpec(key, AES.ALGORITHM), new IvParameterSpec(iv));
            byte[] byArray = cipher.doFinal(data);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
            return byArray;
        }

        @NotNull
        public final byte[] aesCBCEncrypt(@NotNull String $this$aesCBCEncrypt, @NotNull byte[] key, @NotNull byte[] iv) {
            Intrinsics.checkNotNullParameter((Object)$this$aesCBCEncrypt, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            String string = $this$aesCBCEncrypt;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return this.encrypt(key, iv, byArray);
        }

        @NotNull
        public final byte[] aesCBCEncrypt(@NotNull byte[] $this$aesCBCEncrypt, @NotNull byte[] key, @NotNull byte[] iv) {
            Intrinsics.checkNotNullParameter((Object)$this$aesCBCEncrypt, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            return this.encrypt(key, iv, $this$aesCBCEncrypt);
        }

        @NotNull
        public final byte[] aesCBCDecrypt(@NotNull byte[] $this$aesCBCDecrypt, @NotNull byte[] key, @NotNull byte[] iv) {
            Intrinsics.checkNotNullParameter((Object)$this$aesCBCDecrypt, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            return this.decrypt(key, iv, $this$aesCBCDecrypt);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lapp/termora/AES$ECB;", "", "<init>", "()V", "TRANSFORMATION", "", "encrypt", "", "key", "data", "decrypt", "termora"})
    public static final class ECB {
        @NotNull
        public static final ECB INSTANCE = new ECB();
        @NotNull
        private static final String TRANSFORMATION = "AES/ECB/PKCS5Padding";

        private ECB() {
        }

        @NotNull
        public final byte[] encrypt(@NotNull byte[] key, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(1, new SecretKeySpec(key, AES.ALGORITHM));
            byte[] byArray = cipher.doFinal(data);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
            return byArray;
        }

        @NotNull
        public final byte[] decrypt(@NotNull byte[] key, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, new SecretKeySpec(key, AES.ALGORITHM));
            byte[] byArray = cipher.doFinal(data);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
            return byArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lapp/termora/AES$GCM;", "", "<init>", "()V", "TRANSFORMATION", "", "GCM_TAG_LENGTH", "", "encrypt", "", "key", "iv", "data", "decrypt", "termora"})
    public static final class GCM {
        @NotNull
        public static final GCM INSTANCE = new GCM();
        @NotNull
        private static final String TRANSFORMATION = "AES/GCM/NoPadding";
        private static final int GCM_TAG_LENGTH = 128;

        private GCM() {
        }

        @NotNull
        public final byte[] encrypt(@NotNull byte[] key, @NotNull byte[] iv, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(1, (Key)new SecretKeySpec(key, AES.ALGORITHM), new GCMParameterSpec(128, iv));
            byte[] byArray = cipher.doFinal(data);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
            return byArray;
        }

        @NotNull
        public final byte[] decrypt(@NotNull byte[] key, @NotNull byte[] iv, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, (Key)new SecretKeySpec(key, AES.ALGORITHM), new GCMParameterSpec(128, iv));
            byte[] byArray = cipher.doFinal(data);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
            return byArray;
        }
    }
}

