/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Application;
import app.termora.ApplicationRunner;
import app.termora.ApplicationRunnerExtension;
import app.termora.ApplicationScope;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicColor;
import app.termora.I18n;
import app.termora.MixpanelService;
import app.termora.NativeIcons;
import app.termora.OpenURIHandlers;
import app.termora.ScopeKt;
import app.termora.TermoraFrame;
import app.termora.TermoraFrameManager;
import app.termora.ThemeManager;
import app.termora.database.DatabaseManager;
import app.termora.plugin.ExtensionManager;
import app.termora.plugin.PluginManager;
import com.formdev.flatlaf.extras.FlatDesktop;
import com.formdev.flatlaf.extras.FlatInspector;
import com.formdev.flatlaf.ui.FlatTableCellBorder;
import com.formdev.flatlaf.util.SystemInfo;
import com.jthemedetecor.OsThemeDetector;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.desktop.AppReopenedEvent;
import java.awt.desktop.AppReopenedListener;
import java.awt.desktop.SystemEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002J\b\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u00020\fH\u0002J\b\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lapp/termora/ApplicationRunner;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "run", "", "clearTemporary", "startMainFrame", "setupSystemTray", "quitHandler", "loadSettings", "setupLaf", "setupMacOSDock", "printSystemInfo", "openDatabase", "enableAnalytics", "termora"})
@SourceDebugExtension(value={"SMAP\nApplicationRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationRunner.kt\napp/termora/ApplicationRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,372:1\n1#2:373\n*E\n"})
public final class ApplicationRunner {
    @NotNull
    private final Lazy log$delegate = LazyKt.lazy(ApplicationRunner::log_delegate$lambda$0);

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    public final void run() {
        Thread loadPluginThread = Thread.ofVirtual().start(ApplicationRunner::run$lambda$0);
        this.printSystemInfo();
        this.openDatabase();
        this.loadSettings();
        this.enableAnalytics();
        this.setupLaf();
        this.clearTemporary();
        loadPluginThread.join();
        for (ApplicationRunnerExtension extension : ExtensionManager.Companion.getInstance().getExtensions(ApplicationRunnerExtension.class)) {
            extension.ready();
        }
        SwingUtilities.invokeLater(() -> ApplicationRunner.run$lambda$1(this));
    }

    private final void clearTemporary() {
        BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        FileUtils.cleanDirectory((File)Application.INSTANCE.getTemporaryDir());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void startMainFrame() {
        TermoraFrameManager.Companion.getInstance().createWindow().setVisible(true);
        if (SystemInfo.isMacOS) {
            SwingUtilities.invokeLater(() -> ApplicationRunner.startMainFrame$lambda$0(this));
        } else if (SystemInfo.isWindows) {
            SwingUtilities.invokeLater(() -> ApplicationRunner.startMainFrame$lambda$1(this));
        }
        OpenURIHandlers.Companion.getInstance();
    }

    private final void setupSystemTray() {
        if (!SystemInfo.isWindows || !SystemTray.isSupported()) {
            return;
        }
        SystemTray tray = SystemTray.getSystemTray();
        BufferedImage image = ImageIO.read(TermoraFrame.class.getResourceAsStream("/icons/termora_32x32.png"));
        TrayIcon trayIcon = new TrayIcon(image);
        JDialog dialog2 = new JDialog();
        JPopupMenu trayPopup = new JPopupMenu();
        dialog2.setUndecorated(true);
        dialog2.setModal(false);
        dialog2.setSize(new Dimension(0, 0));
        trayIcon.setImageAutoSize(true);
        trayIcon.setToolTip(Application.INSTANCE.getName());
        trayPopup.add(I18n.INSTANCE.getString("termora.exit")).addActionListener(arg_0 -> ApplicationRunner.setupSystemTray$lambda$0(this, arg_0));
        trayPopup.addPopupMenuListener(new PopupMenuListener(dialog2){
            final /* synthetic */ JDialog $dialog;
            {
                this.$dialog = $dialog;
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(() -> setupSystemTray.2.popupMenuWillBecomeInvisible$lambda$0(this.$dialog));
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                this.popupMenuWillBecomeInvisible(e);
            }

            private static final void popupMenuWillBecomeInvisible$lambda$0(JDialog $dialog) {
                if ($dialog.isVisible()) {
                    $dialog.setVisible(false);
                }
            }
        });
        trayIcon.addMouseListener(new MouseAdapter(trayPopup, dialog2){
            final /* synthetic */ JPopupMenu $trayPopup;
            final /* synthetic */ JDialog $dialog;
            {
                this.$trayPopup = $trayPopup;
                this.$dialog = $dialog;
            }

            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.maybeShowPopup(e);
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.maybeShowPopup(e);
            }

            private final void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
                    this.$trayPopup.setLocation(mouseLocation.x, mouseLocation.y);
                    this.$trayPopup.setInvoker(this.$dialog);
                    this.$dialog.setVisible(true);
                    this.$trayPopup.setVisible(true);
                }
            }
        });
        dialog2.addWindowFocusListener(new WindowAdapter(dialog2){
            final /* synthetic */ JDialog $dialog;
            {
                this.$dialog = $dialog;
            }

            public void windowLostFocus(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$dialog.setVisible(false);
            }
        });
        trayIcon.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TermoraFrameManager.Companion.getInstance().tick();
            }
        });
        tray.add(trayIcon);
        Disposer.register(ApplicationScope.Companion.forApplicationScope(), new Disposable(tray, trayIcon){
            final /* synthetic */ SystemTray $tray;
            final /* synthetic */ TrayIcon $trayIcon;
            {
                this.$tray = $tray;
                this.$trayIcon = $trayIcon;
            }

            public void dispose() {
                this.$tray.remove(this.$trayIcon);
            }
        });
    }

    private final void quitHandler() {
        for (TermoraFrame frame : TermoraFrameManager.Companion.getInstance().getWindows()) {
            frame.dispatchEvent(new WindowEvent(frame, 202));
        }
        Disposer.dispose(TermoraFrameManager.Companion.getInstance());
    }

    private final void loadSettings() {
        Object object;
        Object $this$loadSettings_u24lambda_u240;
        String language = DatabaseManager.Companion.getInstance().getAppearance().getLanguage();
        Object object2 = this;
        try {
            $this$loadSettings_u24lambda_u240 = object2;
            boolean bl = false;
            $this$loadSettings_u24lambda_u240 = Result.constructor-impl((Object)LocaleUtils.toLocale((String)language));
        }
        catch (Throwable bl) {
            $this$loadSettings_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$loadSettings_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = Locale.getDefault();
        }
        Locale locale = (Locale)object;
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info("Language: {} , Locale: {}", (Object)language, (Object)locale);
        }
        Locale.setDefault(locale);
    }

    private final void setupLaf() {
        System.setProperty("flatlaf.useWindowDecorations", String.valueOf(SystemInfo.isLinux || SystemInfo.isWindows));
        if (SystemInfo.isLinux) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        ThemeManager themeManager = ThemeManager.Companion.getInstance();
        DatabaseManager.Appearance appearance = DatabaseManager.Companion.getInstance().getAppearance();
        String theme = appearance.getTheme();
        if (appearance.getFollowSystem()) {
            theme = OsThemeDetector.getDetector().isDark() ? appearance.getDarkTheme() : appearance.getLightTheme();
        }
        NativeIcons.INSTANCE.getFolderIcon();
        themeManager.change(theme, true);
        if (Application.INSTANCE.isBetaVersion()) {
            FlatInspector.install((String)"ctrl shift X");
        }
        UIManager.put("FlatLaf.fullWindowContent", true);
        UIManager.put("JRootPane.useWindowDecorations", false);
        UIManager.put("Popup.forceHeavyWeight", true);
        UIManager.put("Component.arc", 5);
        UIManager.put("TextComponent.arc", UIManager.getInt("Component.arc"));
        UIManager.put("Component.hideMnemonics", true);
        UIManager.put("TitleBar.height", 36);
        UIManager.put("Dialog.width", 650);
        UIManager.put("Dialog.height", 550);
        Object object = SystemInfo.isMacOS ? UIManager.put("TabbedPane.tabHeight", UIManager.getInt("TitleBar.height")) : (SystemInfo.isLinux ? UIManager.put("TabbedPane.tabHeight", UIManager.getInt("TitleBar.height") - 4) : UIManager.put("TabbedPane.tabHeight", UIManager.getInt("TitleBar.height") - 6));
        if (SystemInfo.isLinux || SystemInfo.isWindows) {
            UIManager.put("TitlePane.centerTitle", true);
            UIManager.put("TitlePane.showIcon", false);
            UIManager.put("TitlePane.showIconInDialogs", false);
        }
        UIManager.put("Table.rowHeight", 24);
        UIManager.put("Table.focusCellHighlightBorder", new FlatTableCellBorder.Default());
        UIManager.put("Table.focusSelectedCellHighlightBorder", new FlatTableCellBorder.Default());
        UIManager.put("Tree.rowHeight", 24);
        UIManager.put("Tree.background", new DynamicColor("window"));
        UIManager.put("Tree.showCellFocusIndicator", false);
        UIManager.put("Tree.repaintWholeRow", true);
        if (SystemInfo.isMacOS || SystemInfo.isWindows) {
            Insets selectionInsets = new Insets(0, 2, 0, 2);
            UIManager.put("Tree.selectionArc", UIManager.getInt("Component.arc"));
            UIManager.put("Tree.selectionInsets", selectionInsets);
            UIManager.put("List.selectionArc", UIManager.getInt("Component.arc"));
            UIManager.put("List.selectionInsets", selectionInsets);
            UIManager.put("ComboBox.selectionArc", UIManager.getInt("Component.arc"));
            UIManager.put("ComboBox.selectionInsets", selectionInsets);
            UIManager.put("Table.selectionArc", UIManager.getInt("Component.arc"));
            UIManager.put("Table.selectionInsets", selectionInsets);
            UIManager.put("MenuBar.selectionArc", UIManager.getInt("Component.arc"));
            UIManager.put("MenuBar.selectionInsets", selectionInsets);
            UIManager.put("MenuItem.selectionArc", UIManager.getInt("Component.arc"));
            UIManager.put("MenuItem.selectionInsets", selectionInsets);
        }
    }

    private final void setupMacOSDock() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Class<?> cls = Class.forName("com.apple.eawt.Application");
        Object app = cls.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
        Object[] objectArray = new Class[]{SystemEventListener.class};
        Method addAppEventListener = cls.getMethod("addAppEventListener", (Class<?>[])objectArray);
        objectArray = new Object[]{new AppReopenedListener(){

            public void appReopened(AppReopenedEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TermoraFrameManager manager = TermoraFrameManager.Companion.getInstance();
                if (manager.getWindows().length == 0) {
                    manager.createWindow().setVisible(true);
                }
            }
        }};
        addAppEventListener.invoke(app, objectArray);
        Disposer.register(ApplicationScope.Companion.forApplicationScope(), new Disposable(countDownLatch){
            final /* synthetic */ CountDownLatch $countDownLatch;
            {
                this.$countDownLatch = $countDownLatch;
            }

            public void dispose() {
                this.$countDownLatch.countDown();
            }
        });
        Thread.ofPlatform().daemon(false).priority(1).start(() -> ApplicationRunner.setupMacOSDock$lambda$0(countDownLatch));
    }

    private final void printSystemInfo() {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Welcome to " + Application.INSTANCE.getName() + " " + Application.INSTANCE.getVersion() + "!");
            Object[] objectArray = new Object[]{SystemUtils.JAVA_VM_NAME, SystemUtils.JAVA_VM_VENDOR, SystemUtils.JAVA_VM_VERSION};
            this.getLog().debug("JVM name: {} , vendor: {} , version: {}", objectArray);
            objectArray = new Object[]{SystemUtils.OS_NAME, SystemUtils.OS_VERSION, SystemUtils.OS_ARCH};
            this.getLog().debug("OS name: {} , version: {} , arch: {}", objectArray);
            this.getLog().debug("Base config dir: " + Application.INSTANCE.getBaseDataDir().getAbsolutePath());
        }
    }

    private final void openDatabase() {
        try {
            DatabaseManager.Companion.getInstance();
        }
        catch (Exception e) {
            if (this.getLog().isErrorEnabled()) {
                this.getLog().error(e.getMessage(), (Throwable)e);
            }
            JOptionPane.showMessageDialog(null, "Unable to open database", I18n.INSTANCE.getString("termora.title"), 0);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void enableAnalytics() {
        if (Application.INSTANCE.isUnknownVersion()) {
            return;
        }
        MixpanelService.push$default(MixpanelService.Companion.getInstance(), "launch", null, 2, null);
    }

    private static final Logger log_delegate$lambda$0() {
        return LoggerFactory.getLogger(ApplicationRunner.class);
    }

    private static final void run$lambda$0() {
        PluginManager.Companion.getInstance();
    }

    private static final void run$lambda$1(ApplicationRunner this$0) {
        this$0.startMainFrame();
    }

    private static final void startMainFrame$lambda$0(ApplicationRunner this$0) {
        block2: {
            try {
                this$0.setupMacOSDock();
            }
            catch (Exception e) {
                if (!this$0.getLog().isWarnEnabled()) break block2;
                this$0.getLog().warn(e.getMessage(), (Throwable)e);
            }
        }
        FlatDesktop.setQuitHandler(arg_0 -> ApplicationRunner.startMainFrame$lambda$0$0(this$0, arg_0));
    }

    private static final void startMainFrame$lambda$0$0(ApplicationRunner this$0, FlatDesktop.QuitResponse it) {
        this$0.quitHandler();
    }

    private static final void startMainFrame$lambda$1(ApplicationRunner this$0) {
        this$0.setupSystemTray();
    }

    private static final void setupSystemTray$lambda$0(ApplicationRunner this$0, ActionEvent it) {
        this$0.quitHandler();
    }

    private static final void setupMacOSDock$lambda$0(CountDownLatch $countDownLatch) {
        $countDownLatch.await();
    }
}

