/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.Disposable;
import app.termora.Host;
import app.termora.TermoraFrameKt;
import app.termora.database.Data;
import app.termora.database.DataType;
import app.termora.database.DatabaseChangedExtension;
import app.termora.database.DatabaseManager;
import app.termora.database.IDataType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lapp/termora/HostManager;", "Lapp/termora/Disposable;", "<init>", "()V", "databaseManager", "Lapp/termora/database/DatabaseManager;", "getDatabaseManager", "()Lapp/termora/database/DatabaseManager;", "addHost", "", "host", "Lapp/termora/Host;", "source", "Lapp/termora/database/DatabaseChangedExtension$Source;", "removeHost", "id", "", "hosts", "", "getHost", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nHostManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostManager.kt\napp/termora/HostManager\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 DatabaseManager.kt\napp/termora/database/DatabaseManager\n*L\n1#1,66:1\n205#2:67\n222#2:79\n222#2:86\n110#3,11:68\n122#3,6:80\n*S KotlinDebug\n*F\n+ 1 HostManager.kt\napp/termora/HostManager\n*L\n37#1:67\n52#1:79\n63#1:86\n52#1:68,11\n52#1:80,6\n*E\n"})
public final class HostManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private HostManager() {
    }

    private final DatabaseManager getDatabaseManager() {
        return DatabaseManager.Companion.getInstance();
    }

    /*
     * WARNING - void declaration
     */
    public final void addHost(@NotNull Host host, @NotNull DatabaseChangedExtension.Source source) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        TermoraFrameKt.assertEventDispatchThread();
        if (host.isTemporary()) {
            throw new IllegalArgumentException("Temporary host");
        }
        if (StringsKt.isBlank((CharSequence)host.getOwnerType())) {
            throw new IllegalArgumentException("Owner type cannot be null");
        }
        DatabaseManager databaseManager = this.getDatabaseManager();
        String string = host.getId();
        String string2 = host.getOwnerId();
        String string3 = host.getOwnerType();
        Json json = Application.INSTANCE.getOhMyJson();
        Host value$iv = host;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        databaseManager.saveAndIncrementVersion(new Data(string, string2, string3, "Host", this_$iv.encodeToString((SerializationStrategy)Host.Companion.serializer(), (Object)value$iv), 0L, false, false, 224, null), source);
    }

    public static /* synthetic */ void addHost$default(HostManager hostManager, Host host, DatabaseChangedExtension.Source source, int n, Object object) {
        if ((n & 2) != 0) {
            source = DatabaseChangedExtension.Source.User;
        }
        hostManager.addHost(host, source);
    }

    public final void removeHost(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DatabaseManager.delete$default(this.getDatabaseManager(), id, "Host", null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Host> hosts() {
        List list$iv$iv;
        Object object;
        block3: {
            void this_$iv;
            object = this.getDatabaseManager();
            IDataType type$iv = DataType.Host;
            boolean $i$f$data = false;
            void var4_4 = this_$iv;
            IDataType iDataType = type$iv;
            String ownerId$iv$iv = "";
            boolean $i$f$data2 = false;
            list$iv$iv = new ArrayList();
            try {
                void type$iv$iv;
                void this_$iv$iv;
                for (Data data$iv$iv : this_$iv$iv.rawData((IDataType)type$iv$iv, ownerId$iv$iv)) {
                    void this_$iv$iv$iv;
                    Json json = Application.INSTANCE.getOhMyJson();
                    String string$iv$iv$iv = data$iv$iv.getData();
                    boolean $i$f$decodeFromString = false;
                    this_$iv$iv$iv.getSerializersModule();
                    list$iv$iv.add(this_$iv$iv$iv.decodeFromString((DeserializationStrategy)Host.Companion.serializer(), string$iv$iv$iv));
                }
            }
            catch (Exception e$iv$iv) {
                if (!DatabaseManager.Companion.getLog().isWarnEnabled()) break block3;
                DatabaseManager.Companion.getLog().warn(e$iv$iv.getMessage(), (Throwable)e$iv$iv);
            }
        }
        object = new Comparator(){

            public final int compare(T a, T b) {
                Host it = (Host)a;
                boolean bl = false;
                Comparable comparable = it.isFolder() ? (Comparable)Integer.valueOf(0) : (Comparable)Integer.valueOf(1);
                it = (Host)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)(it.isFolder() ? (Comparable)Integer.valueOf(0) : (Comparable)Integer.valueOf(1)));
            }
        };
        return CollectionsKt.sortedWith((Iterable)list$iv$iv, (Comparator)new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Host it = (Host)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getSort());
                    it = (Host)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getSort()));
                }
                return n;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Host getHost(@NotNull String id) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Data data = this.getDatabaseManager().data(id);
        if (data == null) {
            return null;
        }
        Data data2 = data;
        if (!Intrinsics.areEqual((Object)data2.getType(), (Object)"Host")) {
            return null;
        }
        if (data2.getDeleted()) {
            return null;
        }
        Json json = Application.INSTANCE.getOhMyJson();
        String string$iv = data2.getData();
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (Host)this_$iv.decodeFromString((DeserializationStrategy)BuiltinSerializersKt.getNullable(Host.Companion.serializer()), string$iv);
    }

    public /* synthetic */ HostManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lapp/termora/HostManager$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/HostManager;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HostManager getInstance() {
            return (HostManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(HostManager.class), Companion::getInstance$lambda$0);
        }

        private static final HostManager getInstance$lambda$0() {
            return new HostManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

