/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.CryptoKt;
import app.termora.ScopeKt;
import app.termora.database.DatabaseManager;
import com.formdev.flatlaf.util.SystemInfo;
import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.MessageBuilder;
import com.mixpanel.mixpanelapi.MixpanelAPI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\tJ\b\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lapp/termora/MixpanelService;", "", "<init>", "()V", "push", "", "event", "", "extras", "", "getAnalyticsUserID", "Companion", "termora"})
public final class MixpanelService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(MixpanelService.class);

    private MixpanelService() {
    }

    public final void push(@NotNull String event, @NotNull Map<String, String> extras) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(extras, (String)"extras");
        BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(extras, this, event, null){
            int label;
            final /* synthetic */ Map<String, String> $extras;
            final /* synthetic */ MixpanelService this$0;
            final /* synthetic */ String $event;
            {
                this.$extras = $extras;
                this.this$0 = $receiver;
                this.$event = $event;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            JSONObject properties = new JSONObject();
                            for (Map.Entry<String, String> entry : this.$extras.entrySet()) {
                                properties.put(entry.getKey(), (Object)entry.getValue());
                            }
                            properties.put("os", (Object)SystemUtils.OS_NAME);
                            if (SystemInfo.isLinux) {
                                properties.put("platform", (Object)"Linux");
                            } else if (SystemInfo.isWindows) {
                                properties.put("platform", (Object)"Windows");
                            } else if (SystemInfo.isMacOS) {
                                properties.put("platform", (Object)"macOS");
                            }
                            properties.put("version", (Object)Application.INSTANCE.getVersion());
                            properties.put("language", (Object)Locale.getDefault().toString());
                            JSONObject message = new MessageBuilder("0871335f59ee6d0eb246b008a20f9d1c").event(MixpanelService.access$getAnalyticsUserID(this.this$0), this.$event, properties);
                            ClientDelivery delivery = new ClientDelivery();
                            delivery.addMessage(message);
                            String[] stringArray = new String[]{"https://api-eu.mixpanel.com", "https://api-in.mixpanel.com", "https://api.mixpanel.com", "http://api.mixpanel.com"};
                            List endpoints = CollectionsKt.listOf((Object[])stringArray);
                            for (String endpoint : endpoints) {
                                try {
                                    new MixpanelAPI(endpoint + "/track", endpoint + "/engage", endpoint + "/groups").deliver(delivery, true);
                                    return Unit.INSTANCE;
                                }
                                catch (Exception e) {
                                    if (!MixpanelService.access$getLog$cp().isErrorEnabled()) continue;
                                    MixpanelService.access$getLog$cp().error(e.getMessage(), (Throwable)e);
                                }
                            }
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            if (!MixpanelService.access$getLog$cp().isErrorEnabled()) return Unit.INSTANCE;
                            MixpanelService.access$getLog$cp().error(e.getMessage(), (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static /* synthetic */ void push$default(MixpanelService mixpanelService, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        mixpanelService.push(string, map);
    }

    private final String getAnalyticsUserID() {
        DatabaseManager.Properties properties = DatabaseManager.Companion.getInstance().getProperties();
        String id = properties.getString("AnalyticsUserID");
        CharSequence charSequence = id;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            id = CryptoKt.randomUUID();
            properties.putString("AnalyticsUserID", id);
        }
        return id;
    }

    public /* synthetic */ MixpanelService(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ String access$getAnalyticsUserID(MixpanelService $this) {
        return $this.getAnalyticsUserID();
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/MixpanelService$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/MixpanelService;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MixpanelService getInstance() {
            return (MixpanelService)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(MixpanelService.class), Companion::getInstance$lambda$0);
        }

        private static final MixpanelService getInstance$lambda$0() {
            return new MixpanelService(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

