/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.CustomizeToolBarDialog;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.TermoraFrame;
import app.termora.TermoraToolbarModel;
import app.termora.ToolBarAction;
import app.termora.WindowScope;
import app.termora.actions.ActionManager;
import app.termora.actions.StateAction;
import com.formdev.flatlaf.extras.components.FlatPopupMenu;
import com.formdev.flatlaf.extras.components.FlatToolBar;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lapp/termora/MyTermoraToolbar;", "Lcom/formdev/flatlaf/extras/components/FlatToolBar;", "windowScope", "Lapp/termora/WindowScope;", "frame", "Lapp/termora/TermoraFrame;", "<init>", "(Lapp/termora/WindowScope;Lapp/termora/TermoraFrame;)V", "customizeToolBarAWTEventListener", "Lapp/termora/MyTermoraToolbar$CustomizeToolBarAWTEventListener;", "model", "Lapp/termora/TermoraToolbarModel;", "getModel", "()Lapp/termora/TermoraToolbarModel;", "actionManager", "Lapp/termora/actions/ActionManager;", "getActionManager", "()Lapp/termora/actions/ActionManager;", "toolbar", "getToolbar", "()Lapp/termora/MyTermoraToolbar;", "disposable", "Lapp/termora/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "initView", "", "initEvents", "refreshActions", "adjust", "redirectAction", "Ljavax/swing/AbstractButton;", "action", "Ljavax/swing/Action;", "CustomizeToolBarAWTEventListener", "termora"})
@SourceDebugExtension(value={"SMAP\nMyTermoraToolbar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MyTermoraToolbar.kt\napp/termora/MyTermoraToolbar\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1#2:195\n*E\n"})
public final class MyTermoraToolbar
extends FlatToolBar {
    @NotNull
    private final WindowScope windowScope;
    @NotNull
    private final TermoraFrame frame;
    @NotNull
    private final CustomizeToolBarAWTEventListener customizeToolBarAWTEventListener;
    @NotNull
    private Disposable disposable;

    public MyTermoraToolbar(@NotNull WindowScope windowScope, @NotNull TermoraFrame frame) {
        Intrinsics.checkNotNullParameter((Object)windowScope, (String)"windowScope");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.windowScope = windowScope;
        this.frame = frame;
        this.customizeToolBarAWTEventListener = new CustomizeToolBarAWTEventListener();
        Disposable disposable2 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        this.disposable = disposable2;
        this.initView();
        this.initEvents();
        this.refreshActions();
    }

    private final TermoraToolbarModel getModel() {
        return TermoraToolbarModel.Companion.getInstance();
    }

    private final ActionManager getActionManager() {
        return this.getModel().getActionManager();
    }

    private final MyTermoraToolbar getToolbar() {
        return this;
    }

    private final void initView() {
        this.setFloatable(false);
    }

    private final void initEvents() {
        Disposer.register(this.windowScope, new Disposable(this){
            final /* synthetic */ MyTermoraToolbar this$0;
            {
                this.this$0 = $receiver;
            }

            public void dispose() {
                Disposer.dispose(MyTermoraToolbar.access$getDisposable$p(this.this$0));
            }
        });
        this.getToolkit().addAWTEventListener(this.customizeToolBarAWTEventListener, 16L);
        Disposer.register(this.windowScope, this.customizeToolBarAWTEventListener);
        Disposable it = this.getModel().addTermoraToolbarModelListener(new TermoraToolbarModel.TermoraToolbarModelListener(this){
            final /* synthetic */ MyTermoraToolbar this$0;
            {
                this.this$0 = $receiver;
            }

            public void onChanged() {
                MyTermoraToolbar.access$refreshActions(this.this$0);
            }
        });
        boolean bl = false;
        Disposer.register(this.windowScope, it);
        if (SystemInfo.isWindows || SystemInfo.isLinux) {
            this.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ MyTermoraToolbar this$0;
                {
                    this.this$0 = $receiver;
                }

                public void componentResized(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    MyTermoraToolbar.access$adjust(this.this$0);
                }
            });
        }
    }

    private final void refreshActions() {
        Disposer.dispose(this.disposable);
        Disposable disposable2 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        this.disposable = disposable2;
        this.removeAll();
        this.add(new JButton(new AbstractAction(this){
            final /* synthetic */ MyTermoraToolbar this$0;
            {
                this.this$0 = $receiver;
                this.putValue("SmallIcon", (Object)((Object)Icons.INSTANCE.getAdd()));
            }

            public void actionPerformed(ActionEvent evt) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    Action action2 = MyTermoraToolbar.access$getActionManager(this.this$0).getAction("FindEverywhereAction");
                    if (action2 == null) break block0;
                    action2.actionPerformed(evt);
                }
            }
        }));
        if (SystemInfo.isLinux || SystemInfo.isWindows) {
            this.add(Box.createHorizontalStrut(24));
        }
        this.add(Box.createHorizontalGlue());
        for (ToolBarAction action2 : this.getModel().getActions()) {
            Action action3;
            if (!action2.getVisible() || this.getActionManager().getAction(action2.getId()) == null) continue;
            this.add(this.redirectAction(action3, this.disposable));
        }
        if (SystemInfo.isWindows || SystemInfo.isLinux) {
            this.adjust();
        }
        this.revalidate();
        this.repaint();
    }

    private final void adjust() {
        Object object = this.frame.getRootPane().getClientProperty("FlatLaf.fullWindowContent.buttonsBounds");
        Rectangle rectangle = object instanceof Rectangle ? (Rectangle)object : null;
        if (rectangle == null) {
            return;
        }
        Rectangle rectangle2 = rectangle;
        int right = rectangle2.width;
        int n = this.getToolbar().getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = this.getToolbar().getComponent(i);
            if (!Intrinsics.areEqual((Object)c.getName(), (Object)"spacing")) continue;
            if (c.getWidth() == right) {
                return;
            }
            this.getToolbar().remove(i);
            break;
        }
        Component spacing = Box.createHorizontalStrut(right);
        spacing.setName("spacing");
        this.getToolbar().add(spacing);
    }

    private final AbstractButton redirectAction(Action action2, Disposable disposable2) {
        AbstractButton button = action2 instanceof StateAction ? new JToggleButton() : new JButton();
        JComponent jComponent = button;
        Object object = action2.getValue("ShortDescription");
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            object = action2.getValue("Name");
            string = object instanceof String ? (String)object : null;
        }
        jComponent.setToolTipText(string);
        Object object2 = action2.getValue("SmallIcon");
        ((AbstractButton)button).setIcon(object2 instanceof Icon ? (Icon)object2 : null);
        ((AbstractButton)button).addActionListener(new AbstractAction(action2, button, this){
            final /* synthetic */ Action $action;
            final /* synthetic */ Object $button;
            final /* synthetic */ MyTermoraToolbar this$0;
            {
                this.$action = $action;
                this.$button = $button;
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$action.actionPerformed(e);
                if (this.$action instanceof StateAction) {
                    ((AbstractButton)this.$button).setSelected(((StateAction)((Object)this.$action)).isSelected(MyTermoraToolbar.access$getWindowScope$p(this.this$0)));
                }
            }
        });
        PropertyChangeListener listener2 = new PropertyChangeListener(action2, button, this){
            final /* synthetic */ Action $action;
            final /* synthetic */ Object $button;
            final /* synthetic */ MyTermoraToolbar this$0;
            {
                this.$action = $action;
                this.$button = $button;
                this.this$0 = $receiver;
            }

            public void propertyChange(PropertyChangeEvent evt) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                if (this.$action instanceof StateAction) {
                    ((AbstractButton)this.$button).setSelected(((StateAction)((Object)this.$action)).isSelected(MyTermoraToolbar.access$getWindowScope$p(this.this$0)));
                }
                ((AbstractButton)this.$button).setIcon((object = this.$action.getValue("SmallIcon")) instanceof Icon ? (Icon)object : null);
            }

            public void dispose() {
                this.$action.removePropertyChangeListener(this);
            }
        };
        action2.addPropertyChangeListener(listener2);
        Disposer.register(disposable2, (Disposable)((Object)listener2));
        return button;
    }

    public static final /* synthetic */ Disposable access$getDisposable$p(MyTermoraToolbar $this) {
        return $this.disposable;
    }

    public static final /* synthetic */ void access$refreshActions(MyTermoraToolbar $this) {
        $this.refreshActions();
    }

    public static final /* synthetic */ void access$adjust(MyTermoraToolbar $this) {
        $this.adjust();
    }

    public static final /* synthetic */ ActionManager access$getActionManager(MyTermoraToolbar $this) {
        return $this.getActionManager();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lapp/termora/MyTermoraToolbar$CustomizeToolBarAWTEventListener;", "Ljava/awt/event/AWTEventListener;", "Lapp/termora/Disposable;", "<init>", "(Lapp/termora/MyTermoraToolbar;)V", "eventDispatched", "", "event", "Ljava/awt/AWTEvent;", "showContextMenu", "Ljava/awt/event/MouseEvent;", "dispose", "termora"})
    private final class CustomizeToolBarAWTEventListener
    implements AWTEventListener,
    Disposable {
        @Override
        public void eventDispatched(@NotNull AWTEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!(event instanceof MouseEvent) || ((MouseEvent)event).getID() != 500 || !SwingUtilities.isRightMouseButton((MouseEvent)event)) {
                return;
            }
            if (!MyTermoraToolbar.this.getToolbar().isShowing()) {
                return;
            }
            if (!new Rectangle(MyTermoraToolbar.this.getToolbar().getLocationOnScreen(), MyTermoraToolbar.this.getToolbar().getSize()).contains(((MouseEvent)event).getLocationOnScreen())) {
                return;
            }
            this.showContextMenu((MouseEvent)event);
        }

        private final void showContextMenu(MouseEvent event) {
            FlatPopupMenu popupMenu = new FlatPopupMenu();
            popupMenu.add(I18n.INSTANCE.getString("termora.toolbar.customize-toolbar")).addActionListener(arg_0 -> CustomizeToolBarAWTEventListener.showContextMenu$lambda$0(MyTermoraToolbar.this, arg_0));
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
        }

        @Override
        public void dispose() {
            MyTermoraToolbar.this.getToolkit().removeAWTEventListener(this);
        }

        private static final void showContextMenu$lambda$0(MyTermoraToolbar this$0, ActionEvent it) {
            Window owner = this$0.windowScope.getWindow();
            CustomizeToolBarDialog dialog2 = new CustomizeToolBarDialog(owner, this$0.windowScope, this$0.getModel());
            dialog2.setLocationRelativeTo(owner);
            if (dialog2.open()) {
                this$0.getModel().setActions(dialog2.getActions());
            }
        }
    }
}

