/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.BannerPanel;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.Icons;
import app.termora.OpenHostActionEvent;
import app.termora.TerminalTab;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.actions.DataProvider;
import app.termora.actions.DataProviderSupport;
import app.termora.actions.DataProviders;
import app.termora.database.DatabaseManager;
import app.termora.terminal.DataKey;
import app.termora.tree.Filter;
import app.termora.tree.FilterableTreeModel;
import app.termora.tree.HostTreeNode;
import app.termora.tree.NewHostTree;
import app.termora.tree.NewHostTreeModel;
import app.termora.tree.TeamTreeNode;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.formdev.flatlaf.extras.components.FlatButton;
import com.formdev.flatlaf.extras.components.FlatTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdesktop.swingx.action.ActionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020 H\u0002J\b\u0010%\u001a\u00020 H\u0002J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\"H\u0016J\b\u0010+\u001a\u00020\u0013H\u0016J\b\u0010,\u001a\u00020\u0013H\u0016J\b\u0010-\u001a\u00020\u0013H\u0016J\b\u0010.\u001a\u00020 H\u0016J\b\u0010/\u001a\u00020 H\u0016J\b\u00100\u001a\u00020 H\u0016J'\u00101\u001a\u0004\u0018\u0001H2\"\b\b\u0000\u00102*\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H205H\u0016\u00a2\u0006\u0002\u00106R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lapp/termora/WelcomePanel;", "Ljavax/swing/JPanel;", "Lapp/termora/Disposable;", "Lapp/termora/TerminalTab;", "Lapp/termora/actions/DataProvider;", "<init>", "()V", "properties", "Lapp/termora/database/DatabaseManager$Properties;", "getProperties", "()Lapp/termora/database/DatabaseManager$Properties;", "rootPanel", "hostTree", "Lapp/termora/tree/NewHostTree;", "bannerPanel", "Lapp/termora/BannerPanel;", "toggle", "Lcom/formdev/flatlaf/extras/components/FlatButton;", "fullContent", "", "dataProviderSupport", "Lapp/termora/actions/DataProviderSupport;", "hostTreeModel", "Lapp/termora/tree/NewHostTreeModel;", "filterableTreeModel", "Lapp/termora/tree/FilterableTreeModel;", "lastFocused", "Ljava/awt/Component;", "searchTextField", "Lcom/formdev/flatlaf/extras/components/FlatTextField;", "kotlin.jvm.PlatformType", "initView", "", "createSearchPanel", "Ljavax/swing/JComponent;", "createHostPanel", "initEvents", "perform", "getTitle", "", "getIcon", "Ljavax/swing/Icon;", "getJComponent", "canReconnect", "canClose", "canClone", "onLostFocus", "onGrabFocus", "dispose", "getData", "T", "", "dataKey", "Lapp/termora/terminal/DataKey;", "(Lapp/termora/terminal/DataKey;)Ljava/lang/Object;", "termora"})
@SourceDebugExtension(value={"SMAP\nWelcomePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WelcomePanel.kt\napp/termora/WelcomePanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1#2:271\n*E\n"})
public final class WelcomePanel
extends JPanel
implements Disposable,
TerminalTab,
DataProvider {
    @NotNull
    private final JPanel rootPanel = new JPanel(new BorderLayout());
    @NotNull
    private final NewHostTree hostTree = new NewHostTree();
    @NotNull
    private final BannerPanel bannerPanel = new BannerPanel(0, false, 3, null);
    @NotNull
    private final FlatButton toggle = new FlatButton();
    private boolean fullContent = Boolean.parseBoolean(this.getProperties().getString("WelcomeFullContent", "false"));
    @NotNull
    private final DataProviderSupport dataProviderSupport = new DataProviderSupport();
    @NotNull
    private final NewHostTreeModel hostTreeModel;
    @NotNull
    private final FilterableTreeModel filterableTreeModel;
    @Nullable
    private Component lastFocused;
    private final FlatTextField searchTextField;

    public WelcomePanel() {
        super(new BorderLayout());
        FilterableTreeModel filterableTreeModel;
        TreeModel treeModel = this.hostTree.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type app.termora.tree.NewHostTreeModel");
        this.hostTreeModel = (NewHostTreeModel)treeModel;
        FilterableTreeModel filterableTreeModel2 = filterableTreeModel = new FilterableTreeModel((JTree)((Object)this.hostTree));
        WelcomePanel welcomePanel = this;
        boolean bl = false;
        $this$filterableTreeModel_u24lambda_u240.expand = true;
        welcomePanel.filterableTreeModel = filterableTreeModel;
        this.searchTextField = this.filterableTreeModel.filterableTextField;
        this.initView();
        this.initEvents();
    }

    private final DatabaseManager.Properties getProperties() {
        return DatabaseManager.Companion.getInstance().getProperties();
    }

    private final void initView() {
        this.putClientProperty("JTabbedPane.tabClosable", false);
        this.putClientProperty("SKIP_FIND_EVERYWHERE", true);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.createSearchPanel(), "North");
        panel2.add((Component)this.createHostPanel(), "Center");
        this.bannerPanel.setForeground(UIManager.getColor("TextField.placeholderForeground"));
        if (!this.fullContent) {
            this.rootPanel.add((Component)this.bannerPanel, "North");
        }
        this.rootPanel.add((Component)panel2, "Center");
        this.add((Component)this.rootPanel, "Center");
        this.dataProviderSupport.addData(DataProviders.Welcome.INSTANCE.getHostTree(), this.hostTree);
    }

    private final JComponent createSearchPanel() {
        this.searchTextField.setFocusTraversalKeysEnabled(false);
        this.searchTextField.setPreferredSize(new Dimension(this.searchTextField.getPreferredSize().width, (int)((double)UIManager.getInt("TitleBar.height") * 0.85)));
        int iconSize = (int)((double)this.searchTextField.getPreferredSize().height * 0.65);
        FlatButton newHost = new FlatButton();
        newHost.setIcon((Icon)new FlatSVGIcon(Icons.INSTANCE.getOpenNewTab().getName(), iconSize, iconSize));
        newHost.setFocusable(false);
        newHost.setButtonType(FlatButton.ButtonType.toolBarButton);
        newHost.addActionListener(WelcomePanel::createSearchPanel$lambda$0);
        this.toggle.setIcon((Icon)new FlatSVGIcon(this.fullContent ? Icons.INSTANCE.getCollapseAll().getName() : Icons.INSTANCE.getCollapseAll().getName(), iconSize, iconSize));
        this.toggle.setFocusable(false);
        this.toggle.setButtonType(FlatButton.ButtonType.toolBarButton);
        Box box = Box.createHorizontalBox();
        box.add((Component)this.searchTextField);
        box.add(Box.createHorizontalStrut(4));
        box.add((Component)newHost);
        box.add(Box.createHorizontalStrut(4));
        box.add((Component)this.toggle);
        if (!this.fullContent) {
            box.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        }
        this.toggle.addActionListener(arg_0 -> WelcomePanel.createSearchPanel$lambda$1(this, iconSize, box, arg_0));
        Intrinsics.checkNotNull((Object)box);
        return box;
    }

    private final JComponent createHostPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.hostTree.getActionMap().put("find", (Action)((Object)new AnAction(this){
            final /* synthetic */ WelcomePanel this$0;
            {
                this.this$0 = $receiver;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                WelcomePanel.access$getSearchTextField$p(this.this$0).requestFocusInWindow();
            }
        }));
        this.hostTree.setShowsRootHandles(true);
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.hostTree));
        scrollPane.getVerticalScrollBar().setMaximumSize(new Dimension(0, 0));
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
        scrollPane.getVerticalScrollBar().setMinimumSize(new Dimension(0, 0));
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        panel2.add((Component)scrollPane, "Center");
        panel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.hostTree.setModel(this.filterableTreeModel);
        this.hostTree.setName("WelcomeHostTree");
        this.hostTree.restoreExpansions();
        return panel2;
    }

    private final void initEvents() {
        Disposer.register(this, this.hostTree);
        Disposer.register(this.hostTree, this.filterableTreeModel);
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ WelcomePanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentShown(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!WelcomePanel.access$getSearchTextField$p(this.this$0).hasFocus()) {
                    WelcomePanel.access$getSearchTextField$p(this.this$0).requestFocusInWindow();
                }
                WelcomePanel.access$perform(this.this$0);
                this.this$0.removeComponentListener(this);
            }
        });
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ WelcomePanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                WelcomePanel.access$perform(this.this$0);
            }
        });
        this.filterableTreeModel.addFilter(new Filter(this){
            final /* synthetic */ WelcomePanel this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean filter(Object node2) {
                Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
                String string = WelcomePanel.access$getSearchTextField$p(this.this$0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String text = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (StringsKt.isBlank((CharSequence)text)) {
                    return true;
                }
                if (!(node2 instanceof HostTreeNode)) {
                    return false;
                }
                if (node2 instanceof TeamTreeNode || Intrinsics.areEqual((Object)((HostTreeNode)node2).getId(), (Object)"0")) {
                    return true;
                }
                return StringsKt.contains((CharSequence)((HostTreeNode)node2).getHost().getName(), (CharSequence)text, (boolean)true) || StringsKt.contains((CharSequence)((HostTreeNode)node2).getHost().getHost(), (CharSequence)text, (boolean)true) || StringsKt.contains((CharSequence)((HostTreeNode)node2).getHost().getUsername(), (CharSequence)text, (boolean)true) || StringsKt.contains((CharSequence)((HostTreeNode)node2).getHost().getRemark(), (CharSequence)text, (boolean)true);
            }

            public boolean canFilter() {
                String string = WelcomePanel.access$getSearchTextField$p(this.this$0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return !StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString());
            }
        });
        this.searchTextField.addKeyListener((KeyListener)new KeyAdapter(this){
            private final ActionEvent event;
            final /* synthetic */ WelcomePanel this$0;
            {
                this.this$0 = $receiver;
                this.event = new ActionEvent(WelcomePanel.access$getHostTree$p($receiver), 1001, "");
            }

            private final Action getOpenHostAction() {
                return ActionManager.getInstance().getAction((Object)"OpenHostAction");
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 40 || e.getKeyCode() == 10 || e.getKeyCode() == 38) {
                    switch (e.getKeyCode()) {
                        case 38: {
                            Action action2 = WelcomePanel.access$getHostTree$p(this.this$0).getActionMap().get("selectPrevious");
                            if (action2 != null) {
                                action2.actionPerformed(this.event);
                            }
                            break;
                        }
                        case 40: {
                            Action action3 = WelcomePanel.access$getHostTree$p(this.this$0).getActionMap().get("selectNext");
                            if (action3 != null) {
                                action3.actionPerformed(this.event);
                            }
                            break;
                        }
                        default: {
                            for (HostTreeNode node2 : WelcomePanel.access$getHostTree$p(this.this$0).getSelectionSimpleTreeNodes(true)) {
                                Action action4 = this.getOpenHostAction();
                                if (action4 == null) continue;
                                action4.actionPerformed(new OpenHostActionEvent((Object)WelcomePanel.access$getHostTree$p(this.this$0), node2.getHost(), (EventObject)e));
                            }
                        }
                    }
                    e.consume();
                }
            }
        });
    }

    private final void perform() {
        this.rootPanel.remove(this.bannerPanel);
        if (this.fullContent) {
            this.rootPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        } else {
            int top = Math.max((int)((double)this.getHeight() * 0.08), 30);
            int left = Math.max((int)((double)this.getWidth() * 0.25), 30);
            this.rootPanel.add((Component)this.bannerPanel, "North");
            this.rootPanel.setBorder(BorderFactory.createEmptyBorder(top, left, top / 2, left));
            SwingUtilities.invokeLater(() -> WelcomePanel.perform$lambda$0(this));
        }
    }

    @Override
    @NotNull
    public String getTitle() {
        return "";
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return (Icon)((Object)Icons.INSTANCE.getHomeFolder());
    }

    @Override
    @NotNull
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public boolean canReconnect() {
        return false;
    }

    @Override
    public boolean canClose() {
        return false;
    }

    @Override
    public boolean canClone() {
        return false;
    }

    @Override
    public void onLostFocus() {
        this.lastFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    @Override
    public void onGrabFocus() {
        SwingUtilities.invokeLater(() -> WelcomePanel.onGrabFocus$lambda$0(this));
    }

    @Override
    public void dispose() {
        this.getProperties().putString("WelcomeFullContent", String.valueOf(this.fullContent));
    }

    @Override
    @Nullable
    public <T> T getData(@NotNull DataKey<T> dataKey) {
        Intrinsics.checkNotNullParameter(dataKey, (String)"dataKey");
        return this.dataProviderSupport.getData(dataKey);
    }

    private static final void createSearchPanel$lambda$0(ActionEvent e) {
        block0: {
            Action action2 = ActionManager.getInstance().getAction((Object)"NewHostAction");
            if (action2 == null) break block0;
            action2.actionPerformed(e);
        }
    }

    private static final void createSearchPanel$lambda$1(WelcomePanel this$0, int $iconSize, Box $box, ActionEvent it) {
        this$0.fullContent = !this$0.fullContent;
        this$0.toggle.setIcon((Icon)new FlatSVGIcon(this$0.fullContent ? Icons.INSTANCE.getCollapseAll().getName() : Icons.INSTANCE.getCollapseAll().getName(), $iconSize, $iconSize));
        if (this$0.fullContent) {
            $box.setBorder(BorderFactory.createEmptyBorder());
        } else {
            $box.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        }
        this$0.perform();
    }

    private static final void perform$lambda$0(WelcomePanel this$0) {
        this$0.rootPanel.revalidate();
        this$0.rootPanel.repaint();
    }

    private static final void onGrabFocus$lambda$0(WelcomePanel this$0) {
        block0: {
            Component component = this$0.lastFocused;
            if (component == null) break block0;
            component.requestFocusInWindow();
        }
    }

    public static final /* synthetic */ FlatTextField access$getSearchTextField$p(WelcomePanel $this) {
        return $this.searchTextField;
    }

    public static final /* synthetic */ void access$perform(WelcomePanel $this) {
        $this.perform();
    }

    public static final /* synthetic */ NewHostTree access$getHostTree$p(WelcomePanel $this) {
        return $this.hostTree;
    }
}

