/*
 * Decompiled with CFR 0.152.
 */
package app.termora.highlight;

import app.termora.Application;
import app.termora.CryptoKt;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicColor;
import app.termora.FileChooser;
import app.termora.I18n;
import app.termora.OptionPane;
import app.termora.TerminalFactory;
import app.termora.account.AccountOwner;
import app.termora.highlight.KeywordHighlight;
import app.termora.highlight.KeywordHighlightManager;
import app.termora.highlight.KeywordHighlightTableModel;
import app.termora.highlight.KeywordHighlightType;
import app.termora.highlight.KeywordHighlightView;
import app.termora.highlight.NewKeywordHighlightDialog;
import app.termora.terminal.ColorPalette;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalColor;
import com.formdev.flatlaf.extras.components.FlatPopupMenu;
import com.formdev.flatlaf.extras.components.FlatTabbedPane;
import com.formdev.flatlaf.extras.components.FlatTable;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001 B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lapp/termora/highlight/KeywordHighlightPanel;", "Ljavax/swing/JPanel;", "Lapp/termora/Disposable;", "accountOwner", "Lapp/termora/account/AccountOwner;", "<init>", "(Lapp/termora/account/AccountOwner;)V", "owner", "Ljava/awt/Window;", "kotlin.jvm.PlatformType", "getOwner", "()Ljava/awt/Window;", "keywordHighlightManager", "Lapp/termora/highlight/KeywordHighlightManager;", "getKeywordHighlightManager", "()Lapp/termora/highlight/KeywordHighlightManager;", "terminal", "Lapp/termora/terminal/Terminal;", "colorPalette", "Lapp/termora/terminal/ColorPalette;", "getColorPalette", "()Lapp/termora/terminal/ColorPalette;", "tabbed", "Lcom/formdev/flatlaf/extras/components/FlatTabbedPane;", "initView", "", "initEvents", "showContextmenu", "index", "", "e", "Ljava/awt/event/MouseEvent;", "KeywordHighlightMiniPanel", "termora"})
@SourceDebugExtension(value={"SMAP\nKeywordHighlightPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeywordHighlightPanel.kt\napp/termora/highlight/KeywordHighlightPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,431:1\n774#2:432\n865#2,2:433\n1056#2:435\n*S KotlinDebug\n*F\n+ 1 KeywordHighlightPanel.kt\napp/termora/highlight/KeywordHighlightPanel\n*L\n59#1:432\n59#1:433,2\n60#1:435\n*E\n"})
public final class KeywordHighlightPanel
extends JPanel
implements Disposable {
    @NotNull
    private final AccountOwner accountOwner;
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final FlatTabbedPane tabbed;

    public KeywordHighlightPanel(@NotNull AccountOwner accountOwner) {
        Intrinsics.checkNotNullParameter((Object)accountOwner, (String)"accountOwner");
        super(new BorderLayout());
        this.accountOwner = accountOwner;
        this.terminal = TerminalFactory.Companion.getInstance().createTerminal();
        this.tabbed = new FlatTabbedPane();
        this.initView();
        this.initEvents();
    }

    private final Window getOwner() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private final KeywordHighlightManager getKeywordHighlightManager() {
        return KeywordHighlightManager.Companion.getInstance();
    }

    private final ColorPalette getColorPalette() {
        return this.terminal.getTerminalModel().getColorPalette();
    }

    /*
     * WARNING - void declaration
     */
    private final void initView() {
        void $this$filterTo$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"focusColor", (Object)new DynamicColor("TabbedPane.background")), TuplesKt.to((Object)"hoverColor", (Object)new DynamicColor("TabbedPane.background")), TuplesKt.to((Object)"inactiveUnderlineColor", (Object)new DynamicColor("TabbedPane.underlineColor"))};
        this.tabbed.setStyleMap(MapsKt.mapOf((Pair[])pairArray));
        this.tabbed.setHasFullBorder(false);
        this.tabbed.setTabPlacement(2);
        this.tabbed.setTabType(FlatTabbedPane.TabType.underlined);
        this.tabbed.setTabsClosable(false);
        this.tabbed.setTabLayoutPolicy(1);
        this.tabbed.setTabWidthMode(FlatTabbedPane.TabWidthMode.preferred);
        this.tabbed.setFocusable(false);
        this.tabbed.setTabHeight(UIManager.getInt("TabbedPane.tabHeight") - 8);
        Iterable $this$filter$iv = this.getKeywordHighlightManager().getKeywordHighlights(this.accountOwner.getId());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KeywordHighlight it = (KeywordHighlight)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == KeywordHighlightType.Set)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List sets = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                KeywordHighlight it = (KeywordHighlight)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getSort());
                it = (KeywordHighlight)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getSort()));
            }
        });
        this.tabbed.addTab(I18n.INSTANCE.getString("termora.highlight.default-set"), (Component)new KeywordHighlightMiniPanel("0"));
        for (KeywordHighlight highlight : sets) {
            this.tabbed.addTab(highlight.getKeyword(), (Component)new KeywordHighlightMiniPanel(highlight.getId()));
        }
        this.add((Component)this.tabbed, "Center");
    }

    private final void initEvents() {
        this.tabbed.addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ KeywordHighlightPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                int index = KeywordHighlightPanel.access$getTabbed$p(this.this$0).indexAtLocation(e.getX(), e.getY());
                if (index < 0) {
                    return;
                }
                KeywordHighlightPanel.access$getTabbed$p(this.this$0).setSelectedIndex(index);
                KeywordHighlightPanel.access$showContextmenu(this.this$0, index, e);
            }
        });
        Disposer.register(this, new Disposable(this){
            final /* synthetic */ KeywordHighlightPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void dispose() {
                KeywordHighlightPanel.access$getTerminal$p(this.this$0).close();
            }
        });
    }

    private final void showContextmenu(int index, MouseEvent e) {
        int offset = 0;
        int i = 0;
        if (i <= index) {
            while (true) {
                offset += this.tabbed.getUI().getTabBounds((JTabbedPane)((JTabbedPane)this.tabbed), (int)i).height;
                if (i == index) break;
                ++i;
            }
        }
        FlatPopupMenu popupMenu = new FlatPopupMenu();
        popupMenu.add(I18n.INSTANCE.getString("termora.new-host.tunneling.add")).addActionListener(new AbstractAction(this){
            final /* synthetic */ KeywordHighlightPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = OptionPane.showInputDialog$default(OptionPane.INSTANCE, KeywordHighlightPanel.access$getOwner(this.this$0), null, null, null, 14, null);
                if (string == null) {
                    return;
                }
                String text = string;
                if (StringsKt.isBlank((CharSequence)text)) {
                    return;
                }
                KeywordHighlightType keywordHighlightType = KeywordHighlightType.Set;
                KeywordHighlight highlight = new KeywordHighlight(null, null, keywordHighlightType, text, null, false, false, 0, 0, false, false, false, false, false, 0L, 0L, 65523, null);
                KeywordHighlightPanel.access$getKeywordHighlightManager(this.this$0).addKeywordHighlight(highlight, KeywordHighlightPanel.access$getAccountOwner$p(this.this$0));
                KeywordHighlightPanel.access$getTabbed$p(this.this$0).addTab(text, (Component)this.this$0.new KeywordHighlightMiniPanel(highlight.getId()));
                KeywordHighlightPanel.access$getTabbed$p(this.this$0).setSelectedIndex(KeywordHighlightPanel.access$getTabbed$p(this.this$0).getTabCount() - 1);
            }
        });
        if (index > 0) {
            popupMenu.add(I18n.INSTANCE.getString("termora.tabbed.contextmenu.rename")).addActionListener(new AbstractAction(this, index){
                final /* synthetic */ KeywordHighlightPanel this$0;
                final /* synthetic */ int $index;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                }

                /*
                 * WARNING - void declaration
                 */
                public void actionPerformed(ActionEvent e) {
                    Object v3;
                    String text;
                    block7: {
                        void $this$firstOrNull$iv;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Component component = KeywordHighlightPanel.access$getTabbed$p(this.this$0).getComponentAt(this.$index);
                        KeywordHighlightMiniPanel keywordHighlightMiniPanel = component instanceof KeywordHighlightMiniPanel ? (KeywordHighlightMiniPanel)component : null;
                        if (keywordHighlightMiniPanel == null) {
                            return;
                        }
                        KeywordHighlightMiniPanel tab = keywordHighlightMiniPanel;
                        String string = KeywordHighlightPanel.access$getTabbed$p(this.this$0).getTitleAt(this.$index);
                        if (string == null) {
                            return;
                        }
                        String title = string;
                        String string2 = OptionPane.showInputDialog$default(OptionPane.INSTANCE, KeywordHighlightPanel.access$getOwner(this.this$0), null, title, null, 10, null);
                        if (string2 == null) {
                            return;
                        }
                        text = string2;
                        if (StringsKt.isBlank((CharSequence)text) || Intrinsics.areEqual((Object)title, (Object)text)) {
                            return;
                        }
                        Iterable iterable = KeywordHighlightPanel.access$getKeywordHighlightManager(this.this$0).getKeywordHighlights(KeywordHighlightPanel.access$getAccountOwner$p(this.this$0).getId());
                        boolean $i$f$filter = false;
                        Iterator<T> iterator2 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            KeywordHighlight it = (KeywordHighlight)element$iv$iv;
                            boolean bl = false;
                            if (!(it.getType() == KeywordHighlightType.Set)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            KeywordHighlight it = (KeywordHighlight)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)tab.getSetId())) continue;
                            v3 = element$iv;
                            break block7;
                        }
                        v3 = null;
                    }
                    KeywordHighlight keywordHighlight = v3;
                    if (keywordHighlight == null) {
                        return;
                    }
                    KeywordHighlight highlight = keywordHighlight;
                    long l = System.currentTimeMillis();
                    KeywordHighlightPanel.access$getKeywordHighlightManager(this.this$0).addKeywordHighlight(KeywordHighlight.copy$default(highlight, null, null, null, text, null, false, false, 0, 0, false, false, false, false, false, 0L, l, 32759, null), KeywordHighlightPanel.access$getAccountOwner$p(this.this$0));
                    KeywordHighlightPanel.access$getTabbed$p(this.this$0).setTitleAt(this.$index, text);
                }
            });
            popupMenu.add(I18n.INSTANCE.getString("termora.remove")).addActionListener(new AbstractAction(this, index){
                final /* synthetic */ KeywordHighlightPanel this$0;
                final /* synthetic */ int $index;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Component component = KeywordHighlightPanel.access$getTabbed$p(this.this$0).getComponentAt(this.$index);
                    KeywordHighlightMiniPanel keywordHighlightMiniPanel = component instanceof KeywordHighlightMiniPanel ? (KeywordHighlightMiniPanel)component : null;
                    if (keywordHighlightMiniPanel == null) {
                        return;
                    }
                    KeywordHighlightMiniPanel tab = keywordHighlightMiniPanel;
                    if (OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, KeywordHighlightPanel.access$getOwner(this.this$0), I18n.INSTANCE.getString("termora.keymgr.delete-warning"), I18n.INSTANCE.getString("termora.remove"), 0, 3, null, null, null, null, 480, null) != 0) {
                        return;
                    }
                    KeywordHighlightPanel.access$getTabbed$p(this.this$0).removeTabAt(this.$index);
                    for (KeywordHighlight highlight : KeywordHighlightPanel.access$getKeywordHighlightManager(this.this$0).getKeywordHighlights(KeywordHighlightPanel.access$getAccountOwner$p(this.this$0).getId())) {
                        if (!Intrinsics.areEqual((Object)highlight.getParentId(), (Object)tab.getSetId()) && !Intrinsics.areEqual((Object)highlight.getId(), (Object)tab.getSetId())) continue;
                        KeywordHighlightPanel.access$getKeywordHighlightManager(this.this$0).removeKeywordHighlight(highlight.getId());
                    }
                }
            });
        }
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    public static final /* synthetic */ FlatTabbedPane access$getTabbed$p(KeywordHighlightPanel $this) {
        return $this.tabbed;
    }

    public static final /* synthetic */ void access$showContextmenu(KeywordHighlightPanel $this, int index, MouseEvent e) {
        $this.showContextmenu(index, e);
    }

    public static final /* synthetic */ Terminal access$getTerminal$p(KeywordHighlightPanel $this) {
        return $this.terminal;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lapp/termora/highlight/KeywordHighlightPanel$KeywordHighlightMiniPanel;", "Ljavax/swing/JPanel;", "setId", "", "<init>", "(Lapp/termora/highlight/KeywordHighlightPanel;Ljava/lang/String;)V", "getSetId", "()Ljava/lang/String;", "addBtn", "Ljavax/swing/JButton;", "editBtn", "deleteBtn", "importBtn", "exportBtn", "model", "Lapp/termora/highlight/KeywordHighlightTableModel;", "table", "Lcom/formdev/flatlaf/extras/components/FlatTable;", "initView", "", "initEvents", "importKeywordHighlights", "file", "Ljava/io/File;", "createCenterPanel", "Ljavax/swing/JComponent;", "termora"})
    @SourceDebugExtension(value={"SMAP\nKeywordHighlightPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeywordHighlightPanel.kt\napp/termora/highlight/KeywordHighlightPanel$KeywordHighlightMiniPanel\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,431:1\n222#2:432\n205#2:445\n1563#3:433\n1634#3,3:434\n774#3:438\n865#3,2:439\n1563#3:441\n1634#3,3:442\n1#4:437\n*S KotlinDebug\n*F\n+ 1 KeywordHighlightPanel.kt\napp/termora/highlight/KeywordHighlightPanel$KeywordHighlightMiniPanel\n*L\n384#1:432\n365#1:445\n385#1:433\n385#1:434,3\n363#1:438\n363#1:439,2\n364#1:441\n364#1:442,3\n*E\n"})
    private final class KeywordHighlightMiniPanel
    extends JPanel {
        @NotNull
        private final String setId;
        @NotNull
        private final JButton addBtn;
        @NotNull
        private final JButton editBtn;
        @NotNull
        private final JButton deleteBtn;
        @NotNull
        private final JButton importBtn;
        @NotNull
        private final JButton exportBtn;
        @NotNull
        private final KeywordHighlightTableModel model;
        @NotNull
        private final FlatTable table;

        public KeywordHighlightMiniPanel(String setId) {
            Intrinsics.checkNotNullParameter((Object)setId, (String)"setId");
            super(new BorderLayout());
            this.setId = setId;
            this.addBtn = new JButton(I18n.INSTANCE.getString("termora.new-host.tunneling.add"));
            this.editBtn = new JButton(I18n.INSTANCE.getString("termora.keymgr.edit"));
            this.deleteBtn = new JButton(I18n.INSTANCE.getString("termora.remove"));
            this.importBtn = new JButton(I18n.INSTANCE.getString("termora.keymgr.import"));
            this.exportBtn = new JButton(I18n.INSTANCE.getString("termora.keymgr.export"));
            this.model = new KeywordHighlightTableModel(KeywordHighlightPanel.this.accountOwner, this.setId);
            this.table = new FlatTable();
            this.initView();
            this.initEvents();
        }

        @NotNull
        public final String getSetId() {
            return this.setId;
        }

        private final void initView() {
            this.model.addColumn(I18n.INSTANCE.getString("termora.highlight.keyword"));
            this.model.addColumn(I18n.INSTANCE.getString("termora.highlight.preview"));
            this.model.addColumn(I18n.INSTANCE.getString("termora.highlight.description"));
            this.table.setFillsViewportHeight(true);
            this.table.getTableHeader().setReorderingAllowed(false);
            this.table.setModel((TableModel)this.model);
            this.editBtn.setEnabled(false);
            this.deleteBtn.setEnabled(false);
            this.table.getColumnModel().getColumn(0).setCellRenderer(new TableCellRenderer(){
                {
                    this.setHorizontalAlignment(2);
                    this.setVerticalAlignment(0);
                }

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    if (value instanceof KeywordHighlight) {
                        this.setText(((KeywordHighlight)value).getKeyword());
                        super.setSelected(((KeywordHighlight)value).getEnabled());
                    }
                    if (isSelected) {
                        this.setForeground(table.getSelectionForeground());
                        super.setBackground(table.getSelectionBackground());
                    } else {
                        this.setForeground(table.getForeground());
                        this.setBackground(table.getBackground());
                    }
                    return this;
                }
            });
            this.table.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(KeywordHighlightPanel.this){
                private final KeywordHighlightView keywordHighlightView;
                final /* synthetic */ KeywordHighlightPanel this$0;
                {
                    this.this$0 = $receiver;
                    this.keywordHighlightView = new KeywordHighlightView(0, 0, 2, null);
                    this.keywordHighlightView.setBorder(null);
                }

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    if (value instanceof KeywordHighlight) {
                        this.keywordHighlightView.setKeywordHighlight((KeywordHighlight)value, KeywordHighlightPanel.access$getColorPalette(this.this$0));
                        if (isSelected) {
                            this.keywordHighlightView.setBackgroundColor(table.getSelectionBackground());
                        }
                        return this.keywordHighlightView;
                    }
                    Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getTableCellRendererComponent(...)");
                    return component;
                }
            });
            this.add((Component)this.createCenterPanel(), "Center");
        }

        private final void initEvents() {
            this.table.addMouseListener((MouseListener)new MouseAdapter(this, KeywordHighlightPanel.this){
                final /* synthetic */ KeywordHighlightMiniPanel this$0;
                final /* synthetic */ KeywordHighlightPanel this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        int row = KeywordHighlightMiniPanel.access$getTable$p(this.this$0).rowAtPoint(e.getPoint());
                        int column = KeywordHighlightMiniPanel.access$getTable$p(this.this$0).columnAtPoint(e.getPoint());
                        if (row >= 0 && column == 0) {
                            KeywordHighlight keywordHighlight = KeywordHighlightMiniPanel.access$getModel$p(this.this$0).getKeywordHighlight(row);
                            KeywordHighlightPanel.access$getKeywordHighlightManager(this.this$1).addKeywordHighlight(KeywordHighlight.copy$default(keywordHighlight, null, null, null, null, null, false, false, 0, 0, false, false, false, false, !keywordHighlight.getEnabled(), 0L, 0L, 57343, null), KeywordHighlightPanel.access$getAccountOwner$p(this.this$1));
                            KeywordHighlightMiniPanel.access$getModel$p(this.this$0).fireTableCellUpdated(row, column);
                        } else if (row < 0) {
                            KeywordHighlightMiniPanel.access$getTable$p(this.this$0).clearSelection();
                        }
                    }
                }
            });
            this.addBtn.addActionListener(arg_0 -> KeywordHighlightMiniPanel.initEvents$lambda$0(KeywordHighlightPanel.this, this, arg_0));
            this.editBtn.addActionListener(arg_0 -> KeywordHighlightMiniPanel.initEvents$lambda$1(this, KeywordHighlightPanel.this, arg_0));
            this.deleteBtn.addActionListener(arg_0 -> KeywordHighlightMiniPanel.initEvents$lambda$2(this, KeywordHighlightPanel.this, arg_0));
            this.table.getSelectionModel().addListSelectionListener(arg_0 -> KeywordHighlightMiniPanel.initEvents$lambda$3(this, arg_0));
            this.exportBtn.addActionListener(arg_0 -> KeywordHighlightMiniPanel.initEvents$lambda$4(KeywordHighlightPanel.this, this, arg_0));
            this.importBtn.addActionListener(arg_0 -> KeywordHighlightMiniPanel.initEvents$lambda$5(KeywordHighlightPanel.this, this, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private final void importKeywordHighlights(File file) {
            try {
                void $this$mapTo$iv$iv;
                void this_$iv;
                Json json = Application.INSTANCE.getOhMyJson();
                String string$iv = FilesKt.readText$default((File)file, null, (int)1, null);
                boolean $i$f$decodeFromString22 = false;
                this_$iv.getSerializersModule();
                Iterable $this$map$iv = (Iterable)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(KeywordHighlight.Companion.serializer()), string$iv);
                boolean $i$f$map = false;
                Iterable $i$f$decodeFromString22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KeywordHighlight keywordHighlight = (KeywordHighlight)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(KeywordHighlight.copy$default((KeywordHighlight)it, CryptoKt.randomUUID(), this.setId, null, null, null, false, false, 0, 0, false, false, false, false, false, 0L, 0L, 65532, null));
                }
                List highlights = (List)destination$iv$iv;
                for (KeywordHighlight highlight : highlights) {
                    KeywordHighlightPanel.this.getKeywordHighlightManager().addKeywordHighlight(highlight, KeywordHighlightPanel.this.accountOwner);
                    this.model.fireTableRowsInserted(this.model.getRowCount() - 1, this.model.getRowCount());
                }
            }
            catch (Exception e) {
                Component component = KeywordHighlightPanel.this.getOwner();
                String string = e.getMessage();
                if (string == null) {
                    string = ExceptionUtils.getRootCauseMessage((Throwable)e);
                }
                String string2 = string;
                Intrinsics.checkNotNull((Object)string2);
                OptionPane.showMessageDialog$default(OptionPane.INSTANCE, component, string2, null, 0, null, 20, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final JComponent createCenterPanel() {
            FormBuilder formBuilder;
            void $this$createCenterPanel_u24lambda_u240;
            JScrollPane jScrollPane;
            JPanel panel2 = new JPanel(new BorderLayout());
            JScrollPane jScrollPane2 = jScrollPane = new JScrollPane((Component)this.table);
            JPanel jPanel = panel2;
            boolean bl = false;
            $this$createCenterPanel_u24lambda_u240.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 0), BorderFactory.createMatteBorder(1, 1, 1, 1, DynamicColor.Companion.getBorderColor())));
            jPanel.add((Component)jScrollPane, "Center");
            int rows = 0;
            rows = 1;
            int step = 2;
            String formMargin = "4dlu";
            FormLayout layout = new FormLayout("default:grow", "pref, " + formMargin + ", pref, " + formMargin + ", pref, " + formMargin + ", pref, " + formMargin + ", pref");
            FormBuilder formBuilder2 = formBuilder = FormBuilder.create().layout(layout).border(BorderFactory.createEmptyBorder(8, 8, 8, 8)).add((Component)this.addBtn).xy(1, rows);
            jPanel = panel2;
            boolean bl2 = false;
            FormBuilder $this$createCenterPanel_u24lambda_u241 = formBuilder = formBuilder.add((Component)this.editBtn).xy(1, rows += step);
            boolean bl3 = false;
            FormBuilder $this$createCenterPanel_u24lambda_u242 = formBuilder = formBuilder.add((Component)this.deleteBtn).xy(1, rows += step);
            boolean bl4 = false;
            FormBuilder $this$createCenterPanel_u24lambda_u243 = formBuilder = formBuilder.add((Component)this.importBtn).xy(1, rows += step);
            boolean bl5 = false;
            FormBuilder $this$createCenterPanel_u24lambda_u244 = formBuilder = formBuilder.add((Component)this.exportBtn).xy(1, rows += step);
            boolean bl6 = false;
            rows += step;
            jPanel.add((Component)formBuilder.build(), "East");
            return panel2;
        }

        private static final void initEvents$lambda$0(KeywordHighlightPanel this$0, KeywordHighlightMiniPanel this$1, ActionEvent it) {
            Window window = this$0.getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"access$getOwner(...)");
            NewKeywordHighlightDialog dialog2 = new NewKeywordHighlightDialog(window, this$0.getColorPalette());
            dialog2.setLocationRelativeTo(this$0.getOwner());
            dialog2.setVisible(true);
            KeywordHighlight keywordHighlight = dialog2.getKeywordHighlight();
            if (keywordHighlight != null) {
                this$0.getKeywordHighlightManager().addKeywordHighlight(KeywordHighlight.copy$default(keywordHighlight, null, this$1.setId, null, null, null, false, false, 0, 0, false, false, false, false, false, 0L, 0L, 65533, null), this$0.accountOwner);
                this$1.model.fireTableRowsInserted(this$1.model.getRowCount() - 1, this$1.model.getRowCount());
            }
        }

        private static final void initEvents$lambda$1(KeywordHighlightMiniPanel this$0, KeywordHighlightPanel this$1, ActionEvent it) {
            int row = this$0.table.getSelectedRow();
            if (row > -1) {
                KeywordHighlight keywordHighlight = this$0.model.getKeywordHighlight(row);
                Window window = this$1.getOwner();
                Intrinsics.checkNotNullExpressionValue((Object)window, (String)"access$getOwner(...)");
                NewKeywordHighlightDialog dialog2 = new NewKeywordHighlightDialog(window, this$1.getColorPalette());
                dialog2.setLocationRelativeTo(this$1.getOwner());
                dialog2.getKeywordTextField().setText(keywordHighlight.getKeyword());
                dialog2.getDescriptionTextField().setText(keywordHighlight.getDescription());
                int n = keywordHighlight.getTextColor();
                boolean bl = 0 <= n ? n < 17 : false;
                if (bl) {
                    if (keywordHighlight.getTextColor() == 0) {
                        dialog2.getTextColor().setBackground(new Color(this$1.getColorPalette().getColor(TerminalColor.Basic.INSTANCE.getFOREGROUND())));
                        dialog2.getTextColor().setColorIndex(-1);
                    } else {
                        dialog2.getTextColor().setColor(new Color(this$1.getColorPalette().getXTerm256Color(keywordHighlight.getTextColor())));
                        dialog2.getTextColor().setColorIndex(keywordHighlight.getTextColor());
                    }
                } else {
                    dialog2.getTextColor().setColor(new Color(keywordHighlight.getTextColor()));
                }
                n = keywordHighlight.getBackgroundColor();
                boolean bl2 = 0 <= n ? n < 17 : false;
                if (bl2) {
                    if (keywordHighlight.getBackgroundColor() == 0) {
                        dialog2.getBackgroundColor().setBackground(new Color(this$1.getColorPalette().getColor(TerminalColor.Basic.INSTANCE.getBACKGROUND())));
                        dialog2.getBackgroundColor().setColorIndex(-1);
                    } else {
                        dialog2.getBackgroundColor().setColor(new Color(this$1.getColorPalette().getXTerm256Color(keywordHighlight.getBackgroundColor())));
                        dialog2.getBackgroundColor().setColorIndex(keywordHighlight.getBackgroundColor());
                    }
                }
                dialog2.getBoldCheckBox().setSelected(keywordHighlight.getBold());
                dialog2.getItalicCheckBox().setSelected(keywordHighlight.getItalic());
                dialog2.getUnderlineCheckBox().setSelected(keywordHighlight.getUnderline());
                dialog2.getLineThroughCheckBox().setSelected(keywordHighlight.getLineThrough());
                dialog2.getMatchCaseBtn().setSelected(keywordHighlight.getMatchCase());
                dialog2.getRegexBtn().setSelected(keywordHighlight.getRegex());
                dialog2.setVisible(true);
                KeywordHighlight value = dialog2.getKeywordHighlight();
                if (value != null) {
                    keywordHighlight = KeywordHighlight.copy$default(value, keywordHighlight.getId(), this$0.setId, null, null, null, false, false, 0, 0, false, false, false, false, false, keywordHighlight.getSort(), 0L, 49148, null);
                    this$1.getKeywordHighlightManager().addKeywordHighlight(keywordHighlight, this$1.accountOwner);
                    this$0.model.fireTableRowsUpdated(row, row);
                }
            }
        }

        private static final void initEvents$lambda$2(KeywordHighlightMiniPanel this$0, KeywordHighlightPanel this$1, ActionEvent it) {
            if (this$0.table.getSelectedRowCount() > 0 && OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, SwingUtilities.getWindowAncestor(this$0), I18n.INSTANCE.getString("termora.keymgr.delete-warning"), null, 0, 2, null, null, null, null, 492, null) == 0) {
                int[] nArray = this$0.table.getSelectedRows();
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
                List rows = CollectionsKt.reversed((Iterable)ArraysKt.sorted((int[])nArray));
                Iterator iterator2 = rows.iterator();
                while (iterator2.hasNext()) {
                    int row = ((Number)iterator2.next()).intValue();
                    String id = this$0.model.getKeywordHighlight(row).getId();
                    this$1.getKeywordHighlightManager().removeKeywordHighlight(id);
                    this$0.model.fireTableRowsDeleted(row, row);
                }
            }
        }

        private static final void initEvents$lambda$3(KeywordHighlightMiniPanel this$0, ListSelectionEvent it) {
            this$0.editBtn.setEnabled(this$0.table.getSelectedRowCount() > 0);
            this$0.deleteBtn.setEnabled(this$0.editBtn.isEnabled());
        }

        private static final void initEvents$lambda$4(KeywordHighlightPanel this$0, KeywordHighlightMiniPanel this$1, ActionEvent it) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setFileSelectionMode(0);
            fileChooser.getWin32Filters().add((Pair<String, List<String>>)new Pair((Object)"All files", (Object)CollectionsKt.listOf((Object)"*")));
            fileChooser.showSaveDialog(this$0.getOwner(), "highlights.json").thenAccept(arg_0 -> KeywordHighlightMiniPanel.initEvents$lambda$4$1(arg_0 -> KeywordHighlightMiniPanel.initEvents$lambda$4$0(this$0, this$1, arg_0), arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private static final Unit initEvents$lambda$4$0(KeywordHighlightPanel this$0, KeywordHighlightMiniPanel this$1, File file) {
            if (file != null) {
                Closeable closeable = new FileOutputStream(file);
                Throwable throwable = null;
                try {
                    void this_$iv;
                    void $this$mapTo$iv$iv;
                    Json $this$map$iv;
                    KeywordHighlight e;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    FileOutputStream it = (FileOutputStream)closeable;
                    boolean bl = false;
                    Iterable iterable = this$0.getKeywordHighlightManager().getKeywordHighlights(this$0.accountOwner.getId());
                    boolean $i$f$filter = false;
                    void var9_12 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        e = (KeywordHighlight)element$iv$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)e.getParentId(), (Object)this$1.setId)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        e = (KeywordHighlight)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(KeywordHighlight.copy$default(e, CryptoKt.randomUUID(), null, null, null, null, false, false, 0, 0, false, false, false, false, false, 0L, 0L, 65534, null));
                    }
                    List highlights = (List)destination$iv$iv;
                    $this$map$iv = Application.INSTANCE.getOhMyJson();
                    List value$iv = highlights;
                    boolean $i$f$encodeToString = false;
                    this_$iv.getSerializersModule();
                    IOUtils.write((String)this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(KeywordHighlight.Companion.serializer()), (Object)value$iv), (OutputStream)it, (Charset)StandardCharsets.UTF_8);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            return Unit.INSTANCE;
        }

        private static final void initEvents$lambda$4$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final void initEvents$lambda$5(KeywordHighlightPanel this$0, KeywordHighlightMiniPanel this$1, ActionEvent it) {
            FileChooser chooser = new FileChooser();
            chooser.setOsxAllowedFileTypes(CollectionsKt.listOf((Object)"json"));
            chooser.setAllowsMultiSelection(false);
            chooser.getWin32Filters().add((Pair<String, List<String>>)new Pair((Object)"JSON files", (Object)CollectionsKt.listOf((Object)"json")));
            chooser.setFileSelectionMode(0);
            chooser.showOpenDialog(this$0.getOwner()).thenAccept(arg_0 -> KeywordHighlightMiniPanel.initEvents$lambda$5$1(arg_0 -> KeywordHighlightMiniPanel.initEvents$lambda$5$0(this$1, arg_0), arg_0));
        }

        private static final Unit initEvents$lambda$5$0(KeywordHighlightMiniPanel this$0, List it) {
            Intrinsics.checkNotNull((Object)it);
            if (!((Collection)it).isEmpty()) {
                SwingUtilities.invokeLater(() -> KeywordHighlightMiniPanel.initEvents$lambda$5$0$0(this$0, it));
            }
            return Unit.INSTANCE;
        }

        private static final void initEvents$lambda$5$0$0(KeywordHighlightMiniPanel this$0, List $it) {
            Intrinsics.checkNotNull((Object)$it);
            this$0.importKeywordHighlights((File)CollectionsKt.first((List)$it));
        }

        private static final void initEvents$lambda$5$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public static final /* synthetic */ FlatTable access$getTable$p(KeywordHighlightMiniPanel $this) {
            return $this.table;
        }

        public static final /* synthetic */ KeywordHighlightTableModel access$getModel$p(KeywordHighlightMiniPanel $this) {
            return $this.model;
        }
    }
}

