/*
 * Decompiled with CFR 0.152.
 */
package app.termora.highlight;

import app.termora.DynamicColor;
import app.termora.highlight.KeywordHighlight;
import app.termora.terminal.ColorPalette;
import app.termora.terminal.TerminalColor;
import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020/H\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR\u001a\u0010$\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001b\"\u0004\b&\u0010\u001d\u00a8\u00060"}, d2={"Lapp/termora/highlight/KeywordHighlightView;", "Ljavax/swing/JPanel;", "arc", "", "fontSize", "<init>", "(II)V", "getArc", "()I", "setArc", "(I)V", "getFontSize", "setFontSize", "text", "", "textColor", "Ljava/awt/Color;", "getTextColor", "()Ljava/awt/Color;", "setTextColor", "(Ljava/awt/Color;)V", "backgroundColor", "getBackgroundColor", "setBackgroundColor", "bold", "", "getBold", "()Z", "setBold", "(Z)V", "italic", "getItalic", "setItalic", "lineThrough", "getLineThrough", "setLineThrough", "underline", "getUnderline", "setUnderline", "setKeywordHighlight", "", "value", "Lapp/termora/highlight/KeywordHighlight;", "colorPalette", "Lapp/termora/terminal/ColorPalette;", "paintComponent", "g", "Ljava/awt/Graphics;", "termora"})
public final class KeywordHighlightView
extends JPanel {
    private int arc;
    private int fontSize;
    @NotNull
    private final String text;
    @Nullable
    private Color textColor;
    @Nullable
    private Color backgroundColor;
    private boolean bold;
    private boolean italic;
    private boolean lineThrough;
    private boolean underline;

    public KeywordHighlightView(int arc, int fontSize) {
        this.arc = arc;
        this.fontSize = fontSize;
        this.text = "Highlight";
        this.setBorder((Border)new FlatLineBorder(new Insets(1, 1, 1, 1), (Color)DynamicColor.Companion.getBorderColor(), 1.0f, this.arc));
    }

    public /* synthetic */ KeywordHighlightView(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = UIManager.getInt("Component.arc");
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        this(n, n2);
    }

    public final int getArc() {
        return this.arc;
    }

    public final void setArc(int n) {
        this.arc = n;
    }

    public final int getFontSize() {
        return this.fontSize;
    }

    public final void setFontSize(int n) {
        this.fontSize = n;
    }

    @Nullable
    public final Color getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(@Nullable Color color) {
        this.textColor = color;
    }

    @Nullable
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setBackgroundColor(@Nullable Color color) {
        this.backgroundColor = color;
    }

    public final boolean getBold() {
        return this.bold;
    }

    public final void setBold(boolean bl) {
        this.bold = bl;
    }

    public final boolean getItalic() {
        return this.italic;
    }

    public final void setItalic(boolean bl) {
        this.italic = bl;
    }

    public final boolean getLineThrough() {
        return this.lineThrough;
    }

    public final void setLineThrough(boolean bl) {
        this.lineThrough = bl;
    }

    public final boolean getUnderline() {
        return this.underline;
    }

    public final void setUnderline(boolean bl) {
        this.underline = bl;
    }

    public final void setKeywordHighlight(@NotNull KeywordHighlight value, @NotNull ColorPalette colorPalette) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)colorPalette, (String)"colorPalette");
        Color color = value.getTextColor() <= 16 ? (value.getTextColor() == 0 ? new Color(colorPalette.getColor(TerminalColor.Basic.INSTANCE.getFOREGROUND())) : new Color(colorPalette.getXTerm256Color(value.getTextColor()))) : (this.textColor = new Color(value.getTextColor()));
        this.backgroundColor = value.getBackgroundColor() <= 16 ? (value.getBackgroundColor() == 0 ? new Color(colorPalette.getColor(TerminalColor.Basic.INSTANCE.getBACKGROUND())) : new Color(colorPalette.getXTerm256Color(value.getBackgroundColor()))) : new Color(value.getBackgroundColor());
        this.bold = value.getBold();
        this.italic = value.getItalic();
        this.underline = value.getUnderline();
        this.lineThrough = value.getLineThrough();
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.fontSize > 0) {
            g.setFont(g.getFont().deriveFont((float)this.fontSize * 1.0f));
        }
        if (this.bold && this.italic) {
            g.setFont(g.getFont().deriveFont(3));
        } else if (this.bold) {
            g.setFont(g.getFont().deriveFont(1));
        } else if (this.italic) {
            g.setFont(g.getFont().deriveFont(2));
        } else {
            g.setFont(g.getFont().deriveFont(0));
        }
        g.setColor(this.backgroundColor);
        g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arc, this.arc);
        FontMetrics fm = g.getFontMetrics();
        int fw = fm.stringWidth(this.text);
        int x = this.getWidth() / 2 - fw / 2;
        int y = this.getHeight() / 2;
        g.setColor(this.textColor);
        FlatUIUtils.drawString((JComponent)this, (Graphics)g, (String)this.text, (int)x, (int)(y + fm.getHeight() / 2 - fm.getDescent()));
        if (this.underline) {
            g.drawLine(x, y + fm.getHeight() / 2, x + fw, y + fm.getHeight() / 2);
        }
        if (this.lineThrough) {
            g.drawLine(x, y, x + fw, y);
        }
    }

    public KeywordHighlightView() {
        this(0, 0, 3, null);
    }
}

