/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin;

import app.termora.I18n;
import app.termora.OptionPane;
import app.termora.TermoraRestarter;
import app.termora.plugin.DispatchThread;
import app.termora.plugin.Extension;
import app.termora.plugin.Plugin;
import app.termora.plugin.PluginDescriptor;
import app.termora.plugin.PluginManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

record ExtensionProxy(Plugin plugin, Extension extension) implements InvocationHandler
{
    private static final Logger log = LoggerFactory.getLogger(ExtensionProxy.class);

    public Object getProxy() {
        return Proxy.newProxyInstance(this.extension.getClass().getClassLoader(), this.extension.getClass().getInterfaces(), (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.extension.getDispatchThread() == DispatchThread.EDT && !SwingUtilities.isEventDispatchThread() && log.isErrorEnabled()) {
            log.error("Event Dispatch Thread", (Throwable)new WrongThreadException("Event Dispatch Thread"));
        }
        try {
            return method.invoke((Object)this.extension, args);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof Error && log.isErrorEnabled()) {
                log.error("Error Invoking method {}", (Object)method.getName(), (Object)target);
            }
            if (target instanceof LinkageError) {
                this.uninstallPlugin();
                this.restart();
            }
            throw target;
        }
    }

    private void restart() {
        if (SwingUtilities.isEventDispatchThread()) {
            OptionPane.INSTANCE.showMessageDialog(null, I18n.INSTANCE.getString("termora.settings.plugin.not-compatible", this.plugin.getName()), UIManager.getString("OptionPane.messageDialogTitle"), 0, Duration.ZERO);
            try {
                TermoraRestarter.Companion.getInstance().scheduleRestart(null, false, List.of());
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                System.exit(1);
            }
        } else {
            SwingUtilities.invokeLater(this::restart);
        }
    }

    private void uninstallPlugin() {
        PluginDescriptor[] descriptors;
        PluginManager pluginManager = PluginManager.Companion.getInstance();
        for (PluginDescriptor descriptor : descriptors = pluginManager.getLoadedPluginDescriptor()) {
            File file;
            if (descriptor.getPlugin() != this.plugin || (file = descriptor.getPath()) == null) continue;
            File uninstalled = FileUtils.getFile((File)file, (String[])new String[]{"uninstalled"});
            try {
                if (uninstalled.createNewFile() || !log.isWarnEnabled()) continue;
                log.error("Create file: {} failed", (Object)uninstalled.getAbsolutePath());
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) continue;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

