/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.badge;

import app.termora.GlassPaneExtension;
import app.termora.Graphics2DKt;
import app.termora.WindowScope;
import app.termora.plugin.internal.badge.Badge;
import app.termora.plugin.internal.badge.BadgePresentation;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lapp/termora/plugin/internal/badge/BadgeGlassPaneExtension;", "Lapp/termora/GlassPaneExtension;", "<init>", "()V", "paint", "", "scope", "Lapp/termora/WindowScope;", "c", "Ljavax/swing/JComponent;", "g2d", "Ljava/awt/Graphics2D;", "paintBadge", "root", "presentation", "Lapp/termora/plugin/internal/badge/BadgePresentation;", "ordered", "", "Companion", "termora"})
public final class BadgeGlassPaneExtension
implements GlassPaneExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BadgeGlassPaneExtension instance = new BadgeGlassPaneExtension();

    private BadgeGlassPaneExtension() {
    }

    @Override
    public void paint(@NotNull WindowScope scope, @NotNull JComponent c, @NotNull Graphics2D g2d) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
        Map<JComponent, BadgePresentation> badges = Badge.Companion.getInstance(scope).getBadges();
        if (badges.isEmpty()) {
            return;
        }
        Graphics2DKt.setupAntialiasing(g2d);
        for (Map.Entry<JComponent, BadgePresentation> entry : badges.entrySet()) {
            JComponent comp = entry.getKey();
            BadgePresentation presentation2 = entry.getValue();
            if (!comp.isShowing() || !presentation2.getVisible()) continue;
            this.paintBadge(c, comp, g2d, presentation2);
        }
    }

    private final void paintBadge(JComponent root, JComponent c, Graphics2D g2d, BadgePresentation presentation2) {
        Point point = c.getLocationOnScreen();
        SwingUtilities.convertPointFromScreen(point, root);
        int size = 6;
        g2d.setColor(presentation2.getColor());
        g2d.fillRoundRect(c.getWidth() - size - 4 + point.x, point.y + 4, size, size, size, size);
    }

    @Override
    public long ordered() {
        return Long.MAX_VALUE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lapp/termora/plugin/internal/badge/BadgeGlassPaneExtension$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/plugin/internal/badge/BadgeGlassPaneExtension;", "getInstance", "()Lapp/termora/plugin/internal/badge/BadgeGlassPaneExtension;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BadgeGlassPaneExtension getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

