/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.plugin;

import app.termora.Application;
import app.termora.CryptoKt;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicColor;
import app.termora.Ed25519;
import app.termora.I18n;
import app.termora.MixpanelService;
import app.termora.OptionPane;
import app.termora.ResponseException;
import app.termora.ScopeKt;
import app.termora.SwingUtils;
import app.termora.TermoraRestarter;
import app.termora.plugin.ExtensionManager;
import app.termora.plugin.PluginDescriptor;
import app.termora.plugin.PluginManager;
import app.termora.plugin.PluginOrigin;
import app.termora.plugin.PluginUninstallExtension;
import app.termora.plugin.internal.plugin.InstallButton;
import app.termora.plugin.internal.plugin.MarketplacePanel;
import app.termora.plugin.internal.plugin.PluginOption;
import app.termora.plugin.internal.plugin.PluginPanel;
import app.termora.plugin.internal.plugin.PluginPluginDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.io.CopyStreamAdapter;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.io.Util;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.semver4j.Semver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0002/0B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010 \u001a\u00020!H\u0002J\u0006\u0010\"\u001a\u00020!J\b\u0010#\u001a\u00020!H\u0002J\b\u0010$\u001a\u00020!H\u0002J\b\u0010%\u001a\u00020!H\u0002J\b\u0010&\u001a\u00020!H\u0002J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\fH\u0002J\u001e\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0082@\u00a2\u0006\u0002\u0010.R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00061"}, d2={"Lapp/termora/plugin/internal/plugin/PluginPanel;", "Ljavax/swing/JPanel;", "Lapp/termora/Disposable;", "descriptor", "Lapp/termora/plugin/internal/plugin/PluginPluginDescriptor;", "<init>", "(Lapp/termora/plugin/internal/plugin/PluginPluginDescriptor;)V", "getDescriptor", "()Lapp/termora/plugin/internal/plugin/PluginPluginDescriptor;", "restartButton", "Ljavax/swing/JButton;", "updateButton", "Lapp/termora/plugin/internal/plugin/InstallButton;", "installButton", "uninstallButton", "installing", "Ljava/util/concurrent/atomic/AtomicInteger;", "getInstalling", "()Ljava/util/concurrent/atomic/AtomicInteger;", "restarter", "Lapp/termora/TermoraRestarter;", "getRestarter", "()Lapp/termora/TermoraRestarter;", "pluginManager", "Lapp/termora/plugin/PluginManager;", "getPluginManager", "()Lapp/termora/plugin/PluginManager;", "owner", "Ljava/awt/Window;", "kotlin.jvm.PlatformType", "getOwner", "()Ljava/awt/Window;", "initView", "", "refreshButtons", "initEvents", "install", "uninstall", "update", "installOrUpdate", "button", "downloadPlugin", "listener", "Lorg/apache/commons/net/io/CopyStreamListener;", "updated", "", "(Lorg/apache/commons/net/io/CopyStreamListener;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "UserCancelException", "termora"})
@SourceDebugExtension(value={"SMAP\nPluginPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginPanel.kt\napp/termora/plugin/internal/plugin/PluginPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,393:1\n1#2:394\n1761#3,3:395\n1869#3,2:400\n1400#4,2:398\n*S KotlinDebug\n*F\n+ 1 PluginPanel.kt\napp/termora/plugin/internal/plugin/PluginPanel\n*L\n107#1:395,3\n181#1:400,2\n113#1:398,2\n*E\n"})
public final class PluginPanel
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginPluginDescriptor descriptor;
    @NotNull
    private final JButton restartButton;
    @NotNull
    private final InstallButton updateButton;
    @NotNull
    private final InstallButton installButton;
    @NotNull
    private final JButton uninstallButton;
    private static final Logger log = LoggerFactory.getLogger(PluginPanel.class);
    @NotNull
    private static final Set<String> installed = new LinkedHashSet();
    @NotNull
    private static final Set<String> uninstalled = new LinkedHashSet();
    @NotNull
    private static final PublicKey publicKey;

    /*
     * WARNING - void declaration
     */
    public PluginPanel(@NotNull PluginPluginDescriptor descriptor) {
        void $this$updateButton_u24lambda_u240;
        InstallButton installButton;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.descriptor = descriptor;
        this.restartButton = new JButton(I18n.INSTANCE.getString("termora.settings.restart.title"));
        InstallButton installButton2 = installButton = new InstallButton();
        PluginPanel pluginPanel = this;
        boolean bl = false;
        $this$updateButton_u24lambda_u240.setUpdate(true);
        pluginPanel.updateButton = installButton;
        this.installButton = new InstallButton();
        this.uninstallButton = new JButton(I18n.INSTANCE.getString("termora.settings.plugin.uninstall"));
        this.initView();
        this.initEvents();
    }

    @NotNull
    public final PluginPluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    private final AtomicInteger getInstalling() {
        return MarketplacePanel.Companion.getInstalling();
    }

    private final TermoraRestarter getRestarter() {
        return TermoraRestarter.Companion.getInstance();
    }

    private final PluginManager getPluginManager() {
        return PluginManager.Companion.getInstance();
    }

    private final Window getOwner() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private final void initView() {
        JXLabel jXLabel;
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(this.descriptor.getIcon()));
        this.add(Box.createHorizontalStrut(8));
        Box infoBox = Box.createVerticalBox();
        infoBox.add(new JLabel("<html><b>" + this.descriptor.getPlugin().getName() + "</b>&nbsp;&nbsp;" + this.descriptor.getVersion() + "</html>"));
        infoBox.add(Box.createVerticalStrut(4));
        JXLabel $this$initView_u24lambda_u240 = jXLabel = new JXLabel(this.descriptor.getDescription());
        boolean bl = false;
        $this$initView_u24lambda_u240.setForeground((Color)new DynamicColor("textInactiveText"));
        JXLabel descriptionLabel = jXLabel;
        descriptionLabel.setPreferredSize(new Dimension(0, descriptionLabel.getPreferredSize().height));
        descriptionLabel.setToolTipText(this.descriptor.getDescription());
        infoBox.add((Component)descriptionLabel);
        this.add(infoBox);
        this.add(Box.createHorizontalGlue());
        this.add(Box.createHorizontalStrut(8));
        this.add(Box.createHorizontalGlue());
        this.installButton.setText(I18n.INSTANCE.getString("termora.settings.plugin.install"));
        this.updateButton.setText(I18n.INSTANCE.getString("termora.update.update"));
        this.installButton.setFocusable(false);
        this.restartButton.setFocusable(false);
        this.updateButton.setFocusable(false);
        this.uninstallButton.setFocusable(false);
        this.refreshButtons();
        this.add((Component)((Object)this.updateButton));
        this.add(this.restartButton);
        this.add((Component)((Object)this.installButton));
        this.add(this.uninstallButton);
        this.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
    }

    public final void refreshButtons() {
        boolean bl;
        block13: {
            this.restartButton.setVisible(false);
            this.installButton.setVisible(false);
            this.uninstallButton.setVisible(false);
            this.updateButton.setVisible(false);
            if (this.descriptor.getOrigin() == PluginOrigin.System || this.descriptor.getOrigin() == PluginOrigin.Internal) {
                return;
            }
            Iterable $this$any$iv = PluginOption.Companion.getInstalledFromDisk();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PluginPluginDescriptor it = (PluginPluginDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.descriptor.getId())) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl || installed.contains(this.descriptor.getId()) || uninstalled.contains(this.descriptor.getId()) || this.descriptor.getOrigin() == PluginOrigin.Memory) {
            this.restartButton.setVisible(true);
        } else if (this.descriptor.getMarketplace()) {
            PluginDescriptor loadedPlugin;
            block14: {
                PluginDescriptor pluginDescriptor;
                PluginDescriptor[] $this$firstOrNull$iv = this.getPluginManager().getLoadedPluginDescriptor();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    PluginDescriptor element$iv;
                    PluginDescriptor it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.descriptor.getId())) continue;
                    pluginDescriptor = element$iv;
                    break block14;
                }
                pluginDescriptor = loadedPlugin = null;
            }
            if (loadedPlugin != null) {
                Semver remoteVersion;
                Semver localVersion = loadedPlugin.getVersion();
                if (localVersion.compareTo(remoteVersion = this.descriptor.getVersion()) >= 0) {
                    this.installButton.setVisible(true);
                    this.installButton.setText(I18n.INSTANCE.getString("termora.settings.plugin.installed"));
                    this.installButton.setEnabled(false);
                } else {
                    this.updateButton.setVisible(true);
                }
            } else {
                this.installButton.setVisible(true);
            }
        } else {
            this.uninstallButton.setVisible(true);
        }
    }

    private final void initEvents() {
        this.restartButton.addActionListener(arg_0 -> PluginPanel.initEvents$lambda$0(this, arg_0));
        this.uninstallButton.addActionListener(arg_0 -> PluginPanel.initEvents$lambda$1(this, arg_0));
        this.updateButton.addActionListener(arg_0 -> PluginPanel.initEvents$lambda$2(this, arg_0));
        this.installButton.addActionListener(arg_0 -> PluginPanel.initEvents$lambda$3(this, arg_0));
    }

    private final void install() {
        this.installOrUpdate(this.installButton);
    }

    private final void uninstall() {
        if (this.descriptor.getOrigin() != PluginOrigin.External) {
            return;
        }
        File file = this.descriptor.getPath();
        if (file == null) {
            return;
        }
        File path = file;
        if (!path.exists() || !path.isDirectory()) {
            return;
        }
        Object[] objectArray = new Object[]{this.descriptor.getPlugin().getName()};
        String string = I18n.INSTANCE.getString("termora.settings.plugin.uninstall-confirm", objectArray);
        objectArray = new Object[]{I18n.INSTANCE.getString("termora.settings.plugin.uninstall"), I18n.INSTANCE.getString("termora.cancel")};
        if (OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, this.getOwner(), string, null, 2, 0, null, objectArray, I18n.INSTANCE.getString("termora.settings.plugin.uninstall"), null, 308, null) != 0) {
            return;
        }
        objectArray = new String[]{"uninstalled"};
        if (FileUtils.getFile((File)path, (String[])objectArray).createNewFile()) {
            block9: {
                this.uninstallButton.setVisible(false);
                this.restartButton.setVisible(true);
                uninstalled.add(this.descriptor.getId());
                try {
                    Iterable $this$forEach$iv = ExtensionManager.Companion.getInstance().getExtensions(PluginUninstallExtension.class);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PluginUninstallExtension it = (PluginUninstallExtension)element$iv;
                        boolean bl = false;
                        it.uninstalled();
                    }
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block9;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            objectArray = new Pair[]{TuplesKt.to((Object)"pluginName", (Object)this.descriptor.getPlugin().getName()), TuplesKt.to((Object)"pluginVersion", (Object)this.descriptor.getVersion().toString())};
            MixpanelService.Companion.getInstance().push("uninstall-plugin", MapsKt.mapOf((Pair[])objectArray));
            TermoraRestarter.scheduleRestart$default(TermoraRestarter.Companion.getInstance(), this.getOwner(), false, null, 6, null);
        } else {
            OptionPane.showMessageDialog$default(OptionPane.INSTANCE, this.getOwner(), I18n.INSTANCE.getString("termora.settings.plugin.uninstall-failed"), null, 0, null, 20, null);
        }
    }

    private final void update() {
        this.installOrUpdate(this.updateButton);
    }

    private final void installOrUpdate(InstallButton button) {
        button.setInstalling(true);
        button.setProgress(0);
        button.setEnabled(false);
        this.getInstalling().incrementAndGet();
        Job job2 = BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, button, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PluginPanel this$0;
            final /* synthetic */ InstallButton $button;
            {
                this.this$0 = $receiver;
                this.$button = $button;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 1;
                        v0 = PluginPanel.access$downloadPlugin(this.this$0, (CopyStreamListener)new CopyStreamAdapter((CoroutineScope)$this$launch, this.$button){
                            final /* synthetic */ CoroutineScope $$this$launch;
                            final /* synthetic */ InstallButton $button;
                            {
                                this.$$this$launch = $$this$launch;
                                this.$button = $button;
                            }

                            public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                                int progress;
                                if (!CoroutineScopeKt.isActive((CoroutineScope)this.$$this$launch)) {
                                    throw new CancellationException();
                                }
                                int oldProgress = this.$button.getProgress();
                                if (oldProgress != (progress = (int)Math.rint((double)totalBytesTransferred * 1.0 / (double)streamSize * 100.0))) {
                                    SwingUtilities.invokeLater(() -> installOrUpdate.job.1.bytesTransferred$lambda$0(this.$button, progress));
                                }
                            }

                            private static final void bytesTransferred$lambda$0(InstallButton $button, int $progress) {
                                $button.setProgress($progress);
                                $button.repaint();
                            }
                        }, Intrinsics.areEqual((Object)this.$button, (Object)PluginPanel.access$getUpdateButton$p(this.this$0)), (Continuation)this);
                        ** if (v0 != var4_3) goto lbl13
lbl12:
                        // 1 sources

                        return var4_3;
lbl13:
                        // 1 sources

                        ** GOTO lbl19
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        var3_4 = new Pair[]{TuplesKt.to((Object)"pluginName", (Object)this.this$0.getDescriptor().getPlugin().getName()), TuplesKt.to((Object)"pluginVersion", (Object)this.this$0.getDescriptor().getVersion().toString())};
                        MixpanelService.Companion.getInstance().push((Intrinsics.areEqual((Object)this.$button, (Object)PluginPanel.access$getInstallButton$p(this.this$0)) != false ? "install" : "update") + "-plugin", MapsKt.mapOf((Pair[])var3_4));
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$button, null){
                            int label;
                            final /* synthetic */ PluginPanel this$0;
                            final /* synthetic */ InstallButton $button;
                            {
                                this.this$0 = $receiver;
                                this.$button = $button;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Container pluginOption;
                                        ResultKt.throwOnFailure((Object)$result);
                                        PluginPanel.access$getInstalled$cp().add(this.this$0.getDescriptor().getId());
                                        if (PluginPanel.access$getInstalling(this.this$0).get() <= 1) {
                                            SwingUtilities.invokeLater(() -> installOrUpdate.job.2.invokeSuspend$lambda$0(this.this$0));
                                        }
                                        if (Intrinsics.areEqual((Object)((Object)this.$button), (Object)((Object)PluginPanel.access$getUpdateButton$p(this.this$0))) && (pluginOption = SwingUtilities.getAncestorOfClass(PluginOption.class, (Component)((Object)this.$button))) != null) {
                                            for (PluginPanel panel2 : SwingUtils.getDescendantsOfType(PluginPanel.class, pluginOption)) {
                                                if (!Intrinsics.areEqual((Object)panel2.getDescriptor().getId(), (Object)this.this$0.getDescriptor().getId())) continue;
                                                panel2.refreshButtons();
                                            }
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final void invokeSuspend$lambda$0(PluginPanel this$0) {
                                TermoraRestarter.scheduleRestart$default(PluginPanel.access$getRestarter(this$0), PluginPanel.access$getOwner(this$0), false, null, 6, null);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v1 != var4_3) goto lbl26
lbl25:
                        // 1 sources

                        return var4_3;
lbl26:
                        // 1 sources

                        ** GOTO lbl32
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl32:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 3;
                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$button, null){
                            int label;
                            final /* synthetic */ PluginPanel this$0;
                            final /* synthetic */ InstallButton $button;
                            {
                                this.this$0 = $receiver;
                                this.$button = $button;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        PluginPanel.access$getInstalling(this.this$0).decrementAndGet();
                                        this.$button.setInstalling(false);
                                        this.this$0.refreshButtons();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var4_3) {
                            return var4_3;
                        }
                        break;
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break;
                    }
                }
                catch (Exception e) {
                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                    this.L$1 = e;
                    this.label = 4;
                    v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$button, null){
                        int label;
                        final /* synthetic */ InstallButton $button;
                        {
                            this.$button = $button;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.$button.setEnabled(true);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)((Continuation)this));
                    ** if (v3 != var4_3) goto lbl50
lbl49:
                    // 1 sources

                    return var4_3;
lbl50:
                    // 1 sources

                    ** GOTO lbl57
                }
                {
                    case 4: {
                        e = (Exception)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl57:
                        // 2 sources

                        if (e instanceof UserCancelException) ** GOTO lbl73
                        if (PluginPanel.access$getLog$cp().isErrorEnabled()) {
                            PluginPanel.access$getLog$cp().error(e.getMessage(), (Throwable)e);
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)e);
                        this.label = 5;
                        v4 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$button, this.this$0, null){
                            int label;
                            final /* synthetic */ InstallButton $button;
                            final /* synthetic */ PluginPanel this$0;
                            {
                                this.$button = $button;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.$button.setEnabled(true);
                                        OptionPane.showMessageDialog$default(OptionPane.INSTANCE, PluginPanel.access$getOwner(this.this$0), I18n.INSTANCE.getString("termora.settings.plugin.install-failed"), null, 0, null, 20, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v4 != var4_3) goto lbl66
lbl65:
                        // 1 sources

                        return var4_3;
lbl66:
                        // 1 sources

                        ** GOTO lbl73
                    }
                    case 5: {
                        e = (Exception)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl73:
                        // 3 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = null;
                        this.label = 6;
                        v5 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)((Continuation)this));
                        if (v5 == var4_3) {
                            return var4_3;
                        }
                        break;
                    }
                    case 6: {
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
                        break;
                    }
                }
                {
                    catch (Throwable var3_7) {
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = var3_7;
                        this.label = 7;
                        v6 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)((Continuation)this));
                        if (v6 == var4_3) {
                            return var4_3;
                        }
                        ** GOTO lbl96
                    }
                }
                {
                    case 7: {
                        var3_8 = (Throwable)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl96:
                        // 2 sources

                        throw var3_8;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Disposer.register(this, new Disposable(job2){
            final /* synthetic */ Job $job;
            {
                this.$job = $job;
            }

            public void dispose() {
                if (this.$job.isActive()) {
                    Job.DefaultImpls.cancel$default((Job)this.$job, null, (int)1, null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object downloadPlugin(CopyStreamListener listener, boolean updated, Continuation<? super Unit> $completion) {
        if (!($completion instanceof downloadPlugin.1)) ** GOTO lbl-1000
        var29_4 = $completion;
        if ((var29_4.label & -2147483648) != 0) {
            var29_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                boolean Z$1;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ PluginPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PluginPanel.access$downloadPlugin(this.this$0, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var30_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                request = new Request.Builder().url(this.descriptor.getDownloadUrl()).get().build();
                response = Application.INSTANCE.getHttpClient().newCall(request).execute();
                if (!response.isSuccessful()) {
                    IOUtils.closeQuietly((Closeable)((Closeable)response));
                    if (PluginPanel.log.isErrorEnabled()) {
                        var6_9 = new Object[]{this.descriptor.getId(), this.descriptor.getDownloadUrl(), Boxing.boxInt((int)response.code())};
                        PluginPanel.log.error("Plugin {} download failed, url: {}, status: {}", var6_9);
                    }
                    throw new ResponseException(response.code(), response);
                }
                v0 = Response.header$default((Response)response, (String)"Content-Length", null, (int)2, null);
                contentLength = v0 != null && (v0 = StringsKt.toLongOrNull((String)v0)) != null ? v0.longValue() : -1L;
                var9_11 /* !! */  = new String[]{CryptoKt.randomUUID()};
                tempFile = FileUtils.getFile((File)Application.INSTANCE.getTemporaryDir(), (String[])var9_11 /* !! */ );
                Intrinsics.checkNotNull((Object)tempFile);
                var9_11 /* !! */  = new FileOutputStream(tempFile);
                var10_14 = null;
                try {
                    fos = (FileOutputStream)var9_11 /* !! */ ;
                    $i$a$-use-PluginPanel$downloadPlugin$2 = false;
                    var14_26 = (Closeable)response;
                    var15_31 = null;
                    try {
                        resp = (Response)var14_26;
                        $i$a$-use-PluginPanel$downloadPlugin$2$1 = false;
                        v1 = resp.body();
                        if (v1 == null) {
                            throw new ResponseException(response.code(), resp);
                        }
                        body = v1;
                        var20_43 = body.byteStream();
                        var21_47 = null;
                        try {
                            input = (InputStream)var20_43;
                            $i$a$-use-PluginPanel$downloadPlugin$2$1$1 = false;
                            var22_49 = Util.copyStream((InputStream)input, (OutputStream)fos, (int)1024, (long)contentLength, (CopyStreamListener)listener);
                        }
                        catch (Throwable $i$a$-use-PluginPanel$downloadPlugin$2$1$1) {
                            var21_47 = $i$a$-use-PluginPanel$downloadPlugin$2$1$1;
                            throw $i$a$-use-PluginPanel$downloadPlugin$2$1$1;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var20_43, (Throwable)var21_47);
                        }
                        var16_36 = var22_49;
                    }
                    catch (Throwable var18_39) {
                        var15_31 = var18_39;
                        throw var18_39;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var14_26, (Throwable)var15_31);
                    }
                    var11_18 = var16_36;
                }
                catch (Throwable $i$a$-use-PluginPanel$downloadPlugin$2) {
                    var10_14 = $i$a$-use-PluginPanel$downloadPlugin$2;
                    throw $i$a$-use-PluginPanel$downloadPlugin$2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var9_11 /* !! */ , (Throwable)var10_14);
                }
                var10_14 = new FileInputStream(tempFile);
                var11_19 /* !! */  = null;
                try {
                    it = (FileInputStream)var10_14;
                    $i$a$-use-PluginPanel$downloadPlugin$signature$1 = false;
                    v2 = it;
                    v3 = Base64.decodeBase64((String)this.descriptor.getSignature());
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"decodeBase64(...)");
                    var13_24 = Ed25519.INSTANCE.verify(PluginPanel.publicKey, v2, v3);
                }
                catch (Throwable $i$a$-use-PluginPanel$downloadPlugin$signature$1) {
                    var11_19 /* !! */  = $i$a$-use-PluginPanel$downloadPlugin$signature$1;
                    throw $i$a$-use-PluginPanel$downloadPlugin$signature$1;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var10_14, (Throwable)var11_19 /* !! */ );
                }
                signature = var13_24;
                if (signature) ** GOTO lbl115
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)listener);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)response);
                $continuation.L$3 = tempFile;
                $continuation.Z$0 = updated;
                $continuation.J$0 = contentLength;
                $continuation.Z$1 = signature;
                $continuation.label = 1;
                v4 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, null){
                    int label;
                    final /* synthetic */ PluginPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object[] objectArray = new Object[]{this.this$0.getDescriptor().getPlugin().getName()};
                                String string = I18n.INSTANCE.getString("termora.settings.plugin.install-from-disk-warning", objectArray);
                                objectArray = new Object[]{I18n.INSTANCE.getString("termora.settings.plugin.install"), I18n.INSTANCE.getString("termora.cancel")};
                                return Boxing.boxBoolean((OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, PluginPanel.access$getOwner(this.this$0), string, null, 2, 2, null, objectArray, I18n.INSTANCE.getString("termora.settings.plugin.install"), null, 292, null) == 0 ? 1 : 0) != 0);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v4 == var30_6) {
                    return var30_6;
                }
                ** GOTO lbl113
            }
            case 1: {
                signature = $continuation.Z$1;
                contentLength = $continuation.J$0;
                updated = $continuation.Z$0;
                tempFile = (File)$continuation.L$3;
                response = (Response)$continuation.L$2;
                request = (Request)$continuation.L$1;
                listener = (CopyStreamListener)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl113:
                // 2 sources

                if (!(stillInstall = ((Boolean)v4).booleanValue())) {
                    throw new UserCancelException();
                }
lbl115:
                // 3 sources

                pluginDirectory = null;
                var11_19 /* !! */  = new String[]{this.descriptor.getId()};
                pluginDirectory = FileUtils.getFile((File)PluginManager.Companion.getInstance().getPluginDirectory(), (String[])var11_19 /* !! */ );
                if (updated) {
                    var11_19 /* !! */  = new String[]{"updated"};
                    pluginDirectory = FileUtils.getFile((File)pluginDirectory, (String[])var11_19 /* !! */ );
                }
                if (pluginDirectory.exists()) {
                    FileUtils.deleteQuietly((File)pluginDirectory);
                }
                FileUtils.forceMkdir((File)pluginDirectory);
                Intrinsics.checkNotNull((Object)tempFile);
                var11_19 /* !! */  = new FileInputStream(tempFile);
                var13_25 = null;
                try {
                    input = (FileInputStream)var11_19 /* !! */ ;
                    $i$a$-use-PluginPanel$downloadPlugin$3 = false;
                    var16_37 = new ZipInputStream(input);
                    var18_41 = null;
                    try {
                        zis = (ZipInputStream)var16_37;
                        $i$a$-use-PluginPanel$downloadPlugin$3$1 = false;
                        zipEntry = zis.getNextEntry();
                        while (zipEntry != null) {
                            var22_50 /* !! */  = new String[]{zipEntry.getName()};
                            file = FileUtils.getFile((File)pluginDirectory, (String[])var22_50 /* !! */ );
                            if (!zipEntry.isDirectory()) ** GOTO lbl145
                            FileUtils.forceMkdir((File)file);
                            ** GOTO lbl160
lbl145:
                            // 1 sources

                            Intrinsics.checkNotNull((Object)file);
                            var22_50 /* !! */  = new FileOutputStream(file);
                            var25_55 = null;
                            try {
                                output = (FileOutputStream)var22_50 /* !! */ ;
                                $i$a$-use-PluginPanel$downloadPlugin$3$1$1 = false;
                                var26_56 = Boxing.boxLong((long)ByteStreamsKt.copyTo$default((InputStream)zis, (OutputStream)output, (int)0, (int)2, null));
                            }
                            catch (Throwable var27_58) {
                                var25_55 = var27_58;
                                throw var27_58;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)var22_50 /* !! */ , (Throwable)var25_55);
                            }
lbl160:
                            // 2 sources

                            zipEntry = zis.getNextEntry();
                        }
                        var19_42 = Unit.INSTANCE;
                    }
                    catch (Throwable var20_45) {
                        var18_41 = var20_45;
                        throw var20_45;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var16_37, (Throwable)var18_41);
                    }
                    var14_30 = Unit.INSTANCE;
                }
                catch (Throwable var15_33) {
                    var13_25 = var15_33;
                    throw var15_33;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var11_19 /* !! */ , (Throwable)var13_25);
                }
                FileUtils.deleteQuietly((File)tempFile);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void initEvents$lambda$0(PluginPanel this$0, ActionEvent it) {
        if (this$0.getRestarter().isSupported()) {
            TermoraRestarter.scheduleRestart$default(this$0.getRestarter(), this$0.getOwner(), false, null, 6, null);
        } else {
            OptionPane.showMessageDialog$default(OptionPane.INSTANCE, this$0.getOwner(), I18n.INSTANCE.getString("termora.settings.restart.manually"), null, 2, null, 20, null);
        }
    }

    private static final void initEvents$lambda$1(PluginPanel this$0, ActionEvent it) {
        this$0.uninstall();
    }

    private static final void initEvents$lambda$2(PluginPanel this$0, ActionEvent it) {
        this$0.update();
    }

    private static final void initEvents$lambda$3(PluginPanel this$0, ActionEvent it) {
        this$0.install();
    }

    public static final /* synthetic */ Object access$downloadPlugin(PluginPanel $this, CopyStreamListener listener2, boolean updated, Continuation $completion) {
        return $this.downloadPlugin(listener2, updated, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ InstallButton access$getUpdateButton$p(PluginPanel $this) {
        return $this.updateButton;
    }

    public static final /* synthetic */ InstallButton access$getInstallButton$p(PluginPanel $this) {
        return $this.installButton;
    }

    public static final /* synthetic */ Set access$getInstalled$cp() {
        return installed;
    }

    public static final /* synthetic */ AtomicInteger access$getInstalling(PluginPanel $this) {
        return $this.getInstalling();
    }

    public static final /* synthetic */ TermoraRestarter access$getRestarter(PluginPanel $this) {
        return $this.getRestarter();
    }

    public static final /* synthetic */ Window access$getOwner(PluginPanel $this) {
        return $this.getOwner();
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    static {
        byte[] byArray = Base64.decodeBase64((String)"MCowBQYDK2VwAyEAHPyJ5kt2UHWYUPnWU84DOEhCCUE5FEpzdAbeTCNV31A");
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decodeBase64(...)");
        publicKey = Ed25519.INSTANCE.generatePublic(byArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lapp/termora/plugin/internal/plugin/PluginPanel$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "installed", "", "", "uninstalled", "publicKey", "Ljava/security/PublicKey;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lapp/termora/plugin/internal/plugin/PluginPanel$UserCancelException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "<init>", "()V", "termora"})
    private static final class UserCancelException
    extends RuntimeException {
    }
}

