/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.sftppty;

import app.termora.Application;
import app.termora.AuthenticationType;
import app.termora.Host;
import app.termora.Icons;
import app.termora.ProxyType;
import app.termora.PtyConnectorFactory;
import app.termora.PtyHostTerminalTab;
import app.termora.TerminalTab;
import app.termora.Tunneling;
import app.termora.TunnelingType;
import app.termora.WindowScope;
import app.termora.database.DatabaseManager;
import app.termora.keymgr.KeyManager;
import app.termora.keymgr.OhKeyPair;
import app.termora.keymgr.OhKeyPairKeyPairProvider;
import app.termora.plugin.internal.ssh.SshClients;
import app.termora.terminal.DataKey;
import app.termora.terminal.DataListener;
import app.termora.terminal.PtyConnector;
import app.termora.terminal.TerminalKeyEvent;
import app.termora.terminal.TerminalLine;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.TerminalSize;
import app.termora.terminal.VisualTerminal;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Window;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.config.keys.writer.openssh.OpenSSHKeyPairResourceWriter;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u000245B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\"\u001a\u00020#H\u0096@\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180&H\u0002J\u001e\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010*\u001a\u00020(H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0014J\u0018\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020#2\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00100\u001a\u00020#H\u0016R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0018\u00010\u0016R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u001c\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00066"}, d2={"Lapp/termora/plugin/internal/sftppty/SFTPPtyTerminalTab;", "Lapp/termora/PtyHostTerminalTab;", "windowScope", "Lapp/termora/WindowScope;", "host", "Lapp/termora/Host;", "<init>", "(Lapp/termora/WindowScope;Lapp/termora/Host;)V", "keyManager", "Lapp/termora/keymgr/KeyManager;", "getKeyManager", "()Lapp/termora/keymgr/KeyManager;", "keyManager$delegate", "Lkotlin/Lazy;", "tempFiles", "", "Ljava/nio/file/Path;", "sshClient", "Lorg/apache/sshd/client/SshClient;", "sshSession", "Lorg/apache/sshd/client/session/ClientSession;", "lastPasswordReporterDataListener", "Lapp/termora/plugin/internal/sftppty/SFTPPtyTerminalTab$PasswordReporterDataListener;", "sftpCommand", "", "getSftpCommand", "()Ljava/lang/String;", "defaultDirectory", "getDefaultDirectory", "owner", "Ljava/awt/Window;", "kotlin.jvm.PlatformType", "getOwner", "()Ljava/awt/Window;", "openPtyConnector", "Lapp/termora/terminal/PtyConnector;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLocalSSHHostKeyAlgorithms", "", "setAuthentication", "", "commands", "stop", "getIcon", "Ljavax/swing/Icon;", "createReconnectTerminalTab", "Lapp/termora/TerminalTab;", "sendStartupCommand", "ptyConnector", "bytes", "", "loginScriptsPtyConnector", "Companion", "PasswordReporterDataListener", "termora"})
@SourceDebugExtension(value={"SMAP\nSFTPPtyTerminalTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SFTPPtyTerminalTab.kt\napp/termora/plugin/internal/sftppty/SFTPPtyTerminalTab\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,247:1\n1#2:248\n1563#3:249\n1634#3,3:250\n774#3:255\n865#3,2:256\n37#4,2:253\n*S KotlinDebug\n*F\n+ 1 SFTPPtyTerminalTab.kt\napp/termora/plugin/internal/sftppty/SFTPPtyTerminalTab\n*L\n106#1:249\n106#1:250,3\n163#1:255\n163#1:256,2\n147#1:253,2\n*E\n"})
public final class SFTPPtyTerminalTab
extends PtyHostTerminalTab {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy keyManager$delegate;
    @NotNull
    private final List<Path> tempFiles;
    @Nullable
    private SshClient sshClient;
    @Nullable
    private ClientSession sshSession;
    @Nullable
    private PasswordReporterDataListener lastPasswordReporterDataListener;
    @NotNull
    private static final Lazy<Boolean> canSupports$delegate = LazyKt.lazy(SFTPPtyTerminalTab::canSupports_delegate$lambda$0);

    public SFTPPtyTerminalTab(@NotNull WindowScope windowScope, @NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)windowScope, (String)"windowScope");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super(windowScope, host, null, 4, null);
        this.keyManager$delegate = LazyKt.lazy(SFTPPtyTerminalTab::keyManager_delegate$lambda$0);
        this.tempFiles = new ArrayList();
        this.getTerminalPanel().setDropFiles(true);
    }

    private final KeyManager getKeyManager() {
        Lazy lazy = this.keyManager$delegate;
        return (KeyManager)lazy.getValue();
    }

    private final String getSftpCommand() {
        return DatabaseManager.Companion.getInstance().getSftp().getSftpCommand();
    }

    private final String getDefaultDirectory() {
        return DatabaseManager.Companion.getInstance().getSftp().getDefaultDirectory();
    }

    private final Window getOwner() {
        return SwingUtilities.getWindowAncestor(this.getTerminalPanel());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object openPtyConnector(@NotNull Continuation<? super PtyConnector> $completion) {
        boolean useJumpHosts = !((Collection)this.getHost().getOptions().getJumpHosts()).isEmpty() || this.getHost().getProxy().getType() != ProxyType.No;
        Object[] objectArray = new String[]{StringUtils.defaultIfBlank((CharSequence)this.getSftpCommand(), (CharSequence)"sftp")};
        List commands = CollectionsKt.mutableListOf((Object[])objectArray);
        Host host = this.getHost();
        if (useJumpHosts) {
            host = Host.copy$default(host, null, null, null, null, 0, null, null, null, null, null, CollectionsKt.listOf((Object)new Tunneling(null, TunnelingType.Local, "localhost", 0, "localhost", host.getPort(), 9, null)), 0L, null, null, null, null, false, 0L, 0L, 523263, null);
            Window window = this.getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"<get-owner>(...)");
            SshClient sshClient = SshClients.INSTANCE.openClient(host, window);
            Object $this$openPtyConnector_u24lambda_u240 = sshClient;
            boolean bl = false;
            this.sshClient = $this$openPtyConnector_u24lambda_u240;
            SshClient sshClient2 = sshClient;
            $this$openPtyConnector_u24lambda_u240 = SshClients.INSTANCE.openSession(host, sshClient2);
            SshClient sshClient3 = $this$openPtyConnector_u24lambda_u240;
            boolean bl2 = false;
            this.sshSession = sshClient3;
            SshClient sshSession = $this$openPtyConnector_u24lambda_u240;
            for (Tunneling tunneling : host.getTunnelings()) {
                SshdSocketAddress address = SshClients.INSTANCE.openTunneling((ClientSession)sshSession, host, tunneling);
                String string = address.getHostName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostName(...)");
                host = Host.copy$default(host, null, null, null, string, address.getPort(), null, null, null, null, null, null, 0L, null, null, null, null, false, 0L, 0L, 524263, null);
            }
        }
        if (useJumpHosts) {
            commands.add("-o");
            commands.add("StrictHostKeyChecking=no");
            commands.add("-o");
            v2 = commands.add("UserKnownHostsFile=" + (SystemInfo.isWindows ? "NUL" : "/dev/null"));
        } else {
            commands.add("-o");
            v2 = commands.add("UserKnownHostsFile=" + new File(Application.INSTANCE.getBaseDataDir(), "known_hosts").getAbsolutePath());
        }
        commands.add("-o");
        commands.add("Compression=yes");
        List list = ClientBuilder.setUpDefaultSignatureFactories((boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"setUpDefaultSignatureFactories(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        String[] destination$iv$iv = (String[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : iterable) {
            void it;
            NamedFactory namedFactory = (NamedFactory)item$iv$iv;
            String[] stringArray = destination$iv$iv;
            boolean bl = false;
            stringArray.add(it.getName());
        }
        List hostKeyAlgorithms = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Set<String> localHostKeyAlgorithms = this.getLocalSSHHostKeyAlgorithms();
        hostKeyAlgorithms.removeIf(arg_0 -> SFTPPtyTerminalTab.openPtyConnector$lambda$4(arg_0 -> SFTPPtyTerminalTab.openPtyConnector$lambda$3(localHostKeyAlgorithms, arg_0), arg_0));
        for (String string : localHostKeyAlgorithms) {
            if (hostKeyAlgorithms.contains(string)) continue;
            hostKeyAlgorithms.add(string);
        }
        commands.add("-o");
        commands.add("HostKeyAlgorithms=" + CollectionsKt.joinToString$default((Iterable)hostKeyAlgorithms, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        commands.add("-F");
        commands.add("/dev/null");
        commands.add("-P");
        commands.add(String.valueOf(host.getPort()));
        this.setAuthentication(commands, host);
        Map<String, String> envs = host.getOptions().envs();
        if (envs.containsKey("CurrentDir")) {
            String string = (String)MapsKt.getValue(envs, (Object)"CurrentDir");
            v4 = commands.add(host.getUsername() + "@" + host.getHost() + ":" + string);
        } else {
            v4 = !StringsKt.isBlank((CharSequence)host.getOptions().getSftpDefaultDirectory()) ? commands.add(host.getUsername() + "@" + host.getHost() + ":" + ((Object)StringsKt.trim((CharSequence)host.getOptions().getSftpDefaultDirectory())).toString()) : commands.add(host.getUsername() + "@" + host.getHost());
        }
        destination$iv$iv = new String[]{StringUtils.defaultIfBlank((CharSequence)this.getDefaultDirectory(), (CharSequence)SystemUtils.USER_HOME)};
        File file = FileUtils.getFile((String[])destination$iv$iv);
        TerminalSize winSize = this.getTerminalPanel().winSize();
        PtyConnectorFactory ptyConnectorFactory = this.getPtyConnectorFactory();
        Collection $this$toTypedArray$iv = commands;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        int n = winSize.getRows();
        int n2 = winSize.getCols();
        Map<String, String> map = host.getOptions().envs();
        Charset charset = Charsets.toCharset((String)host.getOptions().getEncoding(), (Charset)StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"toCharset(...)");
        Charset charset2 = charset;
        String string = file.exists() ? file.getAbsolutePath() : SystemUtils.USER_HOME;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        PtyConnector ptyConnector = ptyConnectorFactory.createPtyConnector(stringArray, n, n2, map, string2, charset2);
        return ptyConnector;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getLocalSSHHostKeyAlgorithms() {
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{"ssh", "-Q", "key"};
        ProcessBuilder pb = new ProcessBuilder(stringArray);
        Process process = pb.start();
        if (process.waitFor() != 0) {
            return SetsKt.emptySet();
        }
        byte[] byArray = process.getInputStream().readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        byte[] byArray2 = byArray;
        Iterable $this$filter$iv = StringsKt.lines((CharSequence)new String(byArray2, kotlin.text.Charsets.UTF_8));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void setAuthentication(List<String> commands, Host host) {
        if (host.getAuthentication().getType() == AuthenticationType.PublicKey) {
            OhKeyPair ohKeyPair = this.getKeyManager().getOhKeyPair(host.getAuthentication().getPassword());
            if (ohKeyPair != null) {
                KeyPair keyPair = OhKeyPairKeyPairProvider.Companion.generateKeyPair(ohKeyPair);
                Path privateKeyPath = Application.createSubTemporaryDir$default(Application.INSTANCE, null, 1, null);
                Path privateKeyFile = Files.createTempFile(privateKeyPath, Application.INSTANCE.getName(), "", new FileAttribute[0]);
                Closeable closeable = Files.newOutputStream(privateKeyFile, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    OutputStream it = (OutputStream)closeable;
                    boolean bl = false;
                    OpenSSHKeyPairResourceWriter.INSTANCE.writePrivateKey(keyPair, null, null, it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                commands.add("-i");
                String string = privateKeyFile.toFile().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                commands.add(string);
                this.tempFiles.add(privateKeyPath);
            }
        } else if (host.getAuthentication().getType() == AuthenticationType.Password) {
            void $this$setAuthentication_u24lambda_u241;
            PasswordReporterDataListener passwordReporterDataListener;
            PasswordReporterDataListener keyPair = passwordReporterDataListener = new PasswordReporterDataListener(host);
            TerminalModel terminalModel = this.getTerminal().getTerminalModel();
            boolean bl = false;
            this.lastPasswordReporterDataListener = $this$setAuthentication_u24lambda_u241;
            terminalModel.addDataListener(passwordReporterDataListener);
        }
    }

    @Override
    public void stop() {
        PasswordReporterDataListener passwordReporterDataListener = this.lastPasswordReporterDataListener;
        if (passwordReporterDataListener != null) {
            PasswordReporterDataListener listener2 = passwordReporterDataListener;
            boolean bl = false;
            SwingUtilities.invokeLater(() -> SFTPPtyTerminalTab.stop$lambda$0$0(this, listener2));
        }
        IOUtils.closeQuietly((Closeable)((Closeable)this.sshSession));
        IOUtils.closeQuietly((Closeable)((Closeable)this.sshClient));
        this.tempFiles.removeIf(arg_0 -> SFTPPtyTerminalTab.stop$lambda$2(SFTPPtyTerminalTab::stop$lambda$1, arg_0));
        super.stop();
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return (Icon)((Object)Icons.INSTANCE.getFileFormat());
    }

    @Override
    @NotNull
    protected TerminalTab createReconnectTerminalTab() {
        return new SFTPPtyTerminalTab(this.getWindowScope(), this.getHost());
    }

    @Override
    public void sendStartupCommand(@NotNull PtyConnector ptyConnector, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)ptyConnector, (String)"ptyConnector");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
    }

    @Override
    @NotNull
    public PtyConnector loginScriptsPtyConnector(@NotNull Host host, @NotNull PtyConnector ptyConnector) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)ptyConnector, (String)"ptyConnector");
        return ptyConnector;
    }

    private static final KeyManager keyManager_delegate$lambda$0() {
        return KeyManager.Companion.getInstance();
    }

    private static final boolean openPtyConnector$lambda$3(Set $localHostKeyAlgorithms, String it) {
        return !$localHostKeyAlgorithms.contains(it);
    }

    private static final boolean openPtyConnector$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void stop$lambda$0$0(SFTPPtyTerminalTab this$0, PasswordReporterDataListener $listener) {
        this$0.getTerminal().getTerminalModel().removeDataListener($listener);
    }

    private static final boolean stop$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FileUtils.deleteQuietly((File)it.toFile());
        return true;
    }

    private static final boolean stop$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean canSupports_delegate$lambda$0() {
        Process process;
        if (SystemInfo.isWindows) {
            var1 = new String[]{"cmd.exe", "/c", "where", "sftp"};
            process = new ProcessBuilder(var1).start();
        } else {
            var1 = new String[]{"which", "sftp"};
            process = new ProcessBuilder(var1).start();
        }
        Process process2 = process;
        process2.waitFor();
        return process2.exitValue() == 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lapp/termora/plugin/internal/sftppty/SFTPPtyTerminalTab$Companion;", "", "<init>", "()V", "canSupports", "", "getCanSupports", "()Z", "canSupports$delegate", "Lkotlin/Lazy;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getCanSupports() {
            Lazy lazy = canSupports$delegate;
            return (Boolean)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/termora/plugin/internal/sftppty/SFTPPtyTerminalTab$PasswordReporterDataListener;", "Lapp/termora/terminal/DataListener;", "host", "Lapp/termora/Host;", "<init>", "(Lapp/termora/plugin/internal/sftppty/SFTPPtyTerminalTab;Lapp/termora/Host;)V", "onChanged", "", "key", "Lapp/termora/terminal/DataKey;", "data", "", "termora"})
    private final class PasswordReporterDataListener
    implements DataListener {
        @NotNull
        private final Host host;

        public PasswordReporterDataListener(Host host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            this.host = host;
        }

        @Override
        public void onChanged(@NotNull DataKey<?> key, @NotNull Object data) {
            TerminalLine line;
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (Intrinsics.areEqual(key, VisualTerminal.Companion.getWritten()) && data instanceof String && StringsKt.startsWith$default((String)StringsKt.trimIndent((String)((Object)StringsKt.trim((CharSequence)(line = SFTPPtyTerminalTab.this.getTerminal().getDocument().getScreenLine(SFTPPtyTerminalTab.this.getTerminal().getCursorModel().getPosition().getY())).getText())).toString()), (String)(this.host.getUsername() + "@" + this.host.getHost() + "'s password:"), (boolean)false, (int)2, null)) {
                SFTPPtyTerminalTab.this.getTerminal().getTerminalModel().removeDataListener(this);
                PtyConnector ptyConnector = SFTPPtyTerminalTab.this.getPtyConnector();
                byte[] byArray = this.host.getAuthentication().getPassword().getBytes(ptyConnector.getCharset());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                ptyConnector.write(byArray);
                byte[] byArray2 = SFTPPtyTerminalTab.this.getTerminal().getKeyEncoder().encode(new TerminalKeyEvent(10, 0, 2, null)).getBytes(ptyConnector.getCharset());
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                ptyConnector.write(byArray2);
            }
        }
    }
}

