/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.CursorStore;
import app.termora.terminal.DataKey;
import app.termora.terminal.GraphicCharacterSet;
import app.termora.terminal.Position;
import app.termora.terminal.ScrollingRegion;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.TerminalModelKt;
import app.termora.terminal.TextStyle;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/termora/terminal/CursorStoreStores;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "restore", "", "terminal", "Lapp/termora/terminal/Terminal;", "store", "termora"})
public final class CursorStoreStores {
    @NotNull
    public static final CursorStoreStores INSTANCE = new CursorStoreStores();
    private static final Logger log = LoggerFactory.getLogger(CursorStoreStores.class);

    private CursorStoreStores() {
    }

    public final void restore(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        TerminalModel terminalModel = terminal.getTerminalModel();
        CursorStore cursorStore = terminalModel.hasData(DataKey.Companion.getSaveCursor()) ? terminalModel.getData(DataKey.Companion.getSaveCursor()) : new CursorStore(new Position(1, 1), TextStyle.Companion.getDefault-c2YIwqY(), false, false, new GraphicCharacterSet(null, null, 3, null), null);
        terminalModel.setData(DataKey.Companion.getOriginMode(), cursorStore.getOriginMode());
        terminalModel.setData(DataKey.Companion.getTextStyle(), TextStyle.box-impl(cursorStore.getTextStyle-c2YIwqY()));
        if (cursorStore.getAutoWarpMode() != null) {
            terminalModel.setData(DataKey.Companion.getAutoWrapMode(), cursorStore.getAutoWarpMode());
        }
        terminalModel.setData(DataKey.Companion.getGraphicCharacterSet(), cursorStore.getGraphicCharacterSet());
        ScrollingRegion region = TerminalModelKt.isOriginMode(terminalModel) ? TerminalModelKt.getScrollingRegion(terminalModel) : new ScrollingRegion(1, terminalModel.getRows());
        int y = cursorStore.getPosition().getY();
        if (y < region.getTop()) {
            y = 1;
        } else if (y > region.getBottom()) {
            y = region.getBottom();
        }
        terminal.getCursorModel().move(y, cursorStore.getPosition().getX());
        if (log.isDebugEnabled()) {
            log.debug("Restore Cursor (DECRC). " + cursorStore);
        }
    }

    public final void store(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        TerminalModel terminalModel = terminal.getTerminalModel();
        GraphicCharacterSet graphicCharacterSet = terminalModel.getData(DataKey.Companion.getGraphicCharacterSet());
        Map characterSets = new LinkedHashMap();
        characterSets.putAll(graphicCharacterSet.getCharacterSets());
        CursorStore cursorStore = new CursorStore(terminal.getCursorModel().getPosition(), terminalModel.getData(DataKey.Companion.getTextStyle()).unbox-impl(), terminalModel.hasData(DataKey.Companion.getAutoWrapMode()) ? terminalModel.getData(DataKey.Companion.getAutoWrapMode()) : null, TerminalModelKt.isOriginMode(terminalModel), GraphicCharacterSet.copy$default(graphicCharacterSet, null, characterSets, 1, null), null);
        terminalModel.setData(DataKey.Companion.getSaveCursor(), cursorStore);
        if (log.isDebugEnabled()) {
            log.debug("Save Cursor (DECSC). " + cursorStore);
        }
    }
}

