/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.DataKey;
import app.termora.terminal.DataListener;
import app.termora.terminal.Document;
import app.termora.terminal.DocumentImpl;
import app.termora.terminal.KTermKt;
import app.termora.terminal.Position;
import app.termora.terminal.SelectionModel;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalLine;
import app.termora.terminal.TextStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0004J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lapp/termora/terminal/SelectionModelImpl;", "Lapp/termora/terminal/SelectionModel;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/Terminal;)V", "startPosition", "Lapp/termora/terminal/Position;", "endPosition", "block", "", "document", "Lapp/termora/terminal/Document;", "getSelectedText", "", "getChars", "", "Lapp/termora/terminal/TerminalLine;", "setSelection", "", "setBlockSelection", "isBlockSelection", "getSelectionStartPosition", "getSelectionEndPosition", "clearSelection", "fireSelectionChanged", "getTerminal", "hasSelection", "position", "x", "", "y", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nSelectionModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionModelImpl.kt\napp/termora/terminal/SelectionModelImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n774#2:271\n865#2,2:272\n*S KotlinDebug\n*F\n+ 1 SelectionModelImpl.kt\napp/termora/terminal/SelectionModelImpl\n*L\n100#1:271\n100#1:272,2\n*E\n"})
public class SelectionModelImpl
implements SelectionModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Terminal terminal;
    @NotNull
    private Position startPosition;
    @NotNull
    private Position endPosition;
    private boolean block;
    @NotNull
    private final Document document;
    private static final Logger log = LoggerFactory.getLogger(SelectionModelImpl.class);

    public SelectionModelImpl(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminal = terminal;
        this.startPosition = Position.Companion.getUnknown();
        this.endPosition = Position.Companion.getUnknown();
        this.document = this.terminal.getDocument();
        this.terminal.getTerminalModel().addDataListener(new DataListener(){

            private final int getCols() {
                return terminal.getTerminalModel().getCols();
            }

            @Override
            public void onChanged(DataKey<?> key, Object data) {
                block5: {
                    Intrinsics.checkNotNullParameter(key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    if (!Intrinsics.areEqual(key, DocumentImpl.Companion.getOverflowLines())) {
                        return;
                    }
                    if (!this.hasSelection() || this.isSelectAll()) {
                        return;
                    }
                    int row = (Integer)data;
                    Position startPosition = Position.copy$default(startPosition, Math.max(startPosition.getY() - row, 1), 0, 2, null);
                    Position endPosition = Position.copy$default(endPosition, endPosition.getY() - row, 0, 2, null);
                    if (endPosition.getY() < 1 || endPosition.getY() < startPosition.getY()) {
                        this.clearSelection();
                        return;
                    }
                    try {
                        this.setSelection(startPosition, endPosition);
                    }
                    catch (Exception e) {
                        if (!log.isTraceEnabled()) break block5;
                        log.trace(e.getMessage());
                    }
                }
            }

            private final boolean isSelectAll() {
                return this.hasSelection() && startPosition.getY() == 1 && startPosition.getX() == 1 && endPosition.getY() == document.getLineCount() && endPosition.getX() == this.getCols();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getSelectedText() {
        StringBuilder sb = new StringBuilder();
        if (!this.hasSelection()) {
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        Position start2 = this.getSelectionStartPosition();
        Position end = this.getSelectionEndPosition();
        if (this.isBlockSelection()) {
            int bottom;
            int left = Math.min(start2.getX(), end.getX());
            int right = Math.max(start2.getX(), end.getX());
            int top = Math.min(start2.getY(), end.getY());
            int lineNum = top;
            if (lineNum <= (bottom = Math.max(start2.getY(), end.getY()))) {
                while (true) {
                    int to;
                    TerminalLine line = this.document.getLine(lineNum);
                    List<Pair<Character, TextStyle>> chars = line.chars();
                    int from = RangesKt.coerceAtLeast((int)(left - 1), (int)0);
                    if (from < (to = RangesKt.coerceAtMost((int)right, (int)chars.size()))) {
                        void $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        Iterable iterable = chars.subList(from, to);
                        boolean $i$f$filter = false;
                        void var16_21 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            Pair it = (Pair)element$iv$iv;
                            boolean bl = false;
                            if (!(!KTermKt.isNull(((Character)it.getFirst()).charValue()) && !KTermKt.isSoftHyphen(((Character)it.getFirst()).charValue()))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        String selected = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, SelectionModelImpl::getSelectedText$lambda$1, (int)30, null);
                        sb.append(selected);
                    }
                    if (lineNum != bottom) {
                        sb.append('\n');
                    }
                    if (lineNum != bottom) {
                        ++lineNum;
                        continue;
                    }
                    break;
                }
            }
        } else {
            Iterator<TerminalLine> iterator2 = this.getChars(start2, end);
            while (iterator2.hasNext()) {
                TerminalLine line = iterator2.next();
                List<Pair<Character, TextStyle>> chars = line.chars();
                if (chars.isEmpty() || KTermKt.isNull(((Character)((Pair)CollectionsKt.first(chars)).getFirst()).charValue())) continue;
                for (Pair<Character, TextStyle> e : chars) {
                    if (KTermKt.isSoftHyphen(((Character)e.getFirst()).charValue())) continue;
                    if (KTermKt.isNull(((Character)e.getFirst()).charValue())) break;
                    sb.append(((Character)e.getFirst()).charValue());
                }
                if (line.getWrapped() || !iterator2.hasNext()) continue;
                sb.append('\n');
            }
        }
        if (((CharSequence)sb).length() > 0 && StringsKt.last((CharSequence)sb) == '\n') {
            sb.deleteCharAt(sb.length() - 1);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final Iterator<TerminalLine> getChars(Position startPosition, Position endPosition) {
        if (!startPosition.isValid() || !endPosition.isValid()) {
            Iterator<TerminalLine> iterator2 = Collections.emptyIterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"emptyIterator(...)");
            return iterator2;
        }
        int cols = this.terminal.getTerminalModel().getCols();
        Document document = this.terminal.getDocument();
        return new Iterator<TerminalLine>(startPosition, endPosition, document, cols){
            private int index;
            final /* synthetic */ Position $startPosition;
            final /* synthetic */ Position $endPosition;
            final /* synthetic */ Document $document;
            final /* synthetic */ int $cols;
            {
                this.$startPosition = $startPosition;
                this.$endPosition = $endPosition;
                this.$document = $document;
                this.$cols = $cols;
                this.index = $startPosition.getY();
            }

            public boolean hasNext() {
                return this.index <= this.$endPosition.getY() && this.index <= this.$document.getLineCount();
            }

            public TerminalLine next() {
                TerminalLine terminalLine;
                TerminalLine current = this.$document.getLine(this.index);
                int n = this.index;
                if (n == this.$startPosition.getY()) {
                    TerminalLine terminalLine2;
                    int endCols = this.$startPosition.getY() == this.$endPosition.getY() ? this.$endPosition.getX() : this.$cols;
                    int offset = this.$startPosition.getX() - 1;
                    List<Pair<Character, TextStyle>> chars = current.chars();
                    int count = chars.size();
                    TerminalLine $this$next_u24lambda_u240 = terminalLine2 = new TerminalLine(chars.subList(offset, Math.min(endCols, count)));
                    boolean bl = false;
                    $this$next_u24lambda_u240.setWrapped(this.hasNext() && current.getWrapped());
                    terminalLine = terminalLine2;
                } else if (n == this.$endPosition.getY()) {
                    List<Pair<Character, TextStyle>> chars = current.chars();
                    int count = chars.size();
                    terminalLine = this.$endPosition.getX() == count ? current : new TerminalLine(chars.subList(0, Math.min(this.$endPosition.getX(), count)));
                } else {
                    terminalLine = current;
                }
                TerminalLine line = terminalLine;
                n = this.index;
                this.index = n + 1;
                return line;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @Override
    public void setSelection(@NotNull Position startPosition, @NotNull Position endPosition) {
        Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
        Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
        if (startPosition.getY() > endPosition.getY() || startPosition.getY() == endPosition.getY() && endPosition.getX() < startPosition.getX()) {
            throw new IllegalArgumentException("Position out of range");
        }
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.fireSelectionChanged();
    }

    @Override
    public void setBlockSelection(boolean block) {
        this.block = block;
    }

    @Override
    public boolean isBlockSelection() {
        return this.block;
    }

    @Override
    @NotNull
    public Position getSelectionStartPosition() {
        return this.startPosition;
    }

    @Override
    @NotNull
    public Position getSelectionEndPosition() {
        return this.endPosition;
    }

    @Override
    public void clearSelection() {
        this.startPosition = Position.Companion.getUnknown();
        this.endPosition = Position.Companion.getUnknown();
        this.fireSelectionChanged();
    }

    protected final void fireSelectionChanged() {
        this.terminal.getTerminalModel().setData(SelectionModel.Companion.getSelection(), Unit.INSTANCE);
    }

    @Override
    @NotNull
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public boolean hasSelection() {
        return this.startPosition.isValid() && this.endPosition.isValid();
    }

    @Override
    public boolean hasSelection(@NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.hasSelection(position.getX(), position.getY());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasSelection(int x, int y) {
        if (!this.hasSelection()) {
            return false;
        }
        if (!this.isBlockSelection()) return Companion.isPointInsideArea(this.startPosition, this.endPosition, x, y, this.terminal.getTerminalModel().getCols());
        int left = Math.min(this.startPosition.getX(), this.endPosition.getX());
        int right = Math.max(this.startPosition.getX(), this.endPosition.getX());
        int top = Math.min(this.startPosition.getY(), this.endPosition.getY());
        int bottom = Math.max(this.startPosition.getY(), this.endPosition.getY());
        if (left > x) return false;
        if (x > right) return false;
        boolean bl = true;
        if (!bl) return false;
        if (top > y) return false;
        if (y > bottom) return false;
        return true;
    }

    private static final CharSequence getSelectedText$lambda$1(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(((Character)it.getFirst()).charValue());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lapp/termora/terminal/SelectionModelImpl$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "isPointInsideArea", "", "start", "Lapp/termora/terminal/Position;", "end", "x", "", "y", "cols", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isPointInsideArea(@NotNull Position start2, @NotNull Position end, int x, int y, int cols) {
            Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            int top = Math.min(start2.getY(), end.getY());
            int bottom = Math.max(start2.getY(), end.getY());
            boolean bl = top <= y ? y <= bottom : false;
            if (bl) {
                if (start2.getY() == end.getY()) {
                    int left = Math.min(start2.getX(), end.getX());
                    int right = Math.max(start2.getX(), end.getX());
                    return left <= x ? x <= right : false;
                }
                if (y == start2.getY()) {
                    return x >= start2.getX() && x <= cols;
                }
                if (y == end.getY()) {
                    return x >= 0 && x <= end.getX();
                }
                return 0 <= x ? x <= cols : false;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

