/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0014\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0006J\r\u0010\u0011\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u0006\u0010\u0017\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lapp/termora/terminal/TerminalReader;", "", "<init>", "()V", "buffer", "Ljava/util/ArrayDeque;", "", "addLast", "", "char", "addFirst", "chars", "", "ch", "text", "", "read", "peek", "()Ljava/lang/Character;", "isEmpty", "", "isNotEmpty", "toString", "clear", "termora"})
@SourceDebugExtension(value={"SMAP\nTerminalReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalReader.kt\napp/termora/terminal/TerminalReader\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,68:1\n1179#2,2:69\n*S KotlinDebug\n*F\n+ 1 TerminalReader.kt\napp/termora/terminal/TerminalReader\n*L\n30#1:69,2\n*E\n"})
public final class TerminalReader {
    @NotNull
    private final ArrayDeque<Character> buffer = new ArrayDeque();

    public final void addLast(char c) {
        this.buffer.addLast(Character.valueOf(c));
    }

    public final void addFirst(@NotNull List<Character> chars) {
        Intrinsics.checkNotNullParameter(chars, (String)"chars");
        for (int i = chars.size() - 1; -1 < i; --i) {
            this.addFirst(chars.get(i).charValue());
        }
    }

    public final void addLast(@NotNull List<Character> chars) {
        Intrinsics.checkNotNullParameter(chars, (String)"chars");
        this.buffer.addAll((Collection<Character>)chars);
    }

    public final void addFirst(char ch) {
        this.buffer.addFirst(Character.valueOf(ch));
    }

    public final void addLast(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence $this$forEach$iv = text;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            this.addLast(it);
        }
    }

    public final char read() {
        Character c = this.buffer.removeFirst();
        Intrinsics.checkNotNullExpressionValue((Object)c, (String)"removeFirst(...)");
        return c.charValue();
    }

    @Nullable
    public final Character peek() {
        return this.buffer.peekFirst();
    }

    public final boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public final boolean isNotEmpty() {
        return !((Collection)this.buffer).isEmpty();
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Character> iterator2 = this.buffer.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Character> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            StringBuilder stringBuilder;
            Character c;
            Character c2;
            Character c3 = c2 = (c = iterator3.next());
            char c4 = '\t';
            if (c3 != null && c3.charValue() == c4) {
                stringBuilder = sb.append("TAB");
                continue;
            }
            Character c5 = c2;
            c4 = '\u001b';
            if (c5 != null && c5.charValue() == c4) {
                stringBuilder = sb.append("ESC");
                continue;
            }
            Character c6 = c2;
            c4 = '\u0007';
            if (c6 != null && c6.charValue() == c4) {
                stringBuilder = sb.append("BEL");
                continue;
            }
            Character c7 = c2;
            c4 = '\r';
            if (c7 != null && c7.charValue() == c4) {
                stringBuilder = sb.append("CR");
                continue;
            }
            Intrinsics.checkNotNull((Object)c);
            stringBuilder = sb.append(c.charValue());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void clear() {
        this.buffer.clear();
    }
}

