/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel;

import app.termora.keymap.KeyShortcut;
import app.termora.keymap.Keymap;
import app.termora.keymap.KeymapManager;
import app.termora.plugin.internal.AltKeyModifier;
import app.termora.terminal.DataKey;
import app.termora.terminal.Terminal;
import app.termora.terminal.panel.AWTTerminalKeyEvent;
import app.termora.terminal.panel.TerminalPanel;
import app.termora.terminal.panel.TerminalPredicateAction;
import app.termora.terminal.panel.TerminalWriter;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lapp/termora/terminal/panel/TerminalPanelKeyAdapter;", "Ljava/awt/event/KeyAdapter;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminal", "Lapp/termora/terminal/Terminal;", "writer", "Lapp/termora/terminal/panel/TerminalWriter;", "<init>", "(Lapp/termora/terminal/panel/TerminalPanel;Lapp/termora/terminal/Terminal;Lapp/termora/terminal/panel/TerminalWriter;)V", "activeKeymap", "Lapp/termora/keymap/Keymap;", "getActiveKeymap", "()Lapp/termora/keymap/Keymap;", "isIgnoreKeyTyped", "", "keyTyped", "", "e", "Ljava/awt/event/KeyEvent;", "keyPressed", "doKeyPressed", "mapKeyChar", "", "isCtrlPressedOnly", "isAltPressedOnly", "simpleMapKeyCodeToChar", "Companion", "termora"})
public final class TerminalPanelKeyAdapter
extends KeyAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalPanel terminalPanel;
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final TerminalWriter writer;
    private boolean isIgnoreKeyTyped;
    private static final char ASCII_ESC = '\u001b';
    private static final Logger log = LoggerFactory.getLogger(TerminalPanelKeyAdapter.class);

    public TerminalPanelKeyAdapter(@NotNull TerminalPanel terminalPanel, @NotNull Terminal terminal, @NotNull TerminalWriter writer) {
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.terminalPanel = terminalPanel;
        this.terminal = terminal;
        this.writer = writer;
    }

    private final Keymap getActiveKeymap() {
        return KeymapManager.Companion.getInstance().getActiveKeymap();
    }

    @Override
    public void keyTyped(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isIgnoreKeyTyped || Character.isISOControl(e.getKeyChar())) {
            return;
        }
        this.terminal.getSelectionModel().clearSelection();
        byte[] byArray = String.valueOf(e.getKeyChar()).getBytes(this.writer.getCharset());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.writer.write(TerminalWriter.WriteRequest.Companion.fromBytes(byArray));
        this.terminal.getScrollingModel().scrollTo(Integer.MAX_VALUE);
    }

    @Override
    public void keyPressed(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.isIgnoreKeyTyped = false;
        try {
            this.doKeyPressed(e);
        }
        catch (Exception e2) {
            if (log.isErrorEnabled()) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
            this.terminal.getSelectionModel().clearSelection();
            this.terminal.getScrollingModel().scrollTo(Integer.MAX_VALUE);
            return;
        }
        if (e.isConsumed()) {
            this.isIgnoreKeyTyped = true;
        }
    }

    private final void doKeyPressed(KeyEvent e) {
        char keyChar;
        if (e.isConsumed()) {
            return;
        }
        if (e.getKeyCode() == 27) {
            this.terminalPanel.hideToast();
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
        for (TerminalPredicateAction action2 : this.terminalPanel.getTerminalActions()) {
            if (!action2.test(keyStroke, e)) continue;
            action2.actionPerformed(e);
            return;
        }
        String encode = this.terminal.getKeyEncoder().encode(new AWTTerminalKeyEvent(e));
        if (((CharSequence)encode).length() > 0) {
            byte[] byArray = encode.getBytes(this.writer.getCharset());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.writer.write(TerminalWriter.WriteRequest.Companion.fromBytes(byArray));
            this.terminal.getScrollingModel().scrollTo(Integer.MAX_VALUE);
            e.consume();
        }
        if (SystemInfo.isWindows && e.getKeyCode() == 9 && this.isCtrlPressedOnly(e)) {
            return;
        }
        AltKeyModifier modifier = this.terminal.getTerminalModel().getData(DataKey.Companion.getAltModifier(), AltKeyModifier.EightBit);
        if (this.isAltPressedOnly(e) && Character.isDefined(e.getKeyChar()) && modifier == AltKeyModifier.CharactersPrecededByESC) {
            char[] cArray = new char[]{'\u001b', this.simpleMapKeyCodeToChar(e)};
            String c = new String(cArray);
            byte[] byArray = c.getBytes(this.writer.getCharset());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.writer.write(TerminalWriter.WriteRequest.Companion.fromBytes(byArray));
            this.terminal.getScrollingModel().scrollTo(Integer.MAX_VALUE);
            e.consume();
            return;
        }
        if (keyStroke.getModifiers() != 0) {
            Keymap keymap = this.getActiveKeymap();
            Intrinsics.checkNotNull((Object)keyStroke);
            if (!((Collection)keymap.getActionIds(new KeyShortcut(keyStroke))).isEmpty()) {
                return;
            }
        }
        if (Character.isISOControl(keyChar = this.mapKeyChar(e))) {
            this.terminal.getSelectionModel().clearSelection();
            if (((CharSequence)encode).length() == 0) {
                byte[] byArray = String.valueOf(keyChar).getBytes(this.writer.getCharset());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                this.writer.write(TerminalWriter.WriteRequest.Companion.fromBytes(byArray));
                e.consume();
            }
            this.terminal.getScrollingModel().scrollTo(Integer.MAX_VALUE);
        }
    }

    private final char mapKeyChar(KeyEvent e) {
        if (Character.isISOControl(e.getKeyChar())) {
            return e.getKeyChar();
        }
        boolean isCtrlPressedOnly = this.isCtrlPressedOnly(e);
        if (isCtrlPressedOnly && e.getKeyCode() == 91) {
            return '\u001b';
        }
        return e.getKeyChar();
    }

    private final boolean isCtrlPressedOnly(KeyEvent e) {
        int modifiersEx = e.getModifiersEx();
        return (modifiersEx & 0x200) == 0 && (modifiersEx & 0x2000) == 0 && (modifiersEx & 0x80) != 0 && (modifiersEx & 0x40) == 0;
    }

    private final boolean isAltPressedOnly(KeyEvent e) {
        int modifiersEx = e.getModifiersEx();
        return (modifiersEx & 0x200) != 0 && (modifiersEx & 0x2000) == 0 && (modifiersEx & 0x80) == 0 && (modifiersEx & 0x40) == 0;
    }

    private final char simpleMapKeyCodeToChar(KeyEvent e) {
        if (e.isShiftDown()) {
            return Character.toUpperCase((char)e.getKeyCode());
        }
        return Character.toLowerCase((char)e.getKeyCode());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/terminal/panel/TerminalPanelKeyAdapter$Companion;", "", "<init>", "()V", "ASCII_ESC", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

