/*
 * Decompiled with CFR 0.152.
 */
package zmodem.xfer.util;

import zmodem.xfer.util.Arrays;
import zmodem.xfer.util.Buffer;
import zmodem.xfer.util.ByteBuffer;

public class HexBuffer
implements Buffer {
    private static final byte[] hx = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private java.nio.ByteBuffer _wrapped;

    public static byte[] binToHex(byte[] bin) {
        byte[] hex = new byte[bin.length * 2];
        for (int i = 0; i < bin.length; ++i) {
            System.arraycopy(HexBuffer.toHex(bin[i]), 0, hex, i * 2, 2);
        }
        return hex;
    }

    public static byte[] hexToBin(byte[] hex) {
        byte[] bin = new byte[hex.length / 2];
        for (int i = 0; i < bin.length; ++i) {
            byte[] bn = new byte[2];
            System.arraycopy(hex, i * 2, bn, 0, 2);
            bin[i] = HexBuffer.toByte(bn);
        }
        return bin;
    }

    private static byte toByte(byte[] array) {
        int d = java.util.Arrays.binarySearch(hx, array[0]) * 16;
        return (byte)(d += java.util.Arrays.binarySearch(hx, array[1]));
    }

    private static byte[] toHex(byte b) {
        byte[] array = new byte[]{hx[b >> 4 & 0xF], hx[b & 0xF]};
        return array;
    }

    protected HexBuffer(java.nio.ByteBuffer b) {
        this._wrapped = b;
    }

    public static HexBuffer allocate(int capacity) {
        return new HexBuffer(java.nio.ByteBuffer.allocate(capacity * 2));
    }

    public static HexBuffer allocateDirect(int capacity) {
        return new HexBuffer(java.nio.ByteBuffer.allocateDirect(capacity * 2));
    }

    public Buffer slice() {
        return new HexBuffer(this._wrapped.slice());
    }

    public Buffer duplicate() {
        return new HexBuffer(this._wrapped.duplicate());
    }

    public Buffer asReadOnlyBuffer() {
        return new HexBuffer(this._wrapped.asReadOnlyBuffer());
    }

    @Override
    public byte get() {
        return HexBuffer.toByte(new byte[]{this._wrapped.get(), this._wrapped.get()});
    }

    @Override
    public Buffer get(byte[] dst, int offset, int len) {
        while (offset < len) {
            dst[offset] = this.get();
            ++offset;
        }
        return this;
    }

    @Override
    public Buffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    @Override
    public Buffer put(byte b) {
        this._wrapped.put(HexBuffer.toHex(b));
        return this;
    }

    @Override
    public Buffer put(byte[] dst, int offset, int len) {
        while (offset < len) {
            this.put(dst[offset]);
            ++offset;
        }
        return this;
    }

    @Override
    public Buffer put(byte[] dst) {
        return this.put(dst, 0, dst.length);
    }

    @Override
    public byte get(int index) {
        return HexBuffer.toByte(new byte[]{this._wrapped.get(index * 2), this._wrapped.get(index * 2 + 1)});
    }

    @Override
    public Buffer get(int index, byte[] dst, int offset, int len) {
        while (offset < len) {
            dst[offset] = this.get(index++);
            ++offset;
        }
        return this;
    }

    @Override
    public Buffer get(int index, byte[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    @Override
    public Buffer put(int index, byte b) {
        byte[] array = HexBuffer.toHex(b);
        this._wrapped.put(index * 2, array[0]);
        this._wrapped.put(index * 2 + 1, array[1]);
        return this;
    }

    @Override
    public Buffer put(int index, byte[] dst, int offset, int len) {
        while (offset < len) {
            this.put(index++, dst[offset]);
            ++offset;
        }
        return this;
    }

    @Override
    public Buffer put(int index, byte[] dst) {
        return this.put(index, dst, 0, dst.length);
    }

    public Buffer compact() {
        this._wrapped.compact();
        return this;
    }

    public boolean isDirect() {
        return this._wrapped.isDirect();
    }

    public char getChar() {
        return (char)this.get();
    }

    public Buffer putChar(char value) {
        return this.put((byte)value);
    }

    public char getChar(int index) {
        return (char)this.get(index);
    }

    public Buffer putChar(int index, char value) {
        return this.put(index, (byte)value);
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return new ByteBuffer(this._wrapped);
    }

    public short getShort() {
        return Arrays.toShort(new byte[]{this.get(), this.get()}, Arrays.Endianness.Little);
    }

    public Buffer putShort(short value) {
        return this.put(Arrays.fromShort(value, Arrays.Endianness.Little));
    }

    public short getShort(int index) {
        return Arrays.toShort(new byte[]{this.get(index), this.get(index + 1)}, Arrays.Endianness.Little);
    }

    public Buffer putShort(int index, short value) {
        return this.put(index, Arrays.fromShort(value, Arrays.Endianness.Little));
    }

    public int getInt() {
        return Arrays.toInt(new byte[]{this.get(), this.get(), this.get(), this.get()}, Arrays.Endianness.Little);
    }

    public Buffer putInt(int value) {
        return this.put(Arrays.fromInt(value, Arrays.Endianness.Little));
    }

    public int getInt(int index) {
        return Arrays.toInt(new byte[]{this.get(index), this.get(index + 1), this.get(index + 2), this.get(index + 3)}, Arrays.Endianness.Little);
    }

    public Buffer putInt(int index, int value) {
        return this.put(index, Arrays.fromInt(value, Arrays.Endianness.Little));
    }

    public long getLong() {
        return Arrays.toLong(new byte[]{this.get(), this.get(), this.get(), this.get(), this.get(), this.get(), this.get(), this.get()}, Arrays.Endianness.Little);
    }

    public Buffer putLong(long value) {
        return this.put(Arrays.fromLong(value, Arrays.Endianness.Little));
    }

    public long getLong(int index) {
        return Arrays.toLong(new byte[]{this.get(index), this.get(index + 1), this.get(index + 2), this.get(index + 3), this.get(index + 4), this.get(index + 5), this.get(index + 6), this.get(index + 7)}, Arrays.Endianness.Little);
    }

    public Buffer putLong(int index, long value) {
        return this.put(index, Arrays.fromLong(value, Arrays.Endianness.Little));
    }

    public boolean isReadOnly() {
        return this._wrapped.isReadOnly();
    }

    @Override
    public void flip() {
        this._wrapped.flip();
    }

    @Override
    public int remaining() {
        double rem = (double)this._wrapped.remaining() / 2.0;
        return (int)Math.floor(rem);
    }

    @Override
    public boolean hasRemaining() {
        return this._wrapped.remaining() > 1;
    }

    @Override
    public HexBuffer asHexBuffer() {
        return this;
    }
}

