/*
 * Decompiled with CFR 0.152.
 */
package zmodem.xfer.zm.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import zmodem.xfer.util.CRC16;
import zmodem.xfer.util.CRC8;
import zmodem.xfer.util.XCRC;

public class Modem {
    public static final byte SOH = 1;
    public static final byte STX = 2;
    public static final byte EOT = 4;
    public static final byte ACK = 6;
    public static final byte NAK = 21;
    public static final byte CAN = 24;
    public static final byte CPMEOF = 26;
    public static final byte ST_C = 67;
    public static final int MAXERRORS = 10;
    public static final int BLOCK_TIMEOUT = 1000;
    public static final int REQUEST_TIMEOUT = 3000;
    public static final int WAIT_FOR_RECEIVER_TIMEOUT = 60000;
    public static final int SEND_BLOCK_TIMEOUT = 10000;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final byte[] shortBlockBuffer;
    private final byte[] longBlockBuffer;

    public Modem(InputStream inputStream, OutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.shortBlockBuffer = new byte[128];
        this.longBlockBuffer = new byte[1024];
    }

    public boolean waitReceiverRequest() throws IOException {
        byte character;
        do {
            if ((character = this.readByte()) != 21) continue;
            return false;
        } while (character != 67);
        return true;
    }

    public void send(Path file, boolean useBlock1K) throws IOException {
        try (DataInputStream dataStream = new DataInputStream(Files.newInputStream(file, new OpenOption[0]));){
            boolean useCRC16 = this.waitReceiverRequest();
            XCRC crc = useCRC16 ? new CRC16() : new CRC8();
            byte[] block = useBlock1K ? new byte[1024] : new byte[128];
            this.sendDataBlocks(dataStream, 1, crc, block);
            this.sendEOT();
        }
    }

    public void sendDataBlocks(DataInputStream dataStream, int blockNumber, XCRC crc, byte[] block) throws IOException {
        int dataLength;
        while ((dataLength = dataStream.read(block)) != -1) {
            this.sendBlock(blockNumber++, block, dataLength, crc);
        }
    }

    public void sendEOT() throws IOException {
        for (int errorCount = 0; errorCount < 10; ++errorCount) {
            this.sendByte((byte)4);
            byte character = this.readByte();
            if (character == 6) {
                return;
            }
            if (character != 24) continue;
            throw new IOException("Transmission terminated");
        }
    }

    public void sendBlock(int blockNumber, byte[] block, int dataLength, XCRC crc) throws IOException {
        if (dataLength < block.length) {
            block[dataLength] = 26;
        }
        block0: for (int errorCount = 0; errorCount < 10; ++errorCount) {
            byte character;
            if (block.length == 1024) {
                this.outputStream.write(2);
            } else {
                this.outputStream.write(1);
            }
            this.outputStream.write(blockNumber);
            this.outputStream.write(~blockNumber);
            this.outputStream.write(block);
            this.writeCRC(block, crc);
            this.outputStream.flush();
            do {
                if ((character = this.readByte()) == 6) {
                    return;
                }
                if (character != 21) continue;
                continue block0;
            } while (character != 24);
            throw new IOException("Transmission terminated");
        }
        throw new IOException("Too many errors caught, abandoning transfer");
    }

    private void writeCRC(byte[] block, XCRC crc) throws IOException {
        byte[] crcBytes = new byte[crc.getCRCLength()];
        long crcValue = crc.calcCRC(block);
        for (int i = 0; i < crc.getCRCLength(); ++i) {
            crcBytes[crc.getCRCLength() - i - 1] = (byte)(crcValue >> 8 * i & 0xFFL);
        }
        this.outputStream.write(crcBytes);
    }

    public void receive(Path file, boolean useCRC16) throws IOException {
        try (DataOutputStream dataOutput = new DataOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            int available = this.inputStream.available();
            if (available > 0) {
                this.inputStream.skip(available);
            }
            int character = this.requestTransmissionStart(useCRC16);
            XCRC crc = useCRC16 ? new CRC16() : new CRC8();
            this.processDataBlocks(crc, 1, character, dataOutput);
        }
    }

    public void processDataBlocks(XCRC crc, int blockNumber, int blockInitialCharacter, DataOutputStream dataOutput) throws IOException {
        boolean result2 = false;
        while (true) {
            int errorCount = 0;
            if (blockInitialCharacter == 4) {
                this.sendByte((byte)6);
                return;
            }
            boolean shortBlock = blockInitialCharacter == 1;
            try {
                byte[] block = this.readBlock(blockNumber, shortBlock, crc);
                dataOutput.write(block);
                ++blockNumber;
                errorCount = 0;
                result2 = true;
                this.sendByte((byte)6);
            }
            catch (InvalidBlockException e) {
                if (++errorCount == 10) {
                    this.interruptTransmission();
                    throw new IOException("Transmission aborted, error count exceeded max");
                }
                this.sendByte((byte)21);
                result2 = false;
            }
            catch (RepeatedBlockException e) {
                this.sendByte((byte)6);
            }
            catch (SynchronizationLostException e) {
                this.interruptTransmission();
                throw new IOException("Fatal transmission error", e);
            }
            blockInitialCharacter = this.readNextBlockStart(result2);
        }
    }

    public void sendByte(byte b) throws IOException {
        this.outputStream.write(b);
        this.outputStream.flush();
    }

    public int requestTransmissionStart(boolean useCRC16) throws IOException {
        byte character;
        boolean errorCount = false;
        byte requestStartByte = !useCRC16 ? (byte)21 : 67;
        this.sendByte(requestStartByte);
        while ((character = this.readByte()) != 1 && character != 2) {
        }
        return character;
    }

    public int readNextBlockStart(boolean lastBlockResult) throws IOException {
        byte character;
        boolean errorCount = false;
        while ((character = this.readByte()) != 1 && character != 2 && character != 4) {
        }
        return character;
    }

    private void shortSleep() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            try {
                this.interruptTransmission();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException("Transmission was interrupted", e);
        }
    }

    public void interruptTransmission() throws IOException {
        this.sendByte((byte)24);
        this.sendByte((byte)24);
    }

    public byte[] readBlock(int blockNumber, boolean shortBlock, XCRC crc) throws IOException, RepeatedBlockException, SynchronizationLostException, InvalidBlockException {
        byte[] block = shortBlock ? this.shortBlockBuffer : this.longBlockBuffer;
        byte character = this.readByte();
        if (character == blockNumber - 1) {
            throw new RepeatedBlockException();
        }
        if (character != blockNumber) {
            throw new SynchronizationLostException();
        }
        character = this.readByte();
        if (character != ~blockNumber) {
            throw new InvalidBlockException();
        }
        for (int i = 0; i < block.length; ++i) {
            block[i] = this.readByte();
        }
        while (true) {
            if (this.inputStream.available() >= crc.getCRCLength()) {
                if (crc.calcCRC(block) == this.readCRC(crc)) break;
                throw new InvalidBlockException();
            }
            this.shortSleep();
        }
        return block;
    }

    private long readCRC(XCRC crc) throws IOException {
        long checkSumma = 0L;
        for (int j = 0; j < crc.getCRCLength(); ++j) {
            checkSumma = (checkSumma << 8) + (long)this.inputStream.read();
        }
        return checkSumma;
    }

    private byte readByte() throws IOException {
        while (true) {
            if (this.inputStream.available() > 0) {
                int b = this.inputStream.read();
                return (byte)b;
            }
            this.shortSleep();
        }
    }

    public class InvalidBlockException
    extends Exception {
    }

    public class RepeatedBlockException
    extends Exception {
    }

    public class SynchronizationLostException
    extends Exception {
    }
}

