/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.jdbc.statements;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.ResultRow;
import org.jetbrains.exposed.v1.core.statements.BatchInsertStatement;
import org.jetbrains.exposed.v1.core.statements.InsertStatement;
import org.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import org.jetbrains.exposed.v1.jdbc.statements.InsertBlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.api.JdbcPreparedStatementApi;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0006\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/exposed/v1/jdbc/statements/BatchInsertBlockingExecutable;", "S", "Lorg/jetbrains/exposed/v1/core/statements/BatchInsertStatement;", "Lorg/jetbrains/exposed/v1/jdbc/statements/InsertBlockingExecutable;", "", "Lorg/jetbrains/exposed/v1/core/ResultRow;", "statement", "<init>", "(Lorg/jetbrains/exposed/v1/core/statements/BatchInsertStatement;)V", "getStatement", "()Lorg/jetbrains/exposed/v1/core/statements/BatchInsertStatement;", "Lorg/jetbrains/exposed/v1/core/statements/BatchInsertStatement;", "isAlwaysBatch", "", "()Z", "prepared", "Lorg/jetbrains/exposed/v1/jdbc/statements/api/JdbcPreparedStatementApi;", "transaction", "Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction;", "sql", "", "exposed-jdbc"})
public class BatchInsertBlockingExecutable<S extends BatchInsertStatement>
extends InsertBlockingExecutable<List<? extends ResultRow>, S> {
    @NotNull
    private final S statement;
    private final boolean isAlwaysBatch;

    public BatchInsertBlockingExecutable(@NotNull S statement) {
        Intrinsics.checkNotNullParameter(statement, (String)"statement");
        super((InsertStatement)statement);
        this.statement = statement;
        this.isAlwaysBatch = true;
    }

    @Override
    @NotNull
    public S getStatement() {
        return this.statement;
    }

    @Override
    public boolean isAlwaysBatch() {
        return this.isAlwaysBatch;
    }

    @Override
    @NotNull
    public JdbcPreparedStatementApi prepared(@NotNull JdbcTransaction transaction, @NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        return !this.getStatement().getShouldReturnGeneratedValues() ? transaction.getConnection().prepareStatement(sql, false) : super.prepared(transaction, sql);
    }
}

