/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.jdbc.vendors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.CheckConstraint;
import org.jetbrains.exposed.v1.core.Column;
import org.jetbrains.exposed.v1.core.ForeignKeyConstraint;
import org.jetbrains.exposed.v1.core.Index;
import org.jetbrains.exposed.v1.core.Schema;
import org.jetbrains.exposed.v1.core.Sequence;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.utils.CacheWithDefault;
import org.jetbrains.exposed.v1.core.vendors.ColumnMetadata;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.PrimaryKeyMetadata;
import org.jetbrains.exposed.v1.core.vendors.SchemaMetadata;
import org.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import org.jetbrains.exposed.v1.jdbc.statements.api.ExposedConnection;
import org.jetbrains.exposed.v1.jdbc.statements.api.JdbcExposedDatabaseMetadata;
import org.jetbrains.exposed.v1.jdbc.transactions.TransactionManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005H\u0004J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007H\u0002J\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\u00020\n*\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ1\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u00070 2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170#\"\u00020\u0017\u00a2\u0006\u0002\u0010$J\u0016\u0010+\u001a\u00020,2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170\u0007H\u0014JU\u0010-\u001a8\u0012(\u0012&\u0012\u0004\u0012\u00020\u0017\u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u0003000/j\f\u0012\b\u0012\u0006\u0012\u0002\b\u000300`10.\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u00070 2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170#\"\u00020\u0017\u00a2\u0006\u0002\u0010$J\u001e\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0006J3\u00107\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u0002080\u00070 2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170#\"\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010$J1\u00109\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\u00070 2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170#\"\u00020\u0017\u00a2\u0006\u0002\u0010$J-\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010<0 2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170#\"\u00020\u0017\u00a2\u0006\u0002\u0010$J1\u0010=\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00070 2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170#\"\u00020\u0017\u00a2\u0006\u0002\u0010$J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007J\u0006\u0010?\u001a\u00020,J\u0006\u0010@\u001a\u00020,R\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0007\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR&\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'0&X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006A"}, d2={"Lorg/jetbrains/exposed/v1/jdbc/vendors/DatabaseDialectMetadata;", "", "<init>", "()V", "_allTableNames", "Lorg/jetbrains/exposed/v1/core/utils/CacheWithDefault;", "", "", "_allSchemaNames", "supportsLimitWithUpdateOrDelete", "", "allTablesNames", "getAllTablesNames", "()Ljava/util/List;", "getAllTableNamesCache", "getAllSchemaNamesCache", "getDatabase", "catalog", "transaction", "Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction;", "allTablesNamesInAllSchemas", "tableExists", "table", "Lorg/jetbrains/exposed/v1/core/Table;", "metadataMatchesTable", "schema", "schemaExists", "Lorg/jetbrains/exposed/v1/core/Schema;", "sequenceExists", "sequence", "Lorg/jetbrains/exposed/v1/core/Sequence;", "tableColumns", "", "Lorg/jetbrains/exposed/v1/core/vendors/ColumnMetadata;", "tables", "", "([Lorg/jetbrains/exposed/v1/core/Table;)Ljava/util/Map;", "columnConstraintsCache", "", "", "Lorg/jetbrains/exposed/v1/core/ForeignKeyConstraint;", "getColumnConstraintsCache", "()Ljava/util/Map;", "fillConstraintCacheForTables", "", "columnConstraints", "Lkotlin/Pair;", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/exposed/v1/core/Column;", "Lkotlin/collections/LinkedHashSet;", "areEquivalentColumnTypes", "columnMetadataSqlType", "columnMetadataType", "", "columnType", "existingIndices", "Lorg/jetbrains/exposed/v1/core/Index;", "existingCheckConstraints", "Lorg/jetbrains/exposed/v1/core/CheckConstraint;", "existingPrimaryKeys", "Lorg/jetbrains/exposed/v1/core/vendors/PrimaryKeyMetadata;", "existingSequences", "sequences", "resetCaches", "resetSchemaCaches", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nDatabaseDialectMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseDialectMetadata.kt\norg/jetbrains/exposed/v1/jdbc/vendors/DatabaseDialectMetadata\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,203:1\n1374#2:204\n1460#2,5:205\n1761#2,3:210\n1761#2,3:213\n1761#2,3:216\n1761#2,3:219\n1869#2:226\n1870#2:234\n3829#3:222\n4344#3,2:223\n13472#3:225\n13473#3:235\n384#4,7:227\n*S KotlinDebug\n*F\n+ 1 DatabaseDialectMetadata.kt\norg/jetbrains/exposed/v1/jdbc/vendors/DatabaseDialectMetadata\n*L\n66#1:204\n66#1:205,5\n75#1:210,3\n82#1:213,3\n105#1:216,3\n111#1:219,3\n136#1:226\n136#1:234\n132#1:222\n132#1:223,2\n135#1:225\n135#1:235\n137#1:227,7\n*E\n"})
public abstract class DatabaseDialectMetadata {
    @Nullable
    private CacheWithDefault<String, List<String>> _allTableNames;
    @Nullable
    private List<String> _allSchemaNames;
    @NotNull
    private final Map<String, Collection<ForeignKeyConstraint>> columnConstraintsCache = new ConcurrentHashMap();

    public boolean supportsLimitWithUpdateOrDelete() {
        return true;
    }

    @NotNull
    public final List<String> getAllTablesNames() {
        ExposedConnection<?> connection = TransactionManager.Companion.current().getConnection();
        return (List)connection.metadata(arg_0 -> DatabaseDialectMetadata._get_allTablesNames_$lambda$0(this, arg_0));
    }

    @NotNull
    protected final CacheWithDefault<String, List<String>> getAllTableNamesCache() {
        if (this._allTableNames == null) {
            this._allTableNames = (CacheWithDefault)TransactionManager.Companion.current().getConnection().metadata(DatabaseDialectMetadata::getAllTableNamesCache$lambda$1);
        }
        CacheWithDefault<String, List<String>> cacheWithDefault = this._allTableNames;
        Intrinsics.checkNotNull(cacheWithDefault);
        return cacheWithDefault;
    }

    private final List<String> getAllSchemaNamesCache() {
        if (this._allSchemaNames == null) {
            this._allSchemaNames = (List)TransactionManager.Companion.current().getConnection().metadata(DatabaseDialectMetadata::getAllSchemaNamesCache$lambda$2);
        }
        List<String> list = this._allSchemaNames;
        Intrinsics.checkNotNull(list);
        return list;
    }

    @NotNull
    public final String getDatabase() {
        return this.catalog(TransactionManager.Companion.current());
    }

    @NotNull
    public final String catalog(@NotNull JdbcTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return transaction.getConnection().getCatalog();
    }

    @NotNull
    public final List<String> allTablesNames() {
        return (List)TransactionManager.Companion.current().getConnection().metadata(DatabaseDialectMetadata::allTablesNames$lambda$3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> allTablesNamesInAllSchemas() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getAllSchemaNamesCache();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String schema = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = (Iterable)this.getAllTableNamesCache().get((Object)schema);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean tableExists(@NotNull Table table) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            String string = table.getSchemaName();
            if (string != null) {
                String schema = string;
                boolean bl2 = false;
                Iterable $this$any$iv = (Iterable)this.getAllTableNamesCache().get((Object)DatabaseDialectKt.inProperCase((String)schema));
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)table.nameInDatabaseCase())) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            } else {
                DatabaseDialectMetadata $this$tableExists_u24lambda_u249 = this;
                boolean bl4 = false;
                SchemaMetadata schemaMetadata = (SchemaMetadata)TransactionManager.Companion.current().getConnection().metadata(arg_0 -> DatabaseDialectMetadata.tableExists$lambda$9$lambda$7($this$tableExists_u24lambda_u249, arg_0));
                String schema = schemaMetadata.component1();
                List allTables = schemaMetadata.component2();
                Iterable $this$any$iv = allTables;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl5 = false;
                        if (!$this$tableExists_u24lambda_u249.metadataMatchesTable(it, schema, table)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected boolean metadataMatchesTable(@NotNull String $this$metadataMatchesTable, @NotNull String schema, @NotNull Table table) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$metadataMatchesTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        if (((CharSequence)schema).length() == 0) {
            bl = Intrinsics.areEqual((Object)$this$metadataMatchesTable, (Object)table.nameInDatabaseCaseUnquoted());
        } else {
            String sanitizedTableName = table.getTableNameWithoutSchemeSanitized();
            String nameInDb = DatabaseDialectKt.inProperCase((String)(schema + '.' + sanitizedTableName));
            bl = Intrinsics.areEqual((Object)$this$metadataMatchesTable, (Object)nameInDb);
        }
        return bl;
    }

    public final boolean schemaExists(@NotNull Schema schema) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            List<String> allSchemas = this.getAllSchemaNamesCache();
            Iterable $this$any$iv = allSchemas;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)DatabaseDialectKt.inProperCase((String)schema.getIdentifier()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean sequenceExists(@NotNull Sequence sequence) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
            Iterable $this$any$iv = this.sequences();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)DatabaseDialectKt.inProperCase((String)sequence.getIdentifier()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final Map<Table, List<ColumnMetadata>> tableColumns(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getConnection().metadata(arg_0 -> DatabaseDialectMetadata.tableColumns$lambda$12(tables, arg_0));
    }

    @NotNull
    protected final Map<String, Collection<ForeignKeyConstraint>> getColumnConstraintsCache() {
        return this.columnConstraintsCache;
    }

    protected void fillConstraintCacheForTables(@NotNull List<? extends Table> tables) {
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        JdbcTransaction tx = TransactionManager.Companion.current();
        this.columnConstraintsCache.putAll((Map)tx.getDb().metadata$exposed_jdbc(arg_0 -> DatabaseDialectMetadata.fillConstraintCacheForTables$lambda$13(tables, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> columnConstraints(Table ... tables) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        HashMap constraints = new HashMap();
        Table[] $this$filter$iv = tables;
        boolean $i$f$filter = false;
        Table[] tableArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Iterable element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!(!this.columnConstraintsCache.containsKey(it.nameInDatabaseCaseUnquoted()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tablesToLoad = (List)destination$iv$iv;
        this.fillConstraintCacheForTables(tablesToLoad);
        Table[] $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            void $this$forEach$iv2;
            Table element$iv;
            Iterable element$iv$iv;
            Table table = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Collection collection = this.columnConstraintsCache.get(table.nameInDatabaseCaseUnquoted());
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            element$iv$iv = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                void $this$getOrPut$iv;
                ForeignKeyConstraint it = (ForeignKeyConstraint)element$iv2;
                boolean bl2 = false;
                Map map = constraints;
                Pair key$iv = TuplesKt.to((Object)table, (Object)it.getFrom());
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(it);
            }
        }
        return constraints;
    }

    public final boolean areEquivalentColumnTypes(@NotNull String columnMetadataSqlType, int columnMetadataType, @NotNull String columnType) {
        Intrinsics.checkNotNullParameter((Object)columnMetadataSqlType, (String)"columnMetadataSqlType");
        Intrinsics.checkNotNullParameter((Object)columnType, (String)"columnType");
        return (Boolean)TransactionManager.Companion.current().getDb().metadata$exposed_jdbc(arg_0 -> DatabaseDialectMetadata.areEquivalentColumnTypes$lambda$18(columnMetadataSqlType, columnMetadataType, columnType, arg_0));
    }

    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getDb().metadata$exposed_jdbc(arg_0 -> DatabaseDialectMetadata.existingIndices$lambda$19(tables, arg_0));
    }

    @NotNull
    public final Map<Table, List<CheckConstraint>> existingCheckConstraints(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getDb().metadata$exposed_jdbc(arg_0 -> DatabaseDialectMetadata.existingCheckConstraints$lambda$20(tables, arg_0));
    }

    @NotNull
    public final Map<Table, PrimaryKeyMetadata> existingPrimaryKeys(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getDb().metadata$exposed_jdbc(arg_0 -> DatabaseDialectMetadata.existingPrimaryKeys$lambda$21(tables, arg_0));
    }

    @NotNull
    public final Map<Table, List<Sequence>> existingSequences(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getDb().metadata$exposed_jdbc(arg_0 -> DatabaseDialectMetadata.existingSequences$lambda$22(tables, arg_0));
    }

    @NotNull
    public final List<String> sequences() {
        return (List)TransactionManager.Companion.current().getDb().metadata$exposed_jdbc(DatabaseDialectMetadata::sequences$lambda$23);
    }

    public final void resetCaches() {
        this._allTableNames = null;
        this.columnConstraintsCache.clear();
        TransactionManager.Companion.current().getDb().metadata$exposed_jdbc(DatabaseDialectMetadata::resetCaches$lambda$24);
    }

    public final void resetSchemaCaches() {
        this._allSchemaNames = null;
        this.resetCaches();
    }

    private static final List _get_allTablesNames_$lambda$0(DatabaseDialectMetadata this$0, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$metadata), (String)"$this$metadata");
        return $this$metadata.tableNamesByCurrentSchema(this$0.getAllTableNamesCache()).getTableNames();
    }

    private static final CacheWithDefault getAllTableNamesCache$lambda$1(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$metadata), (String)"$this$metadata");
        return $this$metadata.getTableNames();
    }

    private static final List getAllSchemaNamesCache$lambda$2(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$metadata), (String)"$this$metadata");
        return $this$metadata.getSchemaNames();
    }

    private static final List allTablesNames$lambda$3(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$metadata), (String)"$this$metadata");
        return $this$metadata.tableNamesByCurrentSchema(null).getTableNames();
    }

    private static final SchemaMetadata tableExists$lambda$9$lambda$7(DatabaseDialectMetadata $this_run, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$metadata), (String)"$this$metadata");
        return $this$metadata.tableNamesByCurrentSchema($this_run.getAllTableNamesCache());
    }

    private static final Map tableColumns$lambda$12(Table[] $tables, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$metadata), (String)"$this$metadata");
        return $this$metadata.columns(Arrays.copyOf($tables, $tables.length));
    }

    private static final Map fillConstraintCacheForTables$lambda$13(List $tables, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$metadata), (String)"$this$metadata");
        return $this$metadata.tableConstraints($tables);
    }

    private static final boolean areEquivalentColumnTypes$lambda$18(String $columnMetadataSqlType, int $columnMetadataType, String $columnType, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$metadata), (String)"$this$metadata");
        return $this$metadata.areEquivalentColumnTypes($columnMetadataSqlType, $columnMetadataType, $columnType);
    }

    private static final Map existingIndices$lambda$19(Table[] $tables, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$metadata), (String)"$this$metadata");
        return $this$metadata.existingIndices(Arrays.copyOf($tables, $tables.length));
    }

    private static final Map existingCheckConstraints$lambda$20(Table[] $tables, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$metadata), (String)"$this$metadata");
        return $this$metadata.existingCheckConstraints(Arrays.copyOf($tables, $tables.length));
    }

    private static final Map existingPrimaryKeys$lambda$21(Table[] $tables, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$metadata), (String)"$this$metadata");
        return $this$metadata.existingPrimaryKeys(Arrays.copyOf($tables, $tables.length));
    }

    private static final Map existingSequences$lambda$22(Table[] $tables, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$metadata), (String)"$this$metadata");
        return $this$metadata.existingSequences(Arrays.copyOf($tables, $tables.length));
    }

    private static final List sequences$lambda$23(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$metadata), (String)"$this$metadata");
        return $this$metadata.sequences();
    }

    private static final Unit resetCaches$lambda$24(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$metadata), (String)"$this$metadata");
        $this$metadata.cleanCache();
        return Unit.INSTANCE;
    }
}

