/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.geo;

import app.termora.ColorHash;
import app.termora.plugin.DispatchThread;
import app.termora.plugins.geo.Geo;
import app.termora.plugins.geo.GeoHostTreeShowMoreEnableExtension;
import app.termora.tree.HostTreeNode;
import app.termora.tree.MarkerSimpleTreeCellAnnotation;
import app.termora.tree.SimpleTreeCellAnnotation;
import app.termora.tree.SimpleTreeCellRendererExtension;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0004"}, d2={"Lapp/termora/plugins/geo/GeoSimpleTreeCellRendererExtension;", "Lapp/termora/tree/SimpleTreeCellRendererExtension;", "<init>", "()V", "geo", "Lapp/termora/plugins/geo/Geo;", "getGeo", "()Lapp/termora/plugins/geo/Geo;", "createAnnotations", "", "Lapp/termora/tree/SimpleTreeCellAnnotation;", "tree", "Ljavax/swing/JTree;", "value", "", "sel", "", "expanded", "leaf", "row", "", "hasFocus", "countryCodeToFlagEmoji", "", "code", "ordered", "", "Companion"})
public final class GeoSimpleTreeCellRendererExtension
implements SimpleTreeCellRendererExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final GeoSimpleTreeCellRendererExtension instance = new GeoSimpleTreeCellRendererExtension();

    private GeoSimpleTreeCellRendererExtension() {
    }

    private final Geo getGeo() {
        return Geo.Companion.getInstance();
    }

    @NotNull
    public List<SimpleTreeCellAnnotation> createAnnotations(@NotNull JTree tree, @Nullable Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        HostTreeNode hostTreeNode = (HostTreeNode)value;
        if (hostTreeNode == null) {
            return CollectionsKt.emptyList();
        }
        HostTreeNode node = hostTreeNode;
        if (node.isFolder()) {
            return CollectionsKt.emptyList();
        }
        String protocol = node.getData().getProtocol();
        if (!Intrinsics.areEqual((Object)protocol, (Object)"SSH") && !Intrinsics.areEqual((Object)protocol, (Object)"RDP")) {
            return CollectionsKt.emptyList();
        }
        if (!GeoHostTreeShowMoreEnableExtension.Companion.getInstance().isShowMore()) {
            return CollectionsKt.emptyList();
        }
        Geo.Country country = this.getGeo().country(node.getData().getHost());
        if (country == null) {
            return CollectionsKt.emptyList();
        }
        Geo.Country country2 = country;
        String text = this.countryCodeToFlagEmoji(country2.getIsoCode()) + country2.getName();
        return CollectionsKt.listOf((Object)new MarkerSimpleTreeCellAnnotation(text, 0.0f, Color.white, ColorHash.INSTANCE.hash(country2.getIsoCode()), 2, null));
    }

    private final String countryCodeToFlagEmoji(String code) {
        if (code.length() < 2) {
            return "\u2753";
        }
        String string = StringsKt.take((String)code, (int)2).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String upper = string;
        int first = Character.codePointAt(upper, 0) - 65 + 127462;
        int second = Character.codePointAt(upper, 1) - 65 + 127462;
        char[] cArray = Character.toChars(first);
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toChars(...)");
        char[] cArray2 = cArray;
        String string2 = new String(cArray2);
        char[] cArray3 = Character.toChars(second);
        Intrinsics.checkNotNullExpressionValue((Object)cArray3, (String)"toChars(...)");
        cArray2 = cArray3;
        return string2 + new String(cArray2);
    }

    public long ordered() {
        return 1L;
    }

    @NotNull
    public DispatchThread getDispatchThread() {
        return SimpleTreeCellRendererExtension.DefaultImpls.getDispatchThread((SimpleTreeCellRendererExtension)this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lapp/termora/plugins/geo/GeoSimpleTreeCellRendererExtension$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/plugins/geo/GeoSimpleTreeCellRendererExtension;", "getInstance", "()Lapp/termora/plugins/geo/GeoSimpleTreeCellRendererExtension;", "geo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GeoSimpleTreeCellRendererExtension getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

