/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.lang.ref.WeakReference;
import jetbrains.exodus.core.execution.SharedTimer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheHitRateable {
    @Nullable
    private final SharedTimer.ExpirablePeriodicTask cacheAdjuster = this.getCacheAdjuster();
    private int attempts = 0;
    private int hits = 0;

    protected CacheHitRateable() {
        if (this.cacheAdjuster != null) {
            SharedTimer.registerPeriodicTask(this.cacheAdjuster);
        }
    }

    public void close() {
        if (this.cacheAdjuster != null) {
            SharedTimer.unregisterPeriodicTask(this.cacheAdjuster);
        }
    }

    public int getAttempts() {
        return this.attempts;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public int getHits() {
        return this.hits;
    }

    public void setHits(int hits) {
        this.hits = hits;
    }

    public float hitRate() {
        int hits = this.hits;
        int attempts = this.attempts;
        if (hits > attempts) {
            attempts = hits;
        }
        return attempts > 0 ? (float)hits / (float)attempts : 0.0f;
    }

    protected void incAttempts() {
        ++this.attempts;
    }

    protected void incHits() {
        ++this.hits;
    }

    public void adjustHitRate() {
        int hits = this.hits;
        int attempts = this.attempts;
        if (hits > attempts) {
            attempts = hits;
        }
        if (attempts > 256) {
            this.attempts = attempts + 1 >> 1;
            this.hits = hits + 1 >> 1;
        }
    }

    @Nullable
    protected SharedTimer.ExpirablePeriodicTask getCacheAdjuster() {
        return new CacheAdjuster(this);
    }

    private static class CacheAdjuster
    implements SharedTimer.ExpirablePeriodicTask {
        private final WeakReference<CacheHitRateable> cacheRef;

        public CacheAdjuster(@NotNull CacheHitRateable cache) {
            this.cacheRef = new WeakReference<CacheHitRateable>(cache);
        }

        @Override
        public boolean isExpired() {
            return this.cacheRef.get() == null;
        }

        @Override
        public void run() {
            CacheHitRateable cache = (CacheHitRateable)this.cacheRef.get();
            if (cache != null) {
                cache.adjustHitRate();
            }
        }
    }
}

