/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.persistent.AbstractPersistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.Persistent23Tree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Persistent23TreeMap<K extends Comparable<K>, V> {
    private final Persistent23Tree<Entry<K, V>> set;

    public Persistent23TreeMap() {
        this(null);
    }

    Persistent23TreeMap(@Nullable AbstractPersistent23Tree.RootNode<Entry<K, V>> root) {
        this.set = new Persistent23Tree<Entry<Entry<K, V>, V>>(root);
    }

    public ImmutableMap<K, V> beginRead() {
        return new ImmutableMap<K, V>(this.set);
    }

    public Persistent23TreeMap<K, V> getClone() {
        return new Persistent23TreeMap<K, V>(this.set.getRoot());
    }

    public MutableMap<K, V> beginWrite() {
        return new MutableMap<K, V>(this.set);
    }

    public boolean endWrite(MutableMap<K, V> tree) {
        return this.set.endWrite(tree);
    }

    public Entry<K, V> createEntry(K key) {
        return new Entry(key);
    }

    public static class Entry<K extends Comparable<K>, V>
    implements Comparable<Entry<K, V>> {
        private final K key;
        private final V value;

        Entry(K k) {
            this(k, null);
        }

        Entry(K k, @Nullable V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public int compareTo(Entry<K, V> o) {
            return this.key.compareTo(o.key);
        }

        public V getValue() {
            return this.value;
        }

        public K getKey() {
            return this.key;
        }
    }

    public static class MutableMap<K extends Comparable<K>, V>
    extends Persistent23Tree.MutableTree<Entry<K, V>> {
        MutableMap(Persistent23Tree<Entry<K, V>> set) {
            super(set);
        }

        public V get(@NotNull K key) {
            AbstractPersistent23Tree.RootNode root = this.getRoot();
            if (root == null) {
                return null;
            }
            Entry entry = root.get(new Entry(key));
            return entry == null ? null : (V)entry.getValue();
        }

        public boolean containsKey(@NotNull K key) {
            return this.get(key) != null;
        }

        public void put(@NotNull K key, @NotNull V value) {
            this.add(new Entry<K, V>(key, value));
        }

        public V remove(@NotNull K key) {
            AbstractPersistent23Tree.RootNode root = this.getRoot();
            if (root == null) {
                return null;
            }
            Pair removeResult = root.remove(new Entry(key), true);
            if (removeResult == null) {
                return null;
            }
            AbstractPersistent23Tree.Node res = removeResult.getFirst();
            if (res instanceof AbstractPersistent23Tree.RemovedNode) {
                res = res.getFirstChild();
            }
            root = res == null ? null : res.asRoot(root.getSize() - 1);
            this.setRoot(root);
            return removeResult.getSecond().getValue();
        }
    }

    public static class ImmutableMap<K extends Comparable<K>, V>
    extends Persistent23Tree.ImmutableTree<Entry<K, V>> {
        ImmutableMap(Persistent23Tree<Entry<K, V>> set) {
            super(set.getRoot());
        }

        public V get(@NotNull K key) {
            AbstractPersistent23Tree.RootNode root = this.getRoot();
            if (root == null) {
                return null;
            }
            Entry entry = root.get(new Entry(key));
            return entry == null ? null : (V)entry.getValue();
        }

        public boolean containsKey(@NotNull K key) {
            AbstractPersistent23Tree.RootNode root = this.getRoot();
            return root != null && root.get(new Entry(key)) != null;
        }
    }
}

