/*
 * Decompiled with CFR 0.152.
 */
package cash.z.ecc.android.crypto;

import cash.z.ecc.android.crypto.FallbackProvider;
import cash.z.ecc.android.crypto.PBEKeySpecCommon;
import cash.z.ecc.android.crypto.SecretKeyCommon;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcash/z/ecc/android/crypto/SecretKeyFactoryCommon;", "", "jvmSecretKeyFactory", "Ljavax/crypto/SecretKeyFactory;", "<init>", "(Ljavax/crypto/SecretKeyFactory;)V", "generateSecret", "Lcash/z/ecc/android/crypto/SecretKeyCommon;", "pbeKeySpec", "Lcash/z/ecc/android/crypto/PBEKeySpecCommon;", "Companion", "bip39-lib"})
public final class SecretKeyFactoryCommon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SecretKeyFactory jvmSecretKeyFactory;

    public SecretKeyFactoryCommon(@NotNull SecretKeyFactory jvmSecretKeyFactory) {
        Intrinsics.checkNotNullParameter((Object)jvmSecretKeyFactory, (String)"jvmSecretKeyFactory");
        this.jvmSecretKeyFactory = jvmSecretKeyFactory;
    }

    @NotNull
    public final SecretKeyCommon generateSecret(@NotNull PBEKeySpecCommon pbeKeySpec) {
        Intrinsics.checkNotNullParameter((Object)pbeKeySpec, (String)"pbeKeySpec");
        SecretKey secretKey = this.jvmSecretKeyFactory.generateSecret(pbeKeySpec.getWrappedPbeKeySpec());
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"generateSecret(...)");
        return new SecretKeyCommon(secretKey);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcash/z/ecc/android/crypto/SecretKeyFactoryCommon$Companion;", "", "<init>", "()V", "getInstance", "Lcash/z/ecc/android/crypto/SecretKeyFactoryCommon;", "algorithm", "", "provider", "Lcash/z/ecc/android/crypto/FallbackProvider;", "bip39-lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SecretKeyFactoryCommon getInstance(@NotNull String algorithm) {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithm);
            Intrinsics.checkNotNullExpressionValue((Object)secretKeyFactory, (String)"getInstance(...)");
            return new SecretKeyFactoryCommon(secretKeyFactory);
        }

        @NotNull
        public final SecretKeyFactoryCommon getInstance(@NotNull String algorithm, @NotNull FallbackProvider provider) {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithm);
            Intrinsics.checkNotNullExpressionValue((Object)secretKeyFactory, (String)"getInstance(...)");
            return new SecretKeyFactoryCommon(secretKeyFactory);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

