/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.s3;

import app.termora.DynamicIcon;
import app.termora.Icons;
import app.termora.plugins.s3.S3FileSystem;
import app.termora.vfs2.FileObjectDescriptor;
import io.minio.GetObjectArgs;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.messages.Item;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u00010B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0019\u0010\u0011\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u0012H\u0014\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\u0015\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0012H\u0014\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0002H\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0014J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u0013H\u0016J\u000f\u0010#\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010$J\n\u0010%\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010&\u001a\u00020\u0016H\u0014J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0014J\b\u0010+\u001a\u00020(H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020 H\u0014J\b\u0010/\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lapp/termora/plugins/s3/S3FileObject;", "Lorg/apache/commons/vfs2/provider/AbstractFileObject;", "Lapp/termora/plugins/s3/S3FileSystem;", "Lapp/termora/vfs2/FileObjectDescriptor;", "minio", "Lio/minio/MinioClient;", "fileName", "Lorg/apache/commons/vfs2/provider/AbstractFileName;", "fileSystem", "<init>", "(Lio/minio/MinioClient;Lorg/apache/commons/vfs2/provider/AbstractFileName;Lapp/termora/plugins/s3/S3FileSystem;)V", "attributes", "Lapp/termora/plugins/s3/S3FileObject$Attributes;", "doGetContentSize", "", "doGetType", "Lorg/apache/commons/vfs2/FileType;", "doListChildren", "", "", "()[Ljava/lang/String;", "doCreateFolder", "", "getBucketName", "doListChildrenResolved", "Lorg/apache/commons/vfs2/FileObject;", "()[Lorg/apache/commons/vfs2/FileObject;", "getFileSystem", "doGetLastModifiedTime", "getIcon", "Lapp/termora/DynamicIcon;", "width", "", "height", "getTypeDescription", "getLastModified", "()Ljava/lang/Long;", "getOwner", "doDelete", "doGetOutputStream", "Ljava/io/OutputStream;", "bAppend", "", "createStreamer", "doGetInputStream", "Ljava/io/InputStream;", "bufferSize", "getObjectName", "Attributes", "s3"})
@SourceDebugExtension(value={"SMAP\nS3FileObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 S3FileObject.kt\napp/termora/plugins/s3/S3FileObject\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,223:1\n37#2:224\n36#2,3:225\n*S KotlinDebug\n*F\n+ 1 S3FileObject.kt\napp/termora/plugins/s3/S3FileObject\n*L\n118#1:224\n118#1:225,3\n*E\n"})
public final class S3FileObject
extends AbstractFileObject<S3FileSystem>
implements FileObjectDescriptor {
    @NotNull
    private final MinioClient minio;
    @NotNull
    private Attributes attributes;

    public S3FileObject(@NotNull MinioClient minio, @NotNull AbstractFileName fileName, @NotNull S3FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)minio, (String)"minio");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)((Object)fileSystem), (String)"fileSystem");
        super(fileName, (AbstractFileSystem)fileSystem);
        this.minio = minio;
        this.attributes = new Attributes(false, false, false, false, null, 0L, 0L, null, 255, null);
        this.attributes = Attributes.copy$default(this.attributes, Intrinsics.areEqual((Object)this.getName().getPath(), (Object)fileSystem.getDelimiter()), false, false, false, null, 0L, 0L, null, 254, null);
    }

    protected long doGetContentSize() {
        return this.attributes.getSize();
    }

    @NotNull
    protected FileType doGetType() {
        return this.attributes.isRoot() || this.attributes.isBucket() ? FileType.FOLDER : (this.attributes.isDirectory() && this.attributes.isFile() ? FileType.FILE_OR_FOLDER : (this.attributes.isFile() ? FileType.FILE : (this.attributes.isDirectory() ? FileType.FOLDER : FileType.IMAGINARY)));
    }

    @Nullable
    protected String[] doListChildren() {
        return null;
    }

    protected void doCreateFolder() {
    }

    private final String getBucketName() {
        if (StringUtils.isNotBlank((CharSequence)this.attributes.getBucket())) {
            return this.attributes.getBucket();
        }
        if (this.getParent() instanceof S3FileObject) {
            FileObject fileObject = this.getParent();
            Intrinsics.checkNotNull((Object)fileObject, (String)"null cannot be cast to non-null type app.termora.plugins.s3.S3FileObject");
            return ((S3FileObject)fileObject).getBucketName();
        }
        throw new IllegalArgumentException("Bucket must be a S3 file object");
    }

    @Nullable
    protected FileObject[] doListChildrenResolved() {
        if (this.isFile()) {
            return null;
        }
        List children = new ArrayList();
        if (this.attributes.isRoot()) {
            List buckets = this.minio.listBuckets();
            for (Object bucket : buckets) {
                String string;
                FileObject file = this.resolveFile(bucket.name());
                if (!(file instanceof S3FileObject)) continue;
                S3FileObject s3FileObject = (S3FileObject)file;
                Attributes attributes = ((S3FileObject)file).attributes;
                Intrinsics.checkNotNullExpressionValue((Object)bucket.name(), (String)"name(...)");
                long l = bucket.creationDate().toInstant().toEpochMilli();
                s3FileObject.attributes = Attributes.copy$default(attributes, false, true, false, false, string, l, 0L, null, 193, null);
                children.add(file);
            }
        } else if (this.attributes.isBucket() || this.attributes.isDirectory()) {
            ListObjectsArgs.Builder builder = ((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.getBucketName())).delimiter(this.getFileSystem().getDelimiter());
            Object prefix = "";
            if (this.attributes.isDirectory()) {
                String string = StringUtils.removeStart((String)this.getName().getPath(), (String)this.getFileSystem().getDelimiter());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeStart(...)");
                prefix = string;
                String string2 = StringUtils.removeStart((String)prefix, (String)this.getBucketName());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"removeStart(...)");
                prefix = string2;
                String string3 = StringUtils.removeStart((String)prefix, (String)this.getFileSystem().getDelimiter());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"removeStart(...)");
                prefix = string3;
                String string4 = StringUtils.removeEnd((String)prefix, (String)this.getFileSystem().getDelimiter());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"removeEnd(...)");
                prefix = string4;
                prefix = (String)prefix + this.getFileSystem().getDelimiter();
            }
            builder.prefix((String)prefix);
            for (Result e : this.minio.listObjects((ListObjectsArgs)builder.build())) {
                Item item = (Item)e.get();
                String objectName = StringUtils.removeStart((String)item.objectName(), (String)prefix);
                FileObject file = this.resolveFile(objectName);
                if (!(file instanceof S3FileObject)) continue;
                long lastModified = item.lastModified() != null ? item.lastModified().toInstant().toEpochMilli() : 0L;
                String owner = item.owner() != null ? item.owner().displayName() : "";
                S3FileObject s3FileObject = (S3FileObject)file;
                Attributes attributes = ((S3FileObject)file).attributes;
                String string = this.attributes.getBucket();
                boolean bl = item.isDir();
                boolean bl2 = !item.isDir();
                long l = !item.isDir() ? item.size() : 0L;
                Intrinsics.checkNotNull((Object)owner);
                String string5 = owner;
                s3FileObject.attributes = Attributes.copy$default(attributes, false, false, bl, bl2, string, lastModified, l, string5, 3, null);
                children.add(file);
            }
        }
        Collection $this$toTypedArray$iv = children;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FileObject[0]);
    }

    @NotNull
    public S3FileSystem getFileSystem() {
        FileSystem fileSystem = super.getFileSystem();
        Intrinsics.checkNotNull((Object)fileSystem, (String)"null cannot be cast to non-null type app.termora.plugins.s3.S3FileSystem");
        return (S3FileSystem)fileSystem;
    }

    protected long doGetLastModifiedTime() {
        return this.attributes.getLastModified();
    }

    @Nullable
    public DynamicIcon getIcon(int width, int height) {
        if (this.attributes.isBucket()) {
            return Icons.INSTANCE.getDbms();
        }
        return FileObjectDescriptor.DefaultImpls.getIcon((FileObjectDescriptor)this, (int)width, (int)height);
    }

    @Nullable
    public String getTypeDescription() {
        if (this.attributes.isBucket()) {
            return "Bucket";
        }
        return null;
    }

    @Nullable
    public Long getLastModified() {
        return this.attributes.getLastModified();
    }

    @Nullable
    public String getOwner() {
        return this.attributes.getOwner();
    }

    protected void doDelete() {
        if (this.isFile()) {
            this.minio.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.getBucketName())).object(this.getObjectName())).build());
        }
    }

    @Nullable
    protected OutputStream doGetOutputStream(boolean bAppend) {
        return this.createStreamer();
    }

    private final OutputStream createStreamer() {
        PipedInputStream pis = new PipedInputStream();
        PipedOutputStream pos = new PipedOutputStream(pis);
        Thread thread = Thread.ofVirtual().start(() -> S3FileObject.createStreamer$lambda$0(this, pis));
        return new OutputStream(pos, thread){
            final /* synthetic */ PipedOutputStream $pos;
            final /* synthetic */ Thread $thread;
            {
                this.$pos = $pos;
                this.$thread = $thread;
            }

            public void write(int b) {
                this.$pos.write(b);
            }

            public void close() {
                this.$pos.close();
                this.$thread.join();
            }
        };
    }

    @Nullable
    protected InputStream doGetInputStream(int bufferSize) {
        return (InputStream)this.minio.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.getBucketName())).object(this.getObjectName())).build());
    }

    private final String getObjectName() {
        String objectName = StringUtils.removeStart((String)this.getName().getPath(), (String)this.getFileSystem().getDelimiter());
        objectName = StringUtils.removeStart((String)objectName, (String)this.getBucketName());
        String string = objectName = StringUtils.removeStart((String)objectName, (String)this.getFileSystem().getDelimiter());
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private static final void createStreamer$lambda$0(S3FileObject this$0, PipedInputStream $pis) {
        this$0.minio.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this$0.getBucketName())).stream((InputStream)$pis, -1L, 0x2000000L).object(this$0.getObjectName())).build());
        IOUtils.closeQuietly((InputStream)$pis);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BW\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003JY\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00032\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006$"}, d2={"Lapp/termora/plugins/s3/S3FileObject$Attributes;", "", "isRoot", "", "isBucket", "isDirectory", "isFile", "bucket", "", "lastModified", "", "size", "owner", "<init>", "(ZZZZLjava/lang/String;JJLjava/lang/String;)V", "()Z", "getBucket", "()Ljava/lang/String;", "getLastModified", "()J", "getSize", "getOwner", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "s3"})
    private static final class Attributes {
        private final boolean isRoot;
        private final boolean isBucket;
        private final boolean isDirectory;
        private final boolean isFile;
        @NotNull
        private final String bucket;
        private final long lastModified;
        private final long size;
        @NotNull
        private final String owner;

        public Attributes(boolean isRoot, boolean isBucket, boolean isDirectory, boolean isFile, @NotNull String bucket, long lastModified, long size, @NotNull String owner) {
            Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.isRoot = isRoot;
            this.isBucket = isBucket;
            this.isDirectory = isDirectory;
            this.isFile = isFile;
            this.bucket = bucket;
            this.lastModified = lastModified;
            this.size = size;
            this.owner = owner;
        }

        public /* synthetic */ Attributes(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, long l, long l2, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            if ((n & 8) != 0) {
                bl4 = false;
            }
            if ((n & 0x10) != 0) {
                string = "";
            }
            if ((n & 0x20) != 0) {
                l = 0L;
            }
            if ((n & 0x40) != 0) {
                l2 = 0L;
            }
            if ((n & 0x80) != 0) {
                string2 = "";
            }
            this(bl, bl2, bl3, bl4, string, l, l2, string2);
        }

        public final boolean isRoot() {
            return this.isRoot;
        }

        public final boolean isBucket() {
            return this.isBucket;
        }

        public final boolean isDirectory() {
            return this.isDirectory;
        }

        public final boolean isFile() {
            return this.isFile;
        }

        @NotNull
        public final String getBucket() {
            return this.bucket;
        }

        public final long getLastModified() {
            return this.lastModified;
        }

        public final long getSize() {
            return this.size;
        }

        @NotNull
        public final String getOwner() {
            return this.owner;
        }

        public final boolean component1() {
            return this.isRoot;
        }

        public final boolean component2() {
            return this.isBucket;
        }

        public final boolean component3() {
            return this.isDirectory;
        }

        public final boolean component4() {
            return this.isFile;
        }

        @NotNull
        public final String component5() {
            return this.bucket;
        }

        public final long component6() {
            return this.lastModified;
        }

        public final long component7() {
            return this.size;
        }

        @NotNull
        public final String component8() {
            return this.owner;
        }

        @NotNull
        public final Attributes copy(boolean isRoot, boolean isBucket, boolean isDirectory, boolean isFile, @NotNull String bucket, long lastModified, long size, @NotNull String owner) {
            Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return new Attributes(isRoot, isBucket, isDirectory, isFile, bucket, lastModified, size, owner);
        }

        public static /* synthetic */ Attributes copy$default(Attributes attributes, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, long l, long l2, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = attributes.isRoot;
            }
            if ((n & 2) != 0) {
                bl2 = attributes.isBucket;
            }
            if ((n & 4) != 0) {
                bl3 = attributes.isDirectory;
            }
            if ((n & 8) != 0) {
                bl4 = attributes.isFile;
            }
            if ((n & 0x10) != 0) {
                string = attributes.bucket;
            }
            if ((n & 0x20) != 0) {
                l = attributes.lastModified;
            }
            if ((n & 0x40) != 0) {
                l2 = attributes.size;
            }
            if ((n & 0x80) != 0) {
                string2 = attributes.owner;
            }
            return attributes.copy(bl, bl2, bl3, bl4, string, l, l2, string2);
        }

        @NotNull
        public String toString() {
            return "Attributes(isRoot=" + this.isRoot + ", isBucket=" + this.isBucket + ", isDirectory=" + this.isDirectory + ", isFile=" + this.isFile + ", bucket=" + this.bucket + ", lastModified=" + this.lastModified + ", size=" + this.size + ", owner=" + this.owner + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isRoot);
            result = result * 31 + Boolean.hashCode(this.isBucket);
            result = result * 31 + Boolean.hashCode(this.isDirectory);
            result = result * 31 + Boolean.hashCode(this.isFile);
            result = result * 31 + this.bucket.hashCode();
            result = result * 31 + Long.hashCode(this.lastModified);
            result = result * 31 + Long.hashCode(this.size);
            result = result * 31 + this.owner.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Attributes)) {
                return false;
            }
            Attributes attributes = (Attributes)other;
            if (this.isRoot != attributes.isRoot) {
                return false;
            }
            if (this.isBucket != attributes.isBucket) {
                return false;
            }
            if (this.isDirectory != attributes.isDirectory) {
                return false;
            }
            if (this.isFile != attributes.isFile) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bucket, (Object)attributes.bucket)) {
                return false;
            }
            if (this.lastModified != attributes.lastModified) {
                return false;
            }
            if (this.size != attributes.size) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.owner, (Object)attributes.owner);
        }

        public Attributes() {
            this(false, false, false, false, null, 0L, 0L, null, 255, null);
        }
    }
}

