/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.s3;

import app.termora.plugins.s3.S3FileSystem;
import app.termora.plugins.s3.S3FileSystemConfigBuilder;
import io.minio.MinioClient;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lapp/termora/plugins/s3/S3FileProvider;", "Lorg/apache/commons/vfs2/provider/AbstractOriginatingFileProvider;", "<init>", "()V", "getCapabilities", "", "Lorg/apache/commons/vfs2/Capability;", "doCreateFileSystem", "Lorg/apache/commons/vfs2/FileSystem;", "rootFileName", "Lorg/apache/commons/vfs2/FileName;", "options", "Lorg/apache/commons/vfs2/FileSystemOptions;", "Companion", "s3"})
public final class S3FileProvider
extends AbstractOriginatingFileProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<S3FileProvider> instance$delegate = LazyKt.lazy(S3FileProvider::instance_delegate$lambda$0);
    @NotNull
    private static final List<Capability> capabilities;

    private S3FileProvider() {
    }

    @NotNull
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }

    @NotNull
    protected FileSystem doCreateFileSystem(@NotNull FileName rootFileName, @NotNull FileSystemOptions options) {
        Intrinsics.checkNotNullParameter((Object)rootFileName, (String)"rootFileName");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String region = S3FileSystemConfigBuilder.Companion.getInstance().getRegion(options);
        String endpoint = S3FileSystemConfigBuilder.Companion.getInstance().getEndpoint(options);
        String accessKey = S3FileSystemConfigBuilder.Companion.getInstance().getAccessKey(options);
        String secretKey = S3FileSystemConfigBuilder.Companion.getInstance().getSecretKey(options);
        MinioClient.Builder builder = MinioClient.builder();
        builder.endpoint(endpoint);
        builder.credentials(accessKey, secretKey);
        if (!StringsKt.isBlank((CharSequence)region)) {
            builder.region(region);
        }
        MinioClient minioClient = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)minioClient, (String)"build(...)");
        return (FileSystem)new S3FileSystem(minioClient, rootFileName, options);
    }

    private static final S3FileProvider instance_delegate$lambda$0() {
        return new S3FileProvider();
    }

    static {
        Object[] objectArray = new Capability[]{Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.WRITE_CONTENT, Capability.GET_LAST_MODIFIED, Capability.RANDOM_ACCESS_READ};
        capabilities = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lapp/termora/plugins/s3/S3FileProvider$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/plugins/s3/S3FileProvider;", "getInstance", "()Lapp/termora/plugins/s3/S3FileProvider;", "instance$delegate", "Lkotlin/Lazy;", "capabilities", "", "Lorg/apache/commons/vfs2/Capability;", "getCapabilities", "()Ljava/util/List;", "s3"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final S3FileProvider getInstance() {
            Lazy lazy = instance$delegate;
            return (S3FileProvider)((Object)lazy.getValue());
        }

        @NotNull
        public final List<Capability> getCapabilities() {
            return capabilities;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

