/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.s3;

import app.termora.plugins.s3.S3FileObject;
import app.termora.plugins.s3.S3FileProvider;
import app.termora.plugins.s3.S3FileSystemConfigBuilder;
import io.minio.MinioClient;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lapp/termora/plugins/s3/S3FileSystem;", "Lorg/apache/commons/vfs2/provider/AbstractFileSystem;", "minio", "Lio/minio/MinioClient;", "rootName", "Lorg/apache/commons/vfs2/FileName;", "fileSystemOptions", "Lorg/apache/commons/vfs2/FileSystemOptions;", "<init>", "(Lio/minio/MinioClient;Lorg/apache/commons/vfs2/FileName;Lorg/apache/commons/vfs2/FileSystemOptions;)V", "addCapabilities", "", "caps", "", "Lorg/apache/commons/vfs2/Capability;", "createFile", "Lorg/apache/commons/vfs2/FileObject;", "name", "Lorg/apache/commons/vfs2/provider/AbstractFileName;", "getDelimiter", "", "close", "s3"})
public final class S3FileSystem
extends AbstractFileSystem {
    @NotNull
    private final MinioClient minio;

    public S3FileSystem(@NotNull MinioClient minio, @NotNull FileName rootName, @NotNull FileSystemOptions fileSystemOptions) {
        Intrinsics.checkNotNullParameter((Object)minio, (String)"minio");
        Intrinsics.checkNotNullParameter((Object)rootName, (String)"rootName");
        Intrinsics.checkNotNullParameter((Object)fileSystemOptions, (String)"fileSystemOptions");
        super(rootName, null, fileSystemOptions);
        this.minio = minio;
    }

    protected void addCapabilities(@NotNull Collection<Capability> caps) {
        Intrinsics.checkNotNullParameter(caps, (String)"caps");
        caps.addAll((Collection<Capability>)S3FileProvider.Companion.getCapabilities());
    }

    @Nullable
    protected FileObject createFile(@NotNull AbstractFileName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (FileObject)new S3FileObject(this.minio, name, this);
    }

    @NotNull
    public final String getDelimiter() {
        S3FileSystemConfigBuilder s3FileSystemConfigBuilder = S3FileSystemConfigBuilder.Companion.getInstance();
        FileSystemOptions fileSystemOptions = this.getFileSystemOptions();
        Intrinsics.checkNotNullExpressionValue((Object)fileSystemOptions, (String)"getFileSystemOptions(...)");
        return s3FileSystemConfigBuilder.getDelimiter(fileSystemOptions);
    }

    public void close() {
        this.minio.close();
    }
}

