/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.s3;

import app.termora.Authentication;
import app.termora.AuthenticationType;
import app.termora.FixedLengthTextArea;
import app.termora.Host;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.Options;
import app.termora.OptionsPane;
import app.termora.OutlinePasswordField;
import app.termora.OutlineTextField;
import app.termora.Proxy;
import app.termora.ProxyType;
import app.termora.plugin.internal.BasicProxyOption;
import app.termora.plugins.s3.S3HostOptionsPane;
import com.formdev.flatlaf.ui.FlatTextBorder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0012\u0010\u0004\u001a\u00060\u0005R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lapp/termora/plugins/s3/S3HostOptionsPane;", "Lapp/termora/OptionsPane;", "<init>", "()V", "generalOption", "Lapp/termora/plugins/s3/S3HostOptionsPane$GeneralOption;", "proxyOption", "Lapp/termora/plugin/internal/BasicProxyOption;", "sftpOption", "Lapp/termora/plugins/s3/S3HostOptionsPane$SFTPOption;", "getHost", "Lapp/termora/Host;", "setHost", "", "host", "validateFields", "", "validateField", "textField", "Ljavax/swing/JTextField;", "setOutlineError", "GeneralOption", "SFTPOption", "s3"})
public final class S3HostOptionsPane
extends OptionsPane {
    @NotNull
    private final GeneralOption generalOption = new GeneralOption();
    @NotNull
    private final BasicProxyOption proxyOption = new BasicProxyOption();
    @NotNull
    private final SFTPOption sftpOption = new SFTPOption();

    public S3HostOptionsPane() {
        this.addOption(this.generalOption);
        this.addOption((OptionsPane.Option)this.proxyOption);
        this.addOption(this.sftpOption);
    }

    @NotNull
    public final Host getHost() {
        String string;
        String string2;
        String string3;
        Object object;
        String name = this.generalOption.getNameTextField().getText();
        String protocol = "S3";
        String host = this.generalOption.getHostTextField().getText();
        int port = 0;
        Authentication authentication = Authentication.Companion.getNo();
        Proxy proxy = Proxy.Companion.getNo();
        AuthenticationType authenticationType = AuthenticationType.Password;
        char[] cArray = this.generalOption.getPasswordTextField().getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
        Object object2 = cArray;
        authentication = authentication.copy(authenticationType, new String((char[])object2));
        if (this.proxyOption.getProxyTypeComboBox().getSelectedItem() != ProxyType.No) {
            object2 = proxy;
            Object object3 = this.proxyOption.getProxyTypeComboBox().getSelectedItem();
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type app.termora.ProxyType");
            object = (Pair[])object3;
            String string4 = this.proxyOption.getProxyHostTextField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
            string3 = string4;
            String string5 = this.proxyOption.getProxyUsernameTextField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
            string2 = string5;
            char[] cArray2 = this.proxyOption.getProxyPasswordTextField().getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"getPassword(...)");
            char[] cArray3 = cArray2;
            string = new String(cArray3);
            Object object4 = this.proxyOption.getProxyPortTextField().getValue();
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.Int");
            int n = (Integer)object4;
            Object object5 = this.proxyOption.getProxyAuthenticationTypeComboBox().getSelectedItem();
            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type app.termora.AuthenticationType");
            AuthenticationType authenticationType2 = (AuthenticationType)object5;
            proxy = object2.copy((ProxyType)object, string3, n, authenticationType2, string2, string);
        }
        Options options = Options.Companion.getDefault();
        String string6 = this.sftpOption.getDefaultDirectoryField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
        object = new Pair[]{TuplesKt.to((Object)"s3.region", (Object)this.generalOption.getRegionTextField().getText()), TuplesKt.to((Object)"s3.delimiter", (Object)this.generalOption.getDelimiterTextField().getText())};
        Options options2 = Options.copy$default((Options)options, null, null, null, null, (int)0, null, (String)string6, (boolean)false, null, null, (Map)MapsKt.mutableMapOf((Pair[])object), (int)959, null);
        Intrinsics.checkNotNull((Object)name);
        object = name;
        Intrinsics.checkNotNull((Object)host);
        string3 = host;
        String string7 = this.generalOption.getUsernameTextField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getText(...)");
        string2 = string7;
        string = authentication;
        Proxy proxy2 = proxy;
        long l = System.currentTimeMillis();
        String string8 = this.generalOption.getRemarkTextArea().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getText(...)");
        String string9 = string8;
        return new Host(null, (String)object, protocol, string3, port, string2, string9, (Authentication)string, proxy2, options2, null, l, null, null, null, null, false, 0L, 0L, 521217, null);
    }

    public final void setHost(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.generalOption.getNameTextField().setText(host.getName());
        this.generalOption.getUsernameTextField().setText(host.getUsername());
        this.generalOption.getHostTextField().setText(host.getHost());
        this.generalOption.getRemarkTextArea().setText(host.getRemark());
        this.generalOption.getPasswordTextField().setText(host.getAuthentication().getPassword());
        OutlineTextField outlineTextField = this.generalOption.getRegionTextField();
        String string = (String)host.getOptions().getExtras().get("s3.region");
        if (string == null) {
            string = "";
        }
        outlineTextField.setText(string);
        OutlineTextField outlineTextField2 = this.generalOption.getDelimiterTextField();
        String string2 = (String)host.getOptions().getExtras().get("s3.delimiter");
        if (string2 == null) {
            string2 = "";
        }
        outlineTextField2.setText(string2);
        this.proxyOption.getProxyTypeComboBox().setSelectedItem((Object)host.getProxy().getType());
        this.proxyOption.getProxyHostTextField().setText(host.getProxy().getHost());
        this.proxyOption.getProxyPasswordTextField().setText(host.getProxy().getPassword());
        this.proxyOption.getProxyUsernameTextField().setText(host.getProxy().getUsername());
        this.proxyOption.getProxyPortTextField().setValue((Object)host.getProxy().getPort());
        this.proxyOption.getProxyAuthenticationTypeComboBox().setSelectedItem((Object)host.getProxy().getAuthenticationType());
        this.sftpOption.getDefaultDirectoryField().setText(host.getOptions().getSftpDefaultDirectory());
    }

    public final boolean validateFields() {
        Host host = this.getHost();
        if (this.validateField((JTextField)this.generalOption.getNameTextField()) || this.validateField((JTextField)this.generalOption.getHostTextField())) {
            return false;
        }
        if (this.validateField((JTextField)this.generalOption.getUsernameTextField())) {
            return false;
        }
        if (host.getAuthentication().getType() == AuthenticationType.Password && this.validateField((JTextField)this.generalOption.getPasswordTextField())) {
            return false;
        }
        if (host.getProxy().getType() != ProxyType.No) {
            if (this.validateField((JTextField)this.proxyOption.getProxyHostTextField())) {
                return false;
            }
            if (host.getProxy().getAuthenticationType() != AuthenticationType.No && (this.validateField((JTextField)this.proxyOption.getProxyUsernameTextField()) || this.validateField((JTextField)this.proxyOption.getProxyPasswordTextField()))) {
                return false;
            }
        }
        return true;
    }

    private final boolean validateField(JTextField textField) {
        if (textField.isEnabled()) {
            String string = textField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                this.setOutlineError(textField);
                return true;
            }
        }
        return false;
    }

    private final void setOutlineError(JTextField textField) {
        this.selectOptionJComponent(textField);
        textField.putClientProperty("JComponent.outline", "error");
        textField.requestFocusInWindow();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR\u0011\u0010\u0017\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\b\u00a8\u0006%"}, d2={"Lapp/termora/plugins/s3/S3HostOptionsPane$GeneralOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/plugins/s3/S3HostOptionsPane;)V", "nameTextField", "Lapp/termora/OutlineTextField;", "getNameTextField", "()Lapp/termora/OutlineTextField;", "usernameTextField", "getUsernameTextField", "hostTextField", "getHostTextField", "passwordTextField", "Lapp/termora/OutlinePasswordField;", "getPasswordTextField", "()Lapp/termora/OutlinePasswordField;", "remarkTextArea", "Lapp/termora/FixedLengthTextArea;", "getRemarkTextArea", "()Lapp/termora/FixedLengthTextArea;", "regionTextField", "getRegionTextField", "delimiterTextField", "getDelimiterTextField", "initView", "", "initEvents", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "", "getJComponent", "Ljavax/swing/JComponent;", "getCenterComponent", "s3"})
    @SourceDebugExtension(value={"SMAP\nS3HostOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 S3HostOptionsPane.kt\napp/termora/plugins/s3/S3HostOptionsPane$GeneralOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,301:1\n1#2:302\n*E\n"})
    private final class GeneralOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final OutlineTextField nameTextField;
        @NotNull
        private final OutlineTextField usernameTextField;
        @NotNull
        private final OutlineTextField hostTextField;
        @NotNull
        private final OutlinePasswordField passwordTextField;
        @NotNull
        private final FixedLengthTextArea remarkTextArea;
        @NotNull
        private final OutlineTextField regionTextField;
        @NotNull
        private final OutlineTextField delimiterTextField;

        public GeneralOption() {
            super(new BorderLayout());
            this.nameTextField = new OutlineTextField(128);
            this.usernameTextField = new OutlineTextField(128);
            this.hostTextField = new OutlineTextField(255);
            this.passwordTextField = new OutlinePasswordField(255, false, 2, null);
            this.remarkTextArea = new FixedLengthTextArea(512);
            this.regionTextField = new OutlineTextField(128);
            this.delimiterTextField = new OutlineTextField(128);
            this.initView();
            this.initEvents();
        }

        @NotNull
        public final OutlineTextField getNameTextField() {
            return this.nameTextField;
        }

        @NotNull
        public final OutlineTextField getUsernameTextField() {
            return this.usernameTextField;
        }

        @NotNull
        public final OutlineTextField getHostTextField() {
            return this.hostTextField;
        }

        @NotNull
        public final OutlinePasswordField getPasswordTextField() {
            return this.passwordTextField;
        }

        @NotNull
        public final FixedLengthTextArea getRemarkTextArea() {
            return this.remarkTextArea;
        }

        @NotNull
        public final OutlineTextField getRegionTextField() {
            return this.regionTextField;
        }

        @NotNull
        public final OutlineTextField getDelimiterTextField() {
            return this.delimiterTextField;
        }

        private final void initView() {
            this.delimiterTextField.setText("/");
            this.add((Component)this.getCenterComponent(), "Center");
        }

        private final void initEvents() {
            this.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ GeneralOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void componentResized(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SwingUtilities.invokeLater(() -> initEvents.1.componentResized$lambda$0(this.this$0));
                    this.this$0.removeComponentListener(this);
                }

                private static final void componentResized$lambda$0(GeneralOption this$0) {
                    this$0.getNameTextField().requestFocusInWindow();
                }
            });
        }

        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)Icons.INSTANCE.getSettings();
        }

        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.new-host.general");
        }

        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private final JComponent getCenterComponent() {
            void $this$getCenterComponent_u24lambda_u246;
            Object object;
            FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow, 7dlu, pref, 7dlu, default", "pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref");
            this.remarkTextArea.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
            this.remarkTextArea.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
            this.remarkTextArea.setRows(8);
            this.remarkTextArea.setLineWrap(true);
            this.remarkTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            int rows = 0;
            rows = 1;
            int step = 2;
            FormBuilder $this$getCenterComponent_u24lambda_u240 = object = FormBuilder.create().layout(layout).add(I18n.INSTANCE.getString("termora.new-host.general.name") + ":", new Object[0]).xy(1, rows).add((Component)this.nameTextField).xyw(3, rows, 5);
            boolean bl = false;
            FormBuilder $this$getCenterComponent_u24lambda_u241 = object = object.add("Endpoint:", new Object[0]).xy(1, rows += step).add((Component)this.hostTextField).xyw(3, rows, 5);
            boolean bl2 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u242 = object = object.add("AccessKey:", new Object[0]).xy(1, rows += step).add((Component)this.usernameTextField).xyw(3, rows, 5);
            boolean bl3 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u243 = object = object.add("SecureKey:", new Object[0]).xy(1, rows += step).add((Component)this.passwordTextField).xyw(3, rows, 5);
            boolean bl4 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u244 = object = object.add("Region:", new Object[0]).xy(1, rows += step).add((Component)this.regionTextField).xyw(3, rows, 5);
            boolean bl5 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u245 = object = object.add("Delimiter:", new Object[0]).xy(1, rows += step).add((Component)this.delimiterTextField).xyw(3, rows, 5);
            boolean bl6 = false;
            FormBuilder formBuilder = object.add(I18n.INSTANCE.getString("termora.new-host.general.remark") + ":", new Object[0]).xy(1, rows += step);
            $this$getCenterComponent_u24lambda_u245 = object = new JScrollPane((Component)this.remarkTextArea);
            FormBuilder formBuilder2 = formBuilder;
            boolean bl7 = false;
            $this$getCenterComponent_u24lambda_u246.setBorder((Border)new FlatTextBorder());
            Object $this$getCenterComponent_u24lambda_u247 = object = formBuilder2.add((Component)object).xyw(3, rows, 5);
            boolean bl8 = false;
            rows += step;
            JPanel panel = object.build();
            Intrinsics.checkNotNull((Object)panel);
            return panel;
        }

        @NotNull
        public String getIdentifier() {
            return OptionsPane.Option.DefaultImpls.getIdentifier((OptionsPane.Option)this);
        }

        @NotNull
        public OptionsPane.Anchor getAnchor() {
            return OptionsPane.Option.DefaultImpls.getAnchor((OptionsPane.Option)this);
        }

        public void onSelected() {
            OptionsPane.Option.DefaultImpls.onSelected((OptionsPane.Option)this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lapp/termora/plugins/s3/S3HostOptionsPane$SFTPOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/plugins/s3/S3HostOptionsPane;)V", "defaultDirectoryField", "Lapp/termora/OutlineTextField;", "getDefaultDirectoryField", "()Lapp/termora/OutlineTextField;", "initView", "", "initEvents", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "", "getJComponent", "Ljavax/swing/JComponent;", "getCenterComponent", "s3"})
    @SourceDebugExtension(value={"SMAP\nS3HostOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 S3HostOptionsPane.kt\napp/termora/plugins/s3/S3HostOptionsPane$SFTPOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,301:1\n1#2:302\n*E\n"})
    private final class SFTPOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final OutlineTextField defaultDirectoryField;

        public SFTPOption() {
            super(new BorderLayout());
            this.defaultDirectoryField = new OutlineTextField(255);
            this.initView();
            this.initEvents();
        }

        @NotNull
        public final OutlineTextField getDefaultDirectoryField() {
            return this.defaultDirectoryField;
        }

        private final void initView() {
            this.add((Component)this.getCenterComponent(), "Center");
        }

        private final void initEvents() {
        }

        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)Icons.INSTANCE.getFolder();
        }

        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.transport.sftp");
        }

        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        private final JComponent getCenterComponent() {
            FormBuilder formBuilder;
            FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow", "pref, 7dlu, pref, 7dlu, pref, 7dlu, pref");
            int rows = 0;
            rows = 1;
            int step = 2;
            FormBuilder $this$getCenterComponent_u24lambda_u240 = formBuilder = FormBuilder.create().layout(layout).add(I18n.INSTANCE.getString("termora.settings.sftp.default-directory") + ":", new Object[0]).xy(1, rows).add((Component)this.defaultDirectoryField).xy(3, rows);
            boolean bl = false;
            rows += step;
            JPanel panel = formBuilder.build();
            Intrinsics.checkNotNull((Object)panel);
            return panel;
        }

        @NotNull
        public String getIdentifier() {
            return OptionsPane.Option.DefaultImpls.getIdentifier((OptionsPane.Option)this);
        }

        @NotNull
        public OptionsPane.Anchor getAnchor() {
            return OptionsPane.Option.DefaultImpls.getAnchor((OptionsPane.Option)this);
        }

        public void onSelected() {
            OptionsPane.Option.DefaultImpls.onSelected((OptionsPane.Option)this);
        }
    }
}

