/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.s3;

import app.termora.DynamicIcon;
import app.termora.Host;
import app.termora.Icons;
import app.termora.plugins.s3.S3FileProvider;
import app.termora.plugins.s3.S3FileSystemConfigBuilder;
import app.termora.protocol.FileObjectHandler;
import app.termora.protocol.FileObjectRequest;
import app.termora.protocol.TransferProtocolProvider;
import io.minio.MinioClient;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.FileProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lapp/termora/plugins/s3/S3ProtocolProvider;", "Lapp/termora/protocol/TransferProtocolProvider;", "<init>", "()V", "getProtocol", "", "getIcon", "Lapp/termora/DynamicIcon;", "width", "", "height", "getFileProvider", "Lorg/apache/commons/vfs2/provider/FileProvider;", "getRootFileObject", "Lapp/termora/protocol/FileObjectHandler;", "requester", "Lapp/termora/protocol/FileObjectRequest;", "Companion", "s3"})
public final class S3ProtocolProvider
implements TransferProtocolProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<S3ProtocolProvider> instance$delegate = LazyKt.lazy(S3ProtocolProvider::instance_delegate$lambda$0);
    @NotNull
    public static final String PROTOCOL = "S3";

    private S3ProtocolProvider() {
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @NotNull
    public DynamicIcon getIcon(int width, int height) {
        return Icons.INSTANCE.getMinio();
    }

    @NotNull
    public FileProvider getFileProvider() {
        return (FileProvider)S3FileProvider.Companion.getInstance();
    }

    @NotNull
    public FileObjectHandler getRootFileObject(@NotNull FileObjectRequest requester) {
        String string;
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        Host host = requester.getHost();
        MinioClient.Builder builder = MinioClient.builder().endpoint(host.getHost()).credentials(host.getUsername(), host.getAuthentication().getPassword());
        String region = (String)host.getOptions().getExtras().get("s3.region");
        if (StringUtils.isNotBlank((CharSequence)region)) {
            builder.region(region);
        }
        if ((string = (String)host.getOptions().getExtras().get("s3.delimiter")) == null) {
            string = "/";
        }
        String delimiter = string;
        FileSystemOptions options = new FileSystemOptions();
        String defaultPath = host.getOptions().getSftpDefaultDirectory();
        S3FileSystemConfigBuilder s3FileSystemConfigBuilder = S3FileSystemConfigBuilder.Companion.getInstance();
        String string2 = StringUtils.defaultString((String)region);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"defaultString(...)");
        s3FileSystemConfigBuilder.setRegion(options, string2);
        S3FileSystemConfigBuilder.Companion.getInstance().setEndpoint(options, host.getHost());
        S3FileSystemConfigBuilder.Companion.getInstance().setAccessKey(options, host.getUsername());
        S3FileSystemConfigBuilder.Companion.getInstance().setSecretKey(options, host.getAuthentication().getPassword());
        S3FileSystemConfigBuilder.Companion.getInstance().setDelimiter(options, delimiter);
        FileObject file = VFS.getManager().resolveFile("s3://" + StringUtils.defaultIfBlank((CharSequence)defaultPath, (CharSequence)"/"), options);
        Intrinsics.checkNotNull((Object)file);
        return new FileObjectHandler(file);
    }

    public boolean isTransfer() {
        return TransferProtocolProvider.DefaultImpls.isTransfer((TransferProtocolProvider)this);
    }

    public boolean isTransient() {
        return TransferProtocolProvider.DefaultImpls.isTransient((TransferProtocolProvider)this);
    }

    public int ordered() {
        return TransferProtocolProvider.DefaultImpls.ordered((TransferProtocolProvider)this);
    }

    private static final S3ProtocolProvider instance_delegate$lambda$0() {
        return new S3ProtocolProvider();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/termora/plugins/s3/S3ProtocolProvider$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/plugins/s3/S3ProtocolProvider;", "getInstance", "()Lapp/termora/plugins/s3/S3ProtocolProvider;", "instance$delegate", "Lkotlin/Lazy;", "PROTOCOL", "", "s3"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final S3ProtocolProvider getInstance() {
            Lazy lazy = instance$delegate;
            return (S3ProtocolProvider)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

