/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.migration;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.DeletedData;
import app.termora.Disposable;
import app.termora.Host;
import app.termora.I18n;
import app.termora.ScopeKt;
import app.termora.highlight.KeywordHighlight;
import app.termora.keymap.Keymap;
import app.termora.keymgr.OhKeyPair;
import app.termora.macro.Macro;
import app.termora.plugins.migration.Doorman;
import app.termora.plugins.migration.MigrationApplicationRunnerExtension;
import app.termora.plugins.migration.SyncType;
import app.termora.snippet.Snippet;
import app.termora.terminal.CursorStyle;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 a2\u00020\u0001:\babcdefghB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020+J\u000e\u0010/\u001a\u00020-2\u0006\u00100\u001a\u000201J\f\u00102\u001a\b\u0012\u0004\u0012\u0002030*J\u0006\u00104\u001a\u00020-J\f\u00105\u001a\b\u0012\u0004\u0012\u0002060*J\u000e\u00107\u001a\u00020-2\u0006\u00108\u001a\u000203J\u000e\u00109\u001a\u00020-2\u0006\u0010:\u001a\u000201J\u000e\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020=J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020=0*J\u000e\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u00020AJ\u000e\u0010B\u001a\u00020-2\u0006\u0010:\u001a\u000201J\f\u0010C\u001a\b\u0012\u0004\u0012\u00020A0*J\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0*J\u000e\u0010F\u001a\u00020-2\u0006\u0010G\u001a\u00020EJ\u000e\u0010H\u001a\u00020-2\u0006\u0010:\u001a\u000201J\f\u0010I\u001a\b\u0012\u0004\u0012\u00020J0*J\u000e\u0010K\u001a\u00020-2\u0006\u0010L\u001a\u00020JJ\u000e\u0010M\u001a\u00020-2\u0006\u0010:\u001a\u000201J\u000e\u0010N\u001a\u00020-2\u0006\u0010O\u001a\u000206J\u000e\u0010P\u001a\u00020-2\u0006\u0010:\u001a\u000201J(\u0010Q\u001a\u00020-2\u0006\u0010R\u001a\u00020S2\u0006\u00100\u001a\u0002012\u0006\u0010O\u001a\u0002012\u0006\u0010T\u001a\u000201H\u0002J \u0010U\u001a\u00020-2\u0006\u0010R\u001a\u00020S2\u0006\u00100\u001a\u0002012\u0006\u0010O\u001a\u000201H\u0002J\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\rR\u00020\u00000VJe\u0010W\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002HY0X\"\u0006\b\u0000\u0010Y\u0018\u00012\u0006\u0010R\u001a\u00020S2\u0006\u00100\u001a\u00020126\u0010Z\u001a2\u0012\u0013\u0012\u001101\u00a2\u0006\f\b\\\u0012\b\b0\u0012\u0004\b\b(O\u0012\u0013\u0012\u001101\u00a2\u0006\f\b\\\u0012\b\b0\u0012\u0004\b\b(T\u0012\u0004\u0012\u0002HY0[H\u0082\bJ$\u0010]\u001a\u00020-2\u0006\u00100\u001a\u0002012\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002010XH\u0002J\u001a\u0010_\u001a\u0004\u0018\u0001012\u0006\u00100\u001a\u0002012\u0006\u0010O\u001a\u000201H\u0002J\b\u0010`\u001a\u00020-H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u00060\u0007R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001f\u0010\f\u001a\u00060\rR\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0011\u001a\u00060\u0012R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000b\u001a\u0004\b\u0013\u0010\u0014R\u001f\u0010\u0016\u001a\u00060\u0017R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000b\u001a\u0004\b\u0018\u0010\u0019R\u001f\u0010\u001b\u001a\u00060\u001cR\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000b\u001a\u0004\b\u001d\u0010\u001eR\u001f\u0010 \u001a\u00060!R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u000b\u001a\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006i"}, d2={"Lapp/termora/plugins/migration/Database;", "Lapp/termora/Disposable;", "env", "Ljetbrains/exodus/env/Environment;", "<init>", "(Ljetbrains/exodus/env/Environment;)V", "properties", "Lapp/termora/plugins/migration/Database$Properties;", "getProperties", "()Lapp/termora/plugins/migration/Database$Properties;", "properties$delegate", "Lkotlin/Lazy;", "safetyProperties", "Lapp/termora/plugins/migration/Database$SafetyProperties;", "getSafetyProperties", "()Lapp/termora/plugins/migration/Database$SafetyProperties;", "safetyProperties$delegate", "terminal", "Lapp/termora/plugins/migration/Database$Terminal;", "getTerminal", "()Lapp/termora/plugins/migration/Database$Terminal;", "terminal$delegate", "appearance", "Lapp/termora/plugins/migration/Database$Appearance;", "getAppearance", "()Lapp/termora/plugins/migration/Database$Appearance;", "appearance$delegate", "sftp", "Lapp/termora/plugins/migration/Database$SFTP;", "getSftp", "()Lapp/termora/plugins/migration/Database$SFTP;", "sftp$delegate", "sync", "Lapp/termora/plugins/migration/Database$Sync;", "getSync", "()Lapp/termora/plugins/migration/Database$Sync;", "sync$delegate", "doorman", "Lapp/termora/plugins/migration/Doorman;", "getDoorman", "()Lapp/termora/plugins/migration/Doorman;", "getKeymaps", "", "Lapp/termora/keymap/Keymap;", "addKeymap", "", "keymap", "removeKeymap", "name", "", "getHosts", "Lapp/termora/Host;", "removeAllKeyPair", "getKeyPairs", "Lapp/termora/keymgr/OhKeyPair;", "addHost", "host", "removeHost", "id", "addDeletedData", "deletedData", "Lapp/termora/DeletedData;", "getDeletedData", "addSnippet", "snippet", "Lapp/termora/snippet/Snippet;", "removeSnippet", "getSnippets", "getKeywordHighlights", "Lapp/termora/highlight/KeywordHighlight;", "addKeywordHighlight", "keywordHighlight", "removeKeywordHighlight", "getMacros", "Lapp/termora/macro/Macro;", "addMacro", "macro", "removeMacro", "addKeyPair", "key", "removeKeyPair", "put", "tx", "Ljetbrains/exodus/env/Transaction;", "value", "delete", "", "openCursor", "", "T", "callback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "putString", "map", "getString", "dispose", "Companion", "Property", "Terminal", "Properties", "SafetyProperties", "Appearance", "SFTP", "Sync", "migration"})
@SourceDebugExtension(value={"SMAP\nDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Database.kt\napp/termora/plugins/migration/Database\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,747:1\n308#1,18:754\n308#1,9:772\n318#1,8:783\n308#1,9:791\n318#1,8:802\n308#1,9:810\n318#1,8:820\n308#1,9:828\n318#1,8:839\n308#1,9:847\n318#1,8:857\n308#1,9:865\n318#1,8:875\n205#2:748\n205#2:749\n205#2:750\n205#2:751\n205#2:752\n205#2:753\n222#2:781\n222#2:782\n222#2:800\n222#2:801\n222#2:819\n222#2:837\n222#2:838\n222#2:856\n222#2:874\n*S KotlinDebug\n*F\n+ 1 Database.kt\napp/termora/plugins/migration/Database\n*L\n65#1:754,18\n100#1:772,9\n100#1:783,8\n123#1:791,9\n123#1:802,8\n166#1:810,9\n166#1:820,8\n201#1:828,9\n201#1:839,8\n212#1:847,9\n212#1:857,8\n239#1:865,9\n239#1:875,8\n133#1:748\n155#1:749\n177#1:750\n219#1:751\n246#1:752\n265#1:753\n102#1:781\n104#1:782\n125#1:800\n127#1:801\n168#1:819\n203#1:837\n205#1:838\n213#1:856\n240#1:874\n*E\n"})
public final class Database
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Environment env;
    @NotNull
    private final Lazy properties$delegate;
    @NotNull
    private final Lazy safetyProperties$delegate;
    @NotNull
    private final Lazy terminal$delegate;
    @NotNull
    private final Lazy appearance$delegate;
    @NotNull
    private final Lazy sftp$delegate;
    @NotNull
    private final Lazy sync$delegate;
    @NotNull
    private static final String KEYMAP_STORE = "Keymap";
    @NotNull
    private static final String HOST_STORE = "Host";
    @NotNull
    private static final String SNIPPET_STORE = "Snippet";
    @NotNull
    private static final String KEYWORD_HIGHLIGHT_STORE = "KeywordHighlight";
    @NotNull
    private static final String MACRO_STORE = "Macro";
    @NotNull
    private static final String KEY_PAIR_STORE = "KeyPair";
    @NotNull
    private static final String DELETED_DATA_STORE = "DeletedData";
    private static final Logger log = LoggerFactory.getLogger(Database.class);

    private Database(Environment env) {
        this.env = env;
        this.properties$delegate = LazyKt.lazy(() -> Database.properties_delegate$lambda$0(this));
        this.safetyProperties$delegate = LazyKt.lazy(() -> Database.safetyProperties_delegate$lambda$1(this));
        this.terminal$delegate = LazyKt.lazy(() -> Database.terminal_delegate$lambda$2(this));
        this.appearance$delegate = LazyKt.lazy(() -> Database.appearance_delegate$lambda$3(this));
        this.sftp$delegate = LazyKt.lazy(() -> Database.sftp_delegate$lambda$4(this));
        this.sync$delegate = LazyKt.lazy(() -> Database.sync_delegate$lambda$5(this));
    }

    @NotNull
    public final Properties getProperties() {
        Lazy lazy = this.properties$delegate;
        return (Properties)lazy.getValue();
    }

    @NotNull
    public final SafetyProperties getSafetyProperties() {
        Lazy lazy = this.safetyProperties$delegate;
        return (SafetyProperties)lazy.getValue();
    }

    @NotNull
    public final Terminal getTerminal() {
        Lazy lazy = this.terminal$delegate;
        return (Terminal)lazy.getValue();
    }

    @NotNull
    public final Appearance getAppearance() {
        Lazy lazy = this.appearance$delegate;
        return (Appearance)lazy.getValue();
    }

    @NotNull
    public final SFTP getSftp() {
        Lazy lazy = this.sftp$delegate;
        return (SFTP)lazy.getValue();
    }

    @NotNull
    public final Sync getSync() {
        Lazy lazy = this.sync$delegate;
        return (Sync)lazy.getValue();
    }

    private final Doorman getDoorman() {
        return Doorman.Companion.getInstance();
    }

    @NotNull
    public final Collection<Keymap> getKeymaps() {
        Collection array = (Collection)this.env.computeInTransaction(arg_0 -> Database.getKeymaps$lambda$7(this, arg_0));
        List keymaps = new ArrayList();
        for (String text : array) {
            Keymap keymap = Keymap.Companion.fromJSON(text);
            if (keymap == null) continue;
            keymaps.add(keymap);
        }
        return keymaps;
    }

    public final void addKeymap(@NotNull Keymap keymap) {
        Intrinsics.checkNotNullParameter((Object)keymap, (String)"keymap");
        this.env.executeInTransaction(arg_0 -> Database.addKeymap$lambda$8(this, keymap, arg_0));
    }

    public final void removeKeymap(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.env.executeInTransaction(arg_0 -> Database.removeKeymap$lambda$9(this, name, arg_0));
    }

    @NotNull
    public final Collection<Host> getHosts() {
        boolean isWorking = this.getDoorman().isWorking();
        Object object = this.env.computeInTransaction(arg_0 -> Database.getHosts$lambda$11(this, isWorking, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeInTransaction(...)");
        return (Collection)object;
    }

    public final void removeAllKeyPair() {
        this.env.executeInTransaction(arg_0 -> Database.removeAllKeyPair$lambda$13(this, arg_0));
    }

    @NotNull
    public final Collection<OhKeyPair> getKeyPairs() {
        boolean isWorking = this.getDoorman().isWorking();
        Object object = this.env.computeInTransaction(arg_0 -> Database.getKeyPairs$lambda$15(this, isWorking, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeInTransaction(...)");
        return (Collection)object;
    }

    public final void addHost(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Ref.ObjectRef text = new Ref.ObjectRef();
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        SerializersModule serializersModule = this_$iv.getSerializersModule();
        KType kType = Reflection.typeOf(Host.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        text.element = this_$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), (Object)host);
        if (this.getDoorman().isWorking()) {
            text.element = this.getDoorman().encrypt((String)text.element);
        }
        this.env.executeInTransaction(arg_0 -> Database.addHost$lambda$16(this, host, text, arg_0));
    }

    public final void removeHost(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.env.executeInTransaction(arg_0 -> Database.removeHost$lambda$17(this, id, arg_0));
    }

    public final void addDeletedData(@NotNull DeletedData deletedData) {
        Intrinsics.checkNotNullParameter((Object)deletedData, (String)"deletedData");
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        SerializersModule serializersModule = this_$iv.getSerializersModule();
        KType kType = Reflection.typeOf(DeletedData.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        String text = this_$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), (Object)deletedData);
        this.env.executeInTransaction(arg_0 -> Database.addDeletedData$lambda$18(this, deletedData, text, arg_0));
    }

    @NotNull
    public final Collection<DeletedData> getDeletedData() {
        Object object = this.env.computeInTransaction(arg_0 -> Database.getDeletedData$lambda$20(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeInTransaction(...)");
        return (Collection)object;
    }

    public final void addSnippet(@NotNull Snippet snippet) {
        Intrinsics.checkNotNullParameter((Object)snippet, (String)"snippet");
        Ref.ObjectRef text = new Ref.ObjectRef();
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        SerializersModule serializersModule = this_$iv.getSerializersModule();
        KType kType = Reflection.typeOf(Snippet.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        text.element = this_$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), (Object)snippet);
        if (this.getDoorman().isWorking()) {
            text.element = this.getDoorman().encrypt((String)text.element);
        }
        this.env.executeInTransaction(arg_0 -> Database.addSnippet$lambda$21(this, snippet, text, arg_0));
    }

    public final void removeSnippet(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.env.executeInTransaction(arg_0 -> Database.removeSnippet$lambda$22(this, id, arg_0));
    }

    @NotNull
    public final Collection<Snippet> getSnippets() {
        boolean isWorking = this.getDoorman().isWorking();
        Object object = this.env.computeInTransaction(arg_0 -> Database.getSnippets$lambda$24(this, isWorking, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeInTransaction(...)");
        return (Collection)object;
    }

    @NotNull
    public final Collection<KeywordHighlight> getKeywordHighlights() {
        Object object = this.env.computeInTransaction(arg_0 -> Database.getKeywordHighlights$lambda$26(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeInTransaction(...)");
        return (Collection)object;
    }

    public final void addKeywordHighlight(@NotNull KeywordHighlight keywordHighlight) {
        Intrinsics.checkNotNullParameter((Object)keywordHighlight, (String)"keywordHighlight");
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        SerializersModule serializersModule = this_$iv.getSerializersModule();
        KType kType = Reflection.typeOf(KeywordHighlight.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        String text = this_$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), (Object)keywordHighlight);
        this.env.executeInTransaction(arg_0 -> Database.addKeywordHighlight$lambda$27(this, keywordHighlight, text, arg_0));
    }

    public final void removeKeywordHighlight(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.env.executeInTransaction(arg_0 -> Database.removeKeywordHighlight$lambda$28(this, id, arg_0));
    }

    @NotNull
    public final Collection<Macro> getMacros() {
        Object object = this.env.computeInTransaction(arg_0 -> Database.getMacros$lambda$30(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeInTransaction(...)");
        return (Collection)object;
    }

    public final void addMacro(@NotNull Macro macro) {
        Intrinsics.checkNotNullParameter((Object)macro, (String)"macro");
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        SerializersModule serializersModule = this_$iv.getSerializersModule();
        KType kType = Reflection.typeOf(Macro.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        String text = this_$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), (Object)macro);
        this.env.executeInTransaction(arg_0 -> Database.addMacro$lambda$31(this, macro, text, arg_0));
    }

    public final void removeMacro(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.env.executeInTransaction(arg_0 -> Database.removeMacro$lambda$32(this, id, arg_0));
    }

    public final void addKeyPair(@NotNull OhKeyPair key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Ref.ObjectRef text = new Ref.ObjectRef();
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        SerializersModule serializersModule = this_$iv.getSerializersModule();
        KType kType = Reflection.typeOf(OhKeyPair.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        text.element = this_$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), (Object)key);
        if (this.getDoorman().isWorking()) {
            text.element = this.getDoorman().encrypt((String)text.element);
        }
        this.env.executeInTransaction(arg_0 -> Database.addKeyPair$lambda$33(this, key, text, arg_0));
    }

    public final void removeKeyPair(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.env.executeInTransaction(arg_0 -> Database.removeKeyPair$lambda$34(this, id, arg_0));
    }

    private final void put(Transaction tx, String name, String key, String value) {
        Store store = this.env.openStore(name, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, tx);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
        Store store2 = store;
        ArrayByteIterable k = StringBinding.stringToEntry((String)key);
        ArrayByteIterable v = StringBinding.stringToEntry((String)value);
        store2.put(tx, (ByteIterable)k, (ByteIterable)v);
    }

    private final void delete(Transaction tx, String name, String key) {
        Store store = this.env.openStore(name, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, tx);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
        Store store2 = store;
        ArrayByteIterable k = StringBinding.stringToEntry((String)key);
        store2.delete(tx, (ByteIterable)k);
    }

    @NotNull
    public final List<SafetyProperties> getSafetyProperties() {
        Object[] objectArray = new SafetyProperties[]{this.getSync(), this.getSafetyProperties()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final /* synthetic */ <T> Map<String, T> openCursor(Transaction tx, String name, Function2<? super String, ? super String, ? extends T> callback) {
        boolean $i$f$openCursor = false;
        Store store = this.env.openStore(name, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, tx);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
        Store store2 = store;
        Map map = new LinkedHashMap();
        Closeable closeable = (Closeable)store2.openCursor(tx);
        Throwable throwable = null;
        try {
            Cursor it = (Cursor)closeable;
            boolean bl = false;
            while (it.getNext()) {
                try {
                    String key = StringBinding.entryToString((ByteIterable)it.getKey());
                    Map map2 = map;
                    Intrinsics.checkNotNull((Object)key);
                    String string = StringBinding.entryToString((ByteIterable)it.getValue());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entryToString(...)");
                    Object object = callback.invoke((Object)key, (Object)string);
                    map2.put(key, object);
                }
                catch (Exception e) {
                    if (!Database.log.isWarnEnabled()) continue;
                    Database.log.warn("Decode data failed. data: {}", (Object)it.getValue(), (Object)e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
        return map;
    }

    private final void putString(String name, Map<String, String> map) {
        this.env.computeInTransaction(arg_0 -> Database.putString$lambda$36(this, name, map, arg_0));
    }

    private final String getString(String name, String key) {
        return (String)this.env.computeInTransaction(arg_0 -> Database.getString$lambda$37(this, name, key, arg_0));
    }

    public void dispose() {
        IOUtils.closeQuietly((Closeable)((Closeable)this.env));
    }

    private static final Properties properties_delegate$lambda$0(Database this$0) {
        return this$0.new Properties();
    }

    private static final SafetyProperties safetyProperties_delegate$lambda$1(Database this$0) {
        return this$0.new SafetyProperties("Setting.SafetyProperties");
    }

    private static final Terminal terminal_delegate$lambda$2(Database this$0) {
        return this$0.new Terminal();
    }

    private static final Appearance appearance_delegate$lambda$3(Database this$0) {
        return this$0.new Appearance();
    }

    private static final SFTP sftp_delegate$lambda$4(Database this$0) {
        return this$0.new SFTP();
    }

    private static final Sync sync_delegate$lambda$5(Database this$0) {
        return this$0.new Sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Collection getKeymaps$lambda$7(Database this$0, Transaction tx) {
        void tx$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Database database = this$0;
        Transaction transaction = tx;
        String name$iv = KEYMAP_STORE;
        boolean $i$f$openCursor = false;
        Store store = ((Database)this_$iv).env.openStore(name$iv, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, (Transaction)tx$iv);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
        Store store$iv = store;
        Map map$iv = new LinkedHashMap();
        Closeable closeable = (Closeable)store$iv.openCursor((Transaction)tx$iv);
        Throwable throwable = null;
        try {
            Cursor it$iv = (Cursor)closeable;
            boolean bl = false;
            while (it$iv.getNext()) {
                try {
                    String value;
                    String key$iv = StringBinding.entryToString((ByteIterable)it$iv.getKey());
                    Map map = map$iv;
                    Intrinsics.checkNotNull((Object)key$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)StringBinding.entryToString((ByteIterable)it$iv.getValue()), (String)"entryToString(...)");
                    boolean bl2 = false;
                    String string = value;
                    map.put(key$iv, string);
                }
                catch (Exception e$iv) {
                    if (!Database.log.isWarnEnabled()) continue;
                    Database.log.warn("Decode data failed. data: {}", (Object)it$iv.getValue(), (Object)e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return map$iv.values();
    }

    private static final void addKeymap$lambda$8(Database this$0, Keymap $keymap, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.put(it, KEYMAP_STORE, $keymap.getName(), $keymap.toJSON());
        if (log.isDebugEnabled()) {
            log.debug("Added Keymap: " + $keymap.getName());
        }
    }

    private static final void removeKeymap$lambda$9(Database this$0, String $name, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.delete(it, KEYMAP_STORE, $name);
        if (log.isDebugEnabled()) {
            log.debug("Removed Keymap: " + $name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Collection getHosts$lambda$11(Database this$0, boolean $isWorking, Transaction tx) {
        void tx$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Database database = this$0;
        Transaction transaction = tx;
        String name$iv = HOST_STORE;
        boolean $i$f$openCursor = false;
        Store store = ((Database)this_$iv).env.openStore(name$iv, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, (Transaction)tx$iv);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
        Store store$iv = store;
        Map map$iv = new LinkedHashMap();
        Closeable closeable = (Closeable)store$iv.openCursor((Transaction)tx$iv);
        Throwable throwable = null;
        try {
            Cursor it$iv = (Cursor)closeable;
            boolean bl = false;
            while (it$iv.getNext()) {
                try {
                    Host host;
                    String key$iv = StringBinding.entryToString((ByteIterable)it$iv.getKey());
                    Map map = map$iv;
                    Intrinsics.checkNotNull((Object)key$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)StringBinding.entryToString((ByteIterable)it$iv.getValue()), (String)"entryToString(...)");
                    boolean bl2 = false;
                    if ($isWorking) {
                        Json json = Application.INSTANCE.getOhMyJson();
                        String string$iv = this$0.getDoorman().decrypt(value);
                        boolean $i$f$decodeFromString = false;
                        SerializersModule serializersModule = this_$iv.getSerializersModule();
                        KType kType = Reflection.typeOf(Host.class);
                        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                        host = (Host)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), string$iv);
                    } else {
                        this_$iv = Application.INSTANCE.getOhMyJson();
                        boolean $i$f$decodeFromString = false;
                        SerializersModule serializersModule = this_$iv.getSerializersModule();
                        KType kType = Reflection.typeOf(Host.class);
                        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                        host = (Host)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), value);
                    }
                    Host host2 = host;
                    map.put(key$iv, host2);
                }
                catch (Exception e$iv) {
                    if (!Database.log.isWarnEnabled()) continue;
                    Database.log.warn("Decode data failed. data: {}", (Object)it$iv.getValue(), (Object)e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return map$iv.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void removeAllKeyPair$lambda$13(Database this$0, Transaction tx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Store store = this$0.env.openStore(KEY_PAIR_STORE, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, tx);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
        Store store2 = store;
        Closeable closeable = (Closeable)store2.openCursor(tx);
        Throwable throwable = null;
        try {
            Cursor it = (Cursor)closeable;
            boolean bl = false;
            while (it.getNext()) {
                it.deleteCurrent();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Collection getKeyPairs$lambda$15(Database this$0, boolean $isWorking, Transaction tx) {
        void tx$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Database database = this$0;
        Transaction transaction = tx;
        String name$iv = KEY_PAIR_STORE;
        boolean $i$f$openCursor = false;
        Store store = ((Database)this_$iv).env.openStore(name$iv, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, (Transaction)tx$iv);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
        Store store$iv = store;
        Map map$iv = new LinkedHashMap();
        Closeable closeable = (Closeable)store$iv.openCursor((Transaction)tx$iv);
        Throwable throwable = null;
        try {
            Cursor it$iv = (Cursor)closeable;
            boolean bl = false;
            while (it$iv.getNext()) {
                try {
                    OhKeyPair ohKeyPair;
                    String key$iv = StringBinding.entryToString((ByteIterable)it$iv.getKey());
                    Map map = map$iv;
                    Intrinsics.checkNotNull((Object)key$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)StringBinding.entryToString((ByteIterable)it$iv.getValue()), (String)"entryToString(...)");
                    boolean bl2 = false;
                    if ($isWorking) {
                        Json json = Application.INSTANCE.getOhMyJson();
                        String string$iv = this$0.getDoorman().decrypt(value);
                        boolean $i$f$decodeFromString = false;
                        SerializersModule serializersModule = this_$iv.getSerializersModule();
                        KType kType = Reflection.typeOf(OhKeyPair.class);
                        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                        ohKeyPair = (OhKeyPair)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), string$iv);
                    } else {
                        this_$iv = Application.INSTANCE.getOhMyJson();
                        boolean $i$f$decodeFromString = false;
                        SerializersModule serializersModule = this_$iv.getSerializersModule();
                        KType kType = Reflection.typeOf(OhKeyPair.class);
                        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                        ohKeyPair = (OhKeyPair)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), value);
                    }
                    OhKeyPair ohKeyPair2 = ohKeyPair;
                    map.put(key$iv, ohKeyPair2);
                }
                catch (Exception e$iv) {
                    if (!Database.log.isWarnEnabled()) continue;
                    Database.log.warn("Decode data failed. data: {}", (Object)it$iv.getValue(), (Object)e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return map$iv.values();
    }

    private static final void addHost$lambda$16(Database this$0, Host $host, Ref.ObjectRef $text, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.put(it, HOST_STORE, $host.getId(), (String)$text.element);
        if (log.isDebugEnabled()) {
            log.debug("Added Host: " + $host.getId() + " , " + $host.getName());
        }
    }

    private static final void removeHost$lambda$17(Database this$0, String $id, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.delete(it, HOST_STORE, $id);
        if (log.isDebugEnabled()) {
            log.debug("Removed host: " + $id);
        }
    }

    private static final void addDeletedData$lambda$18(Database this$0, DeletedData $deletedData, String $text, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.put(it, DELETED_DATA_STORE, $deletedData.getId(), $text);
        if (log.isDebugEnabled()) {
            log.debug("Added DeletedData: " + $deletedData.getId() + " , " + $text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final List getDeletedData$lambda$20(Database this$0, Transaction tx) {
        void tx$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Database database = this$0;
        Transaction transaction = tx;
        String name$iv = DELETED_DATA_STORE;
        boolean $i$f$openCursor = false;
        Store store = ((Database)this_$iv).env.openStore(name$iv, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, (Transaction)tx$iv);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
        Store store$iv = store;
        Map map$iv = new LinkedHashMap();
        Closeable closeable = (Closeable)store$iv.openCursor((Transaction)tx$iv);
        Throwable throwable = null;
        try {
            Cursor it$iv = (Cursor)closeable;
            boolean bl = false;
            while (it$iv.getNext()) {
                try {
                    DeletedData deletedData;
                    String key$iv = StringBinding.entryToString((ByteIterable)it$iv.getKey());
                    Map map = map$iv;
                    Intrinsics.checkNotNull((Object)key$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)StringBinding.entryToString((ByteIterable)it$iv.getValue()), (String)"entryToString(...)");
                    boolean bl2 = false;
                    try {
                        String value;
                        Json this_$iv2 = Application.INSTANCE.getOhMyJson();
                        boolean $i$f$decodeFromString = false;
                        SerializersModule serializersModule = this_$iv2.getSerializersModule();
                        KType kType = Reflection.nullableTypeOf(DeletedData.class);
                        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                        deletedData = (DeletedData)this_$iv2.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), value);
                    }
                    catch (Exception e) {
                        deletedData = null;
                    }
                    DeletedData deletedData2 = deletedData;
                    map.put(key$iv, deletedData2);
                }
                catch (Exception e$iv) {
                    if (!Database.log.isWarnEnabled()) continue;
                    Database.log.warn("Decode data failed. data: {}", (Object)it$iv.getValue(), (Object)e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return CollectionsKt.filterNotNull((Iterable)map$iv.values());
    }

    private static final void addSnippet$lambda$21(Database this$0, Snippet $snippet, Ref.ObjectRef $text, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.put(it, SNIPPET_STORE, $snippet.getId(), (String)$text.element);
        if (log.isDebugEnabled()) {
            log.debug("Added Snippet: " + $snippet.getId() + " , " + $snippet.getName());
        }
    }

    private static final void removeSnippet$lambda$22(Database this$0, String $id, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.delete(it, SNIPPET_STORE, $id);
        if (log.isDebugEnabled()) {
            log.debug("Removed snippet: " + $id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Collection getSnippets$lambda$24(Database this$0, boolean $isWorking, Transaction tx) {
        void tx$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Database database = this$0;
        Transaction transaction = tx;
        String name$iv = SNIPPET_STORE;
        boolean $i$f$openCursor = false;
        Store store = ((Database)this_$iv).env.openStore(name$iv, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, (Transaction)tx$iv);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
        Store store$iv = store;
        Map map$iv = new LinkedHashMap();
        Closeable closeable = (Closeable)store$iv.openCursor((Transaction)tx$iv);
        Throwable throwable = null;
        try {
            Cursor it$iv = (Cursor)closeable;
            boolean bl = false;
            while (it$iv.getNext()) {
                try {
                    Snippet snippet;
                    String key$iv = StringBinding.entryToString((ByteIterable)it$iv.getKey());
                    Map map = map$iv;
                    Intrinsics.checkNotNull((Object)key$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)StringBinding.entryToString((ByteIterable)it$iv.getValue()), (String)"entryToString(...)");
                    boolean bl2 = false;
                    if ($isWorking) {
                        Json json = Application.INSTANCE.getOhMyJson();
                        String string$iv = this$0.getDoorman().decrypt(value);
                        boolean $i$f$decodeFromString = false;
                        SerializersModule serializersModule = this_$iv.getSerializersModule();
                        KType kType = Reflection.typeOf(Snippet.class);
                        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                        snippet = (Snippet)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), string$iv);
                    } else {
                        this_$iv = Application.INSTANCE.getOhMyJson();
                        boolean $i$f$decodeFromString = false;
                        SerializersModule serializersModule = this_$iv.getSerializersModule();
                        KType kType = Reflection.typeOf(Snippet.class);
                        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                        snippet = (Snippet)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), value);
                    }
                    Snippet snippet2 = snippet;
                    map.put(key$iv, snippet2);
                }
                catch (Exception e$iv) {
                    if (!Database.log.isWarnEnabled()) continue;
                    Database.log.warn("Decode data failed. data: {}", (Object)it$iv.getValue(), (Object)e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return map$iv.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Collection getKeywordHighlights$lambda$26(Database this$0, Transaction tx) {
        void tx$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Database database = this$0;
        Transaction transaction = tx;
        String name$iv = KEYWORD_HIGHLIGHT_STORE;
        boolean $i$f$openCursor = false;
        Store store = ((Database)this_$iv).env.openStore(name$iv, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, (Transaction)tx$iv);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
        Store store$iv = store;
        Map map$iv = new LinkedHashMap();
        Closeable closeable = (Closeable)store$iv.openCursor((Transaction)tx$iv);
        Throwable throwable = null;
        try {
            Cursor it$iv = (Cursor)closeable;
            boolean bl = false;
            while (it$iv.getNext()) {
                try {
                    String value;
                    String key$iv = StringBinding.entryToString((ByteIterable)it$iv.getKey());
                    Map map = map$iv;
                    Intrinsics.checkNotNull((Object)key$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)StringBinding.entryToString((ByteIterable)it$iv.getValue()), (String)"entryToString(...)");
                    boolean bl2 = false;
                    Json this_$iv2 = Application.INSTANCE.getOhMyJson();
                    boolean $i$f$decodeFromString = false;
                    SerializersModule serializersModule = this_$iv2.getSerializersModule();
                    KType kType = Reflection.typeOf(KeywordHighlight.class);
                    MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                    KeywordHighlight keywordHighlight = (KeywordHighlight)this_$iv2.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), value);
                    map.put(key$iv, keywordHighlight);
                }
                catch (Exception e$iv) {
                    if (!Database.log.isWarnEnabled()) continue;
                    Database.log.warn("Decode data failed. data: {}", (Object)it$iv.getValue(), (Object)e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return map$iv.values();
    }

    private static final void addKeywordHighlight$lambda$27(Database this$0, KeywordHighlight $keywordHighlight, String $text, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.put(it, KEYWORD_HIGHLIGHT_STORE, $keywordHighlight.getId(), $text);
        if (log.isDebugEnabled()) {
            log.debug("Added keyword highlight: " + $keywordHighlight.getId() + " , " + $keywordHighlight.getKeyword());
        }
    }

    private static final void removeKeywordHighlight$lambda$28(Database this$0, String $id, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.delete(it, KEYWORD_HIGHLIGHT_STORE, $id);
        if (log.isDebugEnabled()) {
            log.debug("Removed keyword highlight: " + $id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Collection getMacros$lambda$30(Database this$0, Transaction tx) {
        void tx$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Database database = this$0;
        Transaction transaction = tx;
        String name$iv = MACRO_STORE;
        boolean $i$f$openCursor = false;
        Store store = ((Database)this_$iv).env.openStore(name$iv, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, (Transaction)tx$iv);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
        Store store$iv = store;
        Map map$iv = new LinkedHashMap();
        Closeable closeable = (Closeable)store$iv.openCursor((Transaction)tx$iv);
        Throwable throwable = null;
        try {
            Cursor it$iv = (Cursor)closeable;
            boolean bl = false;
            while (it$iv.getNext()) {
                try {
                    String value;
                    String key$iv = StringBinding.entryToString((ByteIterable)it$iv.getKey());
                    Map map = map$iv;
                    Intrinsics.checkNotNull((Object)key$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)StringBinding.entryToString((ByteIterable)it$iv.getValue()), (String)"entryToString(...)");
                    boolean bl2 = false;
                    Json this_$iv2 = Application.INSTANCE.getOhMyJson();
                    boolean $i$f$decodeFromString = false;
                    SerializersModule serializersModule = this_$iv2.getSerializersModule();
                    KType kType = Reflection.typeOf(Macro.class);
                    MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                    Macro macro = (Macro)this_$iv2.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), value);
                    map.put(key$iv, macro);
                }
                catch (Exception e$iv) {
                    if (!Database.log.isWarnEnabled()) continue;
                    Database.log.warn("Decode data failed. data: {}", (Object)it$iv.getValue(), (Object)e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return map$iv.values();
    }

    private static final void addMacro$lambda$31(Database this$0, Macro $macro, String $text, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.put(it, MACRO_STORE, $macro.getId(), $text);
        if (log.isDebugEnabled()) {
            log.debug("Added macro: " + $macro.getId());
        }
    }

    private static final void removeMacro$lambda$32(Database this$0, String $id, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.delete(it, MACRO_STORE, $id);
        if (log.isDebugEnabled()) {
            log.debug("Removed macro: " + $id);
        }
    }

    private static final void addKeyPair$lambda$33(Database this$0, OhKeyPair $key, Ref.ObjectRef $text, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.put(it, KEY_PAIR_STORE, $key.getId(), (String)$text.element);
        if (log.isDebugEnabled()) {
            log.debug("Added Key Pair: " + $key.getId() + " , " + $key.getName());
        }
    }

    private static final void removeKeyPair$lambda$34(Database this$0, String $id, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.delete(it, KEY_PAIR_STORE, $id);
        if (log.isDebugEnabled()) {
            log.debug("Removed Key Pair: " + $id);
        }
    }

    private static final Unit putString$lambda$36(Database this$0, String $name, Map $map, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Store store = this$0.env.openStore($name, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, it);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
        Store store2 = store;
        for (Map.Entry entry : $map.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            store2.put(it, (ByteIterable)StringBinding.stringToEntry((String)key), (ByteIterable)StringBinding.stringToEntry((String)value));
        }
        return Unit.INSTANCE;
    }

    private static final String getString$lambda$37(Database this$0, String $name, String $key, Transaction it) {
        ByteIterable value;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Store store = this$0.env.openStore($name, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, it);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
        Store store2 = store;
        ByteIterable byteIterable = value = store2.get(it, (ByteIterable)StringBinding.stringToEntry((String)$key));
        return byteIterable == null ? null : StringBinding.entryToString((ByteIterable)byteIterable);
    }

    public /* synthetic */ Database(Environment env, DefaultConstructorMarker $constructor_marker) {
        this(env);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b \n\u0002\u0010\u0006\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR+\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R+\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\r\u001a\u0004\b\u0017\u0010\t\"\u0004\b\u0018\u0010\u000bR+\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\r\u001a\u0004\b\u001b\u0010\t\"\u0004\b\u001c\u0010\u000bR+\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0015\u001a\u0004\b\u001f\u0010\u0011\"\u0004\b \u0010\u0013R+\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\u0015\u001a\u0004\b#\u0010\u0011\"\u0004\b$\u0010\u0013R+\u0010&\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b)\u0010\r\u001a\u0004\b'\u0010\t\"\u0004\b(\u0010\u000bR+\u0010*\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b+\u0010\t\"\u0004\b,\u0010\u000bR+\u00100\u001a\u00020/2\u0006\u0010\u0005\u001a\u00020/8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b5\u00106\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u00067"}, d2={"Lapp/termora/plugins/migration/Database$Appearance;", "Lapp/termora/plugins/migration/Database$Property;", "Lapp/termora/plugins/migration/Database;", "<init>", "(Lapp/termora/plugins/migration/Database;)V", "<set-?>", "", "theme", "getTheme", "()Ljava/lang/String;", "setTheme", "(Ljava/lang/String;)V", "theme$delegate", "Lapp/termora/plugins/migration/Database$Property$StringPropertyDelegate;", "", "followSystem", "getFollowSystem", "()Z", "setFollowSystem", "(Z)V", "followSystem$delegate", "Lapp/termora/plugins/migration/Database$Property$BooleanPropertyDelegate;", "darkTheme", "getDarkTheme", "setDarkTheme", "darkTheme$delegate", "lightTheme", "getLightTheme", "setLightTheme", "lightTheme$delegate", "backgroundRunning", "getBackgroundRunning", "setBackgroundRunning", "backgroundRunning$delegate", "confirmTabClose", "getConfirmTabClose", "setConfirmTabClose", "confirmTabClose$delegate", "backgroundImage", "getBackgroundImage", "setBackgroundImage", "backgroundImage$delegate", "language", "getLanguage", "setLanguage", "language$delegate", "Lapp/termora/plugins/migration/Database$Property$StringPropertyLazyDelegate;", "", "opacity", "getOpacity", "()D", "setOpacity", "(D)V", "opacity$delegate", "Lapp/termora/plugins/migration/Database$Property$DoublePropertyDelegate;", "migration"})
    public final class Appearance
    extends Property {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final Property.StringPropertyDelegate theme$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate followSystem$delegate;
        @NotNull
        private final Property.StringPropertyDelegate darkTheme$delegate;
        @NotNull
        private final Property.StringPropertyDelegate lightTheme$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate backgroundRunning$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate confirmTabClose$delegate;
        @NotNull
        private final Property.StringPropertyDelegate backgroundImage$delegate;
        @NotNull
        private final Property.StringPropertyLazyDelegate language$delegate;
        @NotNull
        private final Property.DoublePropertyDelegate opacity$delegate;

        public Appearance() {
            super("Setting.Appearance");
            this.theme$delegate = (Property)this.new Property.StringPropertyDelegate("Light");
            this.followSystem$delegate = (Property)this.new Property.BooleanPropertyDelegate(true);
            this.darkTheme$delegate = (Property)this.new Property.StringPropertyDelegate("Dark");
            this.lightTheme$delegate = (Property)this.new Property.StringPropertyDelegate("Light");
            this.backgroundRunning$delegate = (Property)this.new Property.BooleanPropertyDelegate(false);
            this.confirmTabClose$delegate = (Property)this.new Property.BooleanPropertyDelegate(false);
            this.backgroundImage$delegate = (Property)this.new Property.StringPropertyDelegate("");
            this.language$delegate = (Property)this.new Property.StringPropertyLazyDelegate((Function0<String>)((Function0)Appearance::language_delegate$lambda$0));
            this.opacity$delegate = (Property)this.new Property.DoublePropertyDelegate(1.0);
        }

        @NotNull
        public final String getTheme() {
            return (String)this.theme$delegate.getValue(this, $$delegatedProperties[0]);
        }

        public final void setTheme(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.theme$delegate.setValue(this, $$delegatedProperties[0], string);
        }

        public final boolean getFollowSystem() {
            return (Boolean)this.followSystem$delegate.getValue(this, $$delegatedProperties[1]);
        }

        public final void setFollowSystem(boolean bl) {
            this.followSystem$delegate.setValue(this, $$delegatedProperties[1], bl);
        }

        @NotNull
        public final String getDarkTheme() {
            return (String)this.darkTheme$delegate.getValue(this, $$delegatedProperties[2]);
        }

        public final void setDarkTheme(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.darkTheme$delegate.setValue(this, $$delegatedProperties[2], string);
        }

        @NotNull
        public final String getLightTheme() {
            return (String)this.lightTheme$delegate.getValue(this, $$delegatedProperties[3]);
        }

        public final void setLightTheme(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.lightTheme$delegate.setValue(this, $$delegatedProperties[3], string);
        }

        public final boolean getBackgroundRunning() {
            return (Boolean)this.backgroundRunning$delegate.getValue(this, $$delegatedProperties[4]);
        }

        public final void setBackgroundRunning(boolean bl) {
            this.backgroundRunning$delegate.setValue(this, $$delegatedProperties[4], bl);
        }

        public final boolean getConfirmTabClose() {
            return (Boolean)this.confirmTabClose$delegate.getValue(this, $$delegatedProperties[5]);
        }

        public final void setConfirmTabClose(boolean bl) {
            this.confirmTabClose$delegate.setValue(this, $$delegatedProperties[5], bl);
        }

        @NotNull
        public final String getBackgroundImage() {
            return (String)this.backgroundImage$delegate.getValue(this, $$delegatedProperties[6]);
        }

        public final void setBackgroundImage(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.backgroundImage$delegate.setValue(this, $$delegatedProperties[6], string);
        }

        @NotNull
        public final String getLanguage() {
            return (String)this.language$delegate.getValue(this, $$delegatedProperties[7]);
        }

        public final void setLanguage(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.language$delegate.setValue(this, $$delegatedProperties[7], string);
        }

        public final double getOpacity() {
            return ((Number)this.opacity$delegate.getValue(this, $$delegatedProperties[8])).doubleValue();
        }

        public final void setOpacity(double d) {
            this.opacity$delegate.setValue(this, $$delegatedProperties[8], d);
        }

        private static final String language_delegate$lambda$0() {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string = I18n.INSTANCE.containsLanguage(locale);
            if (string == null) {
                String string2 = Locale.US.toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            return string;
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "theme", "getTheme()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "followSystem", "getFollowSystem()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "darkTheme", "getDarkTheme()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "lightTheme", "getLightTheme()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "backgroundRunning", "getBackgroundRunning()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "confirmTabClose", "getConfirmTabClose()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "backgroundImage", "getBackgroundImage()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "language", "getLanguage()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "opacity", "getOpacity()D", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lapp/termora/plugins/migration/Database$Companion;", "", "<init>", "()V", "KEYMAP_STORE", "", "HOST_STORE", "SNIPPET_STORE", "KEYWORD_HIGHLIGHT_STORE", "MACRO_STORE", "KEY_PAIR_STORE", "DELETED_DATA_STORE", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "open", "Lapp/termora/plugins/migration/Database;", "dir", "Ljava/io/File;", "getDatabase", "migration"})
    public static final class Companion {
        private Companion() {
        }

        private final Database open(File dir) {
            EnvironmentConfig config = new EnvironmentConfig();
            config.setLogFileSize(32768L);
            config.setGcEnabled(true);
            config.setGcStartIn((int)Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)));
            Environment environment = Environments.newInstance((File)dir, (EnvironmentConfig)config);
            return new Database(environment, null);
        }

        @NotNull
        public final Database getDatabase() {
            return (Database)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(Database.class), Companion::getDatabase$lambda$0);
        }

        private static final Database getDatabase$lambda$0() {
            return Companion.open(MigrationApplicationRunnerExtension.Companion.getInstance().getDatabaseFile());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lapp/termora/plugins/migration/Database$Properties;", "Lapp/termora/plugins/migration/Database$Property;", "Lapp/termora/plugins/migration/Database;", "<init>", "(Lapp/termora/plugins/migration/Database;)V", "getString", "", "key", "defaultValue", "putString", "", "value", "migration"})
    public final class Properties
    extends Property {
        public Properties() {
            super("Setting.Properties");
        }

        @Override
        @Nullable
        public String getString(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return super.getString(key);
        }

        @NotNull
        public final String getString(@NotNull String key, @NotNull String defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            String string = this.getString(key);
            if (string == null) {
                string = defaultValue;
            }
            return string;
        }

        @Override
        public void putString(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super.putString(key, value);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\b\u00a6\u0004\u0018\u00002\u00020\u0001:\n\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0014J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007RN\u0010\b\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003 \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lapp/termora/plugins/migration/Database$Property;", "", "name", "", "<init>", "(Lapp/termora/plugins/migration/Database;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "properties", "", "kotlin.jvm.PlatformType", "", "getString", "key", "getProperties", "putString", "", "value", "PropertyLazyDelegate", "PropertyDelegate", "StringPropertyDelegate", "IntPropertyDelegate", "DoublePropertyDelegate", "LongPropertyDelegate", "BooleanPropertyDelegate", "StringPropertyLazyDelegate", "CursorStylePropertyDelegate", "SyncTypePropertyDelegate", "migration"})
    @SourceDebugExtension(value={"SMAP\nDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Database.kt\napp/termora/plugins/migration/Database$Property\n+ 2 Database.kt\napp/termora/plugins/migration/Database\n*L\n1#1,747:1\n308#2,18:748\n*S KotlinDebug\n*F\n+ 1 Database.kt\napp/termora/plugins/migration/Database$Property\n*L\n362#1:748,18\n*E\n"})
    public abstract class Property {
        @NotNull
        private final String name;
        private final Map<String, String> properties;

        public Property(String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.properties = Collections.synchronizedMap(new LinkedHashMap());
            BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ Property this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.this$0.properties.putAll(this.this$0.getProperties());
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        protected String getString(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (this.properties.containsKey(key)) {
                return this.properties.get(key);
            }
            return Database.this.getString(this.name, key);
        }

        @NotNull
        public Map<String, String> getProperties() {
            Object object = Database.this.env.computeInTransaction(arg_0 -> Property.getProperties$lambda$1(Database.this, this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeInTransaction(...)");
            return (Map)object;
        }

        protected void putString(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Map<String, String> map = this.properties;
            Intrinsics.checkNotNullExpressionValue(map, (String)"properties");
            map.put(key, value);
            Database.this.putString(this.name, MapsKt.mapOf((Pair)TuplesKt.to((Object)key, (Object)value)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private static final Map getProperties$lambda$1(Database this$0, Property this$1, Transaction tx) {
            void tx$iv;
            void name$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Database database = this$0;
            Transaction transaction = tx;
            String string = this$1.name;
            boolean $i$f$openCursor = false;
            Store store = ((Database)this_$iv).env.openStore((String)name$iv, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, (Transaction)tx$iv);
            Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
            Store store$iv = store;
            Map map$iv = new LinkedHashMap();
            Closeable closeable = (Closeable)store$iv.openCursor((Transaction)tx$iv);
            Throwable throwable = null;
            try {
                Cursor it$iv = (Cursor)closeable;
                boolean bl = false;
                while (it$iv.getNext()) {
                    try {
                        String value;
                        String key$iv = StringBinding.entryToString((ByteIterable)it$iv.getKey());
                        Map map = map$iv;
                        Intrinsics.checkNotNull((Object)key$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)StringBinding.entryToString((ByteIterable)it$iv.getValue()), (String)"entryToString(...)");
                        boolean bl2 = false;
                        String string2 = value;
                        map.put(key$iv, string2);
                    }
                    catch (Exception e$iv) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn("Decode data failed. data: {}", (Object)it$iv.getValue(), (Object)e$iv);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return map$iv;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u00020\u0001R\u00060\u0003R\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lapp/termora/plugins/migration/Database$Property$BooleanPropertyDelegate;", "Lapp/termora/plugins/migration/Database$Property$PropertyDelegate;", "", "Lapp/termora/plugins/migration/Database$Property;", "Lapp/termora/plugins/migration/Database;", "defaultValue", "<init>", "(Lapp/termora/plugins/migration/Database$Property;Z)V", "convertValue", "value", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "migration"})
        protected final class BooleanPropertyDelegate
        extends PropertyDelegate<Boolean> {
            public BooleanPropertyDelegate(boolean defaultValue) {
                super(defaultValue);
            }

            @Override
            @NotNull
            public Boolean convertValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Boolean bl = StringsKt.toBooleanStrictOrNull((String)value);
                return bl != null ? bl.booleanValue() : ((Boolean)this.getInitializer().invoke()).booleanValue();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0084\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u00020\u0001R\u00060\u0003R\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lapp/termora/plugins/migration/Database$Property$CursorStylePropertyDelegate;", "Lapp/termora/plugins/migration/Database$Property$PropertyDelegate;", "Lapp/termora/terminal/CursorStyle;", "Lapp/termora/plugins/migration/Database$Property;", "Lapp/termora/plugins/migration/Database;", "defaultValue", "<init>", "(Lapp/termora/plugins/migration/Database$Property;Lapp/termora/terminal/CursorStyle;)V", "convertValue", "value", "", "migration"})
        protected final class CursorStylePropertyDelegate
        extends PropertyDelegate<CursorStyle> {
            public CursorStylePropertyDelegate(CursorStyle defaultValue) {
                Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
                super(defaultValue);
            }

            @Override
            @NotNull
            public CursorStyle convertValue(@NotNull String value) {
                CursorStyle cursorStyle;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                try {
                    cursorStyle = CursorStyle.valueOf((String)value);
                }
                catch (Exception exception) {
                    cursorStyle = (CursorStyle)this.getInitializer().invoke();
                }
                return cursorStyle;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u00020\u0001R\u00060\u0003R\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lapp/termora/plugins/migration/Database$Property$DoublePropertyDelegate;", "Lapp/termora/plugins/migration/Database$Property$PropertyDelegate;", "", "Lapp/termora/plugins/migration/Database$Property;", "Lapp/termora/plugins/migration/Database;", "defaultValue", "<init>", "(Lapp/termora/plugins/migration/Database$Property;D)V", "convertValue", "value", "", "(Ljava/lang/String;)Ljava/lang/Double;", "migration"})
        protected final class DoublePropertyDelegate
        extends PropertyDelegate<Double> {
            public DoublePropertyDelegate(double defaultValue) {
                super(defaultValue);
            }

            @Override
            @NotNull
            public Double convertValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Double d = StringsKt.toDoubleOrNull((String)value);
                return d != null ? d.doubleValue() : ((Number)this.getInitializer().invoke()).doubleValue();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u00020\u0001R\u00060\u0003R\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lapp/termora/plugins/migration/Database$Property$IntPropertyDelegate;", "Lapp/termora/plugins/migration/Database$Property$PropertyDelegate;", "", "Lapp/termora/plugins/migration/Database$Property;", "Lapp/termora/plugins/migration/Database;", "defaultValue", "<init>", "(Lapp/termora/plugins/migration/Database$Property;I)V", "convertValue", "value", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "migration"})
        protected final class IntPropertyDelegate
        extends PropertyDelegate<Integer> {
            public IntPropertyDelegate(int defaultValue) {
                super(defaultValue);
            }

            @Override
            @NotNull
            public Integer convertValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Integer n = StringsKt.toIntOrNull((String)value);
                return n != null ? n.intValue() : ((Number)this.getInitializer().invoke()).intValue();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u00020\u0001R\u00060\u0003R\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lapp/termora/plugins/migration/Database$Property$LongPropertyDelegate;", "Lapp/termora/plugins/migration/Database$Property$PropertyDelegate;", "", "Lapp/termora/plugins/migration/Database$Property;", "Lapp/termora/plugins/migration/Database;", "defaultValue", "<init>", "(Lapp/termora/plugins/migration/Database$Property;J)V", "convertValue", "value", "", "(Ljava/lang/String;)Ljava/lang/Long;", "migration"})
        protected final class LongPropertyDelegate
        extends PropertyDelegate<Long> {
            public LongPropertyDelegate(long defaultValue) {
                super(defaultValue);
            }

            @Override
            @NotNull
            public Long convertValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Long l = StringsKt.toLongOrNull((String)value);
                return l != null ? l.longValue() : ((Number)this.getInitializer().invoke()).longValue();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00a4\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0010\u0012\u0004\u0012\u0002H\u00010\u0002R\u00060\u0003R\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lapp/termora/plugins/migration/Database$Property$PropertyDelegate;", "T", "Lapp/termora/plugins/migration/Database$Property$PropertyLazyDelegate;", "Lapp/termora/plugins/migration/Database$Property;", "Lapp/termora/plugins/migration/Database;", "defaultValue", "<init>", "(Lapp/termora/plugins/migration/Database$Property;Ljava/lang/Object;)V", "Ljava/lang/Object;", "migration"})
        protected abstract class PropertyDelegate<T>
        extends PropertyLazyDelegate<T> {
            private final T defaultValue;

            public PropertyDelegate(T defaultValue) {
                super(() -> PropertyDelegate._init_$lambda$0(defaultValue));
                this.defaultValue = defaultValue;
            }

            private static final Object _init_$lambda$0(Object $defaultValue) {
                return $defaultValue;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00a4\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\f\u001a\u00028\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u00032\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u0012H&\u00a2\u0006\u0002\u0010\u0013J,\u0010\u0014\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u00032\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\n\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lapp/termora/plugins/migration/Database$Property$PropertyLazyDelegate;", "T", "Lkotlin/properties/ReadWriteProperty;", "", "initializer", "Lkotlin/Function0;", "<init>", "(Lapp/termora/plugins/migration/Database$Property;Lkotlin/jvm/functions/Function0;)V", "getInitializer", "()Lkotlin/jvm/functions/Function0;", "value", "Ljava/lang/Object;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "convertValue", "", "(Ljava/lang/String;)Ljava/lang/Object;", "setValue", "", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;Ljava/lang/Object;)V", "migration"})
        protected abstract class PropertyLazyDelegate<T>
        implements ReadWriteProperty<Object, T> {
            @NotNull
            private final Function0<T> initializer;
            @Nullable
            private T value;

            public PropertyLazyDelegate(Function0<? extends T> initializer) {
                Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
                this.initializer = initializer;
            }

            @NotNull
            protected final Function0<T> getInitializer() {
                return this.initializer;
            }

            public T getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
                Intrinsics.checkNotNullParameter(property, (String)"property");
                if (this.value == null) {
                    String v = Property.this.getString(property.getName());
                    T t = this.value = v == null ? this.initializer.invoke() : this.convertValue(v);
                }
                if (this.value == null) {
                    this.value = this.initializer.invoke();
                }
                T t = this.value;
                Intrinsics.checkNotNull(t);
                return t;
            }

            public abstract T convertValue(@NotNull String var1);

            public void setValue(@Nullable Object thisRef, @NotNull KProperty<?> property, T value) {
                Intrinsics.checkNotNullParameter(property, (String)"property");
                this.value = value;
                Property.this.putString(property.getName(), String.valueOf(value));
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0084\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u00020\u0001R\u00060\u0003R\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lapp/termora/plugins/migration/Database$Property$StringPropertyDelegate;", "Lapp/termora/plugins/migration/Database$Property$PropertyDelegate;", "", "Lapp/termora/plugins/migration/Database$Property;", "Lapp/termora/plugins/migration/Database;", "defaultValue", "<init>", "(Lapp/termora/plugins/migration/Database$Property;Ljava/lang/String;)V", "convertValue", "value", "migration"})
        protected final class StringPropertyDelegate
        extends PropertyDelegate<String> {
            public StringPropertyDelegate(String defaultValue) {
                Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
                super(defaultValue);
            }

            @Override
            @NotNull
            public String convertValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0094\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u00020\u0001R\u00060\u0003R\u00020\u0004B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lapp/termora/plugins/migration/Database$Property$StringPropertyLazyDelegate;", "Lapp/termora/plugins/migration/Database$Property$PropertyLazyDelegate;", "", "Lapp/termora/plugins/migration/Database$Property;", "Lapp/termora/plugins/migration/Database;", "initializer", "Lkotlin/Function0;", "<init>", "(Lapp/termora/plugins/migration/Database$Property;Lkotlin/jvm/functions/Function0;)V", "convertValue", "value", "migration"})
        protected class StringPropertyLazyDelegate
        extends PropertyLazyDelegate<String> {
            public StringPropertyLazyDelegate(Function0<String> initializer) {
                Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
                super(initializer);
            }

            @Override
            @NotNull
            public String convertValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0084\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u00020\u0001R\u00060\u0003R\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lapp/termora/plugins/migration/Database$Property$SyncTypePropertyDelegate;", "Lapp/termora/plugins/migration/Database$Property$PropertyDelegate;", "Lapp/termora/plugins/migration/SyncType;", "Lapp/termora/plugins/migration/Database$Property;", "Lapp/termora/plugins/migration/Database;", "defaultValue", "<init>", "(Lapp/termora/plugins/migration/Database$Property;Lapp/termora/plugins/migration/SyncType;)V", "convertValue", "value", "", "migration"})
        protected final class SyncTypePropertyDelegate
        extends PropertyDelegate<SyncType> {
            public SyncTypePropertyDelegate(SyncType defaultValue) {
                Intrinsics.checkNotNullParameter((Object)((Object)defaultValue), (String)"defaultValue");
                super(defaultValue);
            }

            @Override
            @NotNull
            public SyncType convertValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                try {
                    return SyncType.valueOf(value);
                }
                catch (Exception e) {
                    return (SyncType)((Object)this.getInitializer().invoke());
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR+\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\r\u001a\u0004\b\u000f\u0010\t\"\u0004\b\u0010\u0010\u000bR+\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\r\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000bR+\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00168F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR+\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00168F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u001d\u001a\u0004\b\u001f\u0010\u0019\"\u0004\b \u0010\u001b\u00a8\u0006\""}, d2={"Lapp/termora/plugins/migration/Database$SFTP;", "Lapp/termora/plugins/migration/Database$Property;", "Lapp/termora/plugins/migration/Database;", "<init>", "(Lapp/termora/plugins/migration/Database;)V", "<set-?>", "", "editCommand", "getEditCommand", "()Ljava/lang/String;", "setEditCommand", "(Ljava/lang/String;)V", "editCommand$delegate", "Lapp/termora/plugins/migration/Database$Property$StringPropertyDelegate;", "sftpCommand", "getSftpCommand", "setSftpCommand", "sftpCommand$delegate", "defaultDirectory", "getDefaultDirectory", "setDefaultDirectory", "defaultDirectory$delegate", "", "pinTab", "getPinTab", "()Z", "setPinTab", "(Z)V", "pinTab$delegate", "Lapp/termora/plugins/migration/Database$Property$BooleanPropertyDelegate;", "preserveModificationTime", "getPreserveModificationTime", "setPreserveModificationTime", "preserveModificationTime$delegate", "migration"})
    public final class SFTP
    extends Property {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final Property.StringPropertyDelegate editCommand$delegate;
        @NotNull
        private final Property.StringPropertyDelegate sftpCommand$delegate;
        @NotNull
        private final Property.StringPropertyDelegate defaultDirectory$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate pinTab$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate preserveModificationTime$delegate;

        public SFTP() {
            super("Setting.SFTP");
            this.editCommand$delegate = (Property)this.new Property.StringPropertyDelegate("");
            this.sftpCommand$delegate = (Property)this.new Property.StringPropertyDelegate("");
            this.defaultDirectory$delegate = (Property)this.new Property.StringPropertyDelegate("");
            this.pinTab$delegate = (Property)this.new Property.BooleanPropertyDelegate(false);
            this.preserveModificationTime$delegate = (Property)this.new Property.BooleanPropertyDelegate(false);
        }

        @NotNull
        public final String getEditCommand() {
            return (String)this.editCommand$delegate.getValue(this, $$delegatedProperties[0]);
        }

        public final void setEditCommand(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.editCommand$delegate.setValue(this, $$delegatedProperties[0], string);
        }

        @NotNull
        public final String getSftpCommand() {
            return (String)this.sftpCommand$delegate.getValue(this, $$delegatedProperties[1]);
        }

        public final void setSftpCommand(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.sftpCommand$delegate.setValue(this, $$delegatedProperties[1], string);
        }

        @NotNull
        public final String getDefaultDirectory() {
            return (String)this.defaultDirectory$delegate.getValue(this, $$delegatedProperties[2]);
        }

        public final void setDefaultDirectory(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.defaultDirectory$delegate.setValue(this, $$delegatedProperties[2], string);
        }

        public final boolean getPinTab() {
            return (Boolean)this.pinTab$delegate.getValue(this, $$delegatedProperties[3]);
        }

        public final void setPinTab(boolean bl) {
            this.pinTab$delegate.setValue(this, $$delegatedProperties[3], bl);
        }

        public final boolean getPreserveModificationTime() {
            return (Boolean)this.preserveModificationTime$delegate.getValue(this, $$delegatedProperties[4]);
        }

        public final void setPreserveModificationTime(boolean bl) {
            this.preserveModificationTime$delegate.setValue(this, $$delegatedProperties[4], bl);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SFTP.class, "editCommand", "getEditCommand()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SFTP.class, "sftpCommand", "getSftpCommand()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SFTP.class, "defaultDirectory", "getDefaultDirectory()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SFTP.class, "pinTab", "getPinTab()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SFTP.class, "preserveModificationTime", "getPreserveModificationTime()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0096\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0016R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lapp/termora/plugins/migration/Database$SafetyProperties;", "Lapp/termora/plugins/migration/Database$Property;", "Lapp/termora/plugins/migration/Database;", "name", "", "<init>", "(Lapp/termora/plugins/migration/Database;Ljava/lang/String;)V", "doorman", "Lapp/termora/plugins/migration/Doorman;", "getDoorman", "()Lapp/termora/plugins/migration/Doorman;", "getString", "key", "getProperties", "", "defaultValue", "putString", "", "value", "migration"})
    public class SafetyProperties
    extends Property {
        public SafetyProperties(String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name);
        }

        private final Doorman getDoorman() {
            return Doorman.Companion.getInstance();
        }

        @Override
        @Nullable
        public String getString(@NotNull String key) {
            String value;
            block3: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                value = super.getString(key);
                if (value != null && this.getDoorman().isWorking()) {
                    try {
                        value = this.getDoorman().decrypt(value);
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block3;
                        Object[] objectArray = new Object[]{key, value, e.getMessage()};
                        log.warn("decryption key: [{}], value: [{}] failed: {}", objectArray);
                    }
                }
            }
            return value;
        }

        @Override
        @NotNull
        public Map<String, String> getProperties() {
            Map<String, String> properties = super.getProperties();
            Map map = new LinkedHashMap();
            if (this.getDoorman().isWorking()) {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    String k = entry.getKey();
                    String v = entry.getValue();
                    try {
                        map.put(k, this.getDoorman().decrypt(v));
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) continue;
                        Object[] objectArray = new Object[]{k, v, e.getMessage()};
                        log.warn("decryption key: [{}], value: [{}] failed: {}", objectArray);
                    }
                }
            } else {
                map.putAll(properties);
            }
            return map;
        }

        @NotNull
        public final String getString(@NotNull String key, @NotNull String defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            String string = this.getString(key);
            if (string == null) {
                string = defaultValue;
            }
            return string;
        }

        @Override
        public void putString(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String v = this.getDoorman().isWorking() ? this.getDoorman().encrypt(value) : value;
            super.putString(key, v);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\f\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR+\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R+\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0015\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0013R+\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0015\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R+\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0015\u001a\u0004\b\u001f\u0010\u0011\"\u0004\b \u0010\u0013R+\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\u0015\u001a\u0004\b#\u0010\u0011\"\u0004\b$\u0010\u0013R+\u0010&\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b)\u0010\u0015\u001a\u0004\b'\u0010\u0011\"\u0004\b(\u0010\u0013R+\u0010+\u001a\u00020*2\u0006\u0010\u0005\u001a\u00020*8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b0\u00101\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R+\u00102\u001a\u00020*2\u0006\u0010\u0005\u001a\u00020*8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b5\u00101\u001a\u0004\b3\u0010-\"\u0004\b4\u0010/R+\u00106\u001a\u00020*2\u0006\u0010\u0005\u001a\u00020*8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b9\u00101\u001a\u0004\b7\u0010-\"\u0004\b8\u0010/R+\u0010;\u001a\u00020:2\u0006\u0010\u0005\u001a\u00020:8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b@\u0010A\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R+\u0010B\u001a\u00020*2\u0006\u0010\u0005\u001a\u00020*8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bE\u00101\u001a\u0004\bC\u0010-\"\u0004\bD\u0010/\u00a8\u0006F"}, d2={"Lapp/termora/plugins/migration/Database$Sync;", "Lapp/termora/plugins/migration/Database$SafetyProperties;", "Lapp/termora/plugins/migration/Database;", "<init>", "(Lapp/termora/plugins/migration/Database;)V", "<set-?>", "Lapp/termora/plugins/migration/SyncType;", "type", "getType", "()Lapp/termora/plugins/migration/SyncType;", "setType", "(Lapp/termora/plugins/migration/SyncType;)V", "type$delegate", "Lapp/termora/plugins/migration/Database$Property$SyncTypePropertyDelegate;", "", "rangeHosts", "getRangeHosts", "()Z", "setRangeHosts", "(Z)V", "rangeHosts$delegate", "Lapp/termora/plugins/migration/Database$Property$BooleanPropertyDelegate;", "rangeKeyPairs", "getRangeKeyPairs", "setRangeKeyPairs", "rangeKeyPairs$delegate", "rangeSnippets", "getRangeSnippets", "setRangeSnippets", "rangeSnippets$delegate", "rangeKeywordHighlights", "getRangeKeywordHighlights", "setRangeKeywordHighlights", "rangeKeywordHighlights$delegate", "rangeMacros", "getRangeMacros", "setRangeMacros", "rangeMacros$delegate", "rangeKeymap", "getRangeKeymap", "setRangeKeymap", "rangeKeymap$delegate", "", "token", "getToken", "()Ljava/lang/String;", "setToken", "(Ljava/lang/String;)V", "token$delegate", "Lapp/termora/plugins/migration/Database$Property$StringPropertyDelegate;", "gist", "getGist", "setGist", "gist$delegate", "domain", "getDomain", "setDomain", "domain$delegate", "", "lastSyncTime", "getLastSyncTime", "()J", "setLastSyncTime", "(J)V", "lastSyncTime$delegate", "Lapp/termora/plugins/migration/Database$Property$LongPropertyDelegate;", "policy", "getPolicy", "setPolicy", "policy$delegate", "migration"})
    public final class Sync
    extends SafetyProperties {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final Property.SyncTypePropertyDelegate type$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate rangeHosts$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate rangeKeyPairs$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate rangeSnippets$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate rangeKeywordHighlights$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate rangeMacros$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate rangeKeymap$delegate;
        @NotNull
        private final Property.StringPropertyDelegate token$delegate;
        @NotNull
        private final Property.StringPropertyDelegate gist$delegate;
        @NotNull
        private final Property.StringPropertyDelegate domain$delegate;
        @NotNull
        private final Property.LongPropertyDelegate lastSyncTime$delegate;
        @NotNull
        private final Property.StringPropertyDelegate policy$delegate;

        public Sync() {
            super("Setting.Sync");
            this.type$delegate = (Property)this.new Property.SyncTypePropertyDelegate(SyncType.GitHub);
            this.rangeHosts$delegate = (Property)this.new Property.BooleanPropertyDelegate(true);
            this.rangeKeyPairs$delegate = (Property)this.new Property.BooleanPropertyDelegate(true);
            this.rangeSnippets$delegate = (Property)this.new Property.BooleanPropertyDelegate(true);
            this.rangeKeywordHighlights$delegate = (Property)this.new Property.BooleanPropertyDelegate(true);
            this.rangeMacros$delegate = (Property)this.new Property.BooleanPropertyDelegate(true);
            this.rangeKeymap$delegate = (Property)this.new Property.BooleanPropertyDelegate(true);
            this.token$delegate = (Property)this.new Property.StringPropertyDelegate(new String());
            this.gist$delegate = (Property)this.new Property.StringPropertyDelegate(new String());
            this.domain$delegate = (Property)this.new Property.StringPropertyDelegate(new String());
            this.lastSyncTime$delegate = (Property)this.new Property.LongPropertyDelegate(0L);
            this.policy$delegate = (Property)this.new Property.StringPropertyDelegate("");
        }

        @NotNull
        public final SyncType getType() {
            return (SyncType)((Object)this.type$delegate.getValue(this, $$delegatedProperties[0]));
        }

        public final void setType(@NotNull SyncType syncType) {
            Intrinsics.checkNotNullParameter((Object)((Object)syncType), (String)"<set-?>");
            this.type$delegate.setValue(this, $$delegatedProperties[0], syncType);
        }

        public final boolean getRangeHosts() {
            return (Boolean)this.rangeHosts$delegate.getValue(this, $$delegatedProperties[1]);
        }

        public final void setRangeHosts(boolean bl) {
            this.rangeHosts$delegate.setValue(this, $$delegatedProperties[1], bl);
        }

        public final boolean getRangeKeyPairs() {
            return (Boolean)this.rangeKeyPairs$delegate.getValue(this, $$delegatedProperties[2]);
        }

        public final void setRangeKeyPairs(boolean bl) {
            this.rangeKeyPairs$delegate.setValue(this, $$delegatedProperties[2], bl);
        }

        public final boolean getRangeSnippets() {
            return (Boolean)this.rangeSnippets$delegate.getValue(this, $$delegatedProperties[3]);
        }

        public final void setRangeSnippets(boolean bl) {
            this.rangeSnippets$delegate.setValue(this, $$delegatedProperties[3], bl);
        }

        public final boolean getRangeKeywordHighlights() {
            return (Boolean)this.rangeKeywordHighlights$delegate.getValue(this, $$delegatedProperties[4]);
        }

        public final void setRangeKeywordHighlights(boolean bl) {
            this.rangeKeywordHighlights$delegate.setValue(this, $$delegatedProperties[4], bl);
        }

        public final boolean getRangeMacros() {
            return (Boolean)this.rangeMacros$delegate.getValue(this, $$delegatedProperties[5]);
        }

        public final void setRangeMacros(boolean bl) {
            this.rangeMacros$delegate.setValue(this, $$delegatedProperties[5], bl);
        }

        public final boolean getRangeKeymap() {
            return (Boolean)this.rangeKeymap$delegate.getValue(this, $$delegatedProperties[6]);
        }

        public final void setRangeKeymap(boolean bl) {
            this.rangeKeymap$delegate.setValue(this, $$delegatedProperties[6], bl);
        }

        @NotNull
        public final String getToken() {
            return (String)this.token$delegate.getValue(this, $$delegatedProperties[7]);
        }

        public final void setToken(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.token$delegate.setValue(this, $$delegatedProperties[7], string);
        }

        @NotNull
        public final String getGist() {
            return (String)this.gist$delegate.getValue(this, $$delegatedProperties[8]);
        }

        public final void setGist(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.gist$delegate.setValue(this, $$delegatedProperties[8], string);
        }

        @NotNull
        public final String getDomain() {
            return (String)this.domain$delegate.getValue(this, $$delegatedProperties[9]);
        }

        public final void setDomain(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.domain$delegate.setValue(this, $$delegatedProperties[9], string);
        }

        public final long getLastSyncTime() {
            return ((Number)this.lastSyncTime$delegate.getValue(this, $$delegatedProperties[10])).longValue();
        }

        public final void setLastSyncTime(long l) {
            this.lastSyncTime$delegate.setValue(this, $$delegatedProperties[10], l);
        }

        @NotNull
        public final String getPolicy() {
            return (String)this.policy$delegate.getValue(this, $$delegatedProperties[11]);
        }

        public final void setPolicy(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.policy$delegate.setValue(this, $$delegatedProperties[11], string);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Sync.class, "type", "getType()Lapp/termora/plugins/migration/SyncType;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Sync.class, "rangeHosts", "getRangeHosts()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Sync.class, "rangeKeyPairs", "getRangeKeyPairs()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Sync.class, "rangeSnippets", "getRangeSnippets()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Sync.class, "rangeKeywordHighlights", "getRangeKeywordHighlights()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Sync.class, "rangeMacros", "getRangeMacros()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Sync.class, "rangeKeymap", "getRangeKeymap()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Sync.class, "token", "getToken()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Sync.class, "gist", "getGist()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Sync.class, "domain", "getDomain()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Sync.class, "lastSyncTime", "getLastSyncTime()J", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Sync.class, "policy", "getPolicy()Ljava/lang/String;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR+\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\t\"\u0004\b\u0010\u0010\u000bR+\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00138F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R+\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00138F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001a\u001a\u0004\b\u001c\u0010\u0016\"\u0004\b\u001d\u0010\u0018R+\u0010 \u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u001f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R+\u0010'\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u001f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010&\u001a\u0004\b(\u0010\"\"\u0004\b)\u0010$R+\u0010+\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u001f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b.\u0010&\u001a\u0004\b,\u0010\"\"\u0004\b-\u0010$R+\u0010/\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u001f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b2\u0010&\u001a\u0004\b0\u0010\"\"\u0004\b1\u0010$R+\u00103\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u001f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b6\u0010&\u001a\u0004\b4\u0010\"\"\u0004\b5\u0010$R+\u00108\u001a\u0002072\u0006\u0010\u0005\u001a\u0002078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R+\u0010?\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u001f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bB\u0010&\u001a\u0004\b@\u0010\"\"\u0004\bA\u0010$R+\u0010C\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u001f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bF\u0010&\u001a\u0004\bD\u0010\"\"\u0004\bE\u0010$\u00a8\u0006G"}, d2={"Lapp/termora/plugins/migration/Database$Terminal;", "Lapp/termora/plugins/migration/Database$Property;", "Lapp/termora/plugins/migration/Database;", "<init>", "(Lapp/termora/plugins/migration/Database;)V", "<set-?>", "", "font", "getFont", "()Ljava/lang/String;", "setFont", "(Ljava/lang/String;)V", "font$delegate", "Lapp/termora/plugins/migration/Database$Property$StringPropertyDelegate;", "localShell", "getLocalShell", "setLocalShell", "localShell$delegate", "Lapp/termora/plugins/migration/Database$Property$StringPropertyLazyDelegate;", "", "fontSize", "getFontSize", "()I", "setFontSize", "(I)V", "fontSize$delegate", "Lapp/termora/plugins/migration/Database$Property$IntPropertyDelegate;", "maxRows", "getMaxRows", "setMaxRows", "maxRows$delegate", "", "debug", "getDebug", "()Z", "setDebug", "(Z)V", "debug$delegate", "Lapp/termora/plugins/migration/Database$Property$BooleanPropertyDelegate;", "beep", "getBeep", "setBeep", "beep$delegate", "hyperlink", "getHyperlink", "setHyperlink", "hyperlink$delegate", "cursorBlink", "getCursorBlink", "setCursorBlink", "cursorBlink$delegate", "selectCopy", "getSelectCopy", "setSelectCopy", "selectCopy$delegate", "Lapp/termora/terminal/CursorStyle;", "cursor", "getCursor", "()Lapp/termora/terminal/CursorStyle;", "setCursor", "(Lapp/termora/terminal/CursorStyle;)V", "cursor$delegate", "Lapp/termora/plugins/migration/Database$Property$CursorStylePropertyDelegate;", "autoCloseTabWhenDisconnected", "getAutoCloseTabWhenDisconnected", "setAutoCloseTabWhenDisconnected", "autoCloseTabWhenDisconnected$delegate", "floatingToolbar", "getFloatingToolbar", "setFloatingToolbar", "floatingToolbar$delegate", "migration"})
    public final class Terminal
    extends Property {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final Property.StringPropertyDelegate font$delegate;
        @NotNull
        private final Property.StringPropertyLazyDelegate localShell$delegate;
        @NotNull
        private final Property.IntPropertyDelegate fontSize$delegate;
        @NotNull
        private final Property.IntPropertyDelegate maxRows$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate debug$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate beep$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate hyperlink$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate cursorBlink$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate selectCopy$delegate;
        @NotNull
        private final Property.CursorStylePropertyDelegate cursor$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate autoCloseTabWhenDisconnected$delegate;
        @NotNull
        private final Property.BooleanPropertyDelegate floatingToolbar$delegate;

        public Terminal() {
            super("Setting.Terminal");
            this.font$delegate = (Property)this.new Property.StringPropertyDelegate("JetBrains Mono");
            this.localShell$delegate = (Property)this.new Property.StringPropertyLazyDelegate((Function0<String>)((Function0)Terminal::localShell_delegate$lambda$0));
            this.fontSize$delegate = (Property)this.new Property.IntPropertyDelegate(14);
            this.maxRows$delegate = (Property)this.new Property.IntPropertyDelegate(5000);
            this.debug$delegate = (Property)this.new Property.BooleanPropertyDelegate(false);
            this.beep$delegate = (Property)this.new Property.BooleanPropertyDelegate(true);
            this.hyperlink$delegate = (Property)this.new Property.BooleanPropertyDelegate(true);
            this.cursorBlink$delegate = (Property)this.new Property.BooleanPropertyDelegate(false);
            this.selectCopy$delegate = (Property)this.new Property.BooleanPropertyDelegate(false);
            this.cursor$delegate = (Property)this.new Property.CursorStylePropertyDelegate(CursorStyle.Block);
            this.autoCloseTabWhenDisconnected$delegate = (Property)this.new Property.BooleanPropertyDelegate(false);
            this.floatingToolbar$delegate = (Property)this.new Property.BooleanPropertyDelegate(true);
        }

        @NotNull
        public final String getFont() {
            return (String)this.font$delegate.getValue(this, $$delegatedProperties[0]);
        }

        public final void setFont(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.font$delegate.setValue(this, $$delegatedProperties[0], string);
        }

        @NotNull
        public final String getLocalShell() {
            return (String)this.localShell$delegate.getValue(this, $$delegatedProperties[1]);
        }

        public final void setLocalShell(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.localShell$delegate.setValue(this, $$delegatedProperties[1], string);
        }

        public final int getFontSize() {
            return ((Number)this.fontSize$delegate.getValue(this, $$delegatedProperties[2])).intValue();
        }

        public final void setFontSize(int n) {
            this.fontSize$delegate.setValue(this, $$delegatedProperties[2], n);
        }

        public final int getMaxRows() {
            return ((Number)this.maxRows$delegate.getValue(this, $$delegatedProperties[3])).intValue();
        }

        public final void setMaxRows(int n) {
            this.maxRows$delegate.setValue(this, $$delegatedProperties[3], n);
        }

        public final boolean getDebug() {
            return (Boolean)this.debug$delegate.getValue(this, $$delegatedProperties[4]);
        }

        public final void setDebug(boolean bl) {
            this.debug$delegate.setValue(this, $$delegatedProperties[4], bl);
        }

        public final boolean getBeep() {
            return (Boolean)this.beep$delegate.getValue(this, $$delegatedProperties[5]);
        }

        public final void setBeep(boolean bl) {
            this.beep$delegate.setValue(this, $$delegatedProperties[5], bl);
        }

        public final boolean getHyperlink() {
            return (Boolean)this.hyperlink$delegate.getValue(this, $$delegatedProperties[6]);
        }

        public final void setHyperlink(boolean bl) {
            this.hyperlink$delegate.setValue(this, $$delegatedProperties[6], bl);
        }

        public final boolean getCursorBlink() {
            return (Boolean)this.cursorBlink$delegate.getValue(this, $$delegatedProperties[7]);
        }

        public final void setCursorBlink(boolean bl) {
            this.cursorBlink$delegate.setValue(this, $$delegatedProperties[7], bl);
        }

        public final boolean getSelectCopy() {
            return (Boolean)this.selectCopy$delegate.getValue(this, $$delegatedProperties[8]);
        }

        public final void setSelectCopy(boolean bl) {
            this.selectCopy$delegate.setValue(this, $$delegatedProperties[8], bl);
        }

        @NotNull
        public final CursorStyle getCursor() {
            return (CursorStyle)this.cursor$delegate.getValue(this, $$delegatedProperties[9]);
        }

        public final void setCursor(@NotNull CursorStyle cursorStyle) {
            Intrinsics.checkNotNullParameter((Object)cursorStyle, (String)"<set-?>");
            this.cursor$delegate.setValue(this, $$delegatedProperties[9], cursorStyle);
        }

        public final boolean getAutoCloseTabWhenDisconnected() {
            return (Boolean)this.autoCloseTabWhenDisconnected$delegate.getValue(this, $$delegatedProperties[10]);
        }

        public final void setAutoCloseTabWhenDisconnected(boolean bl) {
            this.autoCloseTabWhenDisconnected$delegate.setValue(this, $$delegatedProperties[10], bl);
        }

        public final boolean getFloatingToolbar() {
            return (Boolean)this.floatingToolbar$delegate.getValue(this, $$delegatedProperties[11]);
        }

        public final void setFloatingToolbar(boolean bl) {
            this.floatingToolbar$delegate.setValue(this, $$delegatedProperties[11], bl);
        }

        private static final String localShell_delegate$lambda$0() {
            return Application.INSTANCE.getDefaultShell();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "font", "getFont()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "localShell", "getLocalShell()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "fontSize", "getFontSize()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "maxRows", "getMaxRows()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "debug", "getDebug()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "beep", "getBeep()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "hyperlink", "getHyperlink()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "cursorBlink", "getCursorBlink()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "selectCopy", "getSelectCopy()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "cursor", "getCursor()Lapp/termora/terminal/CursorStyle;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "autoCloseTabWhenDisconnected", "getAutoCloseTabWhenDisconnected()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "floatingToolbar", "getFloatingToolbar()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

