/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.bg;

import app.termora.Application;
import app.termora.DocumentAdaptor;
import app.termora.FileChooser;
import app.termora.Icons;
import app.termora.NumberSpinner;
import app.termora.OptionPane;
import app.termora.OptionsPane;
import app.termora.OutlineTextField;
import app.termora.plugins.bg.Appearance;
import app.termora.plugins.bg.BGI18n;
import app.termora.plugins.bg.BackgroundManager;
import com.formdev.flatlaf.extras.components.FlatButton;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0001H\u0002R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lapp/termora/plugins/bg/BackgroundOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$PluginOption;", "<init>", "()V", "owner", "Ljava/awt/Window;", "kotlin.jvm.PlatformType", "getOwner", "()Ljava/awt/Window;", "backgroundImageTextField", "Lapp/termora/OutlineTextField;", "getBackgroundImageTextField", "()Lapp/termora/OutlineTextField;", "intervalSpinner", "Lapp/termora/NumberSpinner;", "getIntervalSpinner", "()Lapp/termora/NumberSpinner;", "backgroundButton", "Ljavax/swing/JButton;", "backgroundClearButton", "Lcom/formdev/flatlaf/extras/components/FlatButton;", "initView", "", "initEvents", "onSelectedBackgroundImage", "file", "Ljava/io/File;", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "", "getJComponent", "Ljavax/swing/JComponent;", "getFormPanel", "Companion", "bg"})
@SourceDebugExtension(value={"SMAP\nBackgroundOption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundOption.kt\napp/termora/plugins/bg/BackgroundOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class BackgroundOption
extends JPanel
implements OptionsPane.PluginOption {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OutlineTextField backgroundImageTextField = new OutlineTextField(0, 1, null);
    @NotNull
    private final NumberSpinner intervalSpinner = new NumberSpinner(360, 30, 86400);
    @NotNull
    private final JButton backgroundButton = new JButton((Icon)Icons.INSTANCE.getFolder());
    @NotNull
    private final FlatButton backgroundClearButton = new FlatButton();
    private static final Logger log = LoggerFactory.getLogger(BackgroundOption.class);

    public BackgroundOption() {
        super(new BorderLayout());
        this.initView();
        this.initEvents();
    }

    private final Window getOwner() {
        return SwingUtilities.getWindowAncestor(this);
    }

    @NotNull
    public final OutlineTextField getBackgroundImageTextField() {
        return this.backgroundImageTextField;
    }

    @NotNull
    public final NumberSpinner getIntervalSpinner() {
        return this.intervalSpinner;
    }

    private final void initView() {
        this.backgroundImageTextField.setEditable(false);
        this.backgroundImageTextField.setTrailingComponent((JComponent)this.backgroundButton);
        this.backgroundImageTextField.setText(Appearance.INSTANCE.getBackgroundImage());
        this.backgroundImageTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdaptor(this){
            final /* synthetic */ BackgroundOption this$0;
            {
                this.this$0 = $receiver;
            }

            public void changedUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FlatButton flatButton = BackgroundOption.access$getBackgroundClearButton$p(this.this$0);
                String string = this.this$0.getBackgroundImageTextField().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                flatButton.setEnabled(!StringsKt.isBlank((CharSequence)string));
            }
        });
        this.backgroundClearButton.setFocusable(false);
        String string = this.backgroundImageTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.backgroundClearButton.setEnabled(!StringsKt.isBlank((CharSequence)string));
        this.backgroundClearButton.setIcon((Icon)Icons.INSTANCE.getDelete());
        this.backgroundClearButton.setButtonType(FlatButton.ButtonType.toolBarButton);
        this.intervalSpinner.setValue((Object)Appearance.INSTANCE.getInterval());
        this.add((Component)this.getFormPanel(), "Center");
    }

    private final void initEvents() {
        this.backgroundButton.addActionListener(arg_0 -> BackgroundOption.initEvents$lambda$2(this, arg_0));
        this.backgroundClearButton.addActionListener(arg_0 -> BackgroundOption.initEvents$lambda$3(this, arg_0));
        this.intervalSpinner.addChangeListener(arg_0 -> BackgroundOption.initEvents$lambda$4(this, arg_0));
    }

    private final void onSelectedBackgroundImage(File file) {
        try {
            if (file.isFile()) {
                Object[] objectArray = new String[]{"background", file.getName()};
                File destFile = FileUtils.getFile((File)Application.INSTANCE.getBaseDataDir(), (String[])objectArray);
                FileUtils.forceMkdirParent((File)destFile);
                FileUtils.deleteQuietly((File)destFile);
                objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                FileUtils.copyFile((File)file, (File)destFile, (CopyOption[])objectArray);
                BackgroundManager backgroundManager = BackgroundManager.Companion.getInstance();
                String string = destFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                backgroundManager.setBackgroundImage(string);
            } else if (file.isDirectory()) {
                BackgroundManager backgroundManager = BackgroundManager.Companion.getInstance();
                String string = file.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                backgroundManager.setBackgroundImage(string);
            }
            this.backgroundImageTextField.setText(file.getAbsolutePath());
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            SwingUtilities.invokeLater(() -> BackgroundOption.onSelectedBackgroundImage$lambda$5(this, e));
        }
    }

    @NotNull
    public Icon getIcon(boolean isSelected) {
        return (Icon)Icons.INSTANCE.getImageGray();
    }

    @NotNull
    public String getTitle() {
        return BGI18n.INSTANCE.getString("termora.plugins.bg.background-image");
    }

    @NotNull
    public JComponent getJComponent() {
        return this;
    }

    private final JPanel getFormPanel() {
        FormBuilder formBuilder;
        FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow, 7dlu, default", "pref, 7dlu, pref");
        int rows = 0;
        rows = 1;
        int step = 2;
        FormBuilder builder = FormBuilder.create().layout(layout);
        Box bgClearBox = Box.createHorizontalBox();
        bgClearBox.add((Component)this.backgroundClearButton);
        FormBuilder $this$getFormPanel_u24lambda_u246 = formBuilder = builder.add(BGI18n.INSTANCE.getString("termora.plugins.bg.background-image") + ":", new Object[0]).xy(1, rows).add((Component)this.backgroundImageTextField).xy(3, rows).add((Component)bgClearBox).xy(5, rows);
        boolean bl = false;
        FormBuilder $this$getFormPanel_u24lambda_u247 = formBuilder = builder.add(BGI18n.INSTANCE.getString("termora.plugins.bg.interval") + ":", new Object[0]).xy(1, rows += step).add((Component)this.intervalSpinner).xy(3, rows);
        boolean bl2 = false;
        rows += step;
        JPanel jPanel = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"build(...)");
        return jPanel;
    }

    @NotNull
    public OptionsPane.Anchor getAnchor() {
        return OptionsPane.PluginOption.DefaultImpls.getAnchor((OptionsPane.PluginOption)this);
    }

    @NotNull
    public String getIdentifier() {
        return OptionsPane.PluginOption.DefaultImpls.getIdentifier((OptionsPane.PluginOption)this);
    }

    public void onSelected() {
        OptionsPane.PluginOption.DefaultImpls.onSelected((OptionsPane.PluginOption)this);
    }

    private static final Unit initEvents$lambda$2$lambda$0(BackgroundOption this$0, List it) {
        Intrinsics.checkNotNull((Object)it);
        if (!((Collection)it).isEmpty()) {
            this$0.onSelectedBackgroundImage((File)CollectionsKt.first((List)it));
        }
        return Unit.INSTANCE;
    }

    private static final void initEvents$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void initEvents$lambda$2(BackgroundOption this$0, ActionEvent it) {
        FileChooser chooser = new FileChooser();
        Object[] objectArray = new String[]{"png", "jpg", "jpeg"};
        chooser.setOsxAllowedFileTypes(CollectionsKt.listOf((Object[])objectArray));
        chooser.setAllowsMultiSelection(false);
        objectArray = new String[]{"png", "jpg", "jpeg"};
        chooser.getWin32Filters().add(new Pair((Object)"Image files", (Object)CollectionsKt.listOf((Object[])objectArray)));
        chooser.setFileSelectionMode(2);
        chooser.showOpenDialog(this$0.getOwner()).thenAccept(arg_0 -> BackgroundOption.initEvents$lambda$2$lambda$1(arg_0 -> BackgroundOption.initEvents$lambda$2$lambda$0(this$0, arg_0), arg_0));
    }

    private static final void initEvents$lambda$3(BackgroundOption this$0, ActionEvent it) {
        BackgroundManager.Companion.getInstance().clearBackgroundImage();
        this$0.backgroundImageTextField.setText("");
    }

    private static final void initEvents$lambda$4(BackgroundOption this$0, ChangeEvent it) {
        Object value = this$0.intervalSpinner.getValue();
        if (value instanceof Integer) {
            Appearance.INSTANCE.setInterval(((Number)value).intValue());
        }
    }

    private static final void onSelectedBackgroundImage$lambda$5(BackgroundOption this$0, Exception $e) {
        Component component = this$0.getOwner();
        String string = ExceptionUtils.getRootCauseMessage((Throwable)$e);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRootCauseMessage(...)");
        OptionPane.showMessageDialog-9VgGkz4$default((OptionPane)OptionPane.INSTANCE, (Component)component, (String)string, null, (int)0, (long)0L, (int)20, null);
    }

    public static final /* synthetic */ FlatButton access$getBackgroundClearButton$p(BackgroundOption $this) {
        return $this.backgroundClearButton;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/plugins/bg/BackgroundOption$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "bg"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

