/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.s3;

import app.termora.plugins.s3.S3FileAttributes;
import app.termora.plugins.s3.S3FileSystem;
import app.termora.plugins.s3.S3Path;
import app.termora.plugins.s3.S3ReadSeekableByteChannel;
import app.termora.plugins.s3.S3WriteSeekableByteChannel;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.errors.ErrorResponseException;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\b\u0012\u0002\b\u00030\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J?\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u001a\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c\"\u0006\u0012\u0002\b\u00030\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\nH\u0002J&\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\"2\u0006\u0010#\u001a\u00020\u00142\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00140%H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0017\u001a\u00020\nH\u0002J1\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020\u00142\u001a\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c\"\u0006\u0012\u0002\b\u00030\u001dH\u0016\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J9\u0010+\u001a\u00020(2\b\u0010,\u001a\u0004\u0018\u00010\u00142\b\u0010-\u001a\u0004\u0018\u00010\u00142\u0016\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010.0\u001c\"\u0004\u0018\u00010.H\u0016\u00a2\u0006\u0002\u0010/J9\u00100\u001a\u00020(2\b\u0010,\u001a\u0004\u0018\u00010\u00142\b\u0010-\u001a\u0004\u0018\u00010\u00142\u0016\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010.0\u001c\"\u0004\u0018\u00010.H\u0016\u00a2\u0006\u0002\u0010/J\u001c\u00101\u001a\u0002022\b\u0010\u0017\u001a\u0004\u0018\u00010\u00142\b\u00103\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u00104\u001a\u0002022\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0016J\u0014\u00105\u001a\u0004\u0018\u0001062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0016J)\u00107\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u00142\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u0002090\u001c\"\u000209H\u0016\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020<2\u0006\u0010\u0017\u001a\u00020\nH\u0002JE\u0010=\u001a\u0002H>\"\b\b\u0000\u0010>*\u00020?2\u0006\u0010\u0017\u001a\u00020\u00142\f\u0010@\u001a\b\u0012\u0004\u0012\u0002H>0A2\u0016\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010B0\u001c\"\u0004\u0018\u00010BH\u0016\u00a2\u0006\u0002\u0010CJA\u0010D\u001a\u0002HE\"\b\b\u0000\u0010E*\u00020F2\u0006\u0010\u0017\u001a\u00020\u00142\f\u0010@\u001a\b\u0012\u0004\u0012\u0002HE0A2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020B0\u001c\"\u00020BH\u0016\u00a2\u0006\u0002\u0010GJK\u0010D\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010H\u0018\u00010\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u00142\b\u0010I\u001a\u0004\u0018\u00010\b2\u0016\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010B0\u001c\"\u0004\u0018\u00010BH\u0016\u00a2\u0006\u0002\u0010JJC\u0010K\u001a\u00020(2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00142\b\u0010L\u001a\u0004\u0018\u00010\b2\b\u0010M\u001a\u0004\u0018\u00010H2\u0016\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010B0\u001c\"\u0004\u0018\u00010BH\u0016\u00a2\u0006\u0002\u0010NR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lapp/termora/plugins/s3/S3FileSystemProvider;", "Ljava/nio/file/spi/FileSystemProvider;", "minioClient", "Lio/minio/MinioClient;", "<init>", "(Lio/minio/MinioClient;)V", "directories", "", "", "", "Lapp/termora/plugins/s3/S3Path;", "getScheme", "newFileSystem", "Ljava/nio/file/FileSystem;", "uri", "Ljava/net/URI;", "env", "", "getFileSystem", "getPath", "Ljava/nio/file/Path;", "newByteChannel", "Ljava/nio/channels/SeekableByteChannel;", "path", "options", "", "Ljava/nio/file/OpenOption;", "attrs", "", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/SeekableByteChannel;", "createStreamer", "Ljava/io/OutputStream;", "newDirectoryStream", "Ljava/nio/file/DirectoryStream;", "dir", "filter", "Ljava/nio/file/DirectoryStream$Filter;", "files", "createDirectory", "", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)V", "delete", "copy", "source", "target", "Ljava/nio/file/CopyOption;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/CopyOption;)V", "move", "isSameFile", "", "path2", "isHidden", "getFileStore", "Ljava/nio/file/FileStore;", "checkAccess", "modes", "Ljava/nio/file/AccessMode;", "(Ljava/nio/file/Path;[Ljava/nio/file/AccessMode;)V", "stat", "Lio/minio/StatObjectResponse;", "getFileAttributeView", "V", "Ljava/nio/file/attribute/FileAttributeView;", "type", "Ljava/lang/Class;", "Ljava/nio/file/LinkOption;", "(Ljava/nio/file/Path;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/FileAttributeView;", "readAttributes", "A", "Ljava/nio/file/attribute/BasicFileAttributes;", "(Ljava/nio/file/Path;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/BasicFileAttributes;", "", "attributes", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/LinkOption;)Ljava/util/Map;", "setAttribute", "attribute", "value", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Object;[Ljava/nio/file/LinkOption;)V", "s3"})
public final class S3FileSystemProvider
extends FileSystemProvider {
    @NotNull
    private final MinioClient minioClient;
    @NotNull
    private final Map<String, List<S3Path>> directories;

    public S3FileSystemProvider(@NotNull MinioClient minioClient) {
        Intrinsics.checkNotNullParameter((Object)minioClient, (String)"minioClient");
        this.minioClient = minioClient;
        this.directories = new LinkedHashMap();
    }

    @Override
    @Nullable
    public String getScheme() {
        return "s3";
    }

    @Override
    @NotNull
    public FileSystem newFileSystem(@NotNull URI uri, @NotNull Map<String, ?> env) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public FileSystem getFileSystem(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public Path getPath(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public SeekableByteChannel newByteChannel(@NotNull Path path, @NotNull Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        if (!(path instanceof S3Path)) {
            throw new UnsupportedOperationException("path must be a S3Path");
        }
        if (options.contains(StandardOpenOption.WRITE)) {
            WritableByteChannel writableByteChannel = Channels.newChannel(this.createStreamer((S3Path)((Object)path)));
            Intrinsics.checkNotNullExpressionValue((Object)writableByteChannel, (String)"newChannel(...)");
            return new S3WriteSeekableByteChannel(writableByteChannel);
        }
        GetObjectResponse response = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(((S3Path)((Object)path)).getBucketName())).object(((S3Path)((Object)path)).getObjectName())).build());
        ReadableByteChannel readableByteChannel = Channels.newChannel((InputStream)response);
        Intrinsics.checkNotNullExpressionValue((Object)readableByteChannel, (String)"newChannel(...)");
        return new S3ReadSeekableByteChannel(readableByteChannel, this.stat((S3Path)((Object)path)));
    }

    private final OutputStream createStreamer(S3Path path) {
        PipedInputStream pis = new PipedInputStream();
        PipedOutputStream pos = new PipedOutputStream(pis);
        Thread thread = Thread.ofVirtual().start(() -> S3FileSystemProvider.createStreamer$lambda$0(this, path, pis));
        return new OutputStream(pos, thread){
            final /* synthetic */ PipedOutputStream $pos;
            final /* synthetic */ Thread $thread;
            {
                this.$pos = $pos;
                this.$thread = $thread;
            }

            public void write(int b) {
                this.$pos.write(b);
            }

            public void close() {
                this.$pos.close();
                this.$thread.join();
            }
        };
    }

    @Override
    @NotNull
    public DirectoryStream<Path> newDirectoryStream(@NotNull Path dir, @NotNull DirectoryStream.Filter<? super Path> filter) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return new DirectoryStream<Path>(this, dir){
            final /* synthetic */ S3FileSystemProvider this$0;
            final /* synthetic */ Path $dir;
            {
                this.this$0 = $receiver;
                this.$dir = $dir;
            }

            public Iterator<Path> iterator() {
                Path path = this.$dir;
                Intrinsics.checkNotNull((Object)path, (String)"null cannot be cast to non-null type app.termora.plugins.s3.S3Path");
                return S3FileSystemProvider.access$files(this.this$0, (S3Path)((Object)path)).iterator();
            }

            public void close() {
            }
        };
    }

    private final List<S3Path> files(S3Path path) {
        List subPaths;
        List paths = new ArrayList();
        if (path.isRoot()) {
            for (Bucket bucket : this.minioClient.listBuckets()) {
                S3Path p = (S3Path)path.resolve(bucket.name());
                long l = bucket.creationDate().toInstant().toEpochMilli();
                p.setAttributes(new S3FileAttributes(l, 0L, 0L, false, true, false, false, 0L, 238, null));
                Intrinsics.checkNotNull((Object)((Object)p));
                paths.add(p);
            }
            return paths;
        }
        String startAfter = "";
        int maxKeys = 100;
        do {
            ListObjectsArgs.Builder builder = ((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(path.getBucketName())).maxKeys(maxKeys).delimiter(((S3FileSystem)path.getFileSystem()).getSeparator());
            if (!StringsKt.isBlank((CharSequence)path.getObjectName())) {
                builder.prefix(path.getObjectName() + ((S3FileSystem)path.getFileSystem()).getSeparator());
            }
            if (!StringsKt.isBlank((CharSequence)startAfter)) {
                builder.startAfter(startAfter);
            }
            subPaths = new ArrayList();
            for (Result e : this.minioClient.listObjects((ListObjectsArgs)builder.build())) {
                Item item = (Item)e.get();
                S3Path p = (S3Path)path.getBucket().resolve(item.objectName());
                S3FileAttributes s3FileAttributes = p.getAttributes();
                boolean bl = item.isDir();
                boolean bl2 = !item.isDir();
                long l = item.size();
                S3FileAttributes attributes = S3FileAttributes.copy$default(s3FileAttributes, 0L, 0L, 0L, bl2, bl, false, false, l, 103, null);
                if (item.lastModified() != null) {
                    attributes = S3FileAttributes.copy$default(attributes, item.lastModified().toInstant().toEpochMilli(), 0L, 0L, false, false, false, false, 0L, 254, null);
                }
                p.setAttributes(attributes);
                if (attributes.isDirectory()) {
                    Intrinsics.checkNotNull((Object)((Object)p));
                    this.delete((Path)((Object)p));
                }
                Intrinsics.checkNotNull((Object)((Object)p));
                subPaths.add(p);
                Intrinsics.checkNotNullExpressionValue((Object)item.objectName(), (String)"objectName(...)");
            }
            paths.addAll(subPaths);
        } while (subPaths.size() >= maxKeys);
        List<S3Path> list = this.directories.get(((Object)((Path)((Object)path)).toAbsolutePath()).toString());
        paths.addAll(list != null ? (Collection)list : (Collection)CollectionsKt.emptyList());
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void createDirectory(@NotNull Path dir, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        S3FileSystemProvider s3FileSystemProvider = this;
        synchronized (s3FileSystemProvider) {
            void $this$createDirectory_u24lambda_u244_u24lambda_u243;
            boolean bl = false;
            if (!(dir instanceof S3Path)) {
                throw new UnsupportedOperationException("dir must be a S3Path");
            }
            if (((S3Path)((Object)dir)).isRoot() || ((S3Path)((Object)dir)).isBucket()) {
                throw new UnsupportedOperationException("No operation permission");
            }
            S3Path s3Path = ((S3Path)((Object)dir)).getParent();
            if (s3Path == null) {
                throw new UnsupportedOperationException("No operation permission");
            }
            S3Path parent = s3Path;
            Path path = dir;
            S3Path s3Path2 = (S3Path)((Object)path);
            List list = this.directories.computeIfAbsent(((Object)((Path)((Object)parent)).toAbsolutePath()).toString(), arg_0 -> S3FileSystemProvider.createDirectory$lambda$4$lambda$2(S3FileSystemProvider::createDirectory$lambda$4$lambda$1, arg_0));
            boolean bl2 = false;
            S3FileAttributes s3FileAttributes = $this$createDirectory_u24lambda_u244_u24lambda_u243.getAttributes();
            long l = System.currentTimeMillis();
            $this$createDirectory_u24lambda_u244_u24lambda_u243.setAttributes(S3FileAttributes.copy$default(s3FileAttributes, l, 0L, 0L, false, true, false, false, 0L, 238, null));
            boolean bl3 = list.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!(path instanceof S3Path)) {
            throw new UnsupportedOperationException("path must be a S3Path");
        }
        if (((S3Path)((Object)path)).getAttributes().isDirectory()) {
            S3Path parent = ((S3Path)((Object)path)).getParent();
            if (parent != null) {
                S3FileSystemProvider s3FileSystemProvider = this;
                synchronized (s3FileSystemProvider) {
                    boolean bl = false;
                    List<S3Path> list = this.directories.get(((Object)((Path)((Object)parent)).toAbsolutePath()).toString());
                    Boolean bl2 = list != null ? Boolean.valueOf(list.removeIf(arg_0 -> S3FileSystemProvider.delete$lambda$7$lambda$6(arg_0 -> S3FileSystemProvider.delete$lambda$7$lambda$5(path, arg_0), arg_0))) : null;
                }
            }
            return;
        }
        this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(((S3Path)((Object)path)).getBucketName())).object(((S3Path)((Object)path)).getObjectName())).build());
    }

    @Override
    public void copy(@Nullable Path source, @Nullable Path target, CopyOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        throw new UnsupportedOperationException();
    }

    @Override
    public void move(@Nullable Path source, @Nullable Path target, CopyOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameFile(@Nullable Path path, @Nullable Path path2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHidden(@Nullable Path path) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public FileStore getFileStore(@Nullable Path path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkAccess(@NotNull Path path, AccessMode ... modes) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)modes, (String)"modes");
        if (!(path instanceof S3Path)) {
            throw new UnsupportedOperationException("path must be a S3Path");
        }
        try {
            this.stat((S3Path)((Object)path));
        }
        catch (ErrorResponseException e) {
            throw new NoSuchFileException(e.errorResponse().message());
        }
    }

    private final StatObjectResponse stat(S3Path path) {
        StatObjectResponse statObjectResponse = this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().object(path.getObjectName())).bucket(path.getBucketName())).build());
        Intrinsics.checkNotNullExpressionValue((Object)statObjectResponse, (String)"statObject(...)");
        return statObjectResponse;
    }

    @Override
    @NotNull
    public <V extends FileAttributeView> V getFileAttributeView(@NotNull Path path, @NotNull Class<V> type, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (path instanceof S3Path) {
            V v = type.cast(new BasicFileAttributeView(path){
                final /* synthetic */ Path $path;
                {
                    this.$path = $path;
                }

                public String name() {
                    return "basic";
                }

                public BasicFileAttributes readAttributes() {
                    return ((S3Path)((Object)this.$path)).getAttributes();
                }

                public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) {
                    throw new UnsupportedOperationException();
                }
            });
            Intrinsics.checkNotNullExpressionValue(v, (String)"cast(...)");
            return (V)((FileAttributeView)v);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <A extends BasicFileAttributes> A readAttributes(@NotNull Path path, @NotNull Class<A> type, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (path instanceof S3Path) {
            A a = type.cast(this.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).readAttributes());
            Intrinsics.checkNotNullExpressionValue(a, (String)"cast(...)");
            return (A)((BasicFileAttributes)a);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Map<String, Object> readAttributes(@Nullable Path path, @Nullable String attributes, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(@Nullable Path path, @Nullable String attribute, @Nullable Object value, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        throw new UnsupportedOperationException();
    }

    private static final void createStreamer$lambda$0(S3FileSystemProvider this$0, S3Path $path, PipedInputStream $pis) {
        this$0.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket($path.getBucketName())).stream((InputStream)$pis, -1L, 0x2000000L).object($path.getObjectName())).build());
        IOUtils.closeQuietly((InputStream)$pis);
    }

    private static final List createDirectory$lambda$4$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List createDirectory$lambda$4$lambda$2(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final boolean delete$lambda$7$lambda$5(Path $path, S3Path it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return Intrinsics.areEqual((Object)PathsKt.getName((Path)((Path)((Object)it))), (Object)PathsKt.getName((Path)$path));
    }

    private static final boolean delete$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$files(S3FileSystemProvider $this, S3Path path) {
        return $this.files(path);
    }
}

