/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.s3;

import app.termora.plugins.s3.S3FileAttributes;
import app.termora.plugins.s3.S3FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.sshd.common.file.util.BaseFileSystem;
import org.apache.sshd.common.file.util.BasePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"\"\u00020#H\u0016\u00a2\u0006\u0002\u0010$J\n\u0010%\u001a\u0004\u0018\u00010\u0000H\u0016R\u001c\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u0011\u0010\u001a\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\r\u00a8\u0006&"}, d2={"Lapp/termora/plugins/s3/S3Path;", "Lorg/apache/sshd/common/file/util/BasePath;", "Lapp/termora/plugins/s3/S3FileSystem;", "fileSystem", "root", "", "names", "", "<init>", "(Lapp/termora/plugins/s3/S3FileSystem;Ljava/lang/String;Ljava/util/List;)V", "separator", "kotlin.jvm.PlatformType", "getSeparator", "()Ljava/lang/String;", "attributes", "Lapp/termora/plugins/s3/S3FileAttributes;", "getAttributes", "()Lapp/termora/plugins/s3/S3FileAttributes;", "setAttributes", "(Lapp/termora/plugins/s3/S3FileAttributes;)V", "isBucket", "", "()Z", "isRoot", "bucketName", "getBucketName", "bucket", "getBucket", "()Lapp/termora/plugins/s3/S3Path;", "objectName", "getObjectName", "toRealPath", "Ljava/nio/file/Path;", "options", "", "Ljava/nio/file/LinkOption;", "([Ljava/nio/file/LinkOption;)Ljava/nio/file/Path;", "getParent", "s3"})
public final class S3Path
extends BasePath<S3Path, S3FileSystem> {
    @NotNull
    private S3FileAttributes attributes;

    public S3Path(@NotNull S3FileSystem fileSystem, @Nullable String root, @NotNull List<String> names) {
        Intrinsics.checkNotNullParameter((Object)((Object)fileSystem), (String)"fileSystem");
        Intrinsics.checkNotNullParameter(names, (String)"names");
        super((BaseFileSystem)fileSystem, root, names);
        this.attributes = new S3FileAttributes(0L, 0L, 0L, false, false, false, false, 0L, 255, null);
    }

    private final String getSeparator() {
        return ((S3FileSystem)this.getFileSystem()).getSeparator();
    }

    @NotNull
    public final S3FileAttributes getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(@NotNull S3FileAttributes s3FileAttributes) {
        Intrinsics.checkNotNullParameter((Object)s3FileAttributes, (String)"<set-?>");
        this.attributes = s3FileAttributes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isBucket() {
        if (this.getParent() == null) return false;
        S3Path s3Path = this.getParent();
        if (s3Path == null) return true;
        S3Path s3Path2 = s3Path.getParent();
        if (s3Path2 != null) return false;
        return true;
    }

    public final boolean isRoot() {
        return Intrinsics.areEqual((Object)((Object)((Path)((Object)this)).toAbsolutePath()).toString(), (Object)this.getSeparator());
    }

    @NotNull
    public final String getBucketName() {
        List list = this.names;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"names");
        Object object = CollectionsKt.first((List)list);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        return (String)object;
    }

    @NotNull
    public final S3Path getBucket() {
        String[] stringArray = new String[]{this.getBucketName()};
        Path path = ((S3FileSystem)this.getFileSystem()).getPath(this.root, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return (S3Path)((Object)path);
    }

    @NotNull
    public final String getObjectName() {
        Iterable iterable = this.names.subList(1, this.names.size());
        String string = this.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-separator>(...)");
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public Path toRealPath(LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        BasePath basePath = this.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)basePath, (String)"toAbsolutePath(...)");
        return (Path)basePath;
    }

    @Nullable
    public S3Path getParent() {
        S3Path s3Path = (S3Path)super.getParent();
        if (s3Path == null) {
            return null;
        }
        S3Path path = s3Path;
        path.attributes = S3FileAttributes.copy$default(path.attributes, 0L, 0L, 0L, false, true, false, false, 0L, 239, null);
        return path;
    }
}

