/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.s3;

import app.termora.DynamicIcon;
import app.termora.Host;
import app.termora.Icons;
import app.termora.plugins.s3.S3FileSystem;
import app.termora.protocol.PathHandler;
import app.termora.protocol.PathHandlerRequest;
import app.termora.protocol.TransferProtocolProvider;
import io.minio.MinioClient;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lapp/termora/plugins/s3/S3ProtocolProvider;", "Lapp/termora/protocol/TransferProtocolProvider;", "<init>", "()V", "getProtocol", "", "getIcon", "Lapp/termora/DynamicIcon;", "width", "", "height", "createPathHandler", "Lapp/termora/protocol/PathHandler;", "requester", "Lapp/termora/protocol/PathHandlerRequest;", "Companion", "s3"})
public final class S3ProtocolProvider
implements TransferProtocolProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<S3ProtocolProvider> instance$delegate = LazyKt.lazy(S3ProtocolProvider::instance_delegate$lambda$0);
    @NotNull
    public static final String PROTOCOL = "S3";

    private S3ProtocolProvider() {
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @NotNull
    public DynamicIcon getIcon(int width, int height) {
        return Icons.INSTANCE.getMinio();
    }

    @NotNull
    public PathHandler createPathHandler(@NotNull PathHandlerRequest requester) {
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        Host host = requester.getHost();
        MinioClient.Builder builder = MinioClient.builder().endpoint(host.getHost()).credentials(host.getUsername(), host.getAuthentication().getPassword());
        String region = (String)host.getOptions().getExtras().get("s3.region");
        if (StringUtils.isNotBlank((CharSequence)region)) {
            builder.region(region);
        }
        String defaultPath = host.getOptions().getSftpDefaultDirectory();
        MinioClient minioClient = builder.build();
        Intrinsics.checkNotNull((Object)minioClient);
        S3FileSystem fs = new S3FileSystem(minioClient);
        FileSystem fileSystem = (FileSystem)((Object)fs);
        Path path = fs.getPath(defaultPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return new PathHandler(fileSystem, path);
    }

    public boolean isTransfer() {
        return super.isTransfer();
    }

    public boolean isTransient() {
        return super.isTransient();
    }

    public int ordered() {
        return super.ordered();
    }

    private static final S3ProtocolProvider instance_delegate$lambda$0() {
        return new S3ProtocolProvider();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/termora/plugins/s3/S3ProtocolProvider$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/plugins/s3/S3ProtocolProvider;", "getInstance", "()Lapp/termora/plugins/s3/S3ProtocolProvider;", "instance$delegate", "Lkotlin/Lazy;", "PROTOCOL", "", "s3"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final S3ProtocolProvider getInstance() {
            Lazy lazy = instance$delegate;
            return (S3ProtocolProvider)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

