/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.s3;

import io.minio.StatObjectResponse;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lapp/termora/plugins/s3/S3ReadSeekableByteChannel;", "Ljava/nio/channels/SeekableByteChannel;", "channel", "Ljava/nio/channels/ReadableByteChannel;", "stat", "Lio/minio/StatObjectResponse;", "<init>", "(Ljava/nio/channels/ReadableByteChannel;Lio/minio/StatObjectResponse;)V", "position", "", "read", "", "dst", "Ljava/nio/ByteBuffer;", "write", "src", "newPosition", "size", "truncate", "isOpen", "", "close", "", "s3"})
public final class S3ReadSeekableByteChannel
implements SeekableByteChannel {
    @NotNull
    private final ReadableByteChannel channel;
    @NotNull
    private final StatObjectResponse stat;
    private long position;

    public S3ReadSeekableByteChannel(@NotNull ReadableByteChannel channel, @NotNull StatObjectResponse stat) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        this.channel = channel;
        this.stat = stat;
    }

    @Override
    public int read(@NotNull ByteBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int bytesRead = this.channel.read(dst);
        if (bytesRead > 0) {
            this.position += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public int write(@NotNull ByteBuffer src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        throw new UnsupportedOperationException("Read-only channel");
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    @NotNull
    public SeekableByteChannel position(long newPosition) {
        throw new UnsupportedOperationException("Seek not supported in streaming read");
    }

    @Override
    public long size() {
        return this.stat.size();
    }

    @Override
    @NotNull
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException("Read-only channel");
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.channel);
    }
}

