/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.s3;

import app.termora.transfer.s3.S3FileAttributes;
import app.termora.transfer.s3.S3FileSystem;
import app.termora.transfer.s3.S3FileSystemProvider;
import app.termora.transfer.s3.S3Path;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.AccessMode;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J)\u0010\u0015\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017\"\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lapp/termora/plugins/s3/MyS3FileSystemProvider;", "Lapp/termora/transfer/s3/S3FileSystemProvider;", "minioClient", "Lio/minio/MinioClient;", "<init>", "(Lio/minio/MinioClient;)V", "getScheme", "", "getOutputStream", "Ljava/io/OutputStream;", "path", "Lapp/termora/transfer/s3/S3Path;", "getInputStream", "Ljava/io/InputStream;", "createStreamer", "fetchChildren", "", "delete", "", "isDirectory", "", "checkAccess", "modes", "", "Ljava/nio/file/AccessMode;", "(Lapp/termora/transfer/s3/S3Path;[Ljava/nio/file/AccessMode;)V", "s3"})
public final class MyS3FileSystemProvider
extends S3FileSystemProvider {
    @NotNull
    private final MinioClient minioClient;

    public MyS3FileSystemProvider(@NotNull MinioClient minioClient) {
        Intrinsics.checkNotNullParameter((Object)minioClient, (String)"minioClient");
        this.minioClient = minioClient;
    }

    @Nullable
    public String getScheme() {
        return "s3";
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull S3Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.createStreamer(path);
    }

    @NotNull
    public InputStream getInputStream(@NotNull S3Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        GetObjectResponse getObjectResponse = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(path.getBucketName())).object(path.getObjectName())).build());
        Intrinsics.checkNotNullExpressionValue((Object)getObjectResponse, (String)"getObject(...)");
        return (InputStream)getObjectResponse;
    }

    private final OutputStream createStreamer(S3Path path) {
        PipedInputStream pis = new PipedInputStream();
        PipedOutputStream pos = new PipedOutputStream(pis);
        AtomicReference<Throwable> exception = new AtomicReference<Throwable>();
        Thread thread = Thread.ofVirtual().start(() -> MyS3FileSystemProvider.createStreamer$lambda$0(this, path, pis, exception));
        return new OutputStream(exception, pos, thread){
            final /* synthetic */ AtomicReference<Throwable> $exception;
            final /* synthetic */ PipedOutputStream $pos;
            final /* synthetic */ Thread $thread;
            {
                this.$exception = $exception;
                this.$pos = $pos;
                this.$thread = $thread;
            }

            public void write(int b) {
                Throwable exception;
                Throwable throwable = exception = this.$exception.get();
                if (throwable != null) {
                    throw throwable;
                }
                this.$pos.write(b);
            }

            public void close() {
                this.$pos.close();
                if (this.$thread.isAlive()) {
                    this.$thread.join();
                }
            }
        };
    }

    @NotNull
    public List<S3Path> fetchChildren(@NotNull S3Path path) {
        List subPaths;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        List paths = new ArrayList();
        if (path.isRoot()) {
            for (Bucket bucket : this.minioClient.listBuckets()) {
                S3Path p = (S3Path)path.resolve(bucket.name());
                long l = bucket.creationDate().toInstant().toEpochMilli();
                p.setAttributes(new S3FileAttributes(l, 0L, 0L, false, true, false, false, 0L, 238, null));
                Intrinsics.checkNotNull((Object)p);
                paths.add(p);
            }
            return paths;
        }
        String startAfter = "";
        int maxKeys = 100;
        do {
            ListObjectsArgs.Builder builder = ((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(path.getBucketName())).maxKeys(maxKeys).delimiter(((S3FileSystem)path.getFileSystem()).getSeparator());
            if (!StringsKt.isBlank((CharSequence)path.getObjectName())) {
                builder.prefix(path.getObjectName() + ((S3FileSystem)path.getFileSystem()).getSeparator());
            }
            if (!StringsKt.isBlank((CharSequence)startAfter)) {
                builder.startAfter(startAfter);
            }
            subPaths = new ArrayList();
            for (Result e : this.minioClient.listObjects((ListObjectsArgs)builder.build())) {
                Item item = (Item)e.get();
                S3Path p = (S3Path)path.getBucket().resolve(item.objectName());
                S3FileAttributes s3FileAttributes = p.getAttributes();
                boolean bl = item.isDir();
                boolean bl2 = !item.isDir();
                long l = item.size();
                S3FileAttributes attributes = S3FileAttributes.copy$default((S3FileAttributes)s3FileAttributes, (long)0L, (long)0L, (long)0L, (boolean)bl2, (boolean)bl, (boolean)false, (boolean)false, (long)l, (int)103, null);
                if (item.lastModified() != null) {
                    attributes = S3FileAttributes.copy$default((S3FileAttributes)attributes, (long)item.lastModified().toInstant().toEpochMilli(), (long)0L, (long)0L, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (long)0L, (int)254, null);
                }
                p.setAttributes(attributes);
                if (attributes.isDirectory()) {
                    Intrinsics.checkNotNull((Object)p);
                    this.delete((Path)p);
                }
                Intrinsics.checkNotNull((Object)p);
                subPaths.add(p);
                Intrinsics.checkNotNullExpressionValue((Object)item.objectName(), (String)"objectName(...)");
            }
            paths.addAll(subPaths);
        } while (subPaths.size() >= maxKeys);
        List list = (List)this.getDirectories().get(((Object)((Path)path).toAbsolutePath()).toString());
        paths.addAll(list != null ? (Collection)list : (Collection)CollectionsKt.emptyList());
        return paths;
    }

    public void delete(@NotNull S3Path path, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!isDirectory) {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(path.getBucketName())).object(path.getObjectName())).build());
        }
    }

    public void checkAccess(@NotNull S3Path path, AccessMode ... modes) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)modes, (String)"modes");
        try {
            this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().object(path.getObjectName())).bucket(path.getBucketName())).build());
        }
        catch (ErrorResponseException e) {
            throw new NoSuchFileException(e.errorResponse().message());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createStreamer$lambda$0(MyS3FileSystemProvider this$0, S3Path $path, PipedInputStream $pis, AtomicReference $exception) {
        try {
            this$0.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket($path.getBucketName())).stream((InputStream)$pis, -1L, 0x2000000L).object($path.getObjectName())).build());
        }
        catch (Exception e) {
            $exception.set(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)$pis);
        }
    }
}

