/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.ant.command;

import com.github.sardine.DavResource;
import com.github.sardine.ant.Command;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class RecursiveGet
extends Command {
    String serverUrl;
    String remoteDirectory;
    String localDirectory;
    boolean overwriteFiles = false;
    boolean skipExistingFiles = false;

    @Override
    protected void validateAttributes() throws Exception {
        StringBuilder sb = new StringBuilder();
        if (this.serverUrl == null) {
            sb.append("[serverUrl] must not be null\n");
        }
        if (this.remoteDirectory == null) {
            sb.append("[remoteDirectory] must not be null\n");
        }
        if (this.localDirectory == null) {
            sb.append("[localDirectory] must not be null\n");
        }
        if (sb.length() > 0) {
            throw new IllegalArgumentException(sb.substring(0, sb.length() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws Exception {
        URI remoteDirectoryUrl = new URI(this.serverUrl + "/").resolve(this.remoteDirectory);
        String remoteDirectoryPath = remoteDirectoryUrl.getPath();
        List<DavResource> resource = this.getSardine().list(remoteDirectoryUrl.toString(), -1);
        for (DavResource davResource : resource) {
            if (davResource.isDirectory()) continue;
            String filePathRelativeToRemoteDirectory = davResource.getPath().replace(remoteDirectoryPath, "");
            Path localFilePath = Paths.get(this.localDirectory, filePathRelativeToRemoteDirectory);
            if (this.skipExistingFiles && Files.exists(localFilePath, new LinkOption[0])) {
                this.log("skipping download of already existing file " + String.valueOf(localFilePath));
                continue;
            }
            Files.createDirectories(localFilePath.getParent(), new FileAttribute[0]);
            this.log("downloading " + filePathRelativeToRemoteDirectory + " to " + String.valueOf(localFilePath));
            try (InputStream ioStream = this.getSardine().get(this.serverUrl + davResource.getHref().toString());){
                if (this.overwriteFiles) {
                    Files.copy(ioStream, localFilePath, StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                Files.copy(ioStream, localFilePath, new CopyOption[0]);
            }
        }
        this.log("downloaded files to " + this.localDirectory);
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setRemoteDirectory(String remoteDirectory) {
        this.remoteDirectory = remoteDirectory;
    }

    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    public void setOverwriteFiles(boolean overwriteFiles) {
        this.overwriteFiles = overwriteFiles;
    }

    public void setSkipExistingFiles(boolean skipExistingFiles) {
        this.skipExistingFiles = skipExistingFiles;
    }
}

